#include "eventswindow.h"
#include "ui_eventswindow.h"

EventsWindow::EventsWindow(QWidget *parent, QString token) :
    QMainWindow(parent),
    ui(new Ui::EventsWindow),
    qfacebook(new QFacebook(token, this)),
    accessToken(token),
    nam(new QNetworkAccessManager(this))
{
    ui->setupUi(this);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    connect(ui->actionNew_event, SIGNAL(triggered()), this, SLOT(createEvent()));
    connect(ui->actionRefresh, SIGNAL(triggered()), this, SLOT(updateEvents()));
}

EventsWindow::~EventsWindow()
{
    delete ui;
}

void EventsWindow::browseId(QString id)
{
    m_userId = id;
    this->updateEvents();
}

void EventsWindow::updateEvents()
{
    attendingReply = qfacebook->getConnections(m_userId, "events/attending");
    if (attendingReply)
        connect(attendingReply, SIGNAL(finished()), this, SLOT(onReplyReceived()));

    maybeReply = qfacebook->getConnections(m_userId, "events/maybe");
    if (maybeReply)
        connect(maybeReply, SIGNAL(finished()), this, SLOT(onReplyReceived()));

    declinedReply = qfacebook->getConnections(m_userId, "events/declined");
    if (declinedReply)
        connect(declinedReply, SIGNAL(finished()), this, SLOT(onReplyReceived()));

    notrepliedReply = qfacebook->getConnections(m_userId, "events/not_replied");
    if (notrepliedReply)
        connect(notrepliedReply, SIGNAL(finished()), this, SLOT(onReplyReceived()));
}

void EventsWindow::onReplyReceived()
{
    QFacebookReply *reply = (QFacebookReply*)sender();
    if (reply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to fetch events!";
        reply->deleteLater();
        reply = 0;

        return;
    }

    foreach (EventItem *item, events) {
        ui->scrollLayout->removeWidget(item);
        delete item;
    }

    QVariant jsonData = reply->data();
    QVariantList listData;
    listData = jsonData.toMap().value("data").toList();
    foreach (QVariant jsonData, listData) {
        QString name = jsonData.toMap().value("name").toString();
        QString eventId = jsonData.toMap().value("id").toString();
        QString location = jsonData.toMap().value("location").toString();
        QDateTime from = QDateTime::fromString(jsonData.toMap().value("start_time").toString(), Qt::ISODate);
        QString fromTime = QString(from.toString("dddd, MMMM d %1 hh:mmap").arg(tr("at")));
        QString attending = jsonData.toMap().value("rsvp_status").toString();

        EventItem *item = new EventItem(this, accessToken, nam);
        item->setName(name);
        item->setEventId(eventId);
        item->setLocation(location);
        item->setTime(fromTime);
        item->setRsvp(attending);
        ui->scrollLayout->addWidget(item);
    }
}

void EventsWindow::createEvent()
{
    NewEventDialog *dialog = new NewEventDialog(this, accessToken, qfacebook);
    dialog->show();
}
