#ifndef NOTIFICATIONITEM_H
#define NOTIFICATIONITEM_H

#include <QWidget>
#include <QMouseEvent>
#include <QNetworkAccessManager>
#include <QNetworkReply>

namespace Ui {
    class NotificationItem;
}

class NotificationItem : public QWidget
{
    Q_OBJECT

public:
    explicit NotificationItem(QWidget *parent = 0, QString token = "0", QNetworkAccessManager *nam = 0);
    ~NotificationItem();
    bool isPressed();
    QString objectId();
    QString userId();
    QString text();
    QString objectType();
    void setObjectId(QString id);
    void setUserId(QString id);
    void setText(QString text);
    void setObjectType(QString objectType);
    void setUnread(bool);
    bool isUnread();

protected:
    void mousePressEvent(QMouseEvent *);
    void mouseReleaseEvent(QMouseEvent *);

signals:
    void pressed();
    void released();
    void clicked(NotificationItem *);

private:
    Ui::NotificationItem *ui;
    QString accessToken;
    QString m_userId;
    QString m_objectId;
    QString m_objectType;
    bool m_pressed;
    QNetworkAccessManager *nam;
    QNetworkReply *avatarReply;
    bool m_unread;

private slots:
    void onAvatarReceived();
    void getAvatar();
};

#endif // NOTIFICATIONITEM_H
