#include "newsfeedpost.h"
#include "ui_newsfeedpost.h"

NewsFeedPost::NewsFeedPost(QWidget *parent, QString token, QFacebook *qfacebook, QNetworkAccessManager *nam) :
    QWidget(parent),
    ui(new Ui::NewsFeedPost),
    accessToken(token),
    qfacebook(qfacebook),
    nam(nam)
{
    ui->setupUi(this);
    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));
    connect(ui->commentButton, SIGNAL(clicked()), this, SLOT(onCommentButtonClicked()));
    connect(ui->likeButton, SIGNAL(clicked()), this, SLOT(onLikeButtonClicked()));
    connect(ui->deleteButton, SIGNAL(clicked()), this, SLOT(onDeleteButtonClicked()));
    connect(ui->nameLabel, SIGNAL(clicked()), this, SLOT(onNameClicked()));
    this->orientationChanged();
    this->isLikedByMe = false;
    ui->deleteButton->hide();
    QPalette p = this->palette();
    p.setColor(QPalette::Foreground, p.highlight().color());
    ui->nameLabel->setPalette(p);
#ifdef Q_WS_MAEMO_5
    ui->deleteButton->setText("");
    ui->deleteButton->setIcon(QIcon::fromTheme("general_close"));
#endif
}

NewsFeedPost::~NewsFeedPost()
{
    delete ui;
}

void NewsFeedPost::onCommentButtonClicked()
{
    emit commentButtonClicked(this->id, this->comments, this->likes);
}

void NewsFeedPost::onLikeButtonClicked()
{
    QByteArray data;
    if (this->isLikedByMe)
        data.append("&method=delete");
    this->reply = qfacebook->putObject(this->id, "likes", data);
    if (this->reply)
        connect(reply, SIGNAL(finished()), this, SLOT(onLikeReplyReceived()));
}

void NewsFeedPost::onLikeReplyReceived()
{
    if (this->reply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to get reply!";
        this->reply->deleteLater();
        this->reply = 0;

        return;
    }

    if (this->isLikedByMe) {
        this->isLikedByMe = false;
        this->setNumberOfLikesComments(QString::number(this->likes.toInt()-1).remove("\""), this->comments);
    } else {
        this->isLikedByMe = true;
        this->setNumberOfLikesComments(QString::number(this->likes.toInt()+1).remove("\""), this->comments);
    }
    reply->deleteLater();
}

void NewsFeedPost::orientationChanged()
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
    if (screenGeometry.width() > screenGeometry.height()) {
        ui->bottomLayout->setDirection(QBoxLayout::LeftToRight);
    } else {
        ui->bottomLayout->setDirection(QBoxLayout::TopToBottom);
    }
#ifdef Q_WS_MAEMO_5
    this->setMaximumWidth(((QMainWindow*)parent())->width()-5);
#endif
}

void NewsFeedPost::setName(QString name)
{
    ui->nameLabel->setText(name);
    ui->nameLabel->show();
}

void NewsFeedPost::setDate(QString date)
{
    ui->timeLabel->setText(date);
    ui->timeLabel->show();
}

void NewsFeedPost::setTime(QString time)
{
    QDateTime t = QDateTime::fromString(time, Qt::ISODate);
    QString date = t.toString("dddd hh:mm:ss");
    //QString today = QDateTime().currentDateTime().toString("dddd");
    //if (date.contains(today) && date.is)
    //    date.replace(today, tr("Today"));
    ui->timeLabel->setText(date);
}

void NewsFeedPost::setDeletable(bool deletable)
{
    this->isDeletable = deletable;
    ui->deleteButton->show();
}

void NewsFeedPost::setAvatar(QPixmap pixmap)
{
    ui->avatarLabel->setPixmap(pixmap);
    ui->avatarLabel->show();
}

void NewsFeedPost::setMessage(QString message)
{
    ui->messageLabel->setText(message);
    ui->messageLabel->show();
}

void NewsFeedPost::setId(QString id)
{
    this->id = id;
}

void NewsFeedPost::hideBottomBar(bool hide)
{
    ui->bottomWidget->setHidden(hide);
}

void NewsFeedPost::setNumberOfLikesComments(QString likes, QString comments)
{
    QString likeText;
    if (this->isLikedByMe)
        likeText = tr("Unlike");
    else
        likeText = tr("Like");
    this->likes = likes;
    this->comments = comments;
    ui->commentButton->setText(tr("Comment") + QString(" (%1)").arg(comments));
    ui->likeButton->setText(likeText + QString(" (%1)").arg(likes));
}

void NewsFeedPost::setLikedByMe(bool meLikesThis)
{
    this->isLikedByMe = meLikesThis;
    this->setNumberOfLikesComments(this->likes, this->comments);
}

void NewsFeedPost::setIconFromUrl(QString url)
{
    QNetworkReply *reply = nam->get(QNetworkRequest(url));
    connect(reply, SIGNAL(finished()), this, SLOT(iconReceived()));
}

void NewsFeedPost::getPixmapFromUrl(QString pixmapUrl)
{
    QNetworkReply *reply = nam->get(QNetworkRequest(pixmapUrl));
    connect(reply, SIGNAL(finished()), this, SLOT(avatarReceived()));
}

void NewsFeedPost::setCommentMode(bool isComment)
{
    ui->commentButton->setHidden(isComment);
}

void NewsFeedPost::avatarReceived()
{
    QNetworkReply *reply = qobject_cast<QNetworkReply*>(sender());
    QUrl redir = reply->attribute(QNetworkRequest::RedirectionTargetAttribute).toUrl();
    if (!redir.isEmpty()) {
        reply->deleteLater();
        QNetworkAccessManager *nam = qobject_cast<QNetworkAccessManager*>(sender()->parent());
        QNetworkReply *reply = nam->get(QNetworkRequest(redir));

        connect(reply, SIGNAL(finished()), this, SLOT(avatarReceived()));
        return;
    }
    this->setAvatar(QPixmap::fromImage(QImage::fromData(reply->readAll())));
    reply->deleteLater();
}

void NewsFeedPost::onNameClicked()
{
    emit nameClicked(this->userId, ui->nameLabel->text());
}

void NewsFeedPost::iconReceived()
{
    QNetworkReply *reply = qobject_cast<QNetworkReply*>(sender());
    ui->iconLabel->setPixmap(QPixmap::fromImage(QImage::fromData(reply->readAll())));
    reply->deleteLater();
}

void NewsFeedPost::onDeleteButtonClicked()
{
    QByteArray data;
    data.append("&method=delete");
    this->deleteReply =
            qfacebook->put(QUrl(QString("https://graph.facebook.com/%1&access_token=%2").arg(this->id, accessToken)), data);
    connect(this->deleteReply, SIGNAL(finished()), this, SLOT(onDeleteReplyReceived()));
}

void NewsFeedPost::onDeleteReplyReceived()
{
    if (this->deleteReply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to delete post!" << deleteReply->errorString();
#ifdef Q_WS_MAEMO_5
        QMaemo5InformationBox::information(this, tr("Failed to delete post"));
#endif
        this->deleteReply->deleteLater();
        this->deleteReply = 0;

        return;
    }

    this->hide();
    this->deleteLater();
}

void NewsFeedPost::setUserId(QString id)
{
    this->userId = id;
}

void NewsFeedPost::resizeEvent(QResizeEvent *)
{
    this->orientationChanged();
}

void NewsFeedPost::paintEvent(QPaintEvent *)
{
    /*QPainter painter(this);
    painter.setPen(QColor(this->palette().highlight().color()));
    painter.drawLine(QPoint(this->geometry().left(), this->geometry().bottom()-2),
                     QPoint(this->geometry().right() ,this->geometry().bottom()-2));*/
}
