#ifndef FRIENDSWINDOW_H
#define FRIENDSWINDOW_H

#include <QMainWindow>
#include <QStringList>
#include <QPushButton>
#include <QDebug>
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QListWidgetItem>
#include "profilewindow.h"
#include <qfacebook.h>

namespace Ui {
    class FriendsWindow;
}

class FriendsWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit FriendsWindow(QWidget *parent = 0, QString accessToken = "0");
    ~FriendsWindow();
    void browseId(QString id);
    void setToken(QString token);
    void requestRecepientsList();

signals:
    void recepientsSelected(QList<QListWidgetItem*>);

private:
    Ui::FriendsWindow *ui;
    QFacebook *qfacebook;
    QFacebookReply *reply;
    QString idToBrowse;
    QString token;
    QNetworkAccessManager *nam;

private slots:
    void onReplyFinished();
    void onAvatarReplyFinished(QNetworkReply *reply);
    void onAvatarProcessed(QString id, QPixmap pixmap);
    void onRecepientsSelected();
    void onFriendClicked(QListWidgetItem*);
    void updateFriends();
};

class Friend : public QObject
{
    Q_OBJECT

public:
    explicit Friend(QWidget *parent = 0, QString id = "0");
    ~Friend();

signals:
    void avatarProcessed(QString, QPixmap);

public slots:
    void avatarReceived();

private:
    QString userId;
};

#endif // FRIENDSWINDOW_H
