#include "friendswindow.h"
#include "ui_friendswindow.h"

FriendsWindow::FriendsWindow(QWidget *parent, QString accessToken) :
    QMainWindow(parent),
    ui(new Ui::FriendsWindow),
    token(accessToken),
    nam(new QNetworkAccessManager())
{
    ui->setupUi(this);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
    ui->friendsList->setIconSize(QSize(64, 64));
#endif
    connect(nam, SIGNAL(finished(QNetworkReply*)), this, SLOT(onAvatarReplyFinished(QNetworkReply*)));
    connect(ui->friendsList, SIGNAL(itemActivated(QListWidgetItem*)), this, SLOT(onFriendClicked(QListWidgetItem*)));
    connect(ui->actionRefresh, SIGNAL(triggered()), this, SLOT(updateFriends()));
}

FriendsWindow::~FriendsWindow()
{
    delete ui;
}

void FriendsWindow::updateFriends()
{
    this->browseId(this->idToBrowse);
}

void FriendsWindow::browseId(QString id)
{
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif
    this->idToBrowse = id;
    qfacebook = new QFacebook(this->token, this);

    this->reply = qfacebook->getConnections(this->idToBrowse, "friends");
    if (this->reply)
        connect(reply, SIGNAL(finished()), this, SLOT(onReplyFinished()));
}

void FriendsWindow::onReplyFinished()
{
    if (this->reply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to fetch friends!";
        this->reply->deleteLater();
        this->reply = 0;

        return;
    }

    ui->friendsList->clear();

    QVariant jsonData = this->reply->data();
    QVariantList listData;
    listData = jsonData.toMap().value("data").toList();
    foreach(jsonData, listData) {
        QListWidgetItem *item = new QListWidgetItem(ui->friendsList);
        item->setText(jsonData.toMap().value("name").toString());
        item->setData(Qt::UserRole, jsonData.toMap().value("id").toString());
        Friend *user = new Friend(ui->friendsList, jsonData.toMap().value("id").toString());
        connect(user, SIGNAL(avatarProcessed(QString,QPixmap)), this, SLOT(onAvatarProcessed(QString,QPixmap)));
        QString avatarUrl = QString("http://graph.facebook.com/%1/picture").arg(jsonData.toMap().value("id").toString());
        QNetworkReply *reply =
                nam->get(QNetworkRequest(avatarUrl));
        connect(reply, SIGNAL(finished()), user, SLOT(avatarReceived()));
    }
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
}

void FriendsWindow::onAvatarProcessed(QString id, QPixmap pixmap)
{
    for (int i = 0; i < ui->friendsList->count(); i++) {
        if (ui->friendsList->item(i)->data(Qt::UserRole).toString() == id)
            ui->friendsList->item(i)->setIcon(QIcon(pixmap));
    }
}

void FriendsWindow::onAvatarReplyFinished(QNetworkReply *reply)
{
    QString id = reply->objectName();
    for (int i = 0; i < ui->friendsList->count(); i++) {
        if (ui->friendsList->item(i)->data(Qt::UserRole).toString() == id)
            ui->friendsList->item(i)->setIcon(QIcon(QPixmap::fromImage(QImage::fromData(reply->readAll()))));
    }
}

void FriendsWindow::requestRecepientsList()
{
    ui->friendsList->setSelectionMode(QListWidget::MultiSelection);
    QPushButton *doneButton = new QPushButton(tr("Done"), this);
    connect(doneButton, SIGNAL(clicked()), this, SLOT(onRecepientsSelected()));
    ui->verticalLayout->addWidget(doneButton);
    this->browseId("me");
    this->show();
}

void FriendsWindow::onRecepientsSelected()
{
    emit recepientsSelected(ui->friendsList->selectedItems());
    this->close();
}

void FriendsWindow::onFriendClicked(QListWidgetItem *item)
{
    ProfileWindow *window = new ProfileWindow(this, token);
    window->setAttribute(Qt::WA_DeleteOnClose);
    window->browseProfile(item->data(Qt::UserRole).toString());
    window->setWindowTitle(item->text());
    window->show();
}

Friend::Friend (QWidget *parent, QString id) :
    userId(id)
{
    this->setParent(parent);
}

Friend::~Friend() {}

void Friend::avatarReceived()
{
    QNetworkReply *reply = qobject_cast<QNetworkReply*>(sender());
    QUrl redir = reply->attribute(QNetworkRequest::RedirectionTargetAttribute).toUrl();
    if (!redir.isEmpty()) {
        reply->deleteLater();
        QNetworkAccessManager *nam = qobject_cast<QNetworkAccessManager*>(sender()->parent());
        QNetworkReply *reply = nam->get(QNetworkRequest(redir));

        connect(reply, SIGNAL(finished()), this, SLOT(avatarReceived()));
        return;
    }
    emit avatarProcessed(this->userId, QPixmap::fromImage(QImage::fromData(reply->readAll())));
    reply->deleteLater();
    this->deleteLater();
}
