#include "photowindow.h"
#include "ui_photowindow.h"

PhotoWindow::PhotoWindow(QWidget *parent, QString token) :
    QMainWindow(parent),
    ui(new Ui::PhotoWindow),
    qfacebook(new QFacebook(token, this)),
    accessToken(token),
    nam(new QNetworkAccessManager(this))
{
    ui->setupUi(this);
    setAttribute(Qt::WA_DeleteOnClose);
    connect(ui->photoLabel, SIGNAL(clickedPos(QPoint)), this, SLOT(onClicked(QPoint)));
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
}

PhotoWindow::~PhotoWindow()
{
    delete ui;
}

void PhotoWindow::showPhoto(QString photoId)
{
    this->photoId = photoId;
    QString urlString = QString("https://graph.facebook.com/%1/picture&type=large&access_token=%2").arg(photoId, accessToken);
    qDebug() << urlString;
    this->reply = nam->get(QNetworkRequest(urlString));
    if (this->reply)
        connect(reply, SIGNAL(finished()), this, SLOT(onReplyReceived()));
}

void PhotoWindow::showPhotoFromId(QString id)
{
    this->photoId = id;
    QString urlString = QString("https://graph.facebook.com/%1&type=large&access_token=%2").arg(photoId, accessToken);
    qDebug() << urlString;
    this->reply = nam->get(QNetworkRequest(urlString));
    if (this->reply)
        connect(reply, SIGNAL(finished()), this, SLOT(onReplyReceived()));
}

void PhotoWindow::setPhoto(QString filename)
{
    ui->photoLabel->setPixmap(QPixmap(filename));
}

void PhotoWindow::onReplyReceived()
{
    ui->photoLabel->clear();

    if (reply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to fetch photo!";
        reply->deleteLater();
        reply = 0;

        return;
    }

    QUrl redir = reply->attribute(QNetworkRequest::RedirectionTargetAttribute).toUrl();
    if (!redir.isEmpty()) {
        reply = qfacebook->get(redir);
        if (reply)
            connect(reply, SIGNAL(finished()), this, SLOT(onReplyReceived()));
        return;
    }

    ui->photoLabel->setPixmap(QPixmap::fromImage(QImage::fromData(reply->readAll())));
}

void PhotoWindow::onClicked(QPoint point)
{
    double xOfPhoto = ui->photoLabel->x();
    double yOfPhoto = ui->photoLabel->y();
    double xOfClick = point.x();
    double yOfClick = point.y();

    qDebug() << "Percentage of x click: " << ((xOfClick - xOfPhoto) / ui->photoLabel->width()) * 100;
    qDebug() << "Percentage of y click: " << ((yOfClick - yOfPhoto) / ui->photoLabel->height()) * 100;
}
