#include "notificationsdialog.h"
#include "ui_notificationsdialog.h"

NotificationsDialog::NotificationsDialog(QWidget *parent, QString token) :
    QDialog(parent),
    ui(new Ui::NotificationsDialog),
    accessToken(token),
    nam(new QNetworkAccessManager(this))
{
    ui->setupUi(this);
    this->orientationChanged();
    this->updateNotifications();
    this->getNoficiationCount();
    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));
}

NotificationsDialog::~NotificationsDialog()
{
    delete ui;
}

void NotificationsDialog::orientationChanged()
{
#ifdef Q_WS_MAEMO_5
    setMinimumHeight(QApplication::desktop()->screenGeometry().height());
#endif
}

void NotificationsDialog::getNoficiationCount()
{
    QString url = QString("https://api.facebook.com/method/notifications.get&access_token=%1").arg(accessToken);
    countReply = nam->get(QNetworkRequest(url));
    if (countReply)
        connect(countReply, SIGNAL(finished()), this, SLOT(onGotNotificationsCount()));
}

void NotificationsDialog::onGotNotificationsCount()
{
    if (countReply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to fetch notifications!";
        countReply->deleteLater();
        countReply = 0;
        return;
    }

    QXmlStreamReader xml(countReply->readAll());
    while (!xml.atEnd() && !xml.hasError()) {
        QXmlStreamReader::TokenType token = xml.readNext();
        /* If token is just StartDocument, we'll go to next.*/
        if (token == QXmlStreamReader::StartDocument) {
                continue;
        }
        /* If token is StartElement, we'll see if we can read it.*/
        if (token == QXmlStreamReader::StartElement) {
            //if (xml.name() == "notification_counts")

        }
    }
    /* Error handling. */
    if (xml.hasError()) {
        QMessageBox::critical(this,
                              "QXSRExample::parseXML",
                              xml.errorString(),
                              QMessageBox::Ok);
    }
    /* Removes any device() or data from the reader
     * and resets its internal state to the initial state. */
    xml.clear();
}

void NotificationsDialog::updateNotifications()
{
    QString url;
    url = QString("https://api.facebook.com/method/notifications.getList&include_read=true&access_token=%1").arg(accessToken);
    reply = nam->get(QNetworkRequest(url));
    if (reply)
        connect(reply, SIGNAL(finished()), this, SLOT(onNotificationsListReceived()));
}

void NotificationsDialog::onNotificationsListReceived()
{
    if (this->reply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to fetch notifications!";
        this->reply->deleteLater();
        this->reply = 0;

        return;
    }

    if (!notificationItems.isEmpty()) {
        foreach (NotificationItem *item, notificationItems) {
            ui->layout->removeWidget(item);
            notificationItems.removeOne(item);
            delete item;
        }
    }

    QList< QMap<QString,QString> > notifications;
    QXmlStreamReader xml(reply->readAll());

    while (!xml.atEnd() && !xml.hasError()) {
        QXmlStreamReader::TokenType token = xml.readNext();
        /* If token is just StartDocument, we'll go to next.*/
        if (token == QXmlStreamReader::StartDocument) {
                continue;
        }
        /* If token is StartElement, we'll see if we can read it.*/
        if (token == QXmlStreamReader::StartElement) {
            if (xml.name().toString().contains("notifications list"))
                continue;
            if (xml.name() == "notification")
                notifications.append(this->parseNotification(xml));
        }
    }
    /* Error handling. */
    if (xml.hasError()) {
        qDebug() << xml.errorString();
    }
    /* Removes any device() or data from the reader
     * and resets its internal state to the initial state. */
    xml.clear();
    this->addNotificationsToUi(notifications);
}

QMap <QString, QString> NotificationsDialog::parseNotification(QXmlStreamReader &xml)
{
    QMap <QString, QString> notification;
    while (!(xml.tokenType() == QXmlStreamReader::EndElement &&
                xml.name() == "notification")) {
        if(xml.tokenType() == QXmlStreamReader::StartElement) {
                if (xml.name() == "notification_id")
                    this->addElementDataToMap(xml, notification);
                if (xml.name() == "sender_id")
                    this->addElementDataToMap(xml, notification);
                if (xml.name() == "title_text")
                    this->addElementDataToMap(xml, notification);
                if (xml.name() == "body_text")
                    this->addElementDataToMap(xml, notification);
                if (xml.name() == "created_time")
                    this->addElementDataToMap(xml, notification);
                if (xml.name() == "object_id")
                    this->addElementDataToMap(xml, notification);
                if (xml.name() == "object_type")
                    this->addElementDataToMap(xml, notification);
                if (xml.name() == "icon_url")
                    this->addElementDataToMap(xml, notification);
                if (xml.name() == "is_unread")
                    this->addElementDataToMap(xml, notification);
        }
        xml.readNext();
    }
    return notification;
}

void NotificationsDialog::addElementDataToMap(QXmlStreamReader& xml, QMap<QString, QString>& map) const
{
    if (xml.tokenType() != QXmlStreamReader::StartElement) {
        return;
    }
    QString elementName = xml.name().toString();
    xml.readNext();

    if (xml.tokenType() != QXmlStreamReader::Characters) {
        return;
    }
    map.insert(elementName, xml.text().toString());
}

void NotificationsDialog::addNotificationsToUi(QList< QMap<QString,QString> >& notifications)
{
    while (!notifications.isEmpty()) {
        QMap<QString,QString> notification = notifications.takeFirst();
        QString text = notification["title_text"];
        if (!text.isEmpty()) {
            NotificationItem *item = new NotificationItem(this, accessToken, nam);
            connect(item, SIGNAL(clicked(NotificationItem*)), this, SLOT(onNotificationClicked(NotificationItem*)));
            item->setObjectId(notification["object_id"]);
            item->setObjectType(notification["object_type"]);
            item->setUserId(notification["sender_id"]);
            item->setText(notification["title_text"]);
            bool isUnread = false;
            if (notification["is_unread"].toInt() == 1)
                isUnread = true;
            item->setUnread(isUnread);
            ui->layout->addWidget(item);
            notificationItems.append(item);
        }
    }
}

void NotificationsDialog::onNotificationClicked(NotificationItem *item)
{
    this->close();
    QString type = item->objectType();
    if (type == "stream") {
        SinglePostWindow *post = new SinglePostWindow(this->parentWidget(), accessToken);
        post->loadPost(item->objectId());
        post->show();
    } else if (type == "group") {
        ProfileWindow *group = new ProfileWindow(this->parentWidget(), accessToken);
        group->browseProfile(item->objectId());
        group->show();
    } else if (type == "photo") {
        PhotoWindow *photo = new PhotoWindow(this->parentWidget(), accessToken);
        photo->showPhotoFromId(item->objectId());
        photo->setWindowTitle("Photo");
        photo->show();
    }
}

void NotificationsDialog::showEvent(QShowEvent *)
{
    this->updateNotifications();
}
