#include "newsfeedwindow.h"
#include "ui_newsfeedwindow.h"

NewsFeedWindow::NewsFeedWindow(QWidget *parent, QString token) :
    QMainWindow(parent),
    ui(new Ui::NewsFeedWindow),
    accessToken(token),
    qfacebook(new QFacebook(token, this)),
    nam(new QNetworkAccessManager(this))
{
    ui->setupUi(this);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    connect(ui->newStatusButton, SIGNAL(clicked()), this, SLOT(onNewStatusUpdateButtonClicked()));
    connect(ui->actionRefresh, SIGNAL(triggered()), this, SLOT(updateNewsFeed()));
    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));
    this->orientationChanged();
    this->updateNewsFeed();
}

NewsFeedWindow::~NewsFeedWindow()
{
    delete ui;
}

void NewsFeedWindow::orientationChanged()
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
    ui->scrollAreaWidgetContents->setMaximumWidth(screenGeometry.width()-10);
}

void NewsFeedWindow::onNewStatusUpdateButtonClicked()
{
    NewStatusUpdateDialog *dialog = new NewStatusUpdateDialog(this);
    connect(dialog, SIGNAL(postUpdate(QString,QString,QString)), this, SLOT(postUpdate(QString,QString,QString)));
#ifdef Q_WS_S60
    dialog->showMaximized();
#else
    dialog->show();
#endif
}

void NewsFeedWindow::postUpdate(QString text, QString link, QString video)
{
    QByteArray data;
    if (!text.isEmpty()) {
        data.append("message=" + text);
        if (!link.isEmpty() || !video.isEmpty())
            data.append("&");
    }
    if (!link.isEmpty()) {
        data.append("link=" + link);
        if (!video.isEmpty())
            data.append("&");
    }
    if (!video.isEmpty())
        data.append("video=" + video);
    qDebug() << data;

    qfacebook->putObject("me", "feed", data);
}

void NewsFeedWindow::updateNewsFeed()
{
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif

    QString limit = QSettings().value("main/newsFeedLimit", "80").toString();
    this->reply = qfacebook->getConnections("me", QString("home&limit=%1").arg(limit));
    if (this->reply)
        connect(reply, SIGNAL(finished()), this, SLOT(onReplyFinished()));
}

void NewsFeedWindow::onNameClicked(QString id, QString name)
{
    ProfileWindow *profile = new ProfileWindow(this, accessToken);
    profile->browseProfile(id);
    profile->setWindowTitle(name);
    profile->show();
}

void NewsFeedWindow::onReplyFinished()
{
    if (!posts.isEmpty()) {
        foreach (NewsFeedPost *post, posts) {
            ui->scrollLayout->removeWidget(post);
            delete post;
        }
        ui->scrollLayout->addItem(ui->verticalSpacer);
        posts.clear();
    }

    if (this->reply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to fetch news feed!";
        this->reply->deleteLater();
        this->reply = 0;

        return;
    }

    QVariant jsonData = this->reply->data();
    QVariantList listData;
    this->myId = QSettings().value("main/myId").toString();
    listData = jsonData.toMap().value("data").toList();
    ui->scrollLayout->removeItem(ui->verticalSpacer);
    foreach(jsonData, listData) {
        NewsFeedPost *post = new NewsFeedPost(ui->scrollArea, accessToken, qfacebook, nam);
        connect(post, SIGNAL(commentButtonClicked(QString,QString,QString)),
                this, SLOT(onCommentButtonClicked(QString,QString,QString)));
        connect(post, SIGNAL(nameClicked(QString,QString)), this, SLOT(onNameClicked(QString,QString)));
        QString name = jsonData.toMap().value("from").toMap().value("name").toString();
        QString userId = jsonData.toMap().value("from").toMap().value("id").toString();
        if (userId.contains(myId))
            post->setDeletable(true);
        post->setUserId(userId);
        QString message = jsonData.toMap().value("message").toString();
        QString icon = jsonData.toMap().value("icon").toString();
        QString time = jsonData.toMap().value("created_time").toString();
        QString link = jsonData.toMap().value("link").toString();
        if (!link.isEmpty()) {
            message.append("\nAttached links:\n");
            message.append(link + "\n");
            message.append(jsonData.toMap().value("name").toString() + "\n");
            message.append(jsonData.toMap().value("caption").toString() + "\n");
            message.append(jsonData.toMap().value("description").toString() + "\n");
        }

        // Check if the currently logged in user likes the post
        QVariantList likes = jsonData.toMap().value("likes").toMap().value("data").toList();
        bool meLikesThis = false;
        foreach (QVariant likeId, likes) {
            QVariantMap map = likeId.value<QVariantMap>();
            QString likerId = map.value("id").toString();
            if (likerId.contains(this->myId))
                meLikesThis = true;
            else
                meLikesThis = false;
        }

        // Get like and comment count.
        QString likesCount = jsonData.toMap().value("likes").toMap().value("count").toString();
        if (likesCount.isEmpty())
            likesCount = "0";
        QString comments = jsonData.toMap().value("comments").toMap().value("count").toString();
        if (comments.isEmpty())
            comments = "0";

        // Set parsed data
        post->setName(name);
        post->setMessage(message);
        post->setId(jsonData.toMap().value("id").toString());
        post->getPixmapFromUrl(QString("http://graph.facebook.com/%1/picture").arg(userId));
        post->setLikedByMe(meLikesThis);
        post->setNumberOfLikesComments(likesCount, comments);
        post->setIconFromUrl(icon);
        post->setTime(time);
        posts.append(post);
        ui->scrollLayout->addWidget(post);
    }
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
}

void NewsFeedWindow::onCommentButtonClicked(QString id, QString comments, QString likes)
{
    qDebug() << id;
    SinglePostWindow *window = new SinglePostWindow(this, accessToken);
    window->loadPost(id);
    window->setCountLabel(comments, likes);
#ifdef Q_WS_S60
    window->showMaximized();
#else
    window->show();
#endif
}
