#include "messageview.h"
#include "ui_messageview.h"

MessageView::MessageView(QWidget *parent, QString token) :
    QMainWindow(parent),
    ui(new Ui::MessageView),
    accessToken(token),
    qfacebook(new QFacebook(token, this))
{
    ui->setupUi(this);
    setAttribute(Qt::WA_DeleteOnClose);
    ui->replyButton->setMinimumHeight(ui->replyText->sizeHint().height());
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
}

MessageView::~MessageView()
{
    delete ui;
}

void MessageView::parseMessageById(QString id)
{
    this->reply = qfacebook->getObject(id);
    if (this->reply)
        connect(reply, SIGNAL(finished()), this, SLOT(onReplyReceived()));
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif
}

void MessageView::onReplyReceived()
{
    if (this->reply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to fetch messages!";
        this->reply->deleteLater();
        this->reply = 0;

        return;
    }

    QVariant jsonData = this->reply->data();
    QListWidgetItem *item = new QListWidgetItem();
    QString from = jsonData.toMap().value("from").toMap().value("name").toString();
    this->setWindowTitle(this->windowTitle() + " " + tr("with") + " " + from);
    item->setText(from + "\n\n" + jsonData.toMap().value("message").toString());
    ui->messageList->addItem(item);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
}
