#!/usr/bin/python

##############################################################
##   snuggle - CellID to Geolocation using google's APIs    ##
##############################################################
# get cellid codes via dbus command
#     MCC   :   Mobile Country Code;   
#     MNC   :   Mobile Network Code;
#     LAC   :   Local Area Code;    
#     CellID:   Cellid;
##############################################################


# Copyright (c) 2011 Christos Zamantzas
# Licenced under GPLv2

#Author: Christos Zamantzas <christos.zamantzas@gmail.com>
Version = '2.8-0'

# standard modules
import os
import sys
import time
import csv
import sqlite3


# access modules
from struct import pack, unpack
from httplib import HTTP
import urllib2
import urllib

# Constants 
country         = "en"
device          = "Nokia-N900-M5"
user_agent      = 'Mozilla/4.0 (compatible; MSIE 5.5; Windows NT)'
url_mmap        = 'http://www.google.com/glm/mmap'
url_geo         = 'http://maps.google.com/maps/geo'
url_map         = 'http://maps.google.com/maps'

# application paths and names                             
LogPath         = '/home/user/.config/snuggle'

LogCellInfo     = 'cellInfo.csv'
LogGeoInfo      = 'geoLocation.csv'
kmlInfo         = 'geoLocation.kml'
dbInfo          = 'snuggle.db'

# dbus variables
dbus_browser    = 'dbus-send --system --type=method_call\
                            --dest="com.nokia.osso_browser"\
                            --print-reply /com/nokia/osso_browser/request\
                            com.nokia.osso_browser.load_url string:'

def checkFile(Path, File):       
    ''' Check if a file exists and is readable. '''

    try:
       f = open(Path + '/' + File, 'r')
       f.close()
    except:
       return False
    else:
       return True

def createDB():
    ##Check if db exist, if not create it
    if (checkFile(LogPath, dbInfo) == False) or (os.stat(LogPath+'/'+dbInfo).st_size == 0):
        conn = None
        try:
            conn = sqlite3.connect('%s/%s' % (LogPath, dbInfo))
            c = conn.cursor()

            # Create table
            c.execute('''create table CellIDs (Timestamp text, CELLID INTEGER, LAC INTEGER, MNC INTEGER, MCC INTEGER)''')
            c.execute('''create table Locations (Timestamp text, LAT REAL, LON REAL)''')
            conn.commit()
            c.close()
        except sqlite3.Error, e:
            print "Error %s" % e.args[0]
    else:
       pass

#class snuggleLocationGetter():    

def addCellID2db(Timestamp, CELLID, LAC, MNC, MCC):
    '''add Cell info to the db'''
    
    conn = sqlite3.connect('%s/%s' % (LogPath, dbInfo))
    c = conn.cursor()
    c.execute('''insert into CellIDs values ('%s',%s,%s,%s,%s)''' %(Timestamp, CELLID, LAC, MNC, MCC))
    conn.commit()
    c.close()

def addLocation2db(Timestamp, LAT, LON):
    '''add Location info to the db'''

    conn = sqlite3.connect('%s/%s' % (LogPath, dbInfo))
    c = conn.cursor()
    c.execute('''insert into Locations values ('%s',%s,%s)''' %(Timestamp, LAT, LON))
    conn.commit()
    c.close()

def fetch_latlong_http(query):
    http = HTTP('www.google.com', 80)
    http.putrequest('POST', '/glm/mmap')
    http.putheader('Content-Type', 'application/binary')
    http.putheader('Content-Length', str(len(query)))
    http.endheaders()
    http.send(query)
   
    code, msg, headers = http.getreply()
    result = http.file.read()
   
    return result    

def get_location_by_cell(cid, lac, mnc=0, mcc=0, country='en'):
    latitude = 0
    longitude = 0
    validData = 'False'         
    try:
       b_string = pack('>hqh2sh13sh5sh3sBiiihiiiiii',
                      21, 0,
                      len(country), country,
                      len(device), device,
                      len('1.3.1'), "1.3.1",
                      len('Web'), "Web",
                      27, 0, 0,
                      3, 0, cid, lac,
                      0, 0, 0, 0)
    except:
       message = 'WARNING: Could not construct the http call for fetching the location'
       pass
    else:
       try:
           bytes = fetch_latlong_http(b_string)
           #bytes = self.fetch_latlong_urllib(b_string)
           (a, b, errorCode, latitude, longitude, c, d, e) = unpack(">hBiiiiih",bytes)
           print 'ErrorCode: ', errorCode
       except:
           message = 'WARNING: Could not get a valid responce from the MMAP API'
           pass
       else:
           latitude = latitude / 1000000.0
           longitude = longitude / 1000000.0
           message = 'INFO: Got the LAT and LON for this cellID.'
           validData = 'True'
                
    return latitude, longitude, validData, message

def transferLogToDB():
       
    os.system( 'echo \"Timestamp,LAT,LON\" > %s/%s' % ( LogPath, LogGeoInfo )) 

    cellReader = csv.reader(open('%s/%s' % (LogPath, LogCellInfo), 'rb'), delimiter=',') 

    # Read the column names from the first line of the file  
    fields = cellReader.next()
    #print fields
    for row in cellReader:  
       # Zip together the field names and values  
       items = zip(fields, row)
       item = {}
       # Add the value to our dictionary  
       for (name, value) in items:  
          item[name] = value.strip()  
       print item['Timestamp'], item['MCC'], item['MNC'], item['LAC'], item['CELLID']
       
       addCellID2db(item['Timestamp'], int(item['CELLID']), int(item['LAC']), int(item['MNC']), int(item['MCC']))
       
       LAT,LON,validData,message = get_location_by_cell(int(item['CELLID']), int(item['LAC']), int(item['MNC']), int(item['MCC']))
       print LAT,LON,validData,message

       if validData == 'True':
          os.system( 'echo \"%s,%s,%s\" >> %s/%s' % ( item['Timestamp'], LAT, LON, LogPath, LogGeoInfo )) 
          addLocation2db(item['Timestamp'], LAT, LON)

    #delete the current logs
    os.system ( 'echo \"Timestamp,MCC,MNC,LAC,CELLID\" > %s/%s' % (LogPath, LogCellInfo) )

def createKML_old(): 
   # Create the header of the file    
    try:
       destination = open( LogPath + "/" + kmlInfo, "w" )
       destination.write('''<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<kml xmlns=\"http://earth.google.com/kml/2.2\">
  <Document>
    <name>Points with TimeStamps</name>
    <Style id=\"paddle-a\">
      <IconStyle>
        <Icon>
          <href>http://maps.google.com/mapfiles/kml/paddle/A.png</href>
        </Icon>
        <hotSpot x=\"32\" y=\"1\" xunits=\"pixels\" yunits=\"pixels\"/>
      </IconStyle>
    </Style>
    <Style id=\"paddle-b\">
      <IconStyle>
        <Icon>
          <href>http://maps.google.com/mapfiles/kml/paddle/B.png</href>
        </Icon>
        <hotSpot x=\"32\" y=\"1\" xunits=\"pixels\" yunits=\"pixels\"/>
      </IconStyle>
    </Style>
    <Style id=\"hiker-icon\">
      <IconStyle>
        <Icon>
          <href>http://maps.google.com/mapfiles/ms/icons/hiker.png</href>
        </Icon>
        <hotSpot x=\"0\" y=\".5\" xunits=\"fraction\" yunits=\"fraction\"/>
      </IconStyle>
    </Style>
    <Style id=\"check-hide-children\">
      <ListStyle>
        <listItemType>checkHideChildren</listItemType>
      </ListStyle>
    </Style>
    <styleUrl>#check-hide-children</styleUrl>''')
       destination.close()

    except Exception, e:
       print '<<< Snuggle ERROR when writing the header:\n%s >>>' % e


    # Read the csv file with the location info
    geoReader = csv.reader( open('%s/%s' % (LogPath, LogGeoInfo), 'rb' ), delimiter=',' ) 

    # Read the column names from the first line of the file  
    fields = geoReader.next()
    #print fields
    for row in geoReader:  
       # Zip together the field names and values  
       items = zip(fields, row)
       item = {}
       # Add the value to the dictionary  
       for (name, value) in items:  
          item[name] = value.strip()  

       # Append the new entry to the kml formated file
       try:
          destination = open( LogPath + "/" + kmlInfo, "a" )
          destination.write('''
    <Placemark>
      <TimeStamp>
        <when>%s</when>
      </TimeStamp>
      <styleUrl>#paddle-a</styleUrl>
      <Point>
        <coordinates>%s,%s,0</coordinates>
      </Point>
    </Placemark>''' % (item['Timestamp'], item['LON'], item['LAT']))
          destination.close()
       except Exception, e:
          print '<<< Snuggle ERROR when writing the coordinates:\n%s >>>' % e
                           
    # Create the footer of the file
    try:
       destination = open( LogPath + "/" + kmlInfo, "a" )
       destination.write('''
  </Document>
</kml>''')
       destination.close()

    except Exception, e:
       print '<<< Snuggle ERROR when writing the footer:\n%s >>>' % e
   
##NEW Version:
def createKML(): ##FIXME: use the other type of KML or create a second type for http://www.gpsvisualizer.com/
   # Create the header of the file    
    try:
       destination = open( LogPath + "/" + kmlInfo, "w" )
       destination.write('''<?xml version="1.0" standalone="yes"?>
<kml xmlns="http://earth.google.com/kml/2.2">
  <Document>
    <Folder id="Tracks">
      <Placemark>
        <MultiGeometry>
          <LineString>
            <altitudeMode>clampToGround</altitudeMode>
            <coordinates>''')
       destination.close()

    except Exception, e:
       print '<<< Snuggle ERROR when writing the header:\n%s >>>' % e


    # Read the csv file with the location info
    geoReader = csv.reader( open('%s/%s' % (LogPath, LogGeoInfo), 'rb' ), delimiter=',' ) 

    # Read the column names from the first line of the file  
    fields = geoReader.next()
    #print fields
    for row in geoReader:  
       # Zip together the field names and values  
       items = zip(fields, row)
       item = {}
       # Add the value to the dictionary  
       for (name, value) in items:  
          item[name] = value.strip()  

       # Append the new entry to the kml formated file
       try:
          destination = open( LogPath + "/" + kmlInfo, "a" )
          destination.write('''%s,%s,0 ''' % (item['LON'], item['LAT']))
          destination.close()
       except Exception, e:
          print '<<< Snuggle ERROR when writing the coordinates:\n%s >>>' % e
                           
    # Create the footer of the file
    try:
       destination = open( LogPath + "/" + kmlInfo, "a" )
       destination.write('''</coordinates>
            <tessellate>0</tessellate>
          </LineString>
        </MultiGeometry>
        <Snippet></Snippet>
        <Style>
          <LineStyle>
            <color>FF0000E6</color>
            <width>2</width>
          </LineStyle>
        </Style>
        <description><![CDATA[&nbsp;]]></description>
        <name><![CDATA[%s]]></name>
      </Placemark>
      <name>Tracks</name>
      <open>0</open>
      <visibility>1</visibility>
    </Folder>
    <Snippet><![CDATA[created using <A href="http://wiki.maemo.com/snuggle">Snuggle</A>]]></Snippet>
    <name><![CDATA[%s]]></name>
    <open>1</open>
    <visibility>1</visibility>
  </Document>
</kml>''' % (kmlInfo, kmlInfo))
       destination.close()

    except Exception, e:
       print '<<< Snuggle ERROR when writing the footer:\n%s >>>' % e
       
############################################
## MAIN ##

#createDB()
# following commands are executed from the GUI:
#transferLogToDB()
#createKML()

#############
