#include "motionsenser.h"

#include <QTimerEvent>
#include <QFile>
#include <QKeyEvent>
#include <QRegExp>
#include <QDebug>

static const QString PROC_ENTRY = "/sys/class/i2c-adapter/i2c-3/3-001d/coord";

MotionSenser::MotionSenser(QObject *parent)
    : QThread(parent)
{
    mLastPos = mCurrentPos = QPointF(0,0);
    start();
}

MotionSenser::~MotionSenser()
{
    terminate();
}

void MotionSenser::run()
{
    while( true ) {
        sendEvent();
        msleep( 100 );
    }
}

void MotionSenser::sendEvent()
{    
    readCurrentPos();

    int xDiff = qAbs( mLastPos.x() - mCurrentPos.x() );
    int yDiff = qAbs( mLastPos.y() - mCurrentPos.y() );

    if( xDiff > yDiff && xDiff >= 800 ) {

        if( mLastPos.x() < mCurrentPos.x() ) {
            emit keyEvent( QPoint( -1,0));
        } else {
           emit keyEvent( QPoint( 1,0));
        }

    } else if ( yDiff >= 800 ) {

        if( mLastPos.y() < mCurrentPos.y() ) {
            emit keyEvent( QPoint( 0,-1));
        } else {
            emit keyEvent( QPoint( 0,1));
        }
    }

    mLastPos = mCurrentPos;
}

void MotionSenser::readCurrentPos()
{
    QFile f(PROC_ENTRY);
    if (!f.exists() or !f.open(QIODevice::ReadOnly | QIODevice::Text)) {        
        ////qDebug() << "could not read motion data";
    }
    else {
        QByteArray line = f.readLine();
        QRegExp rx("([0-9-]+) ([0-9-]+) ([0-9-]+)");

        rx.indexIn(line);
        qreal x = rx.cap(1).toInt();
        qreal y = rx.cap(2).toInt();

        mCurrentPos.setX(x*10);
        mCurrentPos.setY(y*10);

        f.close();
    }
}
