#ifndef SNAKE_H
#define SNAKE_H

#include <QList>
#include <QPoint>
#include <QPainter>
#include <QBrush>

class Snake
{
public:

    Snake();

    ~Snake();

    void turn( QPoint aDirection );

    void move();

    bool isColliding( QPoint aMousePosition );

    bool isCollidingWithSelf();

    void increseLength( int aLenthToIncrement );

    void draw( QPainter* aPainter );

    QPoint pos() const;

    QPoint direction() const;

private:

    struct Turn
    {
        QPoint mLocation;
        QPoint mDirection;

        Turn()
        {
        }

        Turn( const Turn& aOtherTurn )
        {
            mLocation = aOtherTurn.mLocation;
            mDirection = aOtherTurn.mDirection;
        }

    };

    bool bouceIfNeeded( Turn* aTurn);

    QList<Turn*> mSnake;
    QList<Turn*> mTurns;

    QBrush mSnakeBrush;
};

#endif // SNAKE_H
