#ifndef MYBUTTON_H
#define MYBUTTON_H

#include <QWidget>
#include <QLabel>
#include <QVBoxLayout>

class MyButton: public QWidget
{
    Q_OBJECT
public:

    MyButton( const QPixmap& aPixmap, const QString& aText )
    {
        QLabel* iconLabel = new QLabel;
        iconLabel->setPixmap( aPixmap );
        iconLabel->setAlignment(Qt::AlignCenter);

        QLabel* textLabel = new QLabel( aText );
        textLabel->setAlignment(Qt::AlignCenter);

        QVBoxLayout* mainLayout = new QVBoxLayout(this);
        mainLayout->addWidget(  iconLabel );
        mainLayout->addWidget( textLabel );
    }

signals:

    void clicked();

private:

    void mousePressEvent(QMouseEvent *)
    {
        emit clicked();
    }
};

#endif // MYBUTTON_H
