//    smssend
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "ptyi.h"

#undef DEBUG

Pty::Pty()
{
    m_Fd = 0;
    m_Pid = 0;
}

Pty::~Pty()
{
    if (m_Fd)
        close(m_Fd);
    if (m_Pid > 0)
        kill(m_Pid, SIGKILL);
}

bool Pty::run(QString pgm, QStringList)
{
    m_Pid = forkpty(&m_Fd, NULL, NULL, NULL);
    if (m_Pid == -1) {
      perror("forkpty");
      return false;
    } else if (m_Pid == 0) {
      if (execlp(pgm.toLatin1(), pgm.toLatin1(), (void*)0) == -1) {
        perror("execlp");
      }
      return false;
    }
#ifdef DEBUG
    printf("Child process: %d\n", m_Pid);
    printf("master fd: %d\n", m_Fd);
#endif

    // Set non-blocking
    int flags;
    if ((flags = fcntl(m_Fd, F_GETFL, 0)) == -1)
      flags = 0;
    if (fcntl(m_Fd, F_SETFL, flags | O_NONBLOCK) == -1) {
      perror("fcntl");
      return false;
    }
    return true;
}

bool Pty::writeCmd(QString* message, QString* response, int msecTimeout)
{
    if (response)
        response->clear();
    QByteArray arr = message->toLatin1();
    const char* cmd = arr.constData();
    if (write(m_Fd, cmd, strlen(cmd)) == -1) {
        perror("write");
        return false;
    }

    int totWait = 0;
    char buf[255];
    while (1) {
        int nread = read(m_Fd, buf, 254);
        if (nread == -1) {
          if (errno == EAGAIN &&
             (totWait < msecTimeout || msecTimeout < 0)) {
            // no, sleep and try again
            if (msecTimeout >= 0)
                totWait++;
            usleep(1000);
            continue;
          }
          //perror("read");
          break;
        }
        if (response){
            for (int i = 0; i < nread; i++) {
                response->append(buf[i]);
            }
#ifdef DEBUG
            printf(buf);
#endif
        }
    }
    return true;
}
