# To change this template, choose Tools | Templates
# and open the template in the editor.

__author__="nerdknight"
__date__ ="$01/04/2011 21:53:44$"

import sys
from PyQt4 import QtCore, QtGui

class GraphCanvas(QtGui.QWidget):
    def __init__(self,graph):
        QtGui.QWidget.__init__(self,graph)
        self.graph=graph
        self.setMinimumSize(300,300)
        self.dataWidth=0
        self.scale=0
        self.floor=0
        self.minDat=-1
        self.maxDat=-sys.maxint
        self.legendGap=20
        self.actY=0
        self.selData=None
    def mousePressEvent(self,event):
        cantx=len(self.graph.xData)
        canty=len(self.graph.yData)
        self.selData=None
        for i in range(cantx):
            for j in range(canty):
                if self.getDataRect(i, j).contains(event.pos()):
                    self.selData=QtCore.QPoint(i,j)
                    self.update()
                    return

    def setGeometry(self,x,y,w,h):
        QtGui.QWidget.setGeometry(self,x,y,w,h)
        self.calculateGraphViewport()
    def calculateGraphViewport(self):
        self.graph.viewPortHeight=self.height()
        cantx=len(self.graph.xData)
        graphWidth=(self.getDataWidth()+2*self.graph.dataGap)*cantx+self.graph.leftGap+self.graph.rightGap
        if graphWidth>self.width():
            self.graph.viewPortWidth=graphWidth
        else:
            self.graph.viewPortWidth=self.width()
        QtGui.QWidget.setGeometry(self,0,0,self.graph.viewPortWidth,self.graph.viewPortHeight)
        self.calculateData()
    def getDataWidth(self):
        return (len(self.graph.yData)*(self.graph.barWidth+2)-2)
    def getDataRect(self,i,j):
        dataWidth=self.getDataWidth()
        x=self.graph.leftGap+15+(dataWidth+2*self.graph.dataGap)*i+(j*(self.graph.barSeparation+self.graph.barWidth))+self.graph.dataGap
        dat=self.graph.yData[j][i]*self.scale
        y=self.actY-dat
        return QtCore.QRect(x,y,self.graph.barWidth,dat)
    def calculateData(self):
        cantx=len(self.graph.xData)
        canty=len(self.graph.yData)
        self.dataWidth=self.getDataWidth()
        self.minDat=-1
        self.maxDat=-sys.maxint
        for i in range(cantx):
            for j in range(canty):
                v=self.graph.yData[j][i]
                if v<self.minDat:
                    self.minDat=v
                if v>self.maxDat:
                    self.maxDat=v
        if self.maxDat<0:
            self.maxDat=1
        self.floor=self.graph.viewPortHeight-self.graph.bottomGap
        self.floor-=25*round(round(len(self.graph.yLabels)/3,1)+0.9)
        self.scale=0
        self.legendGap=20
        if self.minDat<-self.legendGap:
            self.legendGap=0
        if self.maxDat!=self.minDat:
            self.scale=float((self.floor-self.legendGap-self.graph.topGap))/(self.maxDat-self.minDat)

        self.actY=self.floor+self.minDat*self.scale-self.legendGap
    def paintEvent(self, event):
        cantx=len(self.graph.xData)
        canty=len(self.graph.yData)
        scrollPos=self.graph.horizontalScrollBar().value()
        paint = QtGui.QPainter(self)
        paint.setFont(QtGui.QFont("Sans Serif",10))
        paint.setBrush(QtCore.Qt.black)
        paint.drawRect(self.graph.leftGap,self.graph.topGap,self.graph.viewPortWidth-self.graph.rightGap,self.graph.viewPortHeight-self.graph.bottomGap)

        pen = QtGui.QPen(QtCore.Qt.lightGray, 1, QtCore.Qt.DashLine)
        paint.setPen(pen)
        rr=1
        if self.scale<25:
            rr=int((float(15)/self.scale)+0.9)
        for i in range(self.minDat,self.maxDat+1):
            if i%rr==0:
                pos=self.actY-self.scale*i
                rect=QtCore.QRect(self.graph.leftGap+scrollPos,pos,50,25)
                paint.drawText(rect,QtCore.Qt.AlignLeft,str(i))
                paint.drawLine(self.graph.leftGap,pos,self.graph.viewPortWidth-self.graph.rightGap,pos)

        paint.setPen(QtCore.Qt.lightGray)
        actX=self.graph.leftGap+15
        selRect=None
        selVal=None
        for i in range(cantx):
            for j in range(canty):
                paint.setBrush(self.graph.yColor[j%len(self.graph.yColor)])
                dat=self.graph.yData[j][i]*self.scale
                sel=0
                if self.selData!=None:
                    if self.selData.x()==i and self.selData.y()==j:
                        sel=5
                rect=QtCore.QRect(actX-sel/2+(j*(self.graph.barSeparation+self.graph.barWidth))+self.graph.dataGap,self.actY-dat,self.graph.barWidth+sel,dat)
                paint.drawRect(rect)
                if(sel!=0):
                    rect.moveLeft(rect.left()+self.graph.barWidth+sel+2)
                    selRect=rect
                    selVal=self.graph.yData[j][i]

            rect=QtCore.QRect(actX,self.actY,self.dataWidth+2*self.graph.dataGap,20)
            paint.setBrush(QtCore.Qt.white)
            fAnt=paint.font()
            f=QtGui.QFont("Sans Serif",10)
            f.setBold(True)
            paint.setFont(f)
            paint.drawText(rect,QtCore.Qt.AlignCenter,self.graph.xData[i])
            paint.setFont(fAnt)
            actX=actX+self.dataWidth+2*self.graph.dataGap
        if selRect!=None:
            aPen=paint.pen()
            fAnt=paint.font()
            f=QtGui.QFont("Sans Serif",12)
            f.setItalic(True)
            fm=QtGui.QFontMetrics(f)
            selRect.setHeight(fm.height())
            selRect.setWidth(fm.width(str(selVal)))
            paint.setFont(f)
            aBrush=paint.brush()
            paint.setBrush(QtCore.Qt.darkRed)
            paint.setPen(QtCore.Qt.NoPen)
            paint.drawRect(selRect)
            paint.setPen(QtCore.Qt.white)
            paint.drawText(selRect,QtCore.Qt.AlignLeft,str(selVal))
            paint.setFont(fAnt)
            paint.setPen(aPen)
            paint.setBrush(aBrush)
        for i in range(len(self.graph.yLabels)):
            xPos=(i%3)*185+scrollPos
            yPos=self.floor+(i//3)*25
            rect=QtCore.QRect(self.graph.leftGap+xPos,yPos+7.5,25,5)
            paint.setBrush(self.graph.yColor[i%len(self.graph.yColor)])
            paint.drawRect(rect)
            rect=QtCore.QRect(self.graph.leftGap+30+xPos,yPos,100,20)
            paint.drawText(rect,QtCore.Qt.AlignLeft&QtCore.Qt.AlignVCenter,self.graph.yLabels[i])

class Graph(QtGui.QScrollArea):
    def __init__(self,parent=None):
        QtGui.QScrollArea.__init__(self,parent)
        self.graphCanvas=GraphCanvas(self)
        self.barWidth=5
        self.barSeparation=2
        self.dataGap=30
        self.bottomGap=0
        self.leftGap=10
        self.topGap=0
        self.rightGap=10
        self.viewPortWidth=0
        self.viewPortHeight=0
        self.xData=[]
        self.yData=[]
        self.yLabels=[]
        self.yColor=[QtCore.Qt.blue,QtCore.Qt.green,QtCore.Qt.red,QtCore.Qt.yellow,QtCore.Qt.cyan,QtCore.Qt.darkGreen]
        self.setGeometry(0,0,400,400)
        self.setWidget(self.graphCanvas)
    
    def setData(self,xd,yd,yl=[]):
        self.xData=xd
        self.yData=yd
        self.yLabels=yl
        self.graphCanvas.calculateGraphViewport()
        self.graphCanvas.update()
    def scrollContentsBy(self,dx,dy):
        QtGui.QScrollArea.scrollContentsBy(self,dx,dy)
        self.graphCanvas.update()
    def resizeEvent(self,event):
        self.graphCanvas.setGeometry(0,0,self.viewport().width(),self.viewport().height())
class MainWindow(QtGui.QWidget):
    def __init__(self,parent=None):
        QtGui.QMainWindow.__init__(self,parent)
        self.setObjectName("MainWindow")
        self.setGeometry(0,0,800, 480)
        self.graph=Graph(self)
        self.gl = QtGui.QHBoxLayout(self)
        self.gl.addWidget(self.graph)    
        self.graph.dataGap=180
        xData = ["A","B","C"]
        yData=[]
        yData.append([-3,4,-2])
        yData.append([6,3,2])
        yData.append([-7,-1,-2])
        yData.append([5,29,-6])
        yLabels=["Label 1","Label 2","Label 3","Label 4"]
        self.graph.setData(xData, yData,yLabels)

if __name__ == "__main__":
    app = QtGui.QApplication(sys.argv)
    MainWindow = MainWindow()
    MainWindow.show()
    sys.exit(app.exec_())
