#!/usr/bin/python
# -*- coding: utf-8 -*-
from datetime import datetime,timedelta
from PyQt4 import QtCore
import time
import os
import dbus
import gobject
from dbus.mainloop.glib import DBusGMainLoop
import gtk
import hildondesktop
import hildon
import sys
sys.path.insert(0,"/opt/smscounter")
import SMSCounter
import subprocess
import sys
f=open('/tmp/smscw.log', 'at', buffering=1)
sys.stdout=f
sys.stderr=f
class sms_counter():
	def __init__(self):
		self.sent = 0
		self.received = 0
	def getD2(self,d1):
		d2=None
		if d1 > 0:
		      d2=time.gmtime(d1)
		      d2=QtCore.QDate(d2[0],d2[1],d2[2])
		      d2=d2.addMonths(1)
		      d2=SMSCounter.strDateToBD(str(d2.toString("dd.MM.yyyy")))
		return d2
	def update_sms_counters(self, start_time):
		d1=start_time
		d2=self.getD2(d1)
		self.received = SMSCounter.getReceivedSMS(d1,d2)
		self.sent = SMSCounter.getSentSMS(d1,d2)
	def update_call_counters(self, start_time):
		d1=start_time
		d2=self.getD2(d1)
		self.received = SMSCounter.getReceivedCalls(d1,d2)
		self.sent = SMSCounter.getMadeCalls(d1,d2)

class SMS_widget(hildondesktop.HomePluginItem):
	def callback_function(self, button, data=""):
		self.update_widget()

	def __init__(self):
		hildondesktop.HomePluginItem.__init__(self)
		self.set_settings(True)
		self.connect("show-settings", self.show_settings)

		self.this_month_sms = sms_counter()
		self.all_sms = sms_counter()
		self.this_month_calls = sms_counter()
		self.all_calls = sms_counter()
		self.load()
		self.table=None
		
		#SMSs
		self.this_period_sms_sent = gtk.Label('0')
		self.this_month_sms_received = gtk.Label('0')
		self.this_month_sms_total = gtk.Label('0')
		self.all_sms_sent = gtk.Label('0')
		self.all_sms_received = gtk.Label('0')
		self.all_sms_total = gtk.Label('0')
		self.received_sms_title = gtk.Label('Received SMSs')
		self.box_for_received_sms = gtk.HBox()
		
		self.sent_sms_title = gtk.Label('Sent SMSs')
		self.box_for_sent_sms = gtk.HBox()
		
		self.total_sms_title = gtk.Label('Total SMSs')
		self.box_for_total_sms = gtk.HBox()
		
		#Calls
		self.this_period_calls_sent = gtk.Label('0')
		self.this_month_calls_received = gtk.Label('0')
		self.this_month_calls_total = gtk.Label('0')
		self.all_calls_sent = gtk.Label('0')
		self.all_calls_received = gtk.Label('0')
		self.all_calls_total = gtk.Label('0')
		self.received_calls_title = gtk.Label('Received Calls')
		self.box_for_received_calls = gtk.HBox()
		
		self.made_calls_title = gtk.Label('Calls made')
		self.box_for_made_calls = gtk.HBox()
		
		self.total_calls_title = gtk.Label('Total Calls')
		self.box_for_total_calls = gtk.HBox()
		

		self.button = gtk.Button("SMSCounter")
		self.button.connect("clicked", self.tableMouseEvent)
		self.initTable()
		
		self.listen()
	def load(self):
		SMSCounter.ConfigData.load()
		self.period_start = SMSCounter.ConfigData.widget_period
		self.showSMS=SMSCounter.ConfigData.widget_showSMS
		self.showCalls=SMSCounter.ConfigData.widget_showCalls
	def save(self):
		SMSCounter.ConfigData.widget_period=self.period_start
		SMSCounter.ConfigData.widget_showSMS=self.showSMS
		SMSCounter.ConfigData.widget_showCalls=self.showCalls
		SMSCounter.ConfigData.save()
		
	def initTable(self):
		if self.table!=None:
			self.remove(self.table)
		numRows=1
		if self.showSMS:
			numRows+=3
		if self.showCalls:
			numRows+=3
		self.resize_children()
		self.table = gtk.Table(numRows,3,False)
		currRow=1
		if self.showSMS:
			self.box_for_sent_sms.pack_end(self.sent_sms_title, False, False)
			self.table.attach(self.box_for_sent_sms, 0, 1, currRow, currRow+1, xpadding=6)
			self.table.attach(self.this_period_sms_sent, 1, 2, currRow, currRow+1)
			self.table.attach(self.all_sms_sent, 2, 3, currRow, currRow+1)
			currRow+=1
			self.box_for_received_sms.pack_end(self.received_sms_title, False, False)
			self.table.attach(self.box_for_received_sms, 0, 1, currRow, currRow+1, xpadding=6)
			self.table.attach(self.this_month_sms_received, 1, 2, currRow, currRow+1)
			self.table.attach(self.all_sms_received, 2, 3, currRow, currRow+1)
			currRow+=1
			self.box_for_total_sms.pack_end(self.total_sms_title, False, False)
			self.table.attach(self.box_for_total_sms, 0, 1, 3, 4, xpadding=6)
			self.table.attach(self.this_month_sms_total, 1, 2, currRow, currRow+1)
			self.table.attach(self.all_sms_total, 2, 3, currRow, currRow+1)
			currRow+=1
		if self.showCalls:
			self.box_for_made_calls.pack_end(self.made_calls_title, False, False)
			self.table.attach(self.box_for_made_calls, 0, 1, currRow, currRow+1, xpadding=6)
			self.table.attach(self.this_period_calls_sent, 1, 2, currRow, currRow+1)
			self.table.attach(self.all_calls_sent, 2, 3, currRow, currRow+1)
			currRow+=1
			self.box_for_received_calls.pack_end(self.received_calls_title, False, False)
			self.table.attach(self.box_for_received_calls, 0, 1, currRow, currRow+1, xpadding=6)
			self.table.attach(self.this_month_calls_received, 1, 2, currRow, currRow+1)
			self.table.attach(self.all_calls_received, 2, 3, currRow, currRow+1)
			currRow+=1
			self.box_for_total_calls.pack_end(self.total_calls_title, False, False)
			self.table.attach(self.box_for_total_calls, 0, 1, currRow, currRow+1, xpadding=6)
			self.table.attach(self.this_month_calls_total, 1, 2, currRow, currRow+1)
			self.table.attach(self.all_calls_total, 2, 3, currRow, currRow+1)
			
			currRow+=1

		self.table.attach(gtk.Label('Month'), 1, 2, 0, 1, xpadding=6)
		self.table.attach(gtk.Label('All-time'), 2, 3, 0, 1, xpadding=6)
		
		self.button = gtk.Button("SMSCounter")
		self.button.connect("clicked", self.tableMouseEvent)
		self.button.show_all()
		self.table.attach(self.button,0,1,0,1)
		self.table.show_all()
		self.add(self.table)
		self.resize_children()
		self.update_widget()

	def tableMouseEvent(self,widget=None, event=None):
		subprocess.Popen(["smscounter"])
	def update_widget(self, dummy1="", dummy2="", dummy3="", dummy4="", dummy5=""):
		t = time.localtime(time.time())
		tt=None
		if t[2] < self.period_start:
                        if t[1] == 1:
                                # need to roll back one year, and to the period start day in December
                                tt=time.mktime((t[0]-1, 12, self.period_start, 0, 0, 0, 0, 0, t[8]))
                        else:
                                # rolling back to period start day in previous month
                                tt=time.mktime((t[0], t[1]-1, self.period_start, 0, 0, 0, 0, 0, t[8]))
                else:        
                        tt=time.mktime((t[0], t[1], self.period_start, 0, 0, 0, 0, 0, t[8]))
		if self.showSMS:
			self.this_month_sms.update_sms_counters(tt)
			self.all_sms.update_sms_counters(0)
			self.this_period_sms_sent.set_text(str(self.this_month_sms.sent))
			self.this_month_sms_received.set_text(str(self.this_month_sms.received))
			self.this_month_sms_total.set_text(str(self.this_month_sms.sent + self.this_month_sms.received))
			self.all_sms_sent.set_text(str(self.all_sms.sent))
			self.all_sms_received.set_text(str(self.all_sms.received))
			self.all_sms_total.set_text(str(self.all_sms.sent + self.all_sms.received))
		if self.showCalls:
			self.this_month_calls.update_call_counters(tt)
			self.all_calls.update_call_counters(0)
			self.this_period_calls_sent.set_text(str(self.this_month_calls.sent))
			self.this_month_calls_received.set_text(str(self.this_month_calls.received))
			self.this_month_calls_total.set_text(str(self.this_month_calls.sent + self.this_month_calls.received))
			self.all_calls_sent.set_text(str(self.all_calls.sent))
			self.all_calls_received.set_text(str(self.all_calls.received))
			self.all_calls_total.set_text(str(self.all_calls.sent + self.all_calls.received))

	def listen(self):
		DBusGMainLoop(set_as_default=True)
		self.bus = dbus.SystemBus()
		self.bus.add_signal_receiver(self.update_widget, path='/com/nokia/phone/SMS', dbus_interface='Phone.SMS', signal_name='IncomingSegment')
		self.bus.add_signal_receiver(self.update_widget, path='/com/nokia/phone/SMS/ba212ae1', dbus_interface='com.nokia.csd.SMS.Outgoing', signal_name='OutgoingSegment')
	
        def show_settings(self, widget):
                dialog = gtk.Dialog()
                dialog.set_transient_for(self)
                dialog.set_title("SMSCounter Widget Settings")
                dialog.add_button("Save", gtk.RESPONSE_OK)
                selector = hildon.TouchSelector(text = True)
                for i in range(1,28):     # works for all months, if 29th or 30th are needed, then some extra logic needs to be inserted in the code
                        selector.append_text("%d" % (i))
                num_itemsPicker = hildon.PickerButton(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
                num_itemsPicker.set_title("First day of period")
                num_itemsPicker.set_selector(selector)
                num_itemsPicker.set_alignment(0.0, 0.5, 1.0, 1.0)
                num_itemsPicker.set_active(self.period_start-1)
                dialog.vbox.add(num_itemsPicker)
		btnSMS = hildon.CheckButton(gtk.HILDON_SIZE_AUTO)
		btnSMS.set_label("Show SMS")
		btnSMS.set_active(self.showSMS)
		dialog.vbox.add(btnSMS)
		btnCalls = hildon.CheckButton(gtk.HILDON_SIZE_AUTO)
		btnCalls.set_label("Show Calls")
		btnCalls.set_active(self.showCalls)
		dialog.vbox.add(btnCalls)
                dialog.show_all()
                response = dialog.run()
                if response == gtk.RESPONSE_OK:
                        new_period_start = num_itemsPicker.get_active() + 1
                        if new_period_start != self.period_start:
                                self.period_start = new_period_start
                                self.update_widget()
                        #if btnSMS.get_active()!=self.showSMS or btnCalls.get_active()!=self.showCalls:
			self.showSMS=btnSMS.get_active()
			self.showCalls=btnCalls.get_active()
			self.save()
			self.initTable()
			
		dialog.destroy()
		self.hide_all()
		self.show_all()

hd_plugin_type = SMS_widget
def loadWidget():
	import gobject
	gobject.type_register(hd_plugin_type)
	obj = gobject.new(hd_plugin_type, plugin_id="SMS_counter")
	obj.show_all()
	gobject.MainLoop().run()
if __name__ == "__main__":
	loadWidget()

