#!/usr/bin/python
# -*- coding: utf-8 -*-

__author__="nerdknight"
__date__ ="$06/03/2011 00:40:36$"

from PyQt4 import QtCore, QtGui, QtMaemo5
import sys
import os
import locale
import threading
from graph import Graph
import calendar
from datetime import datetime,timedelta
from time import mktime
from sqlite3 import dbapi2 as sqlite
DB_FILE="/home/user/.rtcom-eventlogger/el-v1.db"
EVT_SMS="""RTCOM_EL_EVENTTYPE_SMS_MESSAGE"""
EVT_CALL="""RTCOM_EL_EVENTTYPE_CALL"""
EVT_CALL_MISS="""RTCOM_EL_EVENTTYPE_CALL_MISSED"""
EVT_CALL_VOICEMAIL="""RTCOM_EL_EVENTTYPE_CALL_VOICEMAIL"""
CONFIG_DIR="/home/user/.smscounter"
CONFIG_FILE=CONFIG_DIR+"/options.cfg"
def getSQL(sqlstr):
    #print sqlstr
    #sql=pexpect.spawn("sqlite3",[DB_FILE,sqlstr])
    #res=sql.readline()
    #sql.sendeof()
    conn = sqlite.connect(DB_FILE)
    res=conn.execute(sqlstr)
    res=res.fetchone()[0]
    conn.close()
    return res

def getEventType(evt_type):
    return """select id from EventTypes where name=\""""+evt_type+"""\""""

def getSQLTot(evt_type):
    sql="""select count(id) from Events where event_type_id=("""
    sql+=getEventType(evt_type)+""")"""
    return sql

def getDateFilter(date,greater):
    res=""
    if date!=None:
        res=" AND storage_time"
        if greater==True:
            res=res+">="
        else:
            res=res+"<="
        res=res+str(date)
    return res

def getSentSMS(d1=None,d2=None):
    sqlstr=getSQLTot(EVT_SMS)+getDateFilter(d1,True)+getDateFilter(d2,False)+ """ AND outgoing=1"""
    return int(getSQL(sqlstr))

def getReceivedSMS(d1=None,d2=None):
    sqlstr=getSQLTot(EVT_SMS)+getDateFilter(d1,True)+getDateFilter(d2,False) + """   AND outgoing=0"""
    return int(getSQL(sqlstr))

def getSpamSMS(d1=None,d2=None):
    sqlstr=getSQLTot(EVT_SMS)+ getDateFilter(d1,True)+getDateFilter(d2,False)+ """ AND length(remote_uid)<=5"""
    return int(getSQL(sqlstr))

def getMadeCalls(d1=None,d2=None):
    sqlstr=getSQLTot(EVT_CALL)+getDateFilter(d1,True)+getDateFilter(d2,False)+ """ AND outgoing=1"""
    return int(getSQL(sqlstr))

def getMadeCallsDuration(d1=None,d2=None):
    sqlstr="""select sum(case when event_type_id=("""+getEventType(EVT_CALL)+")"+getDateFilter(d1,True)+getDateFilter(d2,False)+ """ AND outgoing=1 AND end_time!=0 then end_time-start_time else 0 end) from Events""" 
    res=(getSQL(sqlstr))
    return float(res)

def getReceivedCalls(d1=None,d2=None):
    sqlstr=getSQLTot(EVT_CALL)+getDateFilter(d1,True)+getDateFilter(d2,False) + """   AND outgoing=0"""
    return int(getSQL(sqlstr))

def getReceivedCallsDuration(d1=None,d2=None):
    sqlstr="""select sum(case when event_type_id=("""+getEventType(EVT_CALL)+")"+getDateFilter(d1,True)+getDateFilter(d2,False)+ """ AND outgoing=0 AND end_time!=0 then end_time-start_time else 0 end) from Events"""
    res=(getSQL(sqlstr))
    return float(res)

def getMissedCalls(d1=None,d2=None):
    sqlstr=getSQLTot(EVT_CALL_MISS)+getDateFilter(d1,True)+getDateFilter(d2,False) + """   AND outgoing=0"""
    return int(getSQL(sqlstr))

def getMinDate():
    d=None
    sqlstr="""select min(storage_time) from Events;"""
    d=int(getSQL(sqlstr))
    d=datetime.fromtimestamp(d)
    return d

def strDateToBD(dateStr):
    d=datetime.strptime(dateStr,"%d.%m.%Y")
    d=d.replace(hour=0,minute=0,second=0)
    d1=int(mktime(d.timetuple()))
    return d1

def datetimeToBD(dt):
    return int(mktime(dt.timetuple()))

def timeFormat(secs):
    res=""
    res+="%02d:"%(secs//3600)
    secs=secs%3600
    res+="%02d:%02d"%(secs//60,secs%60)
    return res

class ConfigData(object):
    sms_cost=0
    call_minute_cost=0
    from_date=""
    to_date=""
    widget_period=1
    widget_showSMS=True
    widget_showCalls=True
    log="Nada"

    @staticmethod
    def save():
        if not os.path.exists(CONFIG_DIR):
            os.makedirs(CONFIG_DIR)
        f=open(CONFIG_FILE,"w")
        f.write("SMSCost="+str(ConfigData.sms_cost)+"\n")
        f.write("CallCost="+str(ConfigData.call_minute_cost)+"\n")
        f.write("from_date="+str(ConfigData.from_date)+"\n")
        f.write("to_date="+str(ConfigData.to_date)+"\n")
        f.write("widget_period="+str(ConfigData.widget_period)+"\n")
        f.write("widget_showSMS="+str(ConfigData.widget_showSMS)+"\n")
        f.write("widget_showCalls="+str(ConfigData.widget_showCalls))
        
    @staticmethod
    def load():
        if os.path.exists(CONFIG_FILE):
            f=open(CONFIG_FILE,"r")
            while True:
                line=f.readline()
                if not line: break
                line=line.split("=")
                if len(line)>=2:
                    try:
                        if line[0]=="SMSCost":
                            ConfigData.sms_cost=float(line[1])
                        elif line[0]=="CallCost":
                            ConfigData.call_minute_cost=float(line[1])
                        elif line[0]=="from_date":
                            ConfigData.from_date=str(line[1]).replace("\n","")
                        elif line[0]=="to_date":
                            ConfigData.to_date=str(line[1]).replace("\n","")
                        elif line[0]=="widget_period":
                            ConfigData.widget_period=int(line[1])
                        elif line[0]=="widget_showSMS":
                            ConfigData.widget_showSMS=(str(line[1]).replace("\n","")=='True')
                        elif line[0]=="widget_showCalls":
                            ConfigData.widget_showCalls=(str(line[1]).replace("\n","")=='True')
                        
                    except Exception, ex:
                        print ex
                        
class About(object):
    def setupUi(self, Form):
        Form.setObjectName("About")
        Form.resize(400, 300)
        self.verticalLayout = QtGui.QVBoxLayout(Form)
        self.verticalLayout.setObjectName("verticalLayout")
        self.label = QtGui.QLabel(Form)
        self.label.setAlignment(QtCore.Qt.AlignCenter)
        self.label.setObjectName("label")
        self.verticalLayout.addWidget(self.label)

        self.retranslateUi(Form)
        QtCore.QMetaObject.connectSlotsByName(Form)

    def retranslateUi(self, Form):
        Form.setWindowTitle(QtGui.QApplication.translate("About", "About", None, QtGui.QApplication.UnicodeUTF8))
        self.label.setText(QtGui.QApplication.translate("About", "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\" \"http://www.w3.org/TR/REC-html40/strict.dtd\">\n"
"<html><head><meta name=\"qrichtext\" content=\"1\" /><style type=\"text/css\">\n"
"p, li { white-space: pre-wrap; }\n"
"</style></head><body style=\" font-family:\'Ubuntu\'; font-size:11pt; font-weight:400; font-style:normal;\">\n"
"<p align=\"center\" style=\" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-size:16pt; font-weight:600;\">SMS Counter</span></p>\n"
"<p align=\"center\" style=\" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-size:12pt; font-weight:600;\">v0.5</span></p>\n"
"<p align=\"center\" style=\"-qt-paragraph-type:empty; margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px; font-size:12pt; font-weight:600;\"></p>\n"
"<p align=\"center\" style=\" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><img src=\"/usr/share/icons/hicolor/64x64/hildon/smscounter.png\" /></p>\n"
"<p align=\"center\" style=\"-qt-paragraph-type:empty; margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px; font-size:12pt; font-weight:600;\"></p>\n"
"<p align=\"center\" style=\" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\">by NerdKnight </p>\n"
"<p align=\"center\" style=\" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\">&lt;<a href=\"mailto:nerdknight@gmail.com\">nerdknight@gmail.com</a>&gt;</p></body></html>", None, QtGui.QApplication.UnicodeUTF8))

class QueryThread(threading.Thread):
    def __init__(self,mainW):
        threading.Thread.__init__(self)
        self.mainW=mainW
    def run(self):
        self.mainW.query()

class Data(object):
    def __init__(self):
        self.d1=None
        self.d2=None
        self.rSms=0
        self.sSms=0
        self.cSms=0
        self.rCalls=0
        self.sCalls=0
        self.mCalls=0
	self.secRCalls=0
	self.minSCalls=0
    def getPeriod(self):
        res=""
        if self.d1.year==self.d2.year and self.d1.month==self.d2.month and self.d1.day==1 and self.d2.day==calendar.monthrange(self.d2.year,self.d2.month)[1]:
            res=self.d1.strftime("%b %Y")
        else:
            res=self.d1.strftime("%x")+" - "+self.d2.strftime("%x")
        return res
    def fillData(self):
        d1=datetimeToBD(self.d1)
        d2=datetimeToBD(self.d2)
        self.rSms=getReceivedSMS(d1,d2)
        self.sSms=getSentSMS(d1,d2)
        self.cSms=getSpamSMS(d1,d2)
        self.rCalls=getReceivedCalls(d1,d2)
        self.sCalls=getMadeCalls(d1,d2)
        self.mCalls=getMissedCalls(d1,d2)
        self.secRCalls=getReceivedCallsDuration(d1, d2)
        self.secMCalls=getMadeCallsDuration(d1, d2)

class ConfigDialog(QtGui.QDialog):
    def __init__(self, parent):
        QtGui.QDialog.__init__(self,parent)
        self.setObjectName("Dialog")
        self.resize(278, 109)
        self.setModal(True)
        self.gridLayout = QtGui.QGridLayout(self)
        self.gridLayout.setObjectName("gridLayout")
        self.buttonBox = QtGui.QDialogButtonBox(self)
        self.buttonBox.setOrientation(QtCore.Qt.Horizontal)
        self.buttonBox.setStandardButtons(QtGui.QDialogButtonBox.Cancel|QtGui.QDialogButtonBox.Ok)
        self.buttonBox.setObjectName("buttonBox")
        self.gridLayout.addWidget(self.buttonBox, 2, 1, 1, 1)
        self.txtSMSCost = QtGui.QLineEdit(self)
        self.txtSMSCost.setObjectName("txtSMSCost")
	self.txtSMSCost.setInputMethodHints(QtCore.Qt.ImhFormattedNumbersOnly)
        self.gridLayout.addWidget(self.txtSMSCost, 0, 1, 1, 1)
        self.label = QtGui.QLabel(self)
        self.label.setObjectName("label")
        self.gridLayout.addWidget(self.label, 0, 0, 1, 1)
        self.label_2 = QtGui.QLabel(self)
        self.label_2.setObjectName("label_2")
        self.gridLayout.addWidget(self.label_2, 1, 0, 1, 1)
        self.txtMinuteCost = QtGui.QLineEdit(self)
        self.txtMinuteCost.setObjectName("txtMinuteCost")
	self.txtMinuteCost.setInputMethodHints(QtCore.Qt.ImhFormattedNumbersOnly)
        self.gridLayout.addWidget(self.txtMinuteCost, 1, 1, 1, 1)

        self.retranslateUi(self)
        QtCore.QObject.connect(self.buttonBox, QtCore.SIGNAL("accepted()"), self.accept)
        QtCore.QObject.connect(self.buttonBox, QtCore.SIGNAL("rejected()"), self.reject)
	QtCore.QObject.connect(self.txtSMSCost, QtCore.SIGNAL("editingFinished()"), self.validateTxtSMSCost)
	QtCore.QObject.connect(self.txtMinuteCost, QtCore.SIGNAL("editingFinished()"), self.validateTxtMinuteCost)
        QtCore.QMetaObject.connectSlotsByName(self)
	
        self.txtSMSCost.setText(locale.str(ConfigData.sms_cost))
        self.txtMinuteCost.setText(locale.str(ConfigData.call_minute_cost))
    def retranslateUi(self, Dialog):
        Dialog.setWindowTitle(QtGui.QApplication.translate("Dialog", "Configuration", None, QtGui.QApplication.UnicodeUTF8))
        self.label.setText(QtGui.QApplication.translate("Dialog", "SMS Cost:", None, QtGui.QApplication.UnicodeUTF8))
        self.label_2.setText(QtGui.QApplication.translate("Dialog", "Minute Cost:", None, QtGui.QApplication.UnicodeUTF8))
    def validateTxtSMSCost(self):
        self.validateLineEdit(self.txtSMSCost,ConfigData.sms_cost)
    def validateTxtMinuteCost(self):
	self.validateLineEdit(self.txtMinuteCost,ConfigData.call_minute_cost)
    def validateLineEdit(self,le,defaultValue):
	try:
	    le.setText(locale.str(locale.atof(le.text())))
	except:
	    le.setText(locale.str(defaultValue))
    def accept(self):
        ConfigData.sms_cost=locale.atof(self.txtSMSCost.text())
        ConfigData.call_minute_cost=locale.atof(self.txtMinuteCost.text())
        ConfigData.save()
        QtGui.QDialog.accept(self)

class MainWidget(object):
    def setupUi(self, Form):
        ConfigData.load()
	self.mw=Form
        Form.setObjectName("Form")
        Form.resize(421, 372)
        self.gridLayout = QtGui.QGridLayout(Form)
        self.gridLayout.setObjectName("gridLayout")
        self.pnlTab = QtGui.QTabWidget(Form)
        self.pnlTab.setObjectName("pnlTab")
        self.pnlTab.setTabPosition(QtGui.QTabWidget.West)
        self.tab = QtGui.QWidget()
        self.tab.setObjectName("tab")
        self.gridLayout.addWidget(self.pnlTab, 1, 0, 1, 1)
        self.gridLayout_2 = QtGui.QGridLayout()
        self.gridLayout_2.setObjectName("gridLayout_2")
        self.btnGo = QtGui.QPushButton(Form)
        sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Fixed, QtGui.QSizePolicy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.btnGo.sizePolicy().hasHeightForWidth())
        self.btnGo.setSizePolicy(sizePolicy)
        self.btnGo.setObjectName("btnGo")
        self.gridLayout_2.addWidget(self.btnGo, 0, 4, 1, 1)
        self.fromDate=QtMaemo5.QMaemo5DatePickSelector()
        self.fromDate.setObjectName("fromDate")
        self.btnFrom=QtMaemo5.QMaemo5ValueButton()
        self.btnFrom.setPickSelector(self.fromDate)
        self.btnFrom.setEnabled(False)
        self.gridLayout_2.addWidget(self.btnFrom, 0, 1, 1, 1)
        self.toDate=QtMaemo5.QMaemo5DatePickSelector()
        self.toDate.setObjectName("toDate")
        self.btnTo=QtMaemo5.QMaemo5ValueButton()
        self.btnTo.setPickSelector(self.toDate)
        self.btnTo.setEnabled(False)
        self.gridLayout_2.addWidget(self.btnTo, 0, 3, 1, 1)
        self.chkFrom = QtGui.QCheckBox(Form)
        sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Fixed, QtGui.QSizePolicy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.chkFrom.sizePolicy().hasHeightForWidth())
        self.chkFrom.setSizePolicy(sizePolicy)
        self.chkFrom.setText("")
        self.chkFrom.setObjectName("chkFrom")
        self.gridLayout_2.addWidget(self.chkFrom, 0, 0, 1, 1)
        self.chkTo = QtGui.QCheckBox(Form)
        sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Fixed, QtGui.QSizePolicy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.chkTo.sizePolicy().hasHeightForWidth())
        self.chkTo.setSizePolicy(sizePolicy)
        self.chkTo.setText("")
        self.chkTo.setObjectName("chkTo")
        self.gridLayout_2.addWidget(self.chkTo, 0, 2, 1, 1)
        self.gridLayout.addLayout(self.gridLayout_2, 0, 0, 1, 1)

        self.smsWidget=SMSWidget(Form)
        self.pnlTab.addTab(self.smsWidget, "SMS")
        self.callsWidget=CallsWidget(Form)
        self.pnlTab.addTab(self.callsWidget,"Calls")
        
        self.dataGraph=DataGraph(Form)
        self.pnlTab.addTab(self.dataGraph, "Graph")

	self.menuBar = QtGui.QMenuBar(Form)
        self.actionOptions = QtGui.QAction(Form)
        self.actionOptions.setObjectName("actionOptions")
        self.menuBar.addAction(self.actionOptions)
	self.actionAbout = QtGui.QAction(Form)
        self.actionAbout.setObjectName("actionAbout")
        self.menuBar.addAction(self.actionAbout)
	self.actionExit = QtGui.QAction(Form)
        self.actionExit.setObjectName("actionExit")
        self.menuBar.addAction(self.actionExit)

	QtCore.QObject.connect(self.menuBar, QtCore.SIGNAL("triggered(QAction*)"), self.menuEvt)
        
        self.retranslateUi(Form)
        self.pnlTab.setCurrentIndex(0)
        QtCore.QMetaObject.connectSlotsByName(Form)
        QtCore.QObject.connect(self.btnGo, QtCore.SIGNAL("clicked()"), self.btnGoAction)
        QtCore.QObject.connect(self.chkFrom, QtCore.SIGNAL("stateChanged(int)"), self.chkFromSelected)
        QtCore.QObject.connect(self.chkTo, QtCore.SIGNAL("stateChanged(int)"), self.chkToSelected)
        self.load()

    def save(self):
	s=""
	if self.chkFrom.checkState():
	    s=str(self.fromDate.currentDate().toString("dd.MM.yyyy"))
	ConfigData.from_date=s
	s=""
	if self.chkTo.checkState():
	    s=str(self.toDate.currentDate().toString("dd.MM.yyyy"))
	ConfigData.to_date=s
        ConfigData.save()
    
    def initDatePicker(self,datePicker,chk,strDate):
	if strDate:
	    date=QtCore.QDate.fromString(strDate,"dd.MM.yyyy")
	    datePicker.setCurrentDate(date)
	    chk.setChecked(True)
	
    def load(self):
	self.initDatePicker(self.fromDate,self.chkFrom,ConfigData.from_date)
	self.initDatePicker(self.toDate,self.chkTo,ConfigData.to_date)
	
    def retranslateUi(self, Form):
        Form.setWindowTitle(QtGui.QApplication.translate("Form", "SMS Counter", None, QtGui.QApplication.UnicodeUTF8))
        self.btnFrom.setText("From")
        self.btnTo.setText("To")
        self.actionOptions.setText("Options")
	self.actionAbout.setText("About")
	self.actionExit.setText("Exit")
        self.btnGo.setText(QtGui.QApplication.translate("Form", "Go!", None, QtGui.QApplication.UnicodeUTF8))
    
    def chkFromSelected(self,v):
        self.btnFrom.setEnabled(self.chkFrom.checkState())
    
    def chkToSelected(self,v):
        self.btnTo.setEnabled(self.chkTo.checkState())
    
    def menuEvt(self,qa):
        if qa==self.actionExit:
            self.mw.close()
        elif qa==self.actionOptions:
            ui = ConfigDialog(self.mw)
            ui.show()
        elif qa==self.actionAbout:
            Form = QtGui.QDialog(self.mw)
            ui = About()
            ui.setupUi(Form)
            Form.setModal(True)
            Form.show()

    def getFrom(self):
        d1=None
        if self.chkFrom.checkState():
            d1=strDateToBD(str(self.fromDate.currentDate().toString("dd.MM.yyyy")))
        return d1
    
    def getTo(self):
        d1=None
        if self.chkTo.checkState():
            d1=strDateToBD(str(self.toDate.currentDate().toString("dd.MM.yyyy")))
        return d1
    
    def btnGoAction(self):
        t=QueryThread(self)
        t.start()
    
    def query(self):
	self.btnGo.setEnabled(False)
	self.btnGo.setText("Wait")
	self.pnlTab.setEnabled(False)
        dF=None
        dT=None
        if self.chkFrom.checkState():
            d=self.fromDate.currentDate()
            dF=datetime(d.year(),d.month(),d.day())
        if dF==None:
            dF=getMinDate()
        if self.chkTo.checkState():
            d=self.toDate.currentDate()
            dT=datetime(d.year(),d.month(),d.day())
        if dT==None:
            dT=datetime.now()
        d1=dF
        td=timedelta(microseconds=1)
        data=[]
        ld=calendar.monthrange(d1.year,d1.month)[1]
        d2=datetime(d1.year,d1.month,ld,23,59,59,999999)
        while d2<dT:
            dat=Data()
            dat.d1=d1
            dat.d2=d2
            dat.fillData()
            data.append(dat)
            d1=d2+td
            ld=calendar.monthrange(d1.year,d1.month)[1]
            d2=datetime(d1.year,d1.month,ld,23,59,59,999999)
        d2=dT
        dat=Data()
        dat.d1=d1
        dat.d2=d2
        dat.fillData()
        data.append(dat)
        self.smsWidget.query(data)
        self.callsWidget.query(data)
        self.dataGraph.query(data)
        self.btnGo.setText("Go!")
	self.pnlTab.setEnabled(True)
	self.btnGo.setEnabled(True)
        
class SMSWidget(QtGui.QWidget):
    def __init__(self, parent=None):
        QtGui.QWidget.__init__(self, parent)
        f=self.font()
        f.setBold(True)
        self.gridLayout = QtGui.QGridLayout(self)
        self.gridLayout.setObjectName("gridLayout")

        self.lblTotSMS = QtGui.QLabel(self)
        self.lblTotSMS.setObjectName("lblTotSMS")
        self.lblTotSMS.setFont(f)
        self.gridLayout.addWidget(self.lblTotSMS, 3, 0, 1, -1)
        
        self.lblSentSMS = QtGui.QLabel(self)
        self.lblSentSMS.setObjectName("lblSentSMS")
        self.gridLayout.addWidget(self.lblSentSMS, 2, 0, 1, 1)
        
        self.lblSMSCost = QtGui.QLabel(self)
        self.lblSMSCost.setObjectName("lblSMSCost")
        self.gridLayout.addWidget(self.lblSMSCost, 2, 1, 1, 1)
        
        self.lblReceivedSMS = QtGui.QLabel(self)
        self.lblReceivedSMS.setObjectName("lblReceivedSMS")
        self.gridLayout.addWidget(self.lblReceivedSMS, 1, 0, 1, 1)
        
        self.lblSpamSMS = QtGui.QLabel(self)
        self.lblSpamSMS.setObjectName("lblSpamSMS")
        self.gridLayout.addWidget(self.lblSpamSMS, 1, 1, 1, 1)

        self.retranslateUi()

    def retranslateUi(self):
        self.lblTotSMS.setText("Total SMS:")
        self.lblSentSMS.setText("Sent SMS:")
        self.lblSMSCost.setText("Cost:")
        self.lblReceivedSMS.setText("Received SMS:")
        self.lblSpamSMS.setText("Spam:")
    
    def query(self,data):
        receivedS=0
        sentS=0
	totS=0
        Spam=0
        for dat in data:
            receivedS+=dat.rSms
            sentS+=dat.sSms
            Spam+=dat.cSms
        totS=receivedS+sentS
        costS=round(sentS*ConfigData.sms_cost,2)

        rr=0
        if receivedS>0:
            rr=round(float(Spam)/receivedS*100,2)
        Spam=str(Spam)+" ("+locale.str(rr)+"%)"
        rr=0
        if totS>0:
            rr=round(float(receivedS)/totS*100,2)
        receivedS=str(receivedS)+" ("+locale.str(rr)+"%)"
        rr=0
        if totS>0:
            rr=round(float(sentS)/totS*100,2)
        sentS=str(sentS)+" ("+locale.str(rr)+"%)"
        totS=str(totS)
        self.lblTotSMS.setText("Total SMS: "+totS)
        self.lblReceivedSMS.setText("Received SMS: "+receivedS)
        self.lblSentSMS.setText("Sent SMS: "+sentS)
        self.lblSMSCost.setText("Cost: "+locale.str(costS))
        self.lblSpamSMS.setText("Spam: "+Spam)

class CallsWidget(QtGui.QWidget):
    def __init__(self, parent=None):
        QtGui.QWidget.__init__(self, parent)
        
        self.gridLayout = QtGui.QGridLayout(self)
        self.gridLayout.setObjectName("gridLayout")

	self.lblReceivedCalls = QtGui.QLabel(self)
        self.lblReceivedCalls.setObjectName("lblReceivedCalls")
        self.gridLayout.addWidget(self.lblReceivedCalls, 1, 0, 1, 1)
        
        self.lblRCallsDuration = QtGui.QLabel(self)
        self.lblRCallsDuration.setObjectName("lblRCallsDuration")
        self.gridLayout.addWidget(self.lblRCallsDuration, 1, 1, 1, 1)
        
        self.lblMadeCalls = QtGui.QLabel(self)
        self.lblMadeCalls.setObjectName("lblMadeCalls")
        self.gridLayout.addWidget(self.lblMadeCalls, 2, 0, 1,1)
        
        self.lblMCallsDuration = QtGui.QLabel(self)
        self.lblMCallsDuration.setObjectName("lblMCallsDuration")
        self.gridLayout.addWidget(self.lblMCallsDuration, 2, 1, 1,1)
        
        self.lblMCallsCost = QtGui.QLabel(self)
        self.lblMCallsCost.setObjectName("lblMCallsCost")
        self.gridLayout.addWidget(self.lblMCallsCost, 3, 1, 1,1)
        
        self.lblMissedCalls = QtGui.QLabel(self)
	self.lblMissedCalls.setObjectName("lblMissedCalls")
        self.gridLayout.addWidget(self.lblMissedCalls, 4, 0, 1, -1)
        
        f=self.font()
        f.setBold(True)
        self.lblTotCalls = QtGui.QLabel(self)
        self.lblTotCalls.setObjectName("lblTotCalls")
        self.lblTotCalls.setFont(f);
        self.gridLayout.addWidget(self.lblTotCalls, 5, 0, 1, 1)
        
        self.lblTotMinutes = QtGui.QLabel(self)
        self.lblTotMinutes.setObjectName("lblTotMinutes")
        self.lblTotMinutes.setFont(QtGui.QFont("Sans Serif",20,QtGui.QFont.Bold));
        self.lblTotMinutes.setFont(f)
        self.gridLayout.addWidget(self.lblTotMinutes, 5, 1, 1, 1)

        self.retranslateUi()

    def retranslateUi(self):
	self.lblTotCalls.setText("Total:")
        self.lblTotMinutes.setText("Total duration:")
        self.lblMadeCalls.setText("Made:")
        self.lblMCallsDuration.setText("Duration:")
        self.lblMCallsCost.setText("Cost:")
        self.lblReceivedCalls.setText("Received:")
        self.lblRCallsDuration.setText("Duration:")
	self.lblMissedCalls.setText("Missed:")

    def query(self,data):
        receivedC=0
        secRCalls=0
        secMCalls=0
        sentC=0
	totC=0
        missedC=0
        for dat in data:
            receivedC+=dat.rCalls
            sentC+=dat.sCalls
            missedC+=dat.mCalls        
            secRCalls+=dat.secRCalls
            secMCalls+=dat.secMCalls
        totC=receivedC+sentC+missedC

	rr=0
        if totC>0:
            rr=round(float(receivedC)/totC*100,2)
        receivedC=str(receivedC)+" ("+locale.str(rr)+"%)"
	rr=0
        if totC>0:
            rr=round(float(missedC)/totC*100,2)
        missedC=str(missedC)+" ("+locale.str(rr)+"%)"
        rr=0
        if totC>0:
            rr=round(float(sentC)/totC*100,2)
        sentC=str(sentC)+" ("+locale.str(rr)+"%)"
        totC=str(totC)
	self.lblTotCalls.setText("Total: "+totC)
        self.lblReceivedCalls.setText("Received: "+receivedC)
        rr=""
        self.lblRCallsDuration.setText("Duration: "+timeFormat(secRCalls))
        self.lblMadeCalls.setText("Made: "+sentC)
        self.lblMCallsDuration.setText("Duration: "+timeFormat(secMCalls))
        self.lblTotMinutes.setText("Total duration: "+timeFormat(secRCalls+secMCalls))
        self.lblMCallsCost.setText("Cost: "+locale.str(secMCalls/60*ConfigData.call_minute_cost))
	self.lblMissedCalls.setText("Missed: "+missedC)
        
class DataGraph(QtGui.QWidget):
    def __init__(self, parent=None):
        QtGui.QWidget.__init__(self, parent)
        hl=QtGui.QHBoxLayout(self)
        self.graph=Graph(self)
        self.graph.dataGap=65
        hl.addWidget(self.graph)

    def query(self,data):
        xData=[]
        yData=[[],[],[],[],[],[]]
        yLabels=["SMS Received ","SMS Sent","Spam SMS","Calls Received","Calls Made","Missed Calls"]
        for dat in data:
            period=dat.getPeriod()
            xData.append(period)
            yData[0].append(dat.rSms)
            yData[1].append(dat.sSms)
            yData[2].append(dat.cSms)
            yData[3].append(dat.rCalls)
            yData[4].append(dat.sCalls)
            yData[5].append(dat.mCalls)
        self.graph.setData(xData, yData, yLabels)

class Main(QtGui.QWidget):
    def __init__(self, parent=None):
        QtGui.QWidget.__init__(self, parent)
        self.mw=MainWidget()
        self.mw.setupUi(self)
    def closeEvent(self,closeEvent):
	self.mw.save()
	QtGui.QWidget.closeEvent(self,closeEvent)
def main():
    locale.setlocale(locale.LC_ALL, '')
    app = QtGui.QApplication(sys.argv)
    qb = Main()
    qb.show()
    sys.exit(app.exec_())
if __name__ == "__main__":
    main()
