#!/usr/bin/python2.5

##############################################################
##   smscon-editor  -  Configuration UI for the SMSCON      ##
##############################################################

#Author: Christos Zamantzas <christos.zamantzas@gmail.com>
#Contributions: Frank Visser - import, decrypt and encrypt from config file the user variables.
Version = '0.7-4'

import os
import sys
import time
import string
import base64

from Crypto.Cipher import AES
from PyQt4.QtGui import *
from PyQt4.QtCore import *
from PyQt4.QtMaemo5 import *

from smsconEditorMainGUI import *
from smsconEditorAskPass import *
from smsconEditorNewPass import *

##############################################################

MainPath      = '/opt/smscon/'                 # main path of files
Path          = '/home/user/.smscon-editor/'   # temp path of files
ConfigFile    = 'smscon_config'                # name of config file
AppPath       = '/opt/smscon-editor/'          # main path of application files
PassFile      = 'smsconEditorPass'             # name of password file

##############################################################

def showMessage(message):
    ''' Method to display a message to the user that waits for a confirmation. '''

    os.system('dbus-send --type=method_call --dest=org.freedesktop.Notifications \
               /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteDialog \
               string:"%s" uint32:0 string:"OK"' % message)          

##############################################################  

def showQuickMessage(message):
    ''' Method to display a message to the user. '''

    os.system('dbus-send --type=method_call --dest=org.freedesktop.Notifications \
               /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint \
               string:"%s"' % message)          

##############################################################

def CheckFile(Path, File):
    ''' Check if a file exists. '''

    try:
        f = open(Path + File, 'r')
        f.close()
    except:
        return False
    else:
        return True

##############################################################  

def doCheckPassword(password):  ### FIXME: what should be the behaviour if password is missing?
    ''' Check the given password. '''
    
    if CheckFile(AppPath, PassFile) == True:
       f = open(AppPath + PassFile, 'r')
       Output = f.readlines() 
       if Output == []:
           message = 'Password is empty'
           showQuickMessage(message)
           f.close()
           sys.exit(1)
       else:
          f.close()
          if os.popen('echo "%s"|md5sum -c %s' % (password, AppPath + PassFile)).read() == '-: OK\n':
            return True
          else:
            return False
    else:
       message = 'Password file does not exist!\nThe application will now exit..'
       showQuickMessage(message)
       #doUpdatePassword()
       sys.exit(1)

##############################################################  

def doCopyConfig():
    '''Make a copy of the configuration for safe editing.'''  

    #Check if configuration file exists.
    if CheckFile(MainPath, ConfigFile) == True:
       #Make the copy
       os.system('cp %s %s' % (MainPath + ConfigFile, Path))
    else:
       message = 'Reading SMSCON settings gave a FATAL ERROR.\nThe configuration file does not exist or it is corrupted.'
       showMessage(message)
       if CheckFile(Path, ConfigFile) == True:
          doUpdateConfig()
          message = 'A settings file has been found in the user directory.\nIt will copied to the root directory and used as main.'
          showMessage(message)
       else:
          os.system('sudo smscon -init')
          message = 'SMSCON has been initialised to the default configuration.\
                    \nThis editor will now quit...\n\nYou will need to open it again and edit your new configuration.'
          showMessage(message)          
          sys.exit(1)

##############################################################  

def doUpdateConfig():
    ''' Replace the config file with the edited and restart deamon. '''
    Delay = 0.5

    time.sleep(Delay)
    os.system('sudo %ssmsconEditorCopyConfig'% AppPath)
    time.sleep(Delay)
    os.system('sudo smscon -stop')
    time.sleep(Delay)
    os.system('sudo smscon -start')

##############################################################  
##   
## Load the user settings from smscon_config file
## Contribution by Frank Visser
##

ConfigVars = ['SENDERNUMBER',                 
               'EMAILADDRESS',
               'COM_CHECK',
               'COM_REBOOT',
               'COM_POWEROFF',
               'COM_POWER',
               'COM_LOCATION',
               'COM_REMOTEON',
               'COM_REMOTEOFF',
               'COM_CAMERA',
               'COM_CALL',
               'COM_LOCK', 
               'COM_UNLOCK',
               'COM_TRACKON',
               'COM_TRACKOFF',
               'COM_CUSTOM',
               'COM_SHELL',
               'USER',         
               'PASSWORD',        
               'EMAILFROM',       
               'MAILSERVER',      
               'MAILPORT',        
               'REMOTEHOST',            
               'REMOTEPORT',           
               'REMOTEUSER',       
               'REMOTEPASSWORD',
               'DISABLESMS',
               'COMMANDREPLY',
               'AUTODEVICELOCK',
               'AUTOBATREPORT',
               'SIMUNLOCK',
               'SILENCEDEVICE',
               'KEYBOARDDETECT',
               'GPSTIMEOUT',
               'GPSPOLLING',
               'GPSINTERVAL',
               'GPSSEND']

EncryptedConfigVars = ['USER',         
                       'PASSWORD',        
                       'REMOTEUSER',       
                       'REMOTEPASSWORD']
BlockSize = 16
Padding   = '{'

Pad = lambda s: s + (BlockSize - len(s) % BlockSize) * Padding

EncodeAES = lambda c, s: base64.b64encode(c.encrypt(Pad(s)))
DecodeAES = lambda c, e: c.decrypt(base64.b64decode(e)).rstrip(Padding)

Secret = '6983456712936753' # this is the code were EncryptedConfigVars will be encoded/decode with. 

try:
    f = open(MainPath + ConfigFile, 'r')
    f.close()
except:
    message = 'Reading SMSCON settings gave a FATAL ERROR while loading\nConfiguration file does not exist.'
    showMessage(message)
    sys.exit(1)
else:
    f = open(MainPath + ConfigFile, 'r')
    ConfigLines = f.readlines() 
    if ConfigLines == []:
       message = 'Reading SMSCON settings gave a FATAL ERROR while loading\nConfiguration file is empty.'
       showMessage(message)
       sys.exit(1)
    else:
       ##New code -- accepts space in Commands and Encrypts commands
       try:
          for Line in ConfigLines:
             Line = Line.strip().replace('\r', '').replace('\n', '')
             
             for Var in ConfigVars:
                ##Get user variable & it's value from text line
                if Line.startswith('%s' % Var):
                   try:
                      ## encrypted text value
                      if Var in EncryptedConfigVars:
                         Variable, EncryptedValue = Line.split('=', 1)
                      ## plain text value
                      else:
                         Variable, Value = Line.split('=', 1)                            
                   except:
                      message = 'FATAL ERROR in SMSCON settings: ERROR in user file.\n\nCannot read the user defined variables'
                      showMessage(message)
                      sys.exit(1)
                   else:
                      ## encrypted text value
                      if Var in EncryptedConfigVars:
                         EncryptedValue = EncryptedValue.lstrip(' ')
                      ## plain text value
                      else:
                         Value = Value.lstrip(' ')
                      try:
                         ## encrypted text value
                         if Var in EncryptedConfigVars:
                            if EncryptedValue.startswith("'") == True and EncryptedValue.endswith("'") == True:
                               EncryptedValue = EncryptedValue.strip("'")
                               vars()[Var] = DecodeAES(AES.new(Secret), EncryptedValue) # get string
                         else:
                            ## plain text value
                            if Value.startswith("'") == True and Value.endswith("'") == True:
                               vars()[Var] = Value.strip("'") ## get string
                            else:
                               ## plain text integer
                               vars()[Var] = int(Value) ## get integer
                      except:
                         message = 'FATAL ERROR in SMSCON settings: ERROR in user settings file.'
                         showMessage(message)
                         sys.exit(1)
       except:
          message = 'FATAL ERROR in SMSCON settings: Configuration file is corrupted.'
          showMessage(message)
          quit()
       else:
          message = 'SMSCON settings succesfully loaded.'
          showQuickMessage(message)
    f.close()

##############################################################

class MyStartupDialog(QtGui.QDialog): ### FIXME: add 3 re-tries for wrong password.
       def __init__(self, parent=None):
        
          ##Build parent user interface
          QtGui.QDialog.__init__(self, parent)
          self.ui = Ui_DialogStart()
          self.ui.setupUi(self)
          ##self.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
          self.setAttribute(Qt.WA_Maemo5StackedWindow, True)

          ##Connect the button
          QtCore.QObject.connect(self.ui.btnEnterPassword, QtCore.SIGNAL('clicked()'), self.doEnterPassword)
               
       def doEnterPassword(self):

          EnteredPassword = self.ui.linePassword.text()
          if doCheckPassword(EnteredPassword) == True:
             message = 'Password Correct'
             showQuickMessage(message)

             self.close()
             return True

          else:
             message = 'Incorrect Password; Exiting..'
             showMessage(message)
             sys.exit(1)

       ##Close app if window closes without a valid password
       def closeEvent (self,event):
          if self.doEnterPassword() == True:
             event.accept()
          else:   
             message = 'You need to put a password; Exiting..'
             showMessage(message)
             sys.exit(1)
             
##############################################################

class MyMainWindow(QtGui.QMainWindow):
       def __init__(self, parent=None):
          ##make a copy of the config for editing
          doCopyConfig()

          #Open Start Dialog - request password
          mydialog = MyStartupDialog()
          mydialog.exec_()

          ##Build parent user interface
          QtGui.QWidget.__init__(self, parent)
          self.ui = Ui_SMSCON_GUI_elements()
          self.ui.setupUi(self)
          ##self.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
          self.setAttribute(Qt.WA_Maemo5StackedWindow, True)

          ##Connect the GUI Buttons with actions
            ##Create Settings
          QtCore.QObject.connect(self.ui.btnCreateConfigGeneral, QtCore.SIGNAL('clicked()'), self.doCreateConfigGeneral)
          QtCore.QObject.connect(self.ui.btnCreateConfigEmail, QtCore.SIGNAL('clicked()'), self.doCreateConfigEmail)
          QtCore.QObject.connect(self.ui.btnCreateConfigSSH, QtCore.SIGNAL('clicked()'), self.doCreateConfigSSH)
          QtCore.QObject.connect(self.ui.btnCreateConfigCommands, QtCore.SIGNAL('clicked()'), self.doCreateConfigCommands)
            ##Initialise
          QtCore.QObject.connect(self.ui.btnInit, QtCore.SIGNAL('clicked()'), self.doInit)
          QtCore.QObject.connect(self.ui.btnReset, QtCore.SIGNAL('clicked()'), self.doReset)
          QtCore.QObject.connect(self.ui.btnDelIMSI, QtCore.SIGNAL('clicked()'), self.doDelIMSI)
          QtCore.QObject.connect(self.ui.btnAddIMSI, QtCore.SIGNAL('clicked()'), self.doAddIMSI)
          QtCore.QObject.connect(self.ui.btnStart, QtCore.SIGNAL('clicked()'), self.doStart)
          QtCore.QObject.connect(self.ui.btnStop, QtCore.SIGNAL('clicked()'), self.doStop)
          QtCore.QObject.connect(self.ui.btnBoot, QtCore.SIGNAL('clicked()'), self.doBoot)
          QtCore.QObject.connect(self.ui.btnUnBoot, QtCore.SIGNAL('clicked()'), self.doUnBoot)
          QtCore.QObject.connect(self.ui.btnPrefix, QtCore.SIGNAL('clicked()'), self.doPrefix)
            ##Test buttons
          QtCore.QObject.connect(self.ui.btnTestMail1, QtCore.SIGNAL('clicked()'), self.doSendTestMail1)
          QtCore.QObject.connect(self.ui.btnTestMail2, QtCore.SIGNAL('clicked()'), self.doSendTestMail2)
          QtCore.QObject.connect(self.ui.btnTestGPS1, QtCore.SIGNAL('clicked()'), self.doSendTestGPS1)
          QtCore.QObject.connect(self.ui.btnTestGPS2, QtCore.SIGNAL('clicked()'), self.doSendTestGPS2)
          QtCore.QObject.connect(self.ui.btnTestCall, QtCore.SIGNAL('clicked()'), self.doSendTestCall)
          QtCore.QObject.connect(self.ui.btnTestSMS, QtCore.SIGNAL('clicked()'), self.doSendTestSMS)
          QtCore.QObject.connect(self.ui.btnTestSSH, QtCore.SIGNAL('clicked()'), self.doSendTestSSH)
          QtCore.QObject.connect(self.ui.btnTestScript, QtCore.SIGNAL('clicked()'), self.doSendTestScript)
          QtCore.QObject.connect(self.ui.btnTestsDone, QtCore.SIGNAL('clicked()'), self.doStart)
          
          ##Connect Menu Buttons 
          QtCore.QObject.connect(self.ui.actionQuit, QtCore.SIGNAL('triggered()'), QtGui.qApp, QtCore.SLOT('quit()'))
          QtCore.QObject.connect(self.ui.actionAbout, QtCore.SIGNAL('triggered()'), self.doAbout)
          QtCore.QObject.connect(self.ui.actionCredits, QtCore.SIGNAL('triggered()'), self.doCredits)
          QtCore.QObject.connect(self.ui.actionUpdate_Password, QtCore.SIGNAL('triggered()'), self.doUpdatePassword)

          ##Set values in the GUI.
          self.SetValues()
               
       def SetValues(self):
          ''' Set values read in the GUI'''
          
          self.ui.linePhone.setText("%s" % SENDERNUMBER)
          self.ui.lineGPSTimeout.setText("%s" % GPSTIMEOUT)  
          self.ui.lineGPSPolling.setText("%s" % GPSPOLLING)
          
          if GPSINTERVAL == 10:
             self.ui.comboBoxGPSInterval.setCurrentIndex(0) 
          elif GPSINTERVAL == 20:
             self.ui.comboBoxGPSInterval.setCurrentIndex(1) 
          elif GPSINTERVAL == 30:
             self.ui.comboBoxGPSInterval.setCurrentIndex(2) 
          elif GPSINTERVAL == 60:
             self.ui.comboBoxGPSInterval.setCurrentIndex(3) 
          elif GPSINTERVAL == 120:
             self.ui.comboBoxGPSInterval.setCurrentIndex(4) 
          else:
             self.ui.comboBoxGPSInterval.setCurrentIndex(3) 

          if GPSSEND == 'sms':
             self.ui.comboBoxGPSSend.setCurrentIndex(0) 
          elif GPSSEND == 'email':
             self.ui.comboBoxGPSSend.setCurrentIndex(1)
          elif GPSSEND == 'both':
             self.ui.comboBoxGPSSend.setCurrentIndex(2)
            
          self.ui.lineEmailUsername.setText("%s" % USER)
          self.ui.lineEmailPassword.setText("%s" % PASSWORD)
          self.ui.lineEmailAddress.setText("%s" % EMAILADDRESS)
          ##self.ui.lineEmailFrom.setText("%s" % EMAILFROM)
          self.ui.lineEmailServer.setText("%s" % MAILSERVER)
          self.ui.lineEmailPort.setText("%s" % MAILPORT)
            
          self.ui.lineSSHUsername.setText("%s" % REMOTEUSER)
          self.ui.lineSSHPassword.setText("%s" % REMOTEPASSWORD)
          self.ui.lineSSHHost.setText("%s" % REMOTEHOST)
          self.ui.lineSSHPort.setText("%s" % REMOTEPORT)
            
          if COMMANDREPLY == 'yes':
             self.ui.checkBoxCommandReply.setChecked(True)
          else:
             self.ui.checkBoxCommandReply.setChecked(False)
          
          if AUTODEVICELOCK == 'yes':
             self.ui.checkBoxDeviceLock.setChecked(True)
          else:
             self.ui.checkBoxDeviceLock.setChecked(False)

          if AUTOBATREPORT  == 'yes':
             self.ui.checkBoxLowBattery.setChecked(True)
          else:
             self.ui.checkBoxLowBattery.setChecked(False)
             
          if DISABLESMS     == 'yes':
             self.ui.checkBoxNoSMS.setChecked(True)
          else:
             self.ui.checkBoxNoSMS.setChecked(False)
             
          if SIMUNLOCK  == 'yes':
             self.ui.checkBoxNewSIMUnlock.setChecked(True)
          else:
             self.ui.checkBoxNewSIMUnlock.setChecked(False)
             
          if SILENCEDEVICE  == 'yes':
             self.ui.checkBoxSilence.setChecked(True)
          else:
             self.ui.checkBoxSilence.setChecked(False)
             
          if KEYBOARDDETECT == 'yes':
             self.ui.checkBoxKeyboardDetect.setChecked(True)
          else:
             self.ui.checkBoxKeyboardDetect.setChecked(False)  
          
          self.ui.lineCheck.setText(    "%s" % COM_CHECK)
          self.ui.lineReboot.setText(   "%s" % COM_REBOOT)
          self.ui.linePowerOff.setText( "%s" % COM_POWEROFF)
          self.ui.linePower.setText(    "%s" % COM_POWER)
          self.ui.lineLocation.setText( "%s" % COM_LOCATION)
          self.ui.lineRemoteOn.setText( "%s" % COM_REMOTEON)
          self.ui.lineRemoteOff.setText("%s" % COM_REMOTEOFF)
          self.ui.lineCamera.setText(   "%s" % COM_CAMERA)
          self.ui.lineCall.setText(     "%s" % COM_CALL)
          self.ui.lineLock.setText(     "%s" % COM_LOCK)
          self.ui.lineUnlock.setText(   "%s" % COM_UNLOCK)
          self.ui.lineTrackOn.setText(  "%s" % COM_TRACKON)
          self.ui.lineTrackOff.setText( "%s" % COM_TRACKOFF)
          self.ui.lineScript.setText(   "%s" % COM_CUSTOM)
          self.ui.lineShell.setText(    "%s" % COM_SHELL)
       
       def doAbout(self):
          self.aboutWin = SMSCONAbout(self)

       def doCredits(self):
          msg = unichr(int('00A9', 16)) + "SMSCON - 2010, Frank Visser (digitalvoid)\n"
          msg += "Control and Track your N900 through SMS\n\n"
          msg += unichr(int('00A9', 16)) + "SMSCON Editor - 2010, Christos Zamantzas (saturn)\n"
          msg += "Configuration and Test user interface for the SMSCON daemon\n\n"
          msg += "Distributed under GPL ver. 2"
          QMessageBox.about(self, "Credits - SMSCON & SMSCON Editor", msg)
       
       ##TAB: INIT
       def doInit(self):
          os.system('sudo smscon -init')
          message = 'SMSCON has been initialised to the default configuration. \
                    \nThis editor will now quit...\n\nYou will need to open it again and edit your new configuration.'
          showMessage(message)
          sys.exit(1)
            
       def doReset(self):
          os.system('sudo smscon -reset')
          message = 'SMSCON has been reset, i.e. the daemon has been stopped, the config file has been deleted\
                     and the deamon has been removed from the boot sequence.\
                     \n\nNext you will need to initialise it and edit your new configuration.'
          showMessage(message)
          #sys.exit(1)

       def doDelIMSI(self):
          message = os.popen('sudo smscon -del imsi').read()
          showMessage(message)

       def doAddIMSI(self):
          message = os.popen('sudo smscon -add imsi').read()
          showMessage(message)

       def doStart(self):
          message = os.popen('sudo smscon -start').read()
          showMessage(message)

       def doStop(self):
          message = os.popen('sudo smscon -stop').read()
          showMessage(message)

       def doBoot(self):
          message = os.popen('sudo smscon -boot').read()
          showMessage(message)

       def doUnBoot(self):
          message = os.popen('sudo smscon -unboot').read()
          showMessage(message)

       ##TAB: General    
       def doCreateConfigGeneral(self):
          DefaultPhone = self.ui.linePhone.text()
          GPSTimeout   = self.ui.lineGPSTimeout.text()
          GPSPolling   = self.ui.lineGPSPolling.text()
          GPSInterval  = self.ui.comboBoxGPSInterval.currentText()
          GPSSend      = self.ui.comboBoxGPSSend.currentText()
        
          CommandReply = self.ui.checkBoxCommandReply.isChecked()
          if CommandReply is True:
             CommandReply = "yes"
          else:
             CommandReply = "no"
             
          AutoDeviceLock = self.ui.checkBoxDeviceLock.isChecked()
          if AutoDeviceLock is True:
             AutoDeviceLock = "yes"
          else:
             AutoDeviceLock = "no"
             
          LowBattery = self.ui.checkBoxLowBattery.isChecked()
          if LowBattery is True:
             LowBattery = "yes"
          else:
             LowBattery = "no"
             
          NoSMS = self.ui.checkBoxNoSMS.isChecked()
          if NoSMS is True:
             NoSMS = "yes"
          else:
             NoSMS = "no"

          NewSIMUnlock = self.ui.checkBoxNewSIMUnlock.isChecked()
          if NewSIMUnlock is True:
             NewSIMUnlock = "yes"
          else:
             NewSIMUnlock = "no"
             
          Silence = self.ui.checkBoxSilence.isChecked()
          if Silence is True:
             Silence = "yes"
          else:
             Silence = "no"
             
          KeyboardDetect = self.ui.checkBoxKeyboardDetect.isChecked()
          if KeyboardDetect is True:
             KeyboardDetect = "yes"
          else:
             KeyboardDetect = "no"
        
          #Update of the config file.
          os.rename( Path + ConfigFile, Path + ConfigFile + "~" )
          destination = open( Path + ConfigFile, "w" )
          source = open( Path + ConfigFile + "~", "r" )
          for Line in source:
             if   Line.startswith("SENDERNUMBER"):
                destination.write('SENDERNUMBER      = \'%s\'\n' % DefaultPhone)
             elif Line.startswith("GPSTIMEOUT"):
                destination.write('GPSTIMEOUT        = %s \n' % GPSTimeout)
             elif Line.startswith("GPSPOLLING"):
                destination.write('GPSPOLLING        = %s \n' % GPSPolling)
             elif Line.startswith("GPSINTERVAL"):
                destination.write('GPSINTERVAL       = %s \n' % GPSInterval)
             elif Line.startswith("GPSSEND"):
                destination.write('GPSSEND           = \'%s\'\n' % GPSSend)
             elif Line.startswith("AUTODEVICELOCK"):
                destination.write('AUTODEVICELOCK    = \'%s\'\n' % AutoDeviceLock)
             elif Line.startswith("AUTOBATREPORT"):
                destination.write('AUTOBATREPORT     = \'%s\'\n' % LowBattery)
             elif Line.startswith("DISABLESMS"):
                destination.write('DISABLESMS        = \'%s\'\n' % NoSMS)
             elif Line.startswith("SIMUNLOCK"):
                destination.write('SIMUNLOCK         = \'%s\'\n' % NewSIMUnlock)
             elif Line.startswith("SILENCEDEVICE"):
                destination.write('SILENCEDEVICE     = \'%s\'\n' % Silence)
             elif Line.startswith("COMMANDREPLY"):
                destination.write('COMMANDREPLY      = \'%s\'\n' % CommandReply)
             elif Line.startswith("KEYBOARDDETECT"):
                destination.write('KEYBOARDDETECT    = \'%s\'\n' % KeyboardDetect)
             else: 
                destination.write( Line )
          source.close()
          destination.close()
          
          message = 'Updating. Please wait..'
          showQuickMessage(message)
          doUpdateConfig()

          message = 'The settings have been successfully saved.\
                     \n%s has been added as the default number.\
                     \nAn SMS will be send to it if the SIM ever gets replaced.\
                     \n\nNOTE: This number will be replaced automaticaly if a successful command is received by a different phone.' % DefaultPhone
          showMessage(message)
          
       ##TAB: Email Settings    
       def doCreateConfigEmail(self):
          EmailUsername = self.ui.lineEmailUsername.text()
          EmailPassword = self.ui.lineEmailPassword.text()
          EmailAddress  = self.ui.lineEmailAddress.text()
          #EmailFrom     = self.ui.lineEmailFrom.text()
          EmailServer   = self.ui.lineEmailServer.text()
          EmailPort     = self.ui.lineEmailPort.text()

          ##Update of the config file.
          os.rename( Path + ConfigFile, Path + ConfigFile + "~" )
          destination = open( Path + ConfigFile, "w" )
          source = open( Path + ConfigFile + "~", "r" )
          for Line in source:
             if   Line.startswith("EMAILADDRESS"):
                destination.write('EMAILADDRESS      = \'%s\'\n' % EmailAddress)
             elif Line.startswith("EMAILFROM"):
                #destination.write('EMAILFROM         = \'%s\'\n' % EmailFrom)
                destination.write('EMAILFROM         = \'%s\'\n' % EmailAddress) # temp solution until we find space in GUI.
             elif Line.startswith("USER"):
                destination.write('USER              = \'%s\'\n' % EncodeAES(AES.new(Secret), str(EmailUsername)))
             elif Line.startswith("PASSWORD"):
                destination.write('PASSWORD          = \'%s\'\n' % EncodeAES(AES.new(Secret), str(EmailPassword)))
             elif Line.startswith("MAILSERVER"):
                destination.write('MAILSERVER        = \'%s\'\n' % EmailServer)
             elif Line.startswith("MAILPORT"):
                destination.write('MAILPORT          = %s\n' % EmailPort)
             else: 
                destination.write( Line )
          source.close()
          destination.close()

          message = 'Updating. Please wait..'
          showQuickMessage(message)
          doUpdateConfig()

          message = 'The settings have been successfully saved.\
                    \nUser name: %s\nPassword: %s\nEmail address: %s\nMail server: %s - Port: %s' % (EmailUsername,
                                                                                                     EmailPassword,
                                                                                                     EmailAddress,
                                                                                                     EmailServer,
                                                                                                     EmailPort)
   
##         message = 'User name: %s, Password: %s\nEmail address: %s\nEmailFrom address: %s\nMail server: %s, Port: %s' % (EmailUsername,
##                                                                                                                         EmailPassword,
##                                                                                                                         EmailAddress,
##                                                                                                                         EmailFrom,
##                                                                                                                         EmailServer,
##                                                                                                                         EmailPort)

          showMessage(message)
            
       ##TAB: Commands Renaming       
       def doPrefix(self):
          prefix = self.ui.linePrefix.text()
          self.ui.lineCheck.setText(    "%s" % prefix + COM_CHECK)
          self.ui.lineReboot.setText(   "%s" % prefix + COM_REBOOT)
          self.ui.linePowerOff.setText( "%s" % prefix + COM_POWEROFF)
          self.ui.linePower.setText(    "%s" % prefix + COM_POWER)
          self.ui.lineLocation.setText( "%s" % prefix + COM_LOCATION)
          self.ui.lineRemoteOn.setText( "%s" % prefix + COM_REMOTEON)
          self.ui.lineRemoteOff.setText("%s" % prefix + COM_REMOTEOFF)
          self.ui.lineCamera.setText(   "%s" % prefix + COM_CAMERA)
          self.ui.lineCall.setText(     "%s" % prefix + COM_CALL)
          self.ui.lineLock.setText(     "%s" % prefix + COM_LOCK)
          self.ui.lineUnlock.setText(   "%s" % prefix + COM_UNLOCK)
          self.ui.lineTrackOn.setText(  "%s" % prefix + COM_TRACKON)
          self.ui.lineTrackOff.setText( "%s" % prefix + COM_TRACKOFF)
          self.ui.lineScript.setText(   "%s" % prefix + COM_CUSTOM)
          self.ui.lineShell.setText(    "%s" % prefix + COM_SHELL)
          
       def doCreateConfigCommands(self):

          Check    = self.ui.lineCheck.text()
          Location = self.ui.lineLocation.text()
          TrackOn  = self.ui.lineTrackOn.text()
          TrackOff = self.ui.lineTrackOff.text()
          Camera   = self.ui.lineCamera.text()
          Call     = self.ui.lineCall.text()
          Lock     = self.ui.lineLock.text()
          Unlock   = self.ui.lineUnlock.text()
          RemoteOn  = self.ui.lineRemoteOn.text()
          RemoteOff = self.ui.lineRemoteOff.text()
          Power     = self.ui.linePower.text()
          Reboot    = self.ui.lineReboot.text()
          PowerOff  = self.ui.linePowerOff.text()
          Script    = self.ui.lineScript.text()
          Shell     = self.ui.lineShell.text()
          
          #Update of the config file.
          os.rename( Path + ConfigFile, Path + ConfigFile + "~" )
          destination = open( Path + ConfigFile, "w" )
          source = open( Path + ConfigFile + "~", "r" )
          for Line in source:
             if   Line.startswith("COM_CHECK"):
                destination.write('COM_CHECK         = \'%s\'\n' % Check)
             elif Line.startswith("COM_LOCATION"):
                destination.write('COM_LOCATION      = \'%s\'\n' % Location)
             elif Line.startswith("COM_TRACKON"):
                destination.write('COM_TRACKON       = \'%s\'\n' % TrackOn)
             elif Line.startswith("COM_TRACKOFF"):
                destination.write('COM_TRACKOFF      = \'%s\'\n' % TrackOff)
             elif Line.startswith("COM_CAMERA"):
                destination.write('COM_CAMERA        = \'%s\'\n' % Camera)
             elif Line.startswith("COM_CALL"):
                destination.write('COM_CALL          = \'%s\'\n' % Call)
             elif Line.startswith("COM_LOCK"):
                destination.write('COM_LOCK          = \'%s\'\n' % Lock)
             elif Line.startswith("COM_UNLOCK"):
                destination.write('COM_UNLOCK        = \'%s\'\n' % Unlock)
             elif Line.startswith("COM_REMOTEON"):
                destination.write('COM_REMOTEON      = \'%s\'\n' % RemoteOn)
             elif Line.startswith("COM_REMOTEOFF"):
                destination.write('COM_REMOTEOFF     = \'%s\'\n' % RemoteOff)
             elif Line.startswith("COM_POWER "):
                destination.write('COM_POWER         = \'%s\'\n' % Power)
             elif Line.startswith("COM_REBOOT"):
                destination.write('COM_REBOOT        = \'%s\'\n' % Reboot)
             elif Line.startswith("COM_POWEROFF"):
                destination.write('COM_POWEROFF      = \'%s\'\n' % PowerOff)
             elif Line.startswith("COM_CUSTOM"):
                destination.write('COM_CUSTOM        = \'%s\'\n' % Script)
             elif Line.startswith("COM_SHELL"):
                destination.write('COM_SHELL         = \'%s\'\n' % Shell)                   
             else: 
                destination.write( Line )
          source.close()
          destination.close()

          message = 'Updating. Please wait..'
          showQuickMessage(message)
          doUpdateConfig()

          message = 'Successfully Updated the Command Names..'
          showMessage(message)
          
       ##TAB: SSH Settings
       def doCreateConfigSSH(self):
          SSHUsername = self.ui.lineSSHUsername.text()
          SSHPassword = self.ui.lineSSHPassword.text()
          SSHHost     = self.ui.lineSSHHost.text()
          SSHPort     = self.ui.lineSSHPort.text()

         # Update of the config file.
          os.rename( Path + ConfigFile, Path + ConfigFile + "~" )
          destination = open( Path + ConfigFile, "w" )
          source = open( Path + ConfigFile + "~", "r" )
          for Line in source:
             if   Line.startswith("REMOTEUSER"):
                destination.write('REMOTEUSER        = \'%s\'\n' % EncodeAES(AES.new(Secret), str(SSHUsername)) )
             elif Line.startswith("REMOTEPASSWORD"):
                destination.write('REMOTEPASSWORD    = \'%s\'\n' % EncodeAES(AES.new(Secret), str(SSHPassword)) )
             elif Line.startswith("REMOTEHOST"):
                destination.write('REMOTEHOST        = \'%s\'\n' % SSHHost)
             elif Line.startswith("REMOTEPORT"):
                destination.write('REMOTEPORT        = %s \n' % SSHPort)
             else: 
                destination.write( Line )
          source.close()
          destination.close()

          message = 'Updating. Please wait..'
          showQuickMessage(message)
          doUpdateConfig()
          
          message = 'The SSH Settings have been successfully saved.\
                     \nUser name: %s\nPassword: %s\nHost: %s - Port: %s' % (SSHUsername,
                                                                            SSHPassword,
                                                                            SSHHost,
                                                                            SSHPort)
          showMessage(message)

       ##TAB: TESTING
       def doSendTestMail1(self):
          os.system('sudo smscon -test email1')
          message = 'TEST INITIATED: An email has been sent.'
          showQuickMessage(message)
            
       def doSendTestMail2(self):
          os.system('sudo smscon -test email2')
          message = 'TEST INITIATED: An email with a picture taken with the front camera has been sent.'
          showQuickMessage(message)
          
       def doSendTestGPS1(self):
          os.system('sudo smscon -test gps1')
          message = 'TEST INITIATED: The GPS coordinates will be acquired and will be send once.'
          showQuickMessage(message)
          
       def doSendTestGPS2(self):
          os.system('sudo smscon -test gps2')
          message = 'TEST INITIATED: The GPS coordinates will be acquired and will be send in regular periods.'
          showQuickMessage(message)
          
       def doSendTestCall(self):
          os.system('sudo smscon -test call')
          message = 'TEST INITIATED: A phonecall to the default number will be initiated.'
          showQuickMessage(message)
          
       def doSendTestSMS(self):
          os.system('sudo smscon -test sms')
          message = 'TEST INITIATED: An SMS to the default number will be send.'
          showQuickMessage(message)
          
       def doSendTestSSH(self):
          os.system('sudo smscon -test ssh')
          message = 'TEST INITIATED: The reverse SSH connection has been initiated.'
          showQuickMessage(message)
          
       def doSendTestScript(self):
          os.system('sudo smscon -test script')
          message = 'TEST INITIATED: The script has been executed.'
          showQuickMessage(message)
          
       def doUpdatePassword(self):
          ##Open Dialog Window - change password
          mydialog = MyPasswordDialog()
          mydialog.exec_()

##############################################################  
       
class MyPasswordDialog(QtGui.QDialog):

       def __init__(self, parent=None):
          ##Build the parent user interface
          QtGui.QDialog.__init__(self, parent)
          self.ui = Ui_DialogPassword()
          self.ui.setupUi(self)
          ##self.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
          self.setAttribute(Qt.WA_Maemo5StackedWindow, True)
          
          ##Connect the button
          QtCore.QObject.connect(self.ui.btnNewPassword, QtCore.SIGNAL('clicked()'), self.doNewPassword)
             
       def doNewPassword(self):

          NewPassword1 = self.ui.lineNewPassword1.text()
          NewPassword2 = self.ui.lineNewPassword2.text()
          
          if   NewPassword1 != NewPassword2:
             message = 'The two cases are not equal. No change has been made.'
             showMessage(message)
             self.close()
          elif NewPassword1 == NewPassword2:
             NewPassword = NewPassword1
             if NewPassword == '':
               NewPassword = '12345'
          try:
             try:
               os.remove( AppPath + PassFile )
             except:
               pass 
             time.sleep(1)             
             os.system('sudo %ssmsconEditorCreatePass %s %s' % (AppPath, NewPassword, AppPath + PassFile))
          except:
             message = 'The new password hash could not be stored.'
             showMessage(message)
             self.close()
          else: 
             message = 'The new password hash has been computed and stored.'
             showMessage(message)
             self.close()
       
##############################################################

class SMSCONAbout(QtGui.QMainWindow):
    '''About Window'''
    def __init__(self, parent=None):
        QMainWindow.__init__(self,parent)
        self.parent = parent
        self.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
        self.setAttribute(Qt.WA_Maemo5StackedWindow, True)
        self.setWindowTitle("SMSCON Editor About")

        aboutScrollArea = QScrollArea(self)
        aboutScrollArea.setWidgetResizable(True)
        awidget = QWidget(aboutScrollArea)
        awidget.setMinimumSize(470,1100)
        awidget.setSizePolicy( QSizePolicy.Expanding, QSizePolicy.Expanding )
        aboutScrollArea.setSizePolicy( QSizePolicy.Expanding, QSizePolicy.Expanding )
        #Kinetic scroller is available on Maemo and should be on meego
        try:
            scroller = aboutScrollArea.property("kineticScroller").toPyObject()
            scroller.setEnabled(True)
        except:
            pass

        aboutLayout = QVBoxLayout(awidget)

        aboutIcon = QLabel()
        aboutIcon.setPixmap( QIcon.fromTheme('smscon-editor').pixmap(48,48) )
        aboutIcon.setAlignment( Qt.AlignCenter or Qt.AlignHCenter )
        aboutIcon.resize(128,128)
        aboutLayout.addWidget(aboutIcon)

        aboutLabel = QLabel('''<center><b>SMSCON Editor</b> 
                                   <br>version: %s
                                   <br>
                                   <br>
                                   <b>The SMSCON Editor is a user interface 
                                   <br>to the configuration of the SMSCON.</b>
                                   <br>
                                   <br>Licenced under GPLv2
                                   <br>by <b>Christos Zamantzas</b> (Saturn)
                                   <br>
                                   <br>It provides the ability to edit 
                                   <br>the options and name the secret  
                                   <br>pass-phrases of the commands used 
                                   <br>for controlling the device.
                                   <br>
                                   <br>In addition, it provides an interface 
                                   <br>to initialise and configure the 
                                   <br>SMSCON daemon.
                                   <br>
                                   <br>Additional information on the usage, 
                                   <br>settings and implications can be found in
                                   <br>the wiki pages (see buttons at the end).
                                   <br>
                                   <br>
                                   <br><b>Thanks to:</b>
                                   <br><b>Frank Visser</b> (Digitalvoid) for 
                                   <br>the code to import, decrypt and encrypt 
                                   <br>the user variables at the config file.
                                   <br>
                                   <br><b>Benoit HERVIER</b> at http://khertan.net/
                                   <br>for the code used in this about window.
                                   <br>
                                   </center>''' % Version)
        aboutLayout.addWidget(aboutLabel)
        self.wiki1_button = QPushButton('SMSCON')
        self.wiki1_button.clicked.connect(self.open_wiki1)
        self.wiki2_button = QPushButton('SMSCON Editor')
        self.wiki2_button.clicked.connect(self.open_wiki2)
        awidget2 = QWidget()
        buttonLayout = QHBoxLayout(awidget2)        
        buttonLayout.addWidget(self.wiki1_button)
        buttonLayout.addWidget(self.wiki2_button)
        aboutLayout.addWidget(awidget2)
        
        awidget.setLayout(aboutLayout)
        aboutScrollArea.setWidget(awidget)
        self.setCentralWidget(aboutScrollArea)
        self.show()        
        
    def open_wiki1(self):
        QDesktopServices.openUrl(QUrl('http://wiki.maemo.org/SMSCON'))
    def open_wiki2(self):
        QDesktopServices.openUrl(QUrl('http://wiki.maemo.org/SMSCON_Editor'))


##############################################################        
             
class smsconEditorMain():
        
          ##############################################################  

          ##Check with what priviledges the GUI has been executed.
          if os.geteuid() == 0:
             message ='ERROR: SMSCON Editor should not be executed as root. Exiting..'
             showMessage(message)
             sys.exit(1)

          ##Check if temp folder is available   
          if os.path.exists(Path) == False:
             os.system('mkdir %s' % Path)
             message ='First Time Use: Creating temp folders..'
             showQuickMessage(message)
          else:
             pass
          ##Check if temp config file available
          if CheckFile(Path, ConfigFile) == False:
             message ='First Time Use: Creating temp folders..'
             showQuickMessage(message)
             doCopyConfig()
          else:
             pass
            
          ##############################################################         
          app = QtGui.QApplication(sys.argv)
          #Open Main Window
          myapp = MyMainWindow()
          myapp.show()

          sys.exit(app.exec_())
          