#!/usr/bin/python2.5

##############################################################
#    smscon-editor  -  Configuration UI for the SMSCON       #
##############################################################

# Author: Christos Zamantzas <christos.zamantzas@gmail.com>
# Version: 0.4.4-6

import os
import sys
import time

from PyQt4 import QtGui,QtCore
from smsconGUIelements import *

##############################################################

def showMessage(message):
    """
    Method to display a message to the user that waits for a confirmation.
    """

    os.system('dbus-send --type=method_call --dest=org.freedesktop.Notifications \
               /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteDialog \
               string:"%s" uint32:0 string:"OK"' % message)          

##############################################################  

# Check with what priviledges the GUI has been executed.
if os.geteuid() == 0:
    message ='ERROR: SMSCON Editor should not be executed as root.'
    showMessage(message)
    sys.exit(1)

##############################################################

MainPath                     = '/usr/bin/'            # main path of files
Path                         = '/home/user/'          # temp path of files
ConfigFile                   = 'smscon_config'        # name of config file

##############################################################

os.system('cp /usr/bin/smscon_config /home/user/')    # make a copy of the config file 

##############################################################

def doUpdateConfig():
    """
    Update the config file with the newly created and restart deamon.
    """

    time.sleep(1)
    os.system('echo "cp /home/user/smscon_config /usr/bin/smscon_config"|root')
    time.sleep(1)
    os.system('sudo smscon -stop')
    time.sleep(1)
    os.system('sudo smscon -start')
    
# Load user settings from smscon_config file
ConfigVars = ['SENDERNUMBER',                 
              'EMAILADDRESS',
              'COM_CHECK',
              'COM_REBOOT',
              'COM_POWEROFF',
              'COM_POWER',
              'COM_LOCATION',
              'COM_REMOTEON',
              'COM_REMOTEOFF',
              'COM_CAMERA',
              'COM_CALL',
              'COM_LOCK', 
              'COM_UNLOCK',
              'COM_TRACKON',
              'COM_TRACKOFF',
              'USER',         
              'PASSWORD',        
              'EMAILFROM',       
              'MAILSERVER',      
              'MAILPORT',        
              'REMOTEHOST',            
              'REMOTEPORT',           
              'REMOTEUSER',       
              'REMOTEPASSWORD',
              'COMMANDREPLY',
              'AUTODEVICELOCK',
              'KEYBOARDDETECT',
              'GPSTIMEOUT',
              'GPSPOLLING',
              'GPSINTERVAL',
              'GPSSEND']
try:
  f = open(Path + ConfigFile, 'r')
  f.close()
except:
  message = 'Reading SMSCON settings gave a FATAL ERROR while loading\nConfiguration file does not exist.'
  showMessage(message)
  sys.exit(1)
else:
  f = open(Path + ConfigFile, 'r')
  ConfigLines = f.readlines() 
  if ConfigLines == []:
      message = 'Reading SMSCON settings gave a FATAL ERROR while loading\nConfiguration file is empty.'
      showMessage(message)
      sys.exit(1)
  else:
      # -- New code -- accepts code in Commands
      try:
          for Line in ConfigLines:
              Line = Line.strip().replace('\r', '').replace('\n', '')
             
              for Var in ConfigVars:
                  # get user variable & it's value from text line
                  if Line.startswith('%s' % Var):
                      try:
                          Variable, Value = Line.split('=')
                      except:
                          # logging.critical('error in user settings from "%s" file' % ConfigFile)
                          message = 'FATAL ERROR in SMSCON settings: ERROR in user settings file.'
                          showMessage(message)
                          sys.exit(1)
                      else:
                          Value = Value.lstrip(' ')
                          try:
                              if Value.startswith("'") == True and Value.endswith("'") == True:
                                  vars()[Var] = Value.strip("'") # get string
                              else:
                                  vars()[Var] = int(Value) # get integer
                          except:
                              # logging.critical('error in user settings from "%s" file' % ConfigFile)
                              message = 'FATAL ERROR in SMSCON settings: ERROR in user settings file.'
                              showMessage(message)
                              sys.exit(1)
      except:
          # logging.critical('error reading user settings from "%s" file' % ConfigFile)
          message = 'FATAL ERROR in SMSCON settings: ERROR reading user settings.'
          showMessage(message)
          quit()
      else:
          # logging.info('user settings succesfully loaded from "%s" file' % ConfigFile) 
          message = 'SMSCON settings succesfully loaded.'
          showMessage(message)
  f.close()

##############################################################


class MyForm(QtGui.QMainWindow):
        def __init__(self, parent=None):
        
                # Build parent user interface
                QtGui.QWidget.__init__(self, parent)
                self.ui = Ui_SMSCON_GUI_elements()
                self.ui.setupUi(self)
 
                # Set Values 
                self.ui.linePhone.setText("%s" % SENDERNUMBER)
                self.ui.lineGPSTimeout.setText("%s" % GPSTIMEOUT)  
                self.ui.lineGPSPolling.setText("%s" % GPSPOLLING)
                
                if GPSINTERVAL == 10:
                   self.ui.comboBoxGPSInterval.setCurrentIndex(0) 
                elif GPSINTERVAL == 20:
                   self.ui.comboBoxGPSInterval.setCurrentIndex(1) 
                elif GPSINTERVAL == 30:
                   self.ui.comboBoxGPSInterval.setCurrentIndex(2) 
                elif GPSINTERVAL == 60:
                   self.ui.comboBoxGPSInterval.setCurrentIndex(3) 
                elif GPSINTERVAL == 120:
                   self.ui.comboBoxGPSInterval.setCurrentIndex(4) 
                else:
                   self.ui.comboBoxGPSInterval.setCurrentIndex(3) 

                if GPSSEND == 'sms':
                   self.ui.comboBoxGPSSend.setCurrentIndex(0) 
                elif GPSSEND == 'email':
                   self.ui.comboBoxGPSSend.setCurrentIndex(1)
                  
                self.ui.lineEmailUsername.setText("%s" % USER)
                self.ui.lineEmailPassword.setText("%s" % PASSWORD)
                self.ui.lineEmailAddress.setText("%s" % EMAILADDRESS)
##                self.ui.lineEmailFrom.setText("%s" % EMAILFROM)
                self.ui.lineEmailServer.setText("%s" % MAILSERVER)
                self.ui.lineEmailPort.setText("%s" % MAILPORT)
                  
                self.ui.lineSSHUsername.setText("%s" % REMOTEUSER)
                self.ui.lineSSHPassword.setText("%s" % REMOTEPASSWORD)
                self.ui.lineSSHHost.setText("%s" % REMOTEHOST)
                self.ui.lineSSHPort.setText("%s" % REMOTEPORT)
                  
                if COMMANDREPLY == 'yes':
                   self.ui.checkBoxCommandReply.setChecked(True)
                else:
                   self.ui.checkBoxCommandReply.setChecked(False)
                
                if AUTODEVICELOCK == 'yes':
                   self.ui.checkBoxDeviceLock.setChecked(True)
                else:
                   self.ui.checkBoxDeviceLock.setChecked(False)
                
                if KEYBOARDDETECT == 'yes':
                   self.ui.checkBoxKeyboardDetect.setChecked(True)
                else:
                   self.ui.checkBoxKeyboardDetect.setChecked(False)  
                
                self.ui.lineCheck.setText(    "%s" % COM_CHECK)
                self.ui.lineReboot.setText(   "%s" % COM_REBOOT)
                self.ui.linePowerOff.setText( "%s" % COM_POWEROFF)
                self.ui.linePower.setText(    "%s" % COM_POWER)
                self.ui.lineLocation.setText( "%s" % COM_LOCATION)
                self.ui.lineRemoteOn.setText( "%s" % COM_REMOTEON)
                self.ui.lineRemoteOff.setText("%s" % COM_REMOTEOFF)
                self.ui.lineCamera.setText(   "%s" % COM_CAMERA)
                self.ui.lineCall.setText(     "%s" % COM_CALL)
                self.ui.lineLock.setText(     "%s" % COM_LOCK)
                self.ui.lineUnlock.setText(   "%s" % COM_UNLOCK)
                self.ui.lineTrackOn.setText(  "%s" % COM_TRACKON)
                self.ui.lineTrackOff.setText( "%s" % COM_TRACKOFF)
                
                # Connect GUI Buttons with actions
                  # Create Settings
                QtCore.QObject.connect(self.ui.btnCreateConfigGeneral, QtCore.SIGNAL('clicked()'), self.doCreateConfigGeneral)
                QtCore.QObject.connect(self.ui.btnCreateConfigEmail, QtCore.SIGNAL('clicked()'), self.doCreateConfigEmail)
                QtCore.QObject.connect(self.ui.btnCreateConfigSSH, QtCore.SIGNAL('clicked()'), self.doCreateConfigSSH)
                QtCore.QObject.connect(self.ui.btnCreateConfigCommands1, QtCore.SIGNAL('clicked()'), self.doCreateConfigCommands1)
                QtCore.QObject.connect(self.ui.btnCreateConfigCommands2, QtCore.SIGNAL('clicked()'), self.doCreateConfigCommands2)
                  # Initialise
                QtCore.QObject.connect(self.ui.btnInit, QtCore.SIGNAL('clicked()'), self.doInit)
                QtCore.QObject.connect(self.ui.btnReset, QtCore.SIGNAL('clicked()'), self.doReset)
                QtCore.QObject.connect(self.ui.btnStart, QtCore.SIGNAL('clicked()'), self.doStart)
                QtCore.QObject.connect(self.ui.btnStop, QtCore.SIGNAL('clicked()'), self.doStop)
                QtCore.QObject.connect(self.ui.btnBoot, QtCore.SIGNAL('clicked()'), self.doBoot)
                QtCore.QObject.connect(self.ui.btnUnBoot, QtCore.SIGNAL('clicked()'), self.doUnBoot)
                  # Test
                QtCore.QObject.connect(self.ui.btnTestMail, QtCore.SIGNAL('clicked()'), self.doSendTestMail)
                QtCore.QObject.connect(self.ui.btnTestMail2, QtCore.SIGNAL('clicked()'), self.doSendTestMail2)
                
                # Connect Menu Buttons 
                  # those do only one action
                QtCore.QObject.connect(self.ui.actionQuit, QtCore.SIGNAL('triggered()'), QtGui.qApp, QtCore.SLOT('quit()'))
##                QtCore.QObject.connect(self.ui.actionAbout, QtCore.SIGNAL('triggered()'), self.doAbout)
##                QtCore.QObject.connect(self.ui.actionCredits, QtCore.SIGNAL('triggered()'), self.doCredits)
                  
       # Create Methods

##        def doAbout(self):
##            msg = "SMSCON - Control your N900 through SMS\n\n"
##            msg += "Version 0.4.6\n\n"
##            msg += unichr(int('00A9', 16)) + "SMSCON - 2010, Frank Visser\n\n"
##            msg += unichr(int('00A9', 16)) + "SMSCON Editor - 2010, Christos Zamantzas\n\n"
##            msg += "Distributed under GPL ver. 3"
##            QMessageBox.about(self, "About - SMSCON", msg)

        # def doCredits(self):
        
        #TAB: INIT
        def doInit(self):
            os.system('sudo smscon -init')
            message = 'SMSCON has been initialised to the default configuration.  \
                      \nThis editor will now quit...\n\nYou will need to open it again and edit your new configuration.'
            showMessage(message)
            sys.exit(1)
            
        def doReset(self):
            os.system('sudo smscon -reset')
            message = 'SMSCON has been reset, i.e. the process has been stopped, the config file has been overwriten to the default \
                       and the deamon has been removed from the boot sequence.\nThis editor will now quit... \
                       \n\nYou will need to open it again and edit your new configuration. '
            showMessage(message)
            sys.exit(1)

        def doStart(self):
            message = os.popen('sudo smscon -start').read()
            showMessage(message)

        def doStop(self):
            message = os.popen('sudo smscon -stop').read()
            showMessage(message)

        def doBoot(self):
            message = os.popen('sudo smscon -boot').read()
            showMessage(message)

        def doUnBoot(self):
            message = os.popen('sudo smscon -unboot').read()
            showMessage(message)

        #TAB: General    
        def doCreateConfigGeneral(self):
            DefaultPhone = self.ui.linePhone.text()
            GPSTimeout   = self.ui.lineGPSTimeout.text()
            GPSPolling   = self.ui.lineGPSPolling.text()
            GPSInterval  = self.ui.comboBoxGPSInterval.currentText()
            GPSSend      = self.ui.comboBoxGPSSend.currentText()
           
            CommandReply = self.ui.checkBoxCommandReply.isChecked()
            if CommandReply is True:
                CommandReply = "yes"
            else:
                CommandReply = "no"
            
            AutoDeviceLock = self.ui.checkBoxDeviceLock.isChecked()
            if AutoDeviceLock is True:
                AutoDeviceLock = "yes"
            else:
                AutoDeviceLock = "no"

            KeyboardDetect = self.ui.checkBoxKeyboardDetect.isChecked()
            if KeyboardDetect is True:
                KeyboardDetect = "yes"
            else:
                KeyboardDetect = "no"
           
            # Update of the config file.
            os.rename( Path + ConfigFile, Path + ConfigFile + "~" )
            destination = open( Path + ConfigFile, "w" )
            source = open( Path + ConfigFile + "~", "r" )
            for Line in source:
                if   Line.startswith("SENDERNUMBER"):
                   destination.write('SENDERNUMBER      = \'%s\'\n' % DefaultPhone)
                elif Line.startswith("GPSTIMEOUT"):
                   destination.write('GPSTIMEOUT        = %s \n' % GPSTimeout)
                elif Line.startswith("GPSPOLLING"):
                   destination.write('GPSPOLLING        = %s \n' % GPSPolling)
                elif Line.startswith("GPSINTERVAL"):
                   destination.write('GPSINTERVAL       = %s \n' % GPSInterval)
                elif Line.startswith("GPSSEND"):
                   destination.write('GPSSEND           = \'%s\'\n' % GPSSend)
                elif Line.startswith("AUTODEVICELOCK"):
                   destination.write('AUTODEVICELOCK    = \'%s\'\n' % AutoDeviceLock)
                elif Line.startswith("COMMANDREPLY"):
                   destination.write('COMMANDREPLY      = \'%s\'\n' % CommandReply)
                elif Line.startswith("KEYBOARDDETECT"):
                   destination.write('KEYBOARDDETECT    = \'%s\'\n' % KeyboardDetect)
                else: 
                   destination.write( Line )
            source.close()
            destination.close()

            message = '%s has been added as the default number.\
                       \nAn SMS will be send to it if the SIM ever gets replaced.\
                       \n\nThe GPS will try at least for %s seconds to get a lock.\
                       \n If successfull, it will choose the most accurate from the next %s acquisitions.\
                       \n\nCoordinates will be sent after that every %s seconds.' % (DefaultPhone,
                                                                                     GPSTimeout,
                                                                                     GPSPolling,
                                                                                     GPSInterval)
            showMessage(message)
            doUpdateConfig()

        #TAB: Email Settings    
        def doCreateConfigEmail(self):
            EmailUsername = self.ui.lineEmailUsername.text()
            EmailPassword = self.ui.lineEmailPassword.text()
            EmailAddress  = self.ui.lineEmailAddress.text()
##            EmailFrom     = self.ui.lineEmailFrom.text()
            EmailServer   = self.ui.lineEmailServer.text()
            EmailPort     = self.ui.lineEmailPort.text()

            # Update of the config file.
            os.rename( Path + ConfigFile, Path + ConfigFile + "~" )
            destination = open( Path + ConfigFile, "w" )
            source = open( Path + ConfigFile + "~", "r" )
            for Line in source:
                if   Line.startswith("EMAILADDRESS"):
                   destination.write('EMAILADDRESS      = \'%s\'\n' % EmailAddress)
##                elif Line.startswith("EMAILFROM"):
##                   destination.write('EMAILFROM         = \'%s\'\n' % EmailFrom)
                elif Line.startswith("USER"):
                   destination.write('USER              = \'%s\'\n' % EmailUsername)
                elif Line.startswith("PASSWORD"):
                   destination.write('PASSWORD          = \'%s\'\n' % EmailPassword)
                elif Line.startswith("MAILSERVER"):
                   destination.write('MAILSERVER        = \'%s\'\n' % EmailServer)
                elif Line.startswith("MAILPORT"):
                   destination.write('MAILPORT          = %s\n' % EmailPort)
                else: 
                   destination.write( Line )
            source.close()
            destination.close()

            message = 'User name: %s, Password: %s\nEmail address: %s\nMail server: %s, Port: %s' % (EmailUsername,
                                                                                                     EmailPassword,
                                                                                                     EmailAddress,
                                                                                                     EmailServer,
                                                                                                     EmailPort)
            
##            message = 'User name: %s, Password: %s\nEmail address: %s\nEmailFrom address: %s\nMail server: %s, Port: %s' % (EmailUsername,
##                                                                                                                            EmailPassword,
##                                                                                                                            EmailAddress,
##                                                                                                                            EmailFrom,
##                                                                                                                            EmailServer,
##                                                                                                                            EmailPort)

            showMessage(message)
            doUpdateConfig()
            
        #TAB: Commands Renaming       
        def doCreateConfigCommands1(self):

            Check    = self.ui.lineCheck.text()
            Location = self.ui.lineLocation.text()
            TrackOn  = self.ui.lineTrackOn.text()
            TrackOff = self.ui.lineTrackOff.text()
            Camera   = self.ui.lineCamera.text()
            Call     = self.ui.lineCall.text()
            Lock     = self.ui.lineLock.text()
            Unlock   = self.ui.lineUnlock.text()

            # Update of the config file.
            os.rename( Path + ConfigFile, Path + ConfigFile + "~" )
            destination = open( Path + ConfigFile, "w" )
            source = open( Path + ConfigFile + "~", "r" )
            for Line in source:
                if   Line.startswith("COM_CHECK"):
                   destination.write('COM_CHECK         = \'%s\'\n' % Check)
                elif Line.startswith("COM_LOCATION"):
                   destination.write('COM_LOCATION      = \'%s\'\n' % Location)
                elif Line.startswith("COM_TRACKON"):
                   destination.write('COM_TRACKON       = \'%s\'\n' % TrackOn)
                elif Line.startswith("COM_TRACKOFF"):
                   destination.write('COM_TRACKOFF      = \'%s\'\n' % TrackOff)
                elif Line.startswith("COM_CAMERA"):
                   destination.write('COM_CAMERA        = \'%s\'\n' % Camera)
                elif Line.startswith("COM_CALL"):
                   destination.write('COM_CALL          = \'%s\'\n' % Call)
                elif Line.startswith("COM_LOCK"):
                   destination.write('COM_LOCK          = \'%s\'\n' % Lock)
                elif Line.startswith("COM_UNLOCK"):
                   destination.write('COM_UNLOCK        = \'%s\'\n' % Unlock)
                else: 
                   destination.write( Line )
            source.close()
            destination.close()

            message = 'Updated Command Names.'
            showMessage(message)
            doUpdateConfig()

        def doCreateConfigCommands2(self):

            RemoteOn  = self.ui.lineRemoteOn.text()
            RemoteOff = self.ui.lineRemoteOff.text()
            Power     = self.ui.linePower.text()
            Reboot    = self.ui.lineReboot.text()
            PowerOff  = self.ui.linePowerOff.text()

            # Update of the config file.
            os.rename( Path + ConfigFile, Path + ConfigFile + "~" )
            destination = open( Path + ConfigFile, "w" )
            source = open( Path + ConfigFile + "~", "r" )
            for Line in source:
                if   Line.startswith("COM_REMOTEON"):
                   destination.write('COM_REMOTEON      = \'%s\'\n' % RemoteOn)
                elif Line.startswith("COM_REMOTEOFF"):
                   destination.write('COM_REMOTEOFF     = \'%s\'\n' % RemoteOff)
                elif Line.startswith("COM_POWER "):
                   destination.write('COM_POWER         = \'%s\'\n' % Power)
                elif Line.startswith("COM_REBOOT"):
                   destination.write('COM_REBOOT        = \'%s\'\n' % Reboot)
                elif Line.startswith("COM_POWEROFF"):
                   destination.write('COM_POWEROFF      = \'%s\'\n' % PowerOff)
                else: 
                   destination.write( Line )
            source.close()
            destination.close()

            message = 'Updated Command Names.'

            showMessage(message)
            doUpdateConfig()

            
        #TAB: SSH Settings
        def doCreateConfigSSH(self):
            SSHUsername = self.ui.lineSSHUsername.text()
            SSHPassword = self.ui.lineSSHPassword.text()
            SSHHost     = self.ui.lineSSHHost.text()
            SSHPort     = self.ui.lineSSHPort.text()

            # Update of the config file.
            os.rename( Path + ConfigFile, Path + ConfigFile + "~" )
            destination = open( Path + ConfigFile, "w" )
            source = open( Path + ConfigFile + "~", "r" )
            for Line in source:
                if   Line.startswith("REMOTEUSER"):
                   destination.write('REMOTEUSER        = \'%s\'\n' % SSHUsername)
                elif Line.startswith("REMOTEPASSWORD"):
                   destination.write('REMOTEPASSWORD    = \'%s\'\n' % SSHPassword)
                elif Line.startswith("REMOTEHOST"):
                   destination.write('REMOTEHOST        = \'%s\'\n' % SSHHost)
                elif Line.startswith("REMOTEPORT"):
                   destination.write('REMOTEPORT        = %s \n' % SSHPort)
                else: 
                   destination.write( Line )
            source.close()
            destination.close()

            message = 'Created SSH Settings\nUser name: %s, Password: %s\nHost: %s, Port: %s' % (SSHUsername,
                                                                                                 SSHPassword,
                                                                                                 SSHHost,
                                                                                                 SSHPort)
            showMessage(message)
            doUpdateConfig()

        #TAB: TESTING
          #FIXME: add more commands.
        def doSendTestMail(self):
            os.system('sudo smscon -test email1')
            message = 'A test email has been sent.'
            showMessage(message)
            
        def doSendTestMail2(self):
            os.system('sudo smscon -test email2')
            message = 'A test email with a picture taken with the front camera has been sent.'
            showMessage(message)
             

if __name__ == "__main__":
        #This function means this was run directly, not called from another Python file.
        app = QtGui.QApplication(sys.argv)
        myapp = MyForm()
        myapp.show()
        sys.exit(app.exec_())
