/*
 * check_func.h - describe functions for different checks.
 * This file is part of PetrSU KP library.
 *
 * Copyright (C) 2009 - Alexander A. Lomov. All rights reserved.
 *
 * PetrSU KP library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PetrSU KP library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with <program name>; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */

#ifndef _UTIL_FUNC_C_
#define _UTIL_FUNC_C_

#include <stdio.h>
#include "kp_error.h"
#include "../structures.h"
#include "util_func.h"
#include "list.h"
#include <sys/types.h>
#include <stdlib.h>
#include "../properties.h"
#include "kpi_low.h"


/******************************************************************************/
/**************************** External functions ******************************/
/**
 * @brief Gets duplacate of given string.
 *
 * @param string to duplcate.
 *
 * @return on success, retuens a ppointer to the location containing
 * the duplicate string, otherwise NULL.
 */
char* get_str_duplicate(const char *string)
{

    if (string == NULL) {
        return NULL;
    }

    /* +1 for for '\0' */
    int len = strlen(string) + 1;

    char *dupl_string = (char *) calloc(len, sizeof(char));

    strcpy(dupl_string, string);

    return dupl_string;
}


/**
 * @brief Checkes is there input item in list of properties.
 *
 * @param property_t needl.
 * @param list_head_t haystack.
 *
 * @return returns true if item founded in list and false otherwise.
 */
bool is_in_property_list(property_t *item, list_t *property_list) {
	list_head_t *pos = NULL;

	if ((item == NULL) || (property_list == NULL)) return false;

	if (list_empty(&property_list->links)) return false;

	list_for_each(pos, &property_list->links) {
		list_t *node = list_entry(pos, list_t, links);
		property_t *prop = (property_t *) node->data;

		if ((strcmp(item->name, prop->name) == 0 ) && (item->type == prop->type) && (item->rtti == prop->rtti))
			return true;
	}

	return false;
}


/**
 * @brief Checkes is there input item in list of properties values.
 *
 * @param prop_val_t needl.
 * @param list_head_t haystack.
 *
 * @return returns true if item founded in list and false otherwise.
 */
bool is_in_property_values_list(prop_val_t *item, list_t *property_list) {
	list_head_t *pos = NULL;
	printf("here1\n");

	if ((item == NULL) || (property_list == NULL)) return false;
	printf("here2\n");

	if (list_empty(&property_list->links)) return false;
	printf("here3\n");

	list_for_each(pos, &property_list->links) {
		list_t *node = list_entry(pos, list_t, links);
		prop_val_t *prop = (prop_val_t *) node->data;

		if (is_prop_names_equal(item, prop))
			return true;
	}

	return false;
}


/**
 * @brief Concatenate two triples lists.
 *
 * This function only add triples list b to a. No new memory allocated.
 * If you using delete function for list a, b will be deleted too.
 *
 * @param a first triples list.
 * @param b second triples list.
 *
 * @return list a with added b. If one of list equals NULL, it return another,
 * if both equals NULL it return NULL.
 */
ss_triple_t *concat_triplets(ss_triple_t *a, ss_triple_t *b)
{
    if (a == NULL && b == NULL) {
        return NULL;
    } else if (a == NULL) {
        return b;
    } else if (b == NULL) {
        return a;
    }

    ss_triple_t *list_walker = a;

    while (true) {
        if (list_walker->next == NULL) {
            list_walker->next = b;
            break;
        }
        list_walker = list_walker->next;
    }

    list_walker = b;

    return a;
}

#endif /* _UTIL_FUNC_C_ */
