/*
 * kp_debug.h - for manipulation of debug for kp library.
 * This file is part of PetrSU KP library.
 *
 * Copyright (C) 2009 - Alexander A. Lomov. All rights reserved.
 *
 * PetrSU KP library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PetrSU KP library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PetrSU KP library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */

#ifndef _KP_DEBUG_H
#define	_KP_DEBUG_H

#ifdef	__cplusplus
extern "C" {
#endif

#define KPLIB_DEBUG_LEVEL_HIGH 1    /**< Debug level */
#define KPLIB_DEBUG_LEVEL_LOW 10    /**< Debug level */
#define KPLIB_DEBUG_LEVEL_MED 5     /**< Debug level */
#define KPLIB_DEBUG_LEVEL_AMED 3    /**< Debug level */
#define KPLIB_DEBUG_LEVEL_BMED 7    /**< Debug level */

/** @brief Set debug level */
#define KPLIB_DEBUG_LEVEL 10

/** @brief Debug flag */
#define KPLIB_DEBUG_ON

#ifdef KPLIB_DEBUG_ON
#define KPLIB_DEBUG(level) if (level <= KPLIB_DEBUG_LEVEL) printf
#else
#define KPLIB_DEBUG(level) //
#endif 


/** @brief Debug prefix for output (classes.[c|h]) */
#define KPLIB_DEBUG_CLASSSES_PREFIX "CLASSES:"

/** @brief Debug prefix for output (kpi_interface.[c|h]) */
#define KPLIB_DEBUG_KPIINTER_PREFIX "KPI_INTER:"

/** @brief Debug prefix for output (ss_subscribe.[c|h]) */
#define KPLIB_DEBUG_SS_SBCR_PREFIX "SS_SBCR:"

/** @brief Debug prefix for output (ss_subscribe.[c|h]) */
#define KPLIB_DEBUG_PROP_PREFIX "PROPS:"

/** @brief Debug prefix for output (utils/check_func.[c|h]) */
#define KPLIB_DEBUG_CHECKS_PREFIX "CHECKS:"
        
#ifdef	__cplusplus
}
#endif

#endif	/* _KP_DEBUG_H */

