#include "generic.h"
#include "/home/vanag/mag/subversion/demos/Drinkers/simple/SmartSlog_lib/drinkers.h"

static void check_ss_properties();
static void check_ss_classes();
static void check_ss_populate();

static void clean_property_ss();

int main()
{
	init_ss();
	register_ontology();

	if (ss_join(get_ss_info(), "TestSS KP") == -1) {
		printf("Can't join to SS\n");
		//return 0;
	}

	check_ss_properties();
	//check_ss_classes();
	//check_ss_populate();



	printf("\n\n --------------------------------------- END --------------------------------------------\n");
	//clean_property_ss();
	return 0;
}

static void check_ss_properties()
{
	printf("\n\n --- Check ss_properties ---\n");


	printf("\n\n --- initing local structures....\n");
	individual_t *drinker1 = new_individual(CLASS_DRINKER);
	individual_t *drinker2 = new_individual(CLASS_DRINKER);

	printf("\n\n --- set uuids....\n");
	drinker1->uuid = "uuid1";
	drinker2->uuid = "uuid2";

	list_t* list;
	list_t *node = NULL;
	list_head_t *pos = NULL;
	prop_val_t *p_val;

	printf("\n\n --- initing liters....\n");
	char *liters = (char *) malloc(sizeof(char) * 2);
	liters[0] = '3';
	liters[1] = '\0';

	char *liters2 = (char *) malloc(sizeof(char) * 2);
	liters2[0] = '5';
	liters2[1] = '\0';

	printf("\n\n --- Setting PROPERTY_TOTALLITRESCOUNT = 3 for drinker1...\n");

	ss_set_property(drinker1, PROPERTY_TOTALLITRESCOUNT->name, liters);

	printf("\n\n --- Updating PROPERTY_TOTALLITRESCOUNT = 5 for drinker1...\n");

	ss_update_property_with_data(drinker1, PROPERTY_TOTALLITRESCOUNT->name, liters, liters2);

	printf("\n\n --- Getting PROPERTY_TOTALLITRESCOUNT for drinker1 with prop_val_t:\n");

	p_val = ss_get_property(drinker1, PROPERTY_TOTALLITRESCOUNT->name);
	if (!p_val) {
		printf("\np_val empty\n");
	}
	else printf("\ndrinker1's liters: %s\n", p_val->prop_value);
	//free_property_value(p_val, free);
	exit(0);

	printf("\n\n --- Getting PROPERTY_TOTALLITRESCOUNT for drinker1 with data:\n");

	p_val = ss_get_property_with_data(drinker1, PROPERTY_TOTALLITRESCOUNT->name, liters);
	if (!p_val) {
		printf("p_val empty\n");
	}
	else printf("drinker1's liters: %s\n", p_val->prop_value);
	//free_property_value(p_val, free);


	printf("\n\n --- Getting PROPERTY_TOTALLITRESCOUNT for drinker2 list of 2:\n");

	ss_set_property(drinker2, PROPERTY_TOTALLITRESCOUNT->name, liters);
	ss_set_property(drinker2, PROPERTY_TOTALLITRESCOUNT->name, liters);
	ss_set_property(drinker2, PROPERTY_TOTALLITRESCOUNT->name, liters);

	list = ss_get_properties(drinker2, PROPERTY_TOTALLITRESCOUNT->name, 2);
	if (!list || list_empty(&list->links)) {
		printf("drinker2's empty result\n");
	}
	else
	{
		list_for_each(pos, &list->links) {
			node = list_entry(pos, list_t, links);
			p_val = (prop_val_t *)node->data;
			printf("drinker2's liters: %s\n", p_val->prop_value);
		}
		list_free(list);
	}

	printf("\n\n --- Is has_property_value PROPERTY_TOTALLITRESCOUNT for drinker1:\n");
	if (ss_has_property_value(drinker1, PROPERTY_TOTALLITRESCOUNT->name, liters))
		printf("drinker1 has PROPERTY_TOTALLITRESCOUNT\n");
	else
		printf("drinker1 has NOT PROPERTY_TOTALLITRESCOUNT\n");

	free(liters);
	//free_individual(drinker1);
	//free_individual(drinker2);
}

static void check_ss_classes()
{
	int code;
	printf("\n\n --- Check ss_classes ---\n");

	printf("\n\n --- initing local structures....\n");
	individual_t *drinker1 = new_individual(CLASS_DRINKER);
	individual_t *drinker2 = new_individual(CLASS_DRINKER);

	printf("\n\n --- initing properties....\n");
	char *liters = (char *) malloc(sizeof(char) * 2);
	liters[0] = '3';
	liters[1] = '\0';
	char *name = (char *) malloc(sizeof(char) * 8);
	strncpy(name, "hisname", 7);

	printf("\n\n --- set uuids & properties....\n");
	drinker1->uuid = "uuid1";
	drinker2->uuid = "uuid2";
	code = set_property(drinker1, PROPERTY_NAME, name);
	code = set_property(drinker1, PROPERTY_TOTALLITRESCOUNT, liters);

	printf("\n\n --- Insert drinker1:\n");
	code = ss_insert_individual(drinker1);
	printf("code=%d\n", code);

	printf("\n\n --- Check ss_get_individuals_by_class ---");
	list_t *uuid_list = ss_get_individuals_by_class(CLASS_DRINKER);

	if (uuid_list == NULL) {
		printf("\n\n\tuuid_list empty\n");
	}
	else
	{
		list_head_t *pos = NULL;
		list_for_each(pos, &uuid_list->links) {
			list_t *node = list_entry(pos, list_t, links);
			individual_t *ind = (individual_t *)node->data;

			printf("\n UUID = %s\n", ind->uuid);
		}

		list_free_with_nodes(uuid_list, free);
	}
	exit(0);

	printf("\n\n -!-!- Check patterns -!-!-\n");
	drinker1 = new_individual(CLASS_DRINKER);
	drinker2 = new_individual(CLASS_DRINKER);

	code = set_property(drinker1, PROPERTY_NAME, name);
	code = set_property(drinker1, PROPERTY_TOTALLITRESCOUNT, liters);
	printf("\n\n\tpattern ready\n");

	list_t *result = ss_get_individuals_by_pattern(drinker1);

	if (uuid_list == NULL) {
		printf("\n\n\tresult empty\n");
		return;
	}
	list_head_t *pos = NULL;
	list_for_each(pos, &uuid_list->links) {
		list_t *node = list_entry(pos, list_t, links);
		prop_val_t *uuid = (prop_val_t *)node->data;

		printf("\n UUID = %s", uuid->prop_value);
	}

	free(liters);
	free(name);
}

static void check_ss_populate()
{
	int code;
	printf("\n\n --- Check ss_populate ---\n");

	printf("\n\n --- initing local structures....\n");
	individual_t *drinker1 = new_individual(CLASS_DRINKER);
	individual_t *drinker2 = new_individual(CLASS_DRINKER);
	individual_t *pattern = new_individual(CLASS_DRINKER);

	printf("\n\n --- initing properties....\n");
	char *liters = (char *) malloc(sizeof(char) * 2);
	liters[0] = '5';
	liters[1] = '\0';
	char *name = (char *) malloc(sizeof(char) * 8);
	strncpy(name, "Hisname", 7);

	printf("\n\n --- set uuids & properties....\n");
	drinker1->uuid = "uuid1";
	drinker2->uuid = "uuid1";
	code = set_property(drinker1, PROPERTY_NAME->name, name);
	code = set_property(drinker1, PROPERTY_TOTALLITRESCOUNT->name, liters);

	printf("\n\n --- Insert drinker1:\n");
	code = ss_insert_individual(drinker1);
	printf("code=%d\n", code);

	printf("\n\n --- Populate drinker 2 to drinker 1 ---\n");
	strncpy(name, "HisName", 7);
	code = set_property(drinker2, PROPERTY_NAME->name, name);
	liters[0] = '3';
	liters[1] = '\0';
	code = set_property(drinker2, PROPERTY_TOTALLITRESCOUNT->name, liters);
	list_head_t *pos = NULL;
	printf("WAS:\n");
	list_for_each(pos, &drinker2->properties->links) {
		list_t *node = list_entry(pos, list_t, links);
		prop_val_t *val = (prop_val_t *)node->data;

		printf("\t%s = %s\n", val->property->name, val->prop_value);
	}
	//code = set_property(pattern, PROPERTY_TOTALLITRESCOUNT->name, liters);
	//code = ss_populate_pattern(drinker2, pattern);
	printf("\n\n --- Populatting...\n");
	code = ss_populate(drinker2);
	printf("code=%d\n", code);
	printf("NOW:\n");
	if (!drinker2->properties || list_empty(&drinker2->properties->links)) {
		printf("no properties\n");
	}
	else
	{
		list_head_t *pos = NULL;
		list_for_each(pos, &drinker2->properties->links) {
			list_t *node = list_entry(pos, list_t, links);
			prop_val_t *val = (prop_val_t *)node->data;

			printf("\t%s = %s\n", val->property->name, val->prop_value);
		}
	}

	free(liters);
	free(name);
}

static void clean_property_ss()
{
    printf("\n\n --- Clean ---");

    ss_triple_t *triple_rqst = NULL;
    ss_triple_t *triple_res = NULL;

    ss_add_triple(&triple_rqst, SS_RDF_SIB_ANY, SS_RDF_SIB_ANY, SS_RDF_SIB_ANY, SS_RDF_TYPE_URI, SS_RDF_TYPE_URI);
    //ss_add_triple(&triple_rqst, SS_RDF_SIB_ANY, RDF_TYPE, SS_RDF_SIB_ANY, SS_RDF_TYPE_URI, SS_RDF_TYPE_URI);

    if(ss_query(get_ss_info(), triple_rqst, &triple_res) < 0) {
        ss_delete_triples(triple_rqst);
        return;
    }

    ss_delete_triples(triple_rqst);

/*
    ss_add_triple(&triple, SS_RDF_SIB_ANY, SS_RDF_SIB_ANY, SS_RDF_SIB_ANY, SS_RDF_TYPE_URI, SS_RDF_TYPE_LIT);
    ss_add_triple(&triple, SS_RDF_SIB_ANY, SS_RDF_SIB_ANY, SS_RDF_SIB_ANY, SS_RDF_TYPE_URI, SS_RDF_TYPE_BNODE);
    ss_add_triple(&triple, SS_RDF_SIB_ANY, SS_RDF_SIB_ANY, SS_RDF_SIB_ANY, SS_RDF_TYPE_URI, SS_RDF_TYPE_URI);
    ss_add_triple(&triple, SS_RDF_SIB_ANY, SS_RDF_SIB_ANY, SS_RDF_SIB_ANY, SS_RDF_TYPE_BNODE, SS_RDF_TYPE_LIT);

    ss_add_triple(&triple, SS_RDF_SIB_ANY, RDF_TYPE, SS_RDF_SIB_ANY, SS_RDF_TYPE_URI, SS_RDF_TYPE_URI);

*/

    if (triple_res != NULL) {
        printf("\nD = %s %s %s\n", triple_res->object, triple_res->predicate, triple_res->subject);
    }
    ss_remove(get_ss_info(), triple_res);
    ss_delete_triples(triple_res);

}
