#include "utils/kp_error.h"
#include "utils/list.h"
#include "structures.h"
#include "classes.h"
#include "properties.h"
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include "ss_func.h"
#include "kpi_low.h"
#include "ss_classes.h"
#include "ss_properties.h"
#include "ss_classes.h"

#include <string.h>

static void check_subclasses();
static void check_errors();
static void check_individuals_typeof();
static void check_properties();
static void check_init_ind();
static void check_ss_properties();

static void clean_property_ss();

static void check_ss_uuid();
static void init();




static void check_subscribe(ss_subs_info_t *subs_info)
{

    ss_triple_t *n_val = NULL;
    ss_triple_t *o_val = NULL;

    ss_subscribe_indication(get_ss_info(), subs_info, &n_val, &o_val, 1000);

    printf("\nNew values:\n");
    print_triples(n_val);

    printf("\nOld values:\n");
    print_triples(o_val);
    
}

static void ss_kpi_low_sbsc()
{
  init_ss();
  ss_join(get_ss_info(), "TestKP1");

  ss_triple_t * triple_rqst = NULL;
  ss_triple_t * first_triple = NULL;
  ss_triple_t * triple = NULL;
  ss_subs_info_t * subs_info = (ss_subs_info_t *) malloc(sizeof(ss_subs_info_t));
  ss_bnode_t *bnode = (ss_bnode_t *) malloc(sizeof(ss_bnode_t));

  char *subject = "testProp";
  char *predicate = "hasValue";

  ss_add_triple(&triple_rqst, subject, predicate, SS_RDF_SIB_ANY, SS_RDF_TYPE_URI, SS_RDF_TYPE_LIT);

  if (ss_subscribe(get_ss_info(), subs_info, triple_rqst, &first_triple) < 0) {
    printf("Failed to subscribe\n");
    ss_perror(get_ss_info()->ss_errno);
    ss_leave(get_ss_info());
    return;
  }

  ss_delete_triples(triple_rqst);

  ss_add_triple(&triple, subject, predicate, "1", SS_RDF_TYPE_URI, SS_RDF_TYPE_LIT);
  ss_insert(get_ss_info(), triple, bnode);
  ss_delete_triples(triple);
  triple = NULL;
  sleep(1);
  
  printf("\n--Added new triple--\n");
  check_subscribe(subs_info);

  ss_triple_t* new_triple = NULL;
  ss_add_triple(&new_triple, subject, predicate, "2", SS_RDF_TYPE_URI, SS_RDF_TYPE_LIT);
  ss_update(get_ss_info(), new_triple, triple, bnode);
  ss_delete_triples(triple);

  printf("\n--Update triple--\n");
  check_subscribe(subs_info);

  ss_remove(get_ss_info(), new_triple);

  printf("\n--Delete triple--\n");
  check_subscribe(subs_info);

  ss_delete_triples(new_triple);
  triple = NULL;
  new_triple = NULL;


  
  ss_unsubscribe(get_ss_info(), subs_info);
  clean_property_ss();
  ss_leave(get_ss_info());

}


static void list_work();


static void print_list(list_t *list)
{
    list_head_t *list_walker = NULL;
    list_for_each (list_walker, &list->links) {
        list_t *node = list_entry(list_walker, list_t, links);

        char *data = (char *)node->data;
        printf("\nData: %s", data);
    }
}


static void concat_triples_test();
static void subscribe_test();
static void check_individual_to_triples_by_properties_any();
static individual_t *create_temp_individual();
static class_t *create_temp_class(char *name);
static property_t *create_temp_prop(char *name);
static property_t *create_temp_object_prop(char *name);
static void check_global_repositories();

static void check_list_get_next_node();

int main()
{

/*
    check_subclasses();
    check_errors();
    check_individuals_typeof();
*/

    //check_init_ind();

    check_ss_properties();

/*
    init();
    check_ss_uuid();

    clean_property_ss();
*/

//    ss_kpi_low_sbsc();

//    list_work();

   // concat_triples_test();

//    init();
    clean_property_ss();
    //check_individual_to_triples_by_properties_any();

//    check_global_repositories();
//    check_list_get_next_node();

    return 0;
}


static void check_list_get_next_node()
{
    printf("\n\n --- Check_list_get_next_node  ---");
    list_t *list = list_get_new_list();

    list_add_data((void *) strdup("list-1"), list);
    list_add_data((void *) strdup("list-2"), list);
    list_add_data((void *) strdup("list-3"), list);

    char* data = NULL;

    list_t *list_walker = NULL;
    //list_get_next_node(list, NULL, (void *) &data);
    list_t *tmp = NULL;
    int i = 0;
    for (i = 0; i < 10; ++i) {
        
        if (i == 2) {
            tmp = list_walker;
        }
        list_walker = list_get_next_node(list, list_walker, (void *) &data);



        if (list_walker == NULL) {
            break;
        }
        printf("\n List data = %s", data);

        if (tmp) {
            printf("\n DEL List data = %s", tmp->data);
            list_del_and_free_node(tmp, free);
            tmp = NULL;
        }
        //list_walker = NULL;
    }

    list_free_with_nodes(list, free);

    printf("\n\n --- END Check_list_get_next_node  ---");
}



static void check_global_repositories()
{
    printf("\n\n --- check_global_repositories  ---\n");

    class_t * class1 = create_temp_class("class1");
    class_t * class2 = create_temp_class("class2");
    add_class_to_repository(class1);
    add_class_to_repository(class2);

    property_t *prop1 = create_temp_prop("prop1");
    property_t *prop2 = create_temp_prop("prop2");
    property_t *prop3 = create_temp_object_prop("prop3");
    add_property_to_repository(prop1);
    add_property_to_repository(prop2);

    individual_t *ind1 = new_individual(class1);
    individual_t *ind2 = new_individual(class1);
    individual_t *ind3 = new_individual(class2);
    ind3->uuid = "uuid1";

    prop_val_t *pval = (prop_val_t *) malloc(sizeof(prop_val_t));

    pval->property = prop3;
    pval->prop_value = ind2;

    ind1->properties = list_get_new_list_if_null(ind1->properties);
    ind3->properties = list_get_new_list_if_null(ind3->properties);

    list_add_data(pval, ind1->properties);
    list_add_data(pval, ind3->properties);
    

    printf("\nReferencess to ind2 = %i", count_references_to_individual(ind2));

    const property_t *test_prop = get_property_from_repository_by_name("prop1");
    printf("\nProp name = %s", test_prop->name);

    test_prop = get_property_from_repository_by_name("prop2");
    printf("\nProp name = %s", test_prop->name);


    const class_t *test_class = get_class_from_repository_by_classtype("class1");
    printf("\n\nClass typename = %s", test_class->classtype);

    test_class = get_class_from_repository_by_classtype("class2");
    printf("\nClass typename = %s\n", test_class->classtype);

    const list_t *ind_list = get_individuals_from_repository_by_classtype(class1->classtype);

    if (ind_list == NULL) {
        return;
    }

    list_head_t *list_walker = NULL;
    list_for_each (list_walker, &ind_list->links) {
        list_t *node = list_entry(list_walker, list_t, links);
        individual_t *ind = (individual_t *) node->data;
        printf("\nInd name = %s", ind->classtype);
    }

    individual_t *test_ind = get_individual_from_repository_by_uuid("uuid1");

    printf("\nInd name = %s", test_ind->classtype);

    printf("\n\n --- END check_global_repositories  ---\n");
}


static class_t *create_temp_class(char *name)
{
    class_t *class = (class_t *) malloc(sizeof(class_t));
    class->classtype = name;
    class->rtti = RTTI_CLASS;
    class->properties = NULL;

    return class;
}

static property_t *create_temp_prop(char *name)
{
    property_t *prop = (property_t *) malloc(sizeof(property_t));

    prop->about = "http://test.ru#testp";
    prop->domain = NULL;
    prop->name = name;
    prop->rtti = RTTI_PROPERTY;
    prop->subpropertyof = NULL;
    prop->type = DATATYPEPROPERTY;
    prop->maxcardinality = -1;
    prop->mincardinality = -1;

    return prop;
}

static property_t *create_temp_object_prop(char *name)
{
    property_t *prop = (property_t *) malloc(sizeof(property_t));

    prop->about = "http://test.ru#testobjectp";
    prop->domain = NULL;
    prop->name = name;
    prop->rtti = RTTI_PROPERTY;
    prop->subpropertyof = NULL;
    prop->type = OBJECTPROPERTY;
    prop->maxcardinality = -1;
    prop->mincardinality = -1;

    return prop;
}

static individual_t *create_temp_individual(class_t *class)
{
    individual_t *ind = (individual_t *) malloc(sizeof(individual_t));
    ind->classtype = class->classtype;
    ind->parent_class = class;
    ind->rtti = RTTI_INDIVIDUAL;
    ind->uuid = NULL;
    ind->properties = NULL;

    return ind;
}

static void check_individual_to_triples_by_properties_any()
{
    printf("\n\n --- check_individual_to_triples_by_properties_any  ---\n");
    class_t *class = create_temp_class("class1");
    property_t *prop = create_temp_prop("prop25555222");
    class->properties = list_get_new_list();
    list_add_data(prop, class->properties);

    individual_t *ind = create_temp_individual(class);

    ind->uuid = "1";
    set_property_by_name((void *) ind, prop->name, "1");


    ss_triple_t *triples = individual_to_triples_by_properties_any(ind, class->properties);

    if (triples != NULL) {
        print_triples(triples);
    }
    ss_delete_triples(triples);


    list_head_t *list_walker = NULL;
    list_for_each (list_walker, &ind->properties->links) {
        list_t *node = list_entry(list_walker, list_t, links);
        prop_val_t *val = (prop_val_t *) node->data;
        free_property_value_with_func(val, NULL);
    }
    list_free_with_nodes(ind->properties, NULL);
    list_free_with_nodes(class->properties, NULL);
    free(class);
    free(ind);


    free_property(prop);

    printf("\n\n --- END check_individual_to_triples_by_properties_any  ---\n");
}

static void subscribe_test()
{

}


static void concat_triples_test()
{
    printf("\n\n --- Concat_triples_test  ---");
    ss_triple_t *triples1 = NULL;
    ss_add_triple(&triples1, "test_s1 1", "test_p1 1", "test_o1 1", SS_RDF_TYPE_URI, SS_RDF_TYPE_LIT);
    ss_add_triple(&triples1, "test_s1 2", "test_p1 2", "test_o1 2", SS_RDF_TYPE_URI, SS_RDF_TYPE_LIT);
    ss_add_triple(&triples1, "test_s1 3", "test_p1 3", "test_o1 3", SS_RDF_TYPE_URI, SS_RDF_TYPE_LIT);

    ss_triple_t *triples2 = NULL;
    ss_add_triple(&triples2, "test_s2 1", "test_p2 1", "test_o2 1", SS_RDF_TYPE_URI, SS_RDF_TYPE_LIT);
    ss_add_triple(&triples2, "test_s2 2", "test_p2 2", "test_o2 2", SS_RDF_TYPE_URI, SS_RDF_TYPE_LIT);
    ss_add_triple(&triples2, "test_s2 3", "test_p2 3", "test_o2 3", SS_RDF_TYPE_URI, SS_RDF_TYPE_LIT);

    ss_triple_t *list_walker = concat_triplets(triples1, triples2);

    while (list_walker) {
        printf("\nTriple %s", list_walker->subject);
        list_walker = list_walker->next;
    }

    ss_delete_triples(triples1);

    printf("\n\n --- Concat_triples_test END ---");
    printf("\n ----------------------------- \n\n");
}


static void list_work()
{
    printf("\n\n --- Check list work ---");

    list_t *list1 = list_get_new_list();
    list_t *list2 = list_get_new_list();

    void *data = (void *) strdup("three");

    list_add_data(strdup("one"), list1);
    list_add_data(strdup("two"), list1);
    list_add_data(data, list1);
    list_add_data(data, list1);

    list_add_data(strdup("one - 2"), list2);
    list_add_data(strdup("two - 2"), list2);
    list_add_data(strdup("three - 2"), list2);

    printf("\n\nList 1:\n");
    print_list(list1);

    printf("\n\nList 2:\n");
    print_list(list2);

    list_add_list(list2, list1);
    list_free(list2);
    list2 = NULL;

    printf("\n\nMerged list:\n");
    print_list(list1);

    list_t *new_list = list_copy_list(list1);
    list_free_with_nodes(list1, NULL);
    printf("\n\nCoped list:\n");
    print_list(new_list);

    printf("\n\nCount nodes with data = %i", list_count_nodes_with_data(new_list, data));

    list_del_and_free_nodes_with_data(new_list, data, free);
    printf("\n\nRemoved data:\n");
    print_list(new_list);

    list_free_with_nodes(new_list, free);
    printf("\n\n --- Check list work END ---");
    printf("\n ----------------------------- \n\n");
}


static void init()
{
    init_ss();
}


static void check_ss_uuid()
{
    printf("\n\n --- Check ss uuid ---");

    //init_ss();
    class_t *class1 = (class_t *) malloc(sizeof(class_t));

    class1->classtype = "class1";

    class1->rtti = RTTI_CLASS;

    individual_t *ind1 = new_individual(class1);
    individual_t *ind2 = new_individual(class1);

    init_individual(ind1);
    init_individual(ind2);

    list_t *uuid_list = ss_get_uuids_by_class(class1);

    if (uuid_list == NULL) {
        return;
    }

    list_head_t *pos = NULL;
    list_for_each(pos, &uuid_list->links) {
         list_t *node = list_entry(pos, list_t, links);
         char *uuid = (char *) node->data;

         printf("\n UUID = %s", uuid);
    }

    list_free_with_nodes(uuid_list, free);

}


static void clean_property_ss()
{
    printf("\n\n --- Clean ---");

    ss_triple_t *triple_rqst = NULL;
    ss_triple_t *triple_res = NULL;

    ss_add_triple(&triple_rqst, SS_RDF_SIB_ANY, SS_RDF_SIB_ANY, SS_RDF_SIB_ANY, SS_RDF_TYPE_URI, SS_RDF_TYPE_LIT);
    ss_add_triple(&triple_rqst, SS_RDF_SIB_ANY, RDF_TYPE, SS_RDF_SIB_ANY, SS_RDF_TYPE_URI, SS_RDF_TYPE_URI);
    ss_remove(get_ss_info(), triple_rqst);

    if(ss_query(get_ss_info(), triple_rqst, &triple_res) < 0) {
        ss_delete_triples(triple_rqst);
        return;
    }

    ss_delete_triples(triple_rqst);

/*
    ss_add_triple(&triple, SS_RDF_SIB_ANY, SS_RDF_SIB_ANY, SS_RDF_SIB_ANY, SS_RDF_TYPE_URI, SS_RDF_TYPE_LIT);
    ss_add_triple(&triple, SS_RDF_SIB_ANY, SS_RDF_SIB_ANY, SS_RDF_SIB_ANY, SS_RDF_TYPE_URI, SS_RDF_TYPE_BNODE);
    ss_add_triple(&triple, SS_RDF_SIB_ANY, SS_RDF_SIB_ANY, SS_RDF_SIB_ANY, SS_RDF_TYPE_URI, SS_RDF_TYPE_URI);
    ss_add_triple(&triple, SS_RDF_SIB_ANY, SS_RDF_SIB_ANY, SS_RDF_SIB_ANY, SS_RDF_TYPE_BNODE, SS_RDF_TYPE_LIT);

    ss_add_triple(&triple, SS_RDF_SIB_ANY, RDF_TYPE, SS_RDF_SIB_ANY, SS_RDF_TYPE_URI, SS_RDF_TYPE_URI);

*/

    if (triple_res != NULL) {
        printf("\nD = %s %s %s\n", triple_res->object, triple_res->predicate, triple_res->subject);
    }
    ss_remove(get_ss_info(), triple_res);
    ss_delete_triples(triple_res);

}



static void check_ss_properties()
{

    printf("\n\n --- Check individuals ss properties ---");

    //init_ss_with_parameters("space", "192.168.0.39", 10010);
    init_ss();

	if (ss_join(get_ss_info(), "KP222222222") == -1) {
		printf("Can't join to SS\n");
		return 0;
	}

    printf("\n3333\n");
  fflush(stdout);

    class_t *class1 = (class_t *) malloc(sizeof(class_t));
    class_t *class2 = (class_t *) malloc(sizeof(class_t));

    class1->classtype = "class1";
    class2->classtype = "class2";
    class1->instances = NULL;
    class2->instances = NULL;

    class1->rtti = RTTI_CLASS;
    class2->rtti = RTTI_CLASS;

    property_t *prop = malloc(sizeof(property_t));
    char *prop_val = "test_val";
    char *prop_val2 = "test_val1";
    char *prop_val3 = "test_val2";
    char *prop_name = "test_prop";

    prop->about = "http://test.ru#testp";
    prop->domain = NULL;
    prop->name = prop_name;
    prop->rtti = RTTI_PROPERTY;
    prop->subpropertyof = NULL;
    prop->type = DATATYPEPROPERTY;
    prop->maxcardinality = 3;
    prop->mincardinality = 2;

    class1->properties = list_get_new_list();
    list_t * node = list_get_new_node(prop);

    list_add(&node->links, &class1->properties->links);


    individual_t *ind = new_individual(class1);

    init_individual(ind);

    printf("\nss set prop1 = %i ", ss_set_property(ind, prop_name, strdup(prop_val)));
    printf("\nddddddd");
    ss_insert_individual(ind);
    printf("\nddddddd");

    printf("\nss set prop2 = %i ", ss_set_property(ind, prop_name, strdup(prop_val2)));
    printf("\nss set prop3 = %i ", ss_set_property(ind, prop_name, strdup(prop_val3)));

    printf("\nUnset prop2 = %i ", unset_property_for_individual(ind, prop_name, prop_val3));

    list_t *prop_list = get_properties(ind, prop_name);
    prop_val_t *p_v = (prop_val_t *) get_property(ind, prop_name);



    if (prop_list == NULL) {
        printf("\nNo properties");
    } else {

        list_t *elem = list_entry(prop_list->links.prev, list_t, links);
        property_t *p = ((prop_val_t *)(elem->data))->property;
        char *v = ((prop_val_t *)(elem->data))->prop_value;
        printf("\nProperty find = %s %s; %s %s", p->name, v, p_v->property->name, (char *) p_v->prop_value);
    }

    /*
    printf("\nUpdate result = %i", update_property_with_data(ind, prop_name, prop_val, "new_value"));

    prop_list = get_properties(ind, prop_name);

    if (prop_list == NULL) {
        printf("\nNo properties");
    } else {
        list_t *elem = list_entry(prop_list->links.prev, list_t, links);
        property_t *p = ((prop_val_t *)(elem->data))->property;
        char *v = ((prop_val_t *)(elem->data))->prop_value;
        printf("\nProperty find = %s %s", p->name, v);
    }

*/
}


static void check_init_ind()
{
    printf("\n\n --- Check init individuals ---");

    class_t *class1 = (class_t *) malloc(sizeof(class_t));

    class1->classtype = "class1";

    class1->rtti = RTTI_CLASS;

    individual_t *ind = new_individual(class1);

    init_ss();
    init_individual(ind);
}


static void check_properties()
{
    printf("\n\n --- Check individuals properties ---");

    class_t *class1 = (class_t *) malloc(sizeof(class_t));
    class_t *class2 = (class_t *) malloc(sizeof(class_t));

    class1->classtype = "class1";
    class2->classtype = "class2";

    class1->rtti = RTTI_CLASS;
    class2->rtti = RTTI_CLASS;

    property_t *prop = malloc(sizeof(property_t));
    char *prop_val = "test_val";
    char *prop_name = "test_prop";

    prop->about = "http://test.ru#testp";
    prop->domain = NULL;
    prop->name = prop_name;
    prop->rtti = RTTI_PROPERTY;
    prop->subpropertyof = NULL;
    prop->type = DATATYPEPROPERTY;
    prop->maxcardinality = -1;
    prop->mincardinality = -1;

    class1->properties = list_get_new_list();
    list_t * node = list_get_new_node(prop);

    list_add(&node->links, &class1->properties->links);

    individual_t *ind = new_individual(class1);


    set_property_by_name(ind, prop_name, prop_val);


    list_t *prop_list = get_properties(ind, prop_name);
    prop_val_t *p_v = (prop_val_t *) get_property(ind, prop_name);


    if (prop_list == NULL) {
        printf("\nNo properties");
    } else {
        list_t *elem = list_entry(prop_list->links.prev, list_t, links);
        property_t *p = ((prop_val_t *)(elem->data))->property;
        printf("\nProperty find = %s %s %s", p->name, p_v->property->name, (char *)p_v->prop_value);
    }

    printf("\nUpdate result = %i", update_property_with_data(ind, prop_name, prop_val, "new_value"));

    prop_list = get_properties(ind, prop_name);

    if (prop_list == NULL) {
        printf("\nNo properties");
    } else {
        list_t *elem = list_entry(prop_list->links.prev, list_t, links);
        property_t *p = ((prop_val_t *)(elem->data))->property;
        char *v = ((prop_val_t *)(elem->data))->prop_value;
        printf("\nProperty find = %s %s", p->name, v);
    }

}



static void check_individuals_typeof()
{
    printf("\n\n --- Check individuals typeof ---");
    class_t *class1 = malloc(sizeof(class_t));
    class_t *class2 = malloc(sizeof(class_t));

    class1->classtype = "class1";
    class2->classtype = "class2";

    class1->rtti = RTTI_CLASS;
    class2->rtti = RTTI_CLASS;

    individual_t *ind = new_individual(class1);

    printf("\nInd typeof class1 = %i", is_classtype_of(ind, class1));
    printf("\nInd typeof class2 = %i", is_classtype_of(ind, class2));
}


static void check_subclasses()
{
    printf("\n\n --- Check subclasses ---");

    class_t *class1 = malloc(sizeof(class_t));
    class_t *class2 = malloc(sizeof(class_t));
    class_t *class3 = malloc(sizeof(class_t));

    class1->classtype = "class1";
    class2->classtype = "class2";
    class3->classtype = "class3";

    class1->rtti = RTTI_CLASS;
    class2->rtti = RTTI_CLASS;
    class3->rtti = RTTI_CLASS;

    class1->superclasses = (list_t *) malloc(sizeof(list_t));
    class2->superclasses = (list_t *) malloc(sizeof(list_t));
    class3->superclasses = (list_t *) malloc(sizeof(list_t));

    INIT_LIST_HEAD(&class1->superclasses->links);
    INIT_LIST_HEAD(&class2->superclasses->links);
    INIT_LIST_HEAD(&class3->superclasses->links);

    list_t *node = list_get_new_node(class2);
    list_add(&node->links, &class1->superclasses->links);

    printf("\nClass1 is subclass of class2 = %i", is_subclassof(class1, class2));
    printf("\nClass1 is subclass of class3 = %i", is_subclassof(class1, class3));
    printf("\nClass2 is subclass of class2 = %i", is_subclassof(class2, class2));
    printf("\nClass3 is subclass of class2 = %i", is_subclassof(class3, class2));

    node = list_get_new_node(class3);
    list_add(&node->links, &class1->superclasses->links);

    printf("\nClass1 is subclass of class3 = %i", is_subclassof(class1, class3));

/*
    list_free_list_with_nodes(class1->superclasses, NULL);
    list_free_list_with_nodes(class2->superclasses, NULL);
    list_free_list_with_nodes(class3->superclasses, NULL);
    list_free_list_with_nodes(class1->superclasses, NULL);
*/
}


static void check_errors()
{
    printf("\n\n --- Errors checks --- ");
    int code = get_error_code();
    const char* text = get_error_text();

    printf("\nError code = %i; text: %s", code, text);

    const char* error = get_error_text_by_code(301);
    printf("\nError code = %i; text: %s", 301, error);

    set_error(400);
    code = get_error_code();
    text = get_error_text();

    printf("\nError code = %i; text: %s", code, text);

    set_error(401);
    code = get_error_code();
    text = get_error_text();

    printf("\nError code = %i; text: %s", code, text);


    set_error(ERROR_INCORRECT_PROPERTY_TYPE);
    code = get_error_code();
    text = get_error_text();

    printf("\nError code = %i; text: %s", code, text);

    set_error(ERROR_INCORRECT_CARDINALITY);
    code = get_error_code();
    text = get_error_text();

    printf("\nError code = %i; text: %s", code, text);

    reset_error();
    code = get_error_code();
    text = get_error_text();

    printf("\nError code = %i; text: %s", code, text);
}