/*
 * ss_subscribe.h - interface for subscribe functions.
 * This file is part of PetrSU KP Library.
 *
 * Copyright (C) 2009 - Alexandr A. Lomov. All rights reserved.
 *
 * PetrSU KP Library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PetrSU KP Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PetrSU KP Library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */

#include <stdio.h>
#include "utils/list.h"
#include "utils/kp_bool.h"
#include "kpi_low.h"
#include "structures.h"
#include <pthread.h>


#ifndef _SS_SUBSCRIBE_H
#define	_SS_SUBSCRIBE_H


/******************************************************************************/
/****************************** Structures list *******************************/

/** @brief  Subscription data for subscription container @see subscription_container_s. */
typedef struct subscription_data_s {
    individual_t *ind;  /**< individual for subscribe. */
    list_t *properties; /**< individual properties for subscribe. */
} subscription_data_t;


/** @brief  Container contains data for subscribe. */
typedef struct subscription_container_s {
    int rtti;                   /**< Run-time type information. */
    list_t *sbrc_data;          /**< Subscription data list (@see subscription_data_s). */
    int subscription_id;        /**< Identifier. */
    int subscription_type;      /**< Type. */
    void (*callback)(struct subscription_container_s*, list_t*); /**< Callback function. */
    bool is_updated;            /**< Update flag. */
    ss_subs_info_t info;        /**< KPI Low information of subscription. */

} subscription_container_t;



/******************************************************************************/
/****************************** Functions list ********************************/

subscription_container_t* new_subscription_container();
subscription_data_t* new_subscription_data(individual_t *ind, list_t *properties);

void free_subscription_data(subscription_data_t *data, bool free_prop_list);
void free_subscription_container(subscription_container_t *container);

void set_subscription_container_callback(subscription_container_t *container,
        void (*func)(subscription_container_t *, list_t *));

int add_individual_to_subscription_container(subscription_container_t *container,
        individual_t *ind, list_t *properties);


int ss_subscribe_container(subscription_container_t *container, bool is_asynchronous);
int wait_subscribe(subscription_container_t *container);
int ss_unsubscribe_container(subscription_container_t *container);
void stop_all_subscriptions();


#endif	/* _SS_SUBSCRIBE_H */
