/*
 * ss_func.h - interface for functions for work with SS.
 * This file is part of PetrSU KP library.
 *
 * Copyright (C) 2009 - Alexandr A. Lomov. All rights reserved.
 *
 * PetrSU KP library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PetrSU KP library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PetrSU KP library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */


#include "utils/check_func.h"
#include "kpi_low.h"
#include <time.h>

#ifndef _SS_FUNC_H
#define	_SS_FUNC_H

/**
 * @brief rdf:type.
 */
#define RDF_TYPE "http://www.w3.org/1999/02/22-rdf-syntax-ns#type"

/**
 * @brief UUID maximum lenght.
 */
#define KPLIB_UUID_MAX_LEN 25


#ifdef	__cplusplus
extern "C" {
#endif

ss_info_t* get_ss_info();
void reset_ss_errno();

char* generate_uuid();

int init_ss();
int init_ss_with_parameters(const char *space_id, const char *ss_address, int ss_port);

#ifdef	__cplusplus
}
#endif

#endif	/* _SS_FUNC_H */

