/*
 * ss_func.c - functions for work with SS.
 * This file is part of PetrSU KP library.
 *
 * Copyright (C) 2009 - Alexandr A. Lomov. All rights reserved.
 *
 * PetrSU KP library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PetrSU KP library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PetrSU KP library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */

#include "ss_func.h"

/**
 * @brief ss_info struct for KP.
 */
static ss_info_t ss_info;

/******************************************************************************/
/**************************** External functions ******************************/
/**
 * @brief Get ss_info struct.
 *
 * ss_info used by KPI Low functions.
 *
 * @return ss_info on success or NULL otherwise.
 */
ss_info_t* get_ss_info()
{
    return &ss_info;
}


/**
 * @brief Set KPI Low ss_errno to 0.
 */
void reset_ss_errno()
{
    get_ss_info()->ss_errno = 0;
}

// TODO: Write better code, find uuid library.
/**
 * @brief Generate UUID.
 *
 * @return new UUID on success or NULL otherwise.
 */
char* generate_uuid()
{
    time_t t;
    srand((unsigned) time(&t));

    int rnd_num = rand() % 1000;

    char *uuid = (char *) malloc(sizeof(char) * 4);

    sprintf(uuid, "%i", rnd_num);

    return uuid;
}


/**
 * @brief Makes different library initialization.
 *
 * @return 0 on success or not otherwise.
 */
int init_ss()
{
    return ss_discovery(&ss_info);
    //user@192.168.0.247
    //ss_info_t ss = {{0}, SS_SPACE_ID, {SS_ADDRESS, SS_PORT}, {0}};
    //*first_ss = ss;
}


/**
 * @brief Makes different library initialization using given data.
 *
 * @param space_id Smart Space id.
 * @param ss_address Smart Space address(ip or nota).
 * @param ss_port Smart Space port.
 *
 * @return 0 on success or not otherwise.
 */
int init_ss_with_parameters(const char *space_id, const char *ss_address, int ss_port)
{
    ss_discovery(&ss_info);

    strncpy(ss_info.space_id, space_id, SS_SPACE_ID_MAX_LEN);
    strncpy(ss_info.address.ip, ss_address, MAX_IP_LEN);
    ss_info.address.port = ss_port;

    return 0;
}

