/*
 * properties.h - describe functions for work with properties.
 * This file is part of PetrSU KP library.
 *
 * Copyright (C) 2009 - Alexander A. Lomov. All rights reserved.
 *
 * PetrSU KP library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PetrSU KP library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PetrSU KP library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */

#include "structures.h"
#include "utils/list.h"
#include "utils/check_func.h"
#include "utils/kp_debug.h"

#ifndef _PROPERTIES_H
#define	_PROPERTIES_H




const property_t *get_property_type(const class_t *oclass, const char *propname);


int set_property_by_name(void *entity, char *propname, void *data);
int set_property(void *entity, property_t *property, void *value);
int set_property_with_value_struct(void *entity, const prop_val_t *prop_val);


const prop_val_t* get_property(individual_t *ind, const char *propname);
const prop_val_t* get_property_with_data(individual_t *ind, const char *propname, void *data);
list_t* get_properties(individual_t *ind, const char *propname);



int update_property(void *entity, const char *propname, void *new_data);

int update_property_with_data(void *entity, const char *propname,
        const void *old_data, void *new_data);

int update_property_value_data(prop_val_t* prop_value, void* new_data);


int unset_property_for_individual(individual_t *ind, char *propname, void *data);

bool is_prop_values_equal(prop_val_t *a, prop_val_t *b);
bool is_prop_names_equal(prop_val_t *a, prop_val_t *b);

#endif	/* _PROPERTIES_H */
