/*
 * check_func.h - describe functions for different checks.
 * This file is part of PetrSU KP library.
 *
 * Copyright (C) 2009 - Alexander A. Lomov. All rights reserved.
 *
 * PetrSU KP library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PetrSU KP library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with <program name>; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */

#ifndef _UTIL_FUNC_H_
#define _UTIL_FUNC_H_

#include <stdio.h>
#include <string.h>
#include "kp_error.h"
#include "kp_bool.h"
#include "../structures.h"
#include "../properties.h"
#include <sys/types.h>



/******************************************************************************/
/****************************** Functions list ********************************/
char* get_str_duplicate(const char *string);
bool is_in_property_list(property_t *item, list_t *property_list);
bool is_in_property_values_list(prop_val_t *item, list_t *property_list);
ss_triple_t *concat_triplets(ss_triple_t *a, ss_triple_t *b);

#endif /* _UTIL_FUNC_H_ */
