/*
 * check_func.h - describe functions for different checks.
 * This file is part of PetrSU KP Library.
 *
 * Copyright (C) 2009 - Alexander A. Lomov. All rights reserved.
 *
 * PetrSU KP Library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PetrSU KP Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PetrSU KP Library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */

#ifndef _CHECK_FUNC_H
#define _CHECK_FUNC_H

#include <stdio.h>
#include <string.h>

#include "kp_error.h"
#include "kp_bool.h"
#include "../structures.h"
#include "../ss_subscribe.h"


bool is_str_null_or_empty(const char* string);

int verify_class(const class_t *oclass);
int verify_individual(const individual_t *individual);
int verify_entity(const void *entity);
int verify_property(const property_t *prop);
int verify_individual_prop_list(const individual_t *individual, list_t *prop_list);
int verify_subscription_container(const subscription_container_t *container);


#endif /* _CHECK_FUNC_H */
