/*
 * ss_populate.h - describe functions for work with populations from SS.
 * This file is part of PetrSU KP library.
 *
 * Copyright (C) 2009 - Pavel Vanag. All rights reserved.
 *
 * PetrSU KP library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PetrSU KP library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with <program name>; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */

#ifndef _SS_POPULATE_H
#define	_SS_POPULATE_H

#include "kpi_interface.h"
#include "ss_func.h"
#include "utils/list.h"

/**
* \fn int ss_populate(individual_t* individual)
*
* \brief Populate if given individual from SS
*
* Tries to ﬁnd individual by given individual data (uuid, properties) and populate it.
* Function sets global PetrSU KP Library's errno.
*
* \param[in] individual_t * individual. Pointer to the individual struct.
* \return int. Status of the operation when completed (0 if successfull, otherwise -1).
*/
int ss_populate(individual_t* individual);

/**
* \fn int ss_populate_by_pattern(individual_t *individual, individual_t *pattern)
*
* \brief Populate if given individual from SS by pattern
*
* Tries to ﬁnd individual by given individual data (uuid, properties) by pattern and populate it.
* Function sets global PetrSU KP Library's errno.
*
* \param[in] individual_t * individual. Pointer to the individual struct.
* \return int. Status of the operation when completed (0 if successfull, otherwise -1).
*/
int ss_populate_by_pattern(individual_t *individual, individual_t *pattern);

/*int ss_populate_by_subscription(subscription_container_t *subscr_container);*/

#endif	/* _SS_POPULATE_H */
