/*
 * classes.h - describe functions for work with classes.
 * This file is part of PetrSU KP library.
 *
 * Copyright (C) 2009 - Alexander A. Lomov. All rights reserved.
 *
 * PetrSU KP library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PetrSU KP library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with <program name>; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */

#include "structures.h"
#include "utils/kp_debug.h"

#ifndef _CLASSES_H
#define	_CLASSES_H

#ifdef	__cplusplus
extern "C" {
#endif
/* Functions for work with classes and properties */
individual_t* new_individual(const class_t *classtype);
list_t* get_superclasses(const class_t *oclass);
int is_subclassof(const class_t *oclass, const class_t *super_class);
int is_classtype_of(const individual_t *individual, const class_t *prent_class);
int count_references_to_individual(individual_t *individual);
int set_uuid(individual_t *ind, const char *uuid);

/* Functions for add/remove entities to repositories */
int add_entity_to_repository(void *entity);
int add_class_to_repository(class_t *oclass);
int add_property_to_repository(property_t *property);
void remove_entity_from_repository(void *entity);
void clean_repositories();

/* Functions for get data from repositories */
const property_t* get_property_from_repository_by_name(const char *name);
const class_t* get_class_from_repository_by_classtype(const char *classtype);
const individual_t* get_individual_from_repository_by_uuid(const char *uuid);
const list_t* get_individuals_from_repository_by_classtype(const char *classtype);
#ifdef	__cplusplus
}
#endif

#endif	/* _CLASSES_H */
