#!/usr/bin/env python
# coding: utf-8
import sys
import os, datetime
from smart_m3 import Node
import _functions
import pango
import string
import threading
import time
import speakers
import Image
import urllib2
#from security import RSA
from settings import security_mode
from settings import time_wait_photo
from settings import widgets_text_gw
from settings import language_gw

if security_mode == True:
    try :
        from security import RSA
    except :
        security_mode = False
    
from firstboot import NoConnect

try:
        import pygtk
        pygtk.require('2.0')
except:
        sys.exit(1)
try:
        import gtk
        import gtk.glade
        import gobject
except:
        sys.exit(1)

from settings import begin_hour, begin_minet
from copy import deepcopy
agenda_inf, tmp, userid = {}, {}, {}
spectator_list, old_speclist, porn = {}, {}, {}
timeslot = ""
flag_begin = False
flag_reg = False
flag_end = False
flag_stop = False
treeview_lock = False
cur_user = 0
time_oper = []
image_button = []
home_path = os.environ['HOME'] + '/'
temp_folder = home_path + '.sc/'
#thread_dev_di = {}

#flag_end_TS = False
(
    COLUMN_TIME,
    COLUMN_SPEAKER,
    COLUMN_PRESENTATION,
    NEXT_ROW,
    BG_COLOR,
    COL_PIXBUF
) = range(6)

(
    COLUMN_SPECTATOR,
    COLUMN_INTERESTS
) = range(2)


#rsa = RSA(1024,4,65537)
try :
    rsa = RSA(1024,4,65537)
    rsa.load_keys_from_file()
except :
    if security_mode == True:
        rsa = RSA(1024,4,65537,False)
        NoConnect(5)
        gtk.main()
    #sys.exit(1)
#    rsa.generate () 
#    rsa.save_key_pair_into_files()


class App:

    def __init__(self):
        global   button, button5, agenda_inf, align_progress_bar #status_label, timer_label,
        from settings import widgets_text_gw
        from settings import language_gw
       
        #agenda_inf = self.get_start_info()
        # number of selected row in agenda
        self.selected_row = None
        #load interface file
        self.gladefile = "whiteboard.glade"
        # elements tree of interface
        self.widgetsTree = gtk.glade.XML(self.gladefile)
        self.alignment1 = self.widgetsTree.get_widget("alignment3")
        self.alignment2 = self.widgetsTree.get_widget("alignment4")
        align_progress_bar = self.widgetsTree.get_widget("alignment7")
        #self.status_label = self.widgetsTree.get_widget("label1")

        #status_label = self.widgetsTree.get_widget("label1")
        #timer_label = self.widgetsTree.get_widget("label3")
        button = self.widgetsTree.get_widget("button1")
        button5 = self.widgetsTree.get_widget("button5")
        self.button2 = self.widgetsTree.get_widget("button2")
        self.up_button = self.widgetsTree.get_widget("button3")
        self.down_button = self.widgetsTree.get_widget("button4")
        self.up_button.set_sensitive(0)
        self.down_button.set_sensitive(0)
        self.up_button_sensitive = 0
        self.down_button_sensitive = 0

        main_frame_label = self.widgetsTree.get_widget("label2")
        fontdesc = pango.FontDescription("sance 36")
        main_frame_label.modify_font(fontdesc)
        main_frame_label.set_text(widgets_text_gw[language_gw]['main_frame_header'])

        #self.label_button = self.widgetsTree.get_widget("label4")
        #fontdesc = pango.FontDescription("sance 12")
        #self.label_button.modify_font(fontdesc)
        #self.label_button.set_text(widgets_text_gw[language_gw]['Begin meeting'])    

        self.window = self.widgetsTree.get_widget("whiteboard_win")
        if (self.window):
            self.window.connect("destroy", self.close_app)

        # vertical scroll for spectators list
        self.spectators_list_scroll = gtk.ScrolledWindow(hadjustment=None, vadjustment=None)
        self.spectators_list_scroll.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        self.spectators_list_scroll.set_shadow_type(gtk.SHADOW_ETCHED_IN)
        self.alignment2.add(self.spectators_list_scroll)

        # create spectators list model
        self.spectators_list_model = self.create_sl_model()

        # create spectators list view
        self.spectators_listview = gtk.TreeView(self.spectators_list_model)
        self.spectators_listview.set_rules_hint(True)
        #self.spectators_listview.set_reorderable(True)
        self.spectators_listview.set_headers_visible(True)
        self.add_SLColumns(self.spectators_listview)
        
        self.spectators_list_scroll.add(self.spectators_listview)

        # vertical scroll for speakers list
        self.scrolled_window1 = gtk.ScrolledWindow(hadjustment=None, vadjustment=None)
        self.scrolled_window1.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        self.scrolled_window1.set_shadow_type(gtk.SHADOW_ETCHED_IN)
        self.alignment1.add(self.scrolled_window1)

        # create tree model
        self.model = self.__create_model()

        dic = { 
                "button1_clicked_cb": self.begin_meeting,
                "button2_clicked_cb": self.full_screen,
                "button3_clicked_cb": self.get_up_speaker,
                "button4_clicked_cb": self.get_down_speaker,
                "button5_clicked_cb": self.set_first_speaker
                }

        self.widgetsTree.signal_autoconnect(dic)


        # create tree view
        self.treeview = gtk.TreeView(self.model)
        self.treeview.set_rules_hint(True)
        #self.treeview.set_reorderable(True)
        self.treeview.set_headers_visible(True)
        self.__add_columns(self.treeview)
        selection = self.treeview.get_selection()
        selection.set_mode(gtk.SELECTION_SINGLE)
        selection.connect('changed', self.selection_changed_cb)

        self.scrolled_window1.add(self.treeview)
        self.source_flag, self.photo_flag = 0, 0
        self.t1_flag, self.t2_flag = False, False
        self.photo_stock = []
        self.source_id = gobject.idle_add(self.handle_data)
        self.phcheck_id = None
        self.window.maximize()
        #self.window.fullscreen()
        self.window.show_all()
    
    
    def handle_data(self):
        global agenda_inf, tmp, ts_c5, ts_c, \
               statusbar_text, widgets_text, \
               spectator_list, old_speclist, treeview_lock
        
        ainf = deepcopy(agenda_inf)
        if ainf != tmp:
            tmp = deepcopy(ainf)
            num, ainf = 0, sort(ainf)
            #print ainf
            # photo update
            for items in ainf:
                num = num + 1
                self.download_photo(ainf[items][4], num)
            self.photo_flag = 0
            if self.source_flag == 0:
                self.phcheck_id = gobject.idle_add(self.phcheck_handle)
            
            self.update_tree_model()

        spc_list = deepcopy(spectator_list)        
        if spc_list != old_speclist:
            self.update_tree_model()
            old_speclist = deepcopy(spc_list)
        
        lock = False
        for item in self.photo_stock:
            if temp_folder+'pics/default.jpg' in item:
                lock = True
                break
        if lock:
            treeview_lock = True
        else:
            treeview_lock = False
                
        if self.selected_row == None:
            if self.up_button_sensitive:
                self.up_button.set_sensitive(0)
                self.up_button_sensitive = 0
            elif self.down_button_sensitive:
                self.down_button.set_sensitive(0)
                self.down_button_sensitive = 0
            elif self.up_button_sensitive and self.down_button_sensitive:
                self.up_button.set_sensitive(0)
                self.up_button_sensitive = 0
                self.down_button.set_sensitive(0)
                self.down_button_sensitive = 0
        
        return 1

    def selection_changed_cb(self, selection):
        global porn, treeview_lock
        _selection = selection.get_selected()
        if not _selection:
            return

        if treeview_lock:
            self.selected_row = None
            return
        
        model, iter = _selection
        if iter:
            self.selected_row = model.get_path(iter)[0]
            if self.selected_row == 0:
                if agenda_inf[self.selected_row+1][3] or \
                    agenda_inf[self.selected_row+2][3]:
                        self.up_button.set_sensitive(0)
                        self.down_button.set_sensitive(0)
                        self.up_button_sensitive = 0
                        self.down_button_sensitive = 0
                else:
                    self.up_button.set_sensitive(0)
                    self.down_button.set_sensitive(1)
                    self.up_button_sensitive = 0
                    self.down_button_sensitive = 1
            elif self.selected_row == len(porn)-1:
                if agenda_inf[self.selected_row+1][3] or \
                    agenda_inf[self.selected_row][3]:
                        self.up_button.set_sensitive(0)
                        self.down_button.set_sensitive(0)
                        self.up_button_sensitive = 0
                        self.down_button_sensitive = 0
                else:
                    self.down_button.set_sensitive(0)
                    self.up_button.set_sensitive(1)
                    self.down_button_sensitive = 0
                    self.up_button_sensitive = 1
            else:
                if agenda_inf[self.selected_row+1][3]:
                    if self.up_button_sensitive:
                        self.up_button.set_sensitive(0)
                        self.up_button_sensitive = 0
                    if self.down_button_sensitive:
                        self.down_button.set_sensitive(0)
                        self.down_button_sensitive = 0
                elif agenda_inf[self.selected_row][3]:
                    if self.up_button_sensitive:
                        self.up_button.set_sensitive(0)
                        self.up_button_sensitive = 0
                    if not self.down_button_sensitive:
                        self.down_button.set_sensitive(1)
                        self.down_button_sensitive = 1
                elif agenda_inf[self.selected_row+2][3]:
                    if self.down_button_sensitive:
                        self.down_button.set_sensitive(0)
                        self.down_button_sensitive = 0
                    if not self.up_button_sensitive:
                        self.up_button.set_sensitive(1)
                        self.up_button_sensitive = 1
                else:                    
                    if not self.up_button_sensitive:
                        self.up_button.set_sensitive(1)
                        self.up_button_sensitive = 1
                    if not self.down_button_sensitive:
                        self.down_button.set_sensitive(1)
                        self.down_button_sensitive = 1
                
    def phcheck_handle(self):
        self.source_flag = 1
        if self.photo_flag == 0:
            self.check_wlogs()
        return 1

    def resize_image(self, url):
        from settings import presenter_photo_size
        try:
            im1 = Image.open(url)
            im2 = im1.resize((presenter_photo_size, presenter_photo_size), Image.NEAREST)
            im2.save(url)
        except IOError, err:
            return 0
        return 1
 

    def get_up_speaker(self, widget):
        global agenda_inf
        if self.selected_row == 0:
            return
        ainf = sort(agenda_inf)
        selected_user = ainf[self.selected_row+1][8]
        next_user = ainf[self.selected_row][8]
        su_time, nx_time = self.change_position_in_ss(selected_user, next_user)
        agenda_inf = sort(agenda_inf)
        agenda_inf[self.selected_row+1][0] = su_time
        agenda_inf[self.selected_row][0] = nx_time
        self.change_photo_position(self.selected_row, self.selected_row-1)
        self.selected_row = None
    
    def get_down_speaker(self, widget):
        global agenda_inf, porn
        if self.selected_row == len(porn)-1:
            return
        ainf = sort(agenda_inf)
        selected_user = ainf[self.selected_row+1][8]
        next_user = ainf[self.selected_row+2][8]
        su_time, nx_time = self.change_position_in_ss(selected_user, next_user)
        agenda_inf = sort(agenda_inf)
        agenda_inf[self.selected_row+1][0] = su_time
        agenda_inf[self.selected_row+2][0] = nx_time
        self.change_photo_position(self.selected_row, self.selected_row+1)
        self.selected_row = None
    
    def set_first_speaker(self, widget):
        global agenda_inf, cur_user, porn
        if not self.selected_row:
            return
        cancelled_speaker = self.selected_row
        TS = 'TS_'+str(cancelled_speaker+1)
        qs = node.CreateQueryTransaction(ss_handle)
        result = qs.rdf_query([((TS, "is_not_occupied_by", None), "literal")])
        node.CloseQueryTransaction(qs)
        if result:
            for item in result:
                user = item[0][2]
            old = [((TS, "is_not_occupied_by", user), "uri", "literal")]
            new = [((TS, "is_occupied_by", user), "uri", "literal")]
            update_inf_SS(new, old)
            uncancelled_speaker = cancelled_speaker + 1
            while uncancelled_speaker <= len(porn):
                uncancelled_speaker = uncancelled_speaker + 1
                TS = 'TS_'+str(uncancelled_speaker)
                qs = node.CreateQueryTransaction(ss_handle)
                result = qs.rdf_query([((TS, "is_not_occupied_by", None), "literal")])
                node.CloseQueryTransaction(qs)
                if result:
                    for item in result:
                        user = item[0][2]
                    old = [((TS, "is_not_occupied_by", user), "uri", "literal")]
                    new = [((TS, "is_occupied_by", user), "uri", "literal")]
                    update_inf_SS(new, old)
        else:
            qs = node.CreateQueryTransaction(ss_handle)
            result = qs.rdf_query([((TS, "is_occupied_by", None), "literal")])
            node.CloseQueryTransaction(qs)
            if not result:
                return
            while cancelled_speaker > 0:
                TS = 'TS_'+str(cancelled_speaker)
                qs = node.CreateQueryTransaction(ss_handle)
                result = qs.rdf_query([((TS, "is_occupied_by", None), "literal")])
                node.CloseQueryTransaction(qs)
                if result:
                    for item in result:
                        user = item[0][2]
                    old = [((TS, "is_occupied_by", user), "uri", "literal")]
                    new = [((TS, "is_not_occupied_by", user), "uri", "literal")]
                    update_inf_SS(new, old)
                cancelled_speaker = cancelled_speaker - 1
        if cur_user:
            agenda_inf[cur_user][3] = 0
        cur_user = self.selected_row + 1
        agenda_inf[cur_user][3] = 1
        self.selected_row = None

    def change_photo_position(self, selected_row, next_row):

        if self.photo_stock[selected_row][0] != 'None':
            if self.photo_stock[next_row][0] != 'None':
                os.rename(self.photo_stock[selected_row][0], temp_folder+'wlog~')
                os.rename(self.photo_stock[next_row][0], 
                          self.photo_stock[selected_row][0])
                os.rename(temp_folder+'wlog~', self.photo_stock[next_row][0])
                os.rename(self.photo_stock[selected_row][1], temp_folder+'sph~')
                os.rename(self.photo_stock[next_row][1], 
                          self.photo_stock[selected_row][1])
                os.rename(temp_folder+'sph~', self.photo_stock[next_row][1])
                su_phurl, su_logtime = self.photo_stock[selected_row][2], \
                                        self.photo_stock[selected_row][3]
                nx_phurl, nx_logtime = self.photo_stock[next_row][2], \
                                        self.photo_stock[next_row][3]
                self.photo_stock[selected_row][2] = nx_phurl
                self.photo_stock[selected_row][3] = nx_logtime
                self.photo_stock[next_row][2] = su_phurl
                self.photo_stock[next_row][3] = su_logtime
            else:
                wl_len = self.photo_stock[selected_row][0].find('wlog') + 4
                sp_len = self.photo_stock[selected_row][1].find('speakers_photo') + 14
                os.rename(self.photo_stock[selected_row][0], 
                          self.photo_stock[selected_row][0][:wl_len]+str(next_row+1))
                os.rename(self.photo_stock[selected_row][1], 
                          self.photo_stock[selected_row][1][:sp_len]+str(next_row+1)+'.jpg')
                tmp = self.photo_stock[next_row]
                self.photo_stock[next_row] = [temp_folder+'wlog'+str(next_row+1),
                                              temp_folder+'speakers_photo'+str(next_row+1)+'.jpg',
                                              self.photo_stock[selected_row][2],
                                              self.photo_stock[selected_row][3]]
                self.photo_stock[selected_row] = tmp
        else:
            if self.photo_stock[next_row][0] != 'None':
                wl_len = self.photo_stock[next_row][0].find('wlog') + 4
                sp_len = self.photo_stock[next_row][1].find('speakers_photo') + 14
                os.rename(self.photo_stock[next_row][0], 
                          self.photo_stock[next_row][0][:wl_len]+str(selected_row+1))
                os.rename(self.photo_stock[next_row][1], 
                          self.photo_stock[next_row][1][:sp_len]+str(selected_row+1)+'.jpg')
                tmp = self.photo_stock[selected_row]
                self.photo_stock[selected_row] = [temp_folder+'wlog'+str(selected_row+1),
                                                  temp_folder+'speakers_photo'+str(selected_row+1)+'.jpg',
                                                  self.photo_stock[next_row][2],
                                                  self.photo_stock[next_row][3]]
                self.photo_stock[next_row] = tmp
                
    def change_position_in_ss(self, selected_user, next_user):
        global node, ss_handle, porn
        qs = node.CreateQueryTransaction(ss_handle)
        result = qs.rdf_query([((None, "have", selected_user), "literal")])
        for item in result:
             su_TS = item[0][0]
        result = qs.rdf_query([((su_TS, "is", None), "literal")])
        for item in result:
            su_time = item[0][2]
        result = qs.rdf_query([((su_TS, "length", None), "literal")])
        for item in result:
             suTS_length = item[0][2]
        result = qs.rdf_query([((None, "is_occupied_by", selected_user), "literal")])
        su_OTS = None
        if result != []: 
            for item in result:
                 su_OTS = item[0][0]
        result = qs.rdf_query([((None, "have", next_user), "literal")])
        for item in result:
             nx_TS = item[0][0]
        result = qs.rdf_query([((nx_TS, "is", None), "literal")])
        for item in result:
            nx_time = item[0][2]
        result = qs.rdf_query([((nx_TS, "length", None), "literal")])
        for item in result:
             nxTS_length = item[0][2]
        result = qs.rdf_query([((None, "is_occupied_by", next_user), "literal")])
        nx_OTS = None
        if result != []: 
            for item in result:
                 nx_OTS = item[0][0]
        node.CloseQueryTransaction(qs)
        new, old = [], []
        if su_OTS and not nx_OTS:
            old = [((su_OTS, "is_occupied_by", selected_user), "uri", "literal")]
            new = [((nx_TS, "is_occupied_by", selected_user), "uri", "literal")]
        elif not su_OTS and nx_OTS:
            old = [((nx_OTS, "is_occupied_by", next_user), "uri", "literal")]
            new = [((su_TS, "is_occupied_by", next_user), "uri", "literal")]
        elif su_OTS and nx_OTS:
            old = [((su_OTS, "is_occupied_by", selected_user), "uri", "literal"),
                   ((nx_OTS, "is_occupied_by", next_user), "uri", "literal")]
            new = [((su_OTS, "is_occupied_by", next_user), "uri", "literal"),
                   ((nx_OTS, "is_occupied_by", selected_user), "uri", "literal")]
        
        old.append(((su_TS, "length", suTS_length), "uri", "literal"))
        old.append(((nx_TS, "length", nxTS_length), "uri", "literal"))
        old.append(((su_TS, "have", selected_user), "uri", "literal"))
        old.append(((nx_TS, "have", next_user), "uri", "literal"))
        old.append(((su_TS, "is", su_time), "uri", "literal"))
        old.append(((nx_TS, "is", nx_time), "uri", "literal"))
        new.append(((su_TS, "length", nxTS_length), "uri", "literal"))
        new.append(((nx_TS, "length", suTS_length), "uri", "literal"))
        new.append(((nx_TS, "have", selected_user), "uri", "literal"))
        new.append(((su_TS, "have", next_user), "uri", "literal"))
        su_time, nx_time = self.reverse_time(su_time, nx_time)
        new.append(((su_TS, "is", su_time), "uri", "literal"))
        new.append(((nx_TS, "is", nx_time), "uri", "literal"))
        
        upd = node.CreateUpdateTransaction(ss_handle)
        upd.update(new, "RDF-M3", old, "RDF-M3", confirm = True)
        node.CloseUpdateTransaction(upd)
        porn[selected_user] = nx_TS
        porn[next_user] = su_TS
        pro = node.CreateInsertTransaction(ss_handle)
        insert = [((selected_user, "change", "timeslot"), "uri", "literal"),
                  ((next_user, "change", "timeslot"), "uri", "literal")]
        pro.send(insert, confirm = True)
        node.CloseInsertTransaction(pro)
        return su_time, nx_time
    
    def reverse_time(self, ts1, ts2):
        tmp = None
        if datetime.timedelta(hours=int(ts1[:2]),minutes=int(ts1[3:5])) > \
            datetime.timedelta(hours=int(ts2[:2]),minutes=int(ts2[3:5])):
            tmp = ts1
            ts1 = ts2
            ts2 = tmp
        ts1_interval = datetime.timedelta(hours=int(ts1[8:10]),minutes=int(ts1[11:13])) - \
                        datetime.timedelta(hours=int(ts1[:2]),minutes=int(ts1[3:5]))
        middle_time = datetime.timedelta(hours=int(ts2[8:10]),minutes=int(ts2[11:13])) - \
                        ts1_interval
        if tmp:
            return str(middle_time)[:5]+' - '+ts2[8:13], ts1[:5]+' - '+str(middle_time)[:5]
        else:
            return ts1[:5]+' - '+str(middle_time)[:5], str(middle_time)[:5]+' - '+ts2[8:13]
    
    def update_tree_model(self):
        global agenda_inf, spectator_list
        ainf = sort(agenda_inf)
        self.model.clear()
        self.spectators_list_model.clear()
        for item in ainf.keys():
            user_photo = self.photo_stock[item-1][1]
            if not self.resize_image(user_photo):
                user_photo = temp_folder+'pics/default_avatar.jpg'
            try:
                pic = gtk.gdk.pixbuf_new_from_file(user_photo)
            except:
                pic = gtk.gdk.pixbuf_new_from_file(temp_folder+'pics/default_avatar.jpg')
            iter = self.model.append()        
            self.model.set(iter,
                COLUMN_TIME, ainf[item][COLUMN_TIME],
                COLUMN_SPEAKER, ainf[item][COLUMN_SPEAKER],
                COLUMN_PRESENTATION, ainf[item][COLUMN_PRESENTATION],
                NEXT_ROW, ainf[item][NEXT_ROW],
                BG_COLOR, '#FFF000',
                COL_PIXBUF, pic
                )

        for item in spectator_list.keys():
            iter = self.spectators_list_model.append()
            self.spectators_list_model.set(iter,
                COLUMN_SPECTATOR, spectator_list[item][COLUMN_SPECTATOR],
                COLUMN_INTERESTS, spectator_list[item][COLUMN_INTERESTS],
            ) 

        self.treeview = gtk.TreeView(self.model)
        self.treeview.set_rules_hint(True)
        #self.treeview.set_reorderable(True)
        self.__add_columns(self.treeview)
        #selection = self.treeview.get_selection()
        #selection.set_mode(gtk.SELECTION_SINGLE)
        #selection.connect('changed', self.selection_changed_cb)

        self.spectators_listview = gtk.TreeView(self.spectators_list_model)
        self.spectators_listview.set_rules_hint(True)
        #self.spectators_listview.set_reorderable(True)
        self.add_SLColumns(self.spectators_listview)
        self.selected_row = None

    def __create_model(self):
        global agenda_inf
        lstore = gtk.ListStore(
            gobject.TYPE_STRING,
            gobject.TYPE_STRING,
            gobject.TYPE_STRING,
            gobject.TYPE_BOOLEAN,
            gobject.TYPE_STRING,
            gtk.gdk.Pixbuf)

        for item in agenda_inf.keys():
            iter = lstore.append()
            lstore.set(iter,
                COLUMN_TIME, agenda_inf[item][COLUMN_TIME],
                COLUMN_SPEAKER, agenda_inf[item][COLUMN_SPEAKER],
                COLUMN_PRESENTATION, agenda_inf[item][COLUMN_PRESENTATION],
                NEXT_ROW, agenda_inf[item][NEXT_ROW],
                BG_COLOR, '#FFF000',
                COL_PIXBUF, gtk.gdk.pixbuf_new_from_file(temp_folder+'pics/default.jpg')
                )
        return lstore

    def create_sl_model(self):
        global agenda_inf, spectator_list
        lstore = gtk.ListStore(
            gobject.TYPE_STRING,
            gobject.TYPE_STRING)

        for item in spectator_list.keys():
            iter = lstore.append()
            lstore.set(iter,
                COLUMN_SPECTATOR, spectator_list[item][COLUMN_SPECTATOR],
                COLUMN_INTERESTS, spectator_list[item][COLUMN_INTERESTS],
            )
        return lstore  

    def __add_columns(self, treeview):
        #global widgets_text
        from settings import widgets_text_gw, presenter_photo_size
        from settings import language_gw
        
        # column for speakers photo
        cell = gtk.CellRendererPixbuf()
        cell.set_fixed_size(presenter_photo_size, presenter_photo_size)
        column = gtk.TreeViewColumn( None, cell, pixbuf=COL_PIXBUF )
        label = gtk.Label(widgets_text_gw[language_gw]['table_headers_4'])
        fontdesc = pango.FontDescription("sance italic 16")
        label.modify_font(fontdesc)
        label.show()        
        column.set_widget(label)
        treeview.append_column(column)

        # columns for time in agenda
        cell = gtk.CellRendererText()
        cell.set_property('font-desc', pango.FontDescription('sance 20'))
        label = gtk.Label(widgets_text_gw[language_gw]['table_headers_1'])
        fontdesc = pango.FontDescription("sance italic 16")
        label.modify_font(fontdesc)
        label.show()
        column = gtk.TreeViewColumn( None, cell,
                                    text=COLUMN_TIME, background=BG_COLOR, background_set=NEXT_ROW)
        column.set_sort_column_id(COLUMN_TIME)
        column.set_widget(label)
        treeview.append_column(column)

        # columns for speakers in agenda
        column = gtk.TreeViewColumn( None, cell,
                                    text=COLUMN_SPEAKER, background=BG_COLOR, background_set=NEXT_ROW)
        #column.set_fixed_width()''
        #column.set_fixed_width(1100)
        column.set_sort_column_id(COLUMN_SPEAKER)
        label = gtk.Label(widgets_text_gw[language_gw]['table_headers_2'])
        fontdesc = pango.FontDescription("sance italic 16")
        label.modify_font(fontdesc)
        label.show()        
        column.set_widget(label)
        treeview.append_column(column)

        # column for presentations in agenda
        column = gtk.TreeViewColumn( None, cell,
                                     text=COLUMN_PRESENTATION, background=BG_COLOR, background_set=NEXT_ROW)
        column.set_sort_column_id(COLUMN_PRESENTATION)
        label = gtk.Label(widgets_text_gw[language_gw]['table_headers_3'])
        fontdesc = pango.FontDescription("sance italic 16")
        label.modify_font(fontdesc)
        label.show()        
        column.set_widget(label)
        treeview.append_column(column)

    def add_SLColumns(self, treeview):
        #global widgets_text
        from settings import widgets_text_gw
        from settings import language_gw
        # columns for time in agenda
        cell = gtk.CellRendererText()
        cell.set_property('font-desc', pango.FontDescription('sance 20'))
        label = gtk.Label(widgets_text_gw[language_gw]['table_headers_5'])
        fontdesc = pango.FontDescription("sance italic 16")
        label.modify_font(fontdesc)
        label.show()
        column = gtk.TreeViewColumn(None, cell, text=COLUMN_SPECTATOR)
        column.set_sort_column_id(COLUMN_SPECTATOR)
        column.set_widget(label)
        treeview.append_column(column)

        # columns for speakers in agenda
        column = gtk.TreeViewColumn(None, cell, text=COLUMN_INTERESTS)
        column.set_sort_column_id(COLUMN_INTERESTS)
        label = gtk.Label(widgets_text_gw[language_gw]['table_headers_6'])
        fontdesc = pango.FontDescription("sance italic 16")
        label.modify_font(fontdesc)
        label.show()        
        column.set_widget(label)
        treeview.append_column(column)        

    def download_photo(self, photoURI, photo_num):
        global treeview_lock
        self.photo_flag = 1
        speakers_photo = temp_folder + 'speakers_photo' + str(photo_num) + ".jpg"
        wlog = temp_folder + 'wlog' + str(photo_num)
        if (self.photo_stock != []) and (photo_num <= len(self.photo_stock)):
            if (photoURI != self.photo_stock[photo_num-1][2]):
                if photoURI != 'None':
                    if photoURI == temp_folder + 'pics/cancelled.jpg':
                        self.photo_stock[photo_num-1][2] = "None"
                        self.photo_stock[photo_num-1][1] = temp_folder+'pics/cancelled.jpg'
                        self.photo_stock[photo_num-1][0] = "None"
                    elif photoURI == temp_folder + 'pics/nospeaker.jpg':
                        self.photo_stock[photo_num-1][2] = "None"
                        self.photo_stock[photo_num-1][1] = temp_folder+'pics/nospeaker.jpg'
                        self.photo_stock[photo_num-1][0] = "None"
                    else:
                        try:
                            urllib2.urlopen(photoURI)
                        except:
                            self.photo_stock[photo_num-1][2] = photoURI
                            self.photo_stock[photo_num-1][1] = temp_folder+'pics/default_avatar.jpg'
                            self.photo_stock[photo_num-1][0] = "None"
                            return
                        self.photo_stock[photo_num-1][2] = photoURI
                        self.photo_stock[photo_num-1][1] = temp_folder+'pics/default.jpg'
                        self.photo_stock[photo_num-1][0] = wlog
                        os.system(
                        "wget -t 1 -o "+wlog+" "+photoURI+" -O "+speakers_photo+" &")
                elif photoURI == 'None':
                    self.photo_stock[photo_num-1][2] = photoURI
                    self.photo_stock[photo_num-1][1] = temp_folder+'pics/nospeaker.jpg'
                    self.photo_stock[photo_num-1][0] = "None"
        else:
            if photoURI == "None":
                self.photo_stock.append(["None",temp_folder+'pics/nospeaker.jpg',photoURI])
            else:
                os.system(
                "wget -t 1 -o "+wlog+" "+photoURI+" -O "+speakers_photo+" &")
                self.photo_stock.append([wlog,temp_folder+'pics/default.jpg',photoURI])

    def check_wlogs(self):
        for item in self.photo_stock:
            if os.access(item[0], os.R_OK):
                f = open(item[0],"rb")
                fs = f.read()
                log_time = open(item[0],"rb").read(21)
                if fs.find("0K") != -1:
                    num = item[0].find('wlog') + 4
                    if (len(item) < 4):
                        item[1] = temp_folder+"speakers_photo"+item[0][num:]+'.jpg'
                        item.append(log_time[2:])
                        self.t1 = threading.Timer(time_wait_photo, self.update_tree_model)
                        self.t1.start()
                        self.t1_flag = True
                    else:
                        if item[3] < log_time[2:]:
                            item[1] = temp_folder+"speakers_photo"+item[0][num:]+'.jpg'
                            item[3] = log_time[2:]
                            self.t2 = threading.Timer(time_wait_photo, self.update_tree_model)
                            self.t2.start()
                            self.t2_flag = True
                f.close()

    def begin_meeting(self, widget):
        global node, ss_handle, t, i, flag_begin, button, button5, flag_stop, image_button, cur_user

        #button.hide()
        #ffflag = True
        flag_stop = False
        fs_img = self.widgetsTree.get_widget("image1")
        image_button.append(fs_img)
        image_button.append(self.widgetsTree.get_widget("button5"))
        #if ffflag == True :
        #    print "PLAY"
        if fs_img.get_stock()[0] == 'gtk-media-play':
            button.set_sensitive(0)
            button5.set_sensitive(0)
            ffflag = False
            fs_img.set_from_stock('gtk-media-stop',gtk.ICON_SIZE_DIALOG)
            tooltips = gtk.tooltips_data_get(widget)[0]
            tooltips.set_tip(widget, 'Stop')
            
            flag_begin = True
            
            if not cur_user:
                all_timeslots = time_oper.all_timeslots
                time_oper.recalculate_user_was_set_first("TS_1")
#                all_timeslots = time_oper.all_timeslots
#                print 'removing ts from ss', time.localtime()[5]
#                for ts in all_timeslots:
#                    insert = [((ts, "is", None), "uri", "literal")]
#                    remove_from_SS(insert)
#                    print 'time_slot_rereg(): begin', time.localtime()[5]
#                    time_oper.time_slot_rereg()
#                    print 'time_slot_rereg(): end', time.localtime()[5]
            else:
                time_oper.recalculate_user_was_set_first_after_end("TS_"+str(cur_user))
            t= Timer(1)
            t.start()
        else :
            button.set_sensitive(0)
            qs = node.CreateQueryTransaction(ss_handle)
            result = qs.rdf_query([((None, "is_not_occupied_by", None), "literal")])
            node.CloseQueryTransaction(qs)
            if result:
                for item in result:
                    old = [((item[0][0], "is_not_occupied_by", item[0][2]), "uri", "literal")]
                    new = [((item[0][0], "is_occupied_by", item[0][2]), "uri", "literal")]
                    update_inf_SS(new, old)
            
            fs_img.set_from_stock('gtk-media-play',gtk.ICON_SIZE_DIALOG)
            tooltips = gtk.tooltips_data_get(widget)[0]
            tooltips.set_tip(widget, 'Play')
            flag_stop = True
            cur_user = 0
            insert = [(("None", "change", "stop" ), "uri", "literal")]
            insert_in_SS(insert)
            tt = Delete_Change(insert)
            tt.start()
            t.realese()
            time_oper.flag_cancelled = False
        


    def full_screen(self, widget):
        fs_img = self.widgetsTree.get_widget("image2")
        if fs_img.get_stock()[0] == 'gtk-fullscreen':
            self.window.fullscreen()
            fs_img.set_from_stock('gtk-leave-fullscreen',gtk.ICON_SIZE_DIALOG)
            tooltips = gtk.tooltips_data_get(widget)[0]
            tooltips.set_tip(widget, 'Leave Fullscreen')
        else :
            self.window.unfullscreen()
            fs_img.set_from_stock('gtk-fullscreen',gtk.ICON_SIZE_DIALOG)
            tooltips = gtk.tooltips_data_get(widget)[0]
            tooltips.set_tip(widget, 'Fullscreen')
        return


    def get_start_info(self):
        import speakers
        sp = speakers.Speakers()
        count, _return = 0, {}
        for item in sp.name:
            count = count + 1
            _return[count] = [sp.starting_time[item] + "-" + \
                              sp.finishing_time[item], \
                              sp.name[item], \
                              sp.presentation_title[item], \
                              0, "None", "None", "None", "None",\
                              item, sp.presentation_id[item]]
        return _return

    def close_app(self, widget):
        global node, ss_handle, rs1, rs2, rs5, rs3, rs4, rs6,rs7, flag_end
        #print "node: ",node, "\nss_handle: ",ss_handle
        #print "Close Subscribe Transactions:\n", \
        #      rs1,"\n",rs2,"\n",rs5,"\n",rs3,"\n",rs4,"\n",rs6,"\n"
        gobject.source_remove(self.source_id)
        if self.phcheck_id != None:
            gobject.source_remove(self.phcheck_id)
        if self.t1_flag: self.t1.cancel()
        if self.t2_flag: self.t2.cancel()
        clear_smart_space(node, ss_handle)
        node.CloseSubscribeTransaction(rs1)
        node.CloseSubscribeTransaction(rs2)
        node.CloseSubscribeTransaction(rs3)
        node.CloseSubscribeTransaction(rs4)
        node.CloseSubscribeTransaction(rs5)
        node.CloseSubscribeTransaction(rs6)
        #node.CloseSubscribeTransaction(rs7)
        node.CloseSubscribeTransaction(rs8)
        node.leave(ss_handle)
        flag_end = True
        if (self.photo_stock != []):
            for item in self.photo_stock:
                if (item[2] != "None"):
                    os.system("rm "+temp_folder+"speakers_photo* "+temp_folder+"wlog*")
                    #print "Cache is cleared."
                    break
        #os.system("rm -r *.pyo")
        gtk.main_quit()
        #sys.exit()
        
        
def clear_smart_space(node, ss_handle):
    global porn
    import speakers
    from settings import greeting
    insert = [(('PresentationURI', 'is', greeting), "uri", "literal")]
    remove_from_SS(insert)
    i = 0
    sp = speakers.Speakers()
    st, su = [], []
    for item in sp.starting_time:
        st.append(sp.starting_time[item])
    st.sort()
    for item in st:
        for item2 in sp.starting_time:
            if sp.starting_time[item2] == item:
                su.append(item2)
    for item in su:
        i = i + 1
        TS = "TS_"+str(i)#item[1])
        init_triples = [((item, "is", sp.name[item]), "uri", "literal"),
                        ((item, "photoURI", "None"), "uri", "literal"),
                        ((item, "interests", "None"), "uri", "literal"),
                        ((item, "email", "None"), "uri", "literal"),
                        ((item, "phone", "None"), "uri", "literal"),
                        ((item, "language", "None"), "uri", "literal"),
                        ((item, "presents", sp.presentation_id[item]), "uri", "literal"),
                        ((sp.presentation_id[item], "Title", sp.presentation_title[item]), "uri", "literal"),
                        ((sp.presentation_id[item], "Keywords", "None"), "uri", "literal"),
                        ((sp.presentation_id[item], "duration", time_oper.get_TS_length(TS)), "uri", "literal")]
        
        insert = [((TS, "have", item), "uri", "literal")]
        porn[item] = TS
        pro = node.CreateRemoveTransaction(ss_handle)
        pro.remove(insert, confirm = True)
        pro.remove(init_triples, confirm = True)
        node.CloseRemoveTransaction(pro)
    qs = node.CreateQueryTransaction(ss_handle)
    result1 = qs.rdf_query([((None, "length", None), 'literal')])
    for item in result1:
        remove = [((item[0][0], item[0][1], item[0][2]), "uri", "literal")]
        remove_from_SS(remove)
    result1 = qs.rdf_query([((None, "duration", None), 'literal')])
    for item in result1:
        remove = [((item[0][0], item[0][1], item[0][2]), "uri", "literal")]
        remove_from_SS(remove)
    result1 = qs.rdf_query([((None, "is", None), 'literal')])
    for item in result1:
        ts=item[0][0]
        if (ts[0] == "T" and ts[1] == "S") or (ts[0] == "u") :
            remove = [((item[0][0], item[0][1], item[0][2]), "uri", "literal")]
            remove_from_SS(remove)
            
    result1 = qs.rdf_query([((None, "Title", None), 'literal')])
    for item in result1:
        pid = item[0][0]
        if pid[0] == "p" :
            remove = [((item[0][0], item[0][1], item[0][2]), "uri", "literal")]
            remove_from_SS(remove)
        
    node.CloseQueryTransaction(qs)
    return

# get a copy of dictionary
def get_dict_copy(fromd):
    tod={}
    for k in fromd.keys():
        try: tod[k]=fromd[k]
        except: pass
    return tod

# sort agenda_inf dictionary
def sort(dic):
    global porn
    d2 = {}
    for xyi in dic:
        d2[int(porn[dic[xyi][8]][3])] = dic[xyi]
    return d2

# return agenda information to global dictionary <agenda_inf>
def scheduling():
    global agenda_inf, node, ss_handle, timeslot, userid, porn
    qs = node.CreateQueryTransaction(ss_handle)
    #print 'qs in scheduling: ', qs
    result = qs.rdf_query([((None, "have", None), "literal")])
    schedule, j, new_agenda = [], 0, {}
    for item in result:
        result1 = qs.rdf_query([((item[0][2], "is", None), "literal")])
        for item1 in result1:
            if security_mode == True:
                UserName = rsa.decrypt(item1[0][2])
            else :
                UserName = item1[0][2]

        result1 = qs.rdf_query([((item[0][2], "presents", None), "literal")])
        for item1 in result1:
            PresentationID = item1[0][2]

        result1 = qs.rdf_query([((PresentationID, "Title", None), "literal")])
        for item1 in result1:
            if security_mode == True:
                PresentationTitle = rsa.decrypt(item1[0][2])
            else :
                PresentationTitle = item1[0][2]

        result1 = qs.rdf_query([((item[0][2], "photoURI", None), "literal")])
        for item1 in result1:
            if security_mode == True:
                photo = rsa.decrypt(item1[0][2])
            else:
                photo = item1[0][2]

        result1 = qs.rdf_query([((item[0][2], "interests", None), "literal")])
        for item1 in result1:
            if security_mode == True:
                interest = rsa.decrypt(item1[0][2])
            else:
                interest = item1[0][2]

        result1 = qs.rdf_query([((item[0][2], "phone", None), "literal")])
        for item1 in result1:
            if security_mode == True:
                phone = rsa.decrypt(item1[0][2])
            else:
                phone = item1[0][2]
                    
        result1 = qs.rdf_query([((item[0][2], "email", None), "literal")])
        for item1 in result1:
            if security_mode == True:
                email = rsa.decrypt(item1[0][2])
            else:
                email = item1[0][2]

        if item[0][0] == timeslot:
            schedule.append(_functions.timeslot2time(item[0][0], node, ss_handle))
            schedule.append(UserName)
            schedule.append(PresentationTitle)
            schedule.append(1)
            schedule.append(photo)
            schedule.append(interest)
            schedule.append(phone)
            schedule.append(email)
            schedule.append(item[0][2])
            schedule.append(PresentationID)
        else:
            schedule.append(_functions.timeslot2time(item[0][0], node, ss_handle))
            schedule.append(UserName)
            schedule.append(PresentationTitle)
            schedule.append(0)
            schedule.append(photo)
            schedule.append(interest)
            schedule.append(phone)
            schedule.append(email)
            schedule.append(item[0][2])
            schedule.append(PresentationID)
        porn[item[0][2]] = item[0][0]

    # get data from SS to agenda_inf
    for item in range(1, len(schedule)+1):
        if item%10 == 0:
            agenda_inf[item/10] = schedule[j:item]
#            userid[schedule[item-2]] = item/10, agenda_inf
#            userid[schedule[item-1]] = item/10, agenda_inf
            j=item

    agenda_inf = sort(agenda_inf)
                    
    PresentationID = ""
    schedule, j = [], 0
    result = qs.rdf_query([((None, "presents", None), "literal")])
    for item in result:
        PresentationID = item[0][2]
        if PresentationID == "None":
            result1 = qs.rdf_query([((item[0][0], "is", None), "literal")])
            for item1 in result1:
                UserName = item1[0][2]
            result1 = qs.rdf_query([((item[0][0], "interests", None), "literal")])
            for item1 in result1:
                interest = item1[0][2]
            schedule.append(UserName)
            schedule.append(interest)
            schedule.append(item[0][0])
    
    for item in range(1, len(schedule)+1):
        if item%3 == 0:
            spectator_list[item/3] = schedule[j:item]
            userid[schedule[item-1]] = item/3, spectator_list 
            j = item
    # close
    node.CloseQueryTransaction(qs)
    return

class timing_opereation:
        flag_cancelled = False
        timeslots_inf = {}
        all_timeslots = []
        def __init__(self):
                self.speakers = speakers.Speakers()
                self.start_time = self.speakers.starting_time
                self.end_time = self.speakers.finishing_time
                self.t_b_e = []
                i = 0
                st, su = [], []
                for item in self.start_time:
                    st.append(self.start_time[item])
                st.sort()
                for item in st:
                    for item2 in self.start_time:
                        if self.start_time[item2] == item:
                            su.append(item2)
                
                for item in su:#self.start_time :
                        i = i + 1
                        TS = "TS_" + str(i)#tem[1])
                        self.all_timeslots.append(TS)
                        TS_b = self.start_time[item]
                        TS_b = self.hour_min(TS_b)
                        TS_e = self.end_time[item]
                        TS_e = self.hour_min(TS_e)
                        self.t_b_e.append(TS_b[0])
                        self.t_b_e.append(TS_b[1])
                        self.t_b_e.append(TS_e[0])
                        self.t_b_e.append(TS_e[1])
                        self.timeslots_inf[TS]=self.t_b_e
                        self.t_b_e = []
                self.all_timeslots.sort()     
        
        def time_slot_reg(self):
                global flag_reg
                for TS in self.all_timeslots :
                        TS_begin,TS_end =[None,None],[None,None]
                        TS_begin[0] = self.timeslots_inf[TS][0]
                        TS_begin[1] = self.timeslots_inf[TS][1]
                        TS_end[0] = self.timeslots_inf[TS][2]
                        TS_end[1] = self.timeslots_inf[TS][3]
                        qs = node.CreateQueryTransaction(ss_handle)
                        result = qs.rdf_query([((TS, "have", None), "literal")])
                        for item in result :
                               result1 = qs.rdf_query([((item[0][2], "presents", None), "literal")])
                               for item1 in result1:
                                   result2 = qs.rdf_query([((item1[0][2], "duration", None), "literal")])
                                   for item2 in result2:
                                       duration = item2[0][2]
                        TS_Time = self.add_zero(TS, TS_begin, TS_end)
                        insert_in_SS(TS_Time)
                        self.change_timeslot(TS)
                        TS_duration = [((TS, "length", duration ), "uri", "literal")]
                        insert_in_SS(TS_duration)
                        # close
                        node.CloseQueryTransaction(qs)
                flag_reg = True
                return
        
        def time_slot_rereg(self):
                TS_begin,TS_end,i =[None,None],[None,None],0
                TS_begin[0] = time.localtime()[3]
                TS_begin[1] = time.localtime()[4]
                for TS in self.all_timeslots :
                    qs = node.CreateQueryTransaction(ss_handle)
                    result2 = qs.rdf_query([((TS, "have", None), "literal")])
                    for item in result2 :
                        #if item[0][2] == "u" :
                        p_id = "p" + item[0][2][1:len(item[0][2])]#"p"+item[0][2][:1len(item[0][2][1:])]
                    
                    
                    i = i + 1
                    #p_id = "p"+str(TS[3])
                    #print TS
                    #print p_id
                    if i > 1 :
                        self.timeslots_inf[TS][0] = TS_end[0]
                        self.timeslots_inf[TS][1] = TS_end[1]
                        TS_begin[0] = TS_end[0]
                        TS_begin[1] = TS_end[1]
                    qs = node.CreateQueryTransaction(ss_handle)
                    #print p_id
                    result2 = qs.rdf_query([((p_id, "duration", None), "literal")])
                    #print result2
                    for item2 in result2:
                        duration = item2[0][2]
                    TS_end = self.calculate_time(TS_begin, TS_end, duration)
                    TS_Time = self.add_zero(TS, TS_begin, TS_end)
                    insert_in_SS(TS_Time)
                    self.timeslots_inf[TS][0] = TS_begin[0]
                    self.timeslots_inf[TS][1] = TS_begin[1]
                    self.timeslots_inf[TS][2] = TS_end[0]
                    self.timeslots_inf[TS][3] = TS_end[1]
                    # close
                    node.CloseQueryTransaction(qs)
                    self.change_timeslot(TS)
                flag_reg = True
                return
        
        def recalculation_time_reg(self, current_ts):
                TS_begin,TS_end,flag_update, TS_e =[None,None],[None,None],False,[None,None]
                for TS in self.all_timeslots :
                        if flag_update == True :
                                qs = node.CreateQueryTransaction(ss_handle)
                                result = qs.rdf_query([((TS, "is", None), "literal")])
                                for item in result:
                                    remove = [((item[0][0], item[0][1], item[0][2]), "uri", "literal")]
                                    remove_from_SS(remove)
                                self.timeslots_inf[TS][0] = TS_end[0]
                                self.timeslots_inf[TS][1] = TS_end[1]
                                TS_begin[0] = self.timeslots_inf[TS][0]
                                TS_begin[1] = self.timeslots_inf[TS][1]
                                TS_end[0] = self.timeslots_inf[TS][2]
                                TS_end[1] = self.timeslots_inf[TS][3]
                                TS_Time_new = self.add_zero(TS, TS_begin, TS_end)
                                insert_in_SS(TS_Time_new)
                                node.CloseQueryTransaction(qs)
                                #self.change_timeslot(TS)
                                
                        TS_begin[0] = self.timeslots_inf[TS][0]
                        TS_begin[1] = self.timeslots_inf[TS][1]
                        TS_end[0] = self.timeslots_inf[TS][2]
                        TS_end[1] = self.timeslots_inf[TS][3]  
                        #print "b",self.timeslots_inf[TS]
                        if flag_update == True :
                                self.timeslots_inf[TS][2] = time.localtime()[3]
                                self.timeslots_inf[TS][3] = time.localtime()[4]
                                TS_end[0] = self.timeslots_inf[TS][2]
                                TS_end[1] = self.timeslots_inf[TS][3]
                                #TS_Time = self.add_zero(TS, TS_begin, TS_end)
                                qs = node.CreateQueryTransaction(ss_handle)
                                result = qs.rdf_query([((TS, "is", None), "literal")])
                                for item in result:
                                    TS_Time = [((item[0][0], item[0][1], item[0][2]), "uri", "literal")]
                                node.CloseQueryTransaction(qs)
                                self.update_time_reg(TS, TS_begin, TS_end,0,TS_Time)
                                self.change_timeslot(TS)
                        if current_ts == TS:
                                qs = node.CreateQueryTransaction(ss_handle)
                                result = qs.rdf_query([((TS, "is", None), "literal")])
                                TS_Time = ''
                                for item in result:
                                    TS_Time = [((item[0][0], item[0][1], item[0][2]), "uri", "literal")]
                                    #remove_from_SS(remove)
                                    #TS_Time = self.add_zero(TS, TS_begin, TS_end)
                                #print TS_Time
                                node.CloseQueryTransaction(qs)
                                TS_end[0] = time.localtime()[3]
                                TS_end[1] = time.localtime()[4]
                                self.update_time_reg(TS, TS_begin, TS_end,1,TS_Time)
                                flag_update = True
                                self.change_timeslot(TS)
                        #print "e",self.timeslots_inf[TS]       
                flag_update = False
                return
        
        def recalculation_time_user_close(self, timeslot):
            TS_b,TS_e,flag_update =[None,None],[None,None],False
            for TS in self.all_timeslots :
                if flag_update == True :
                    self.timeslots_inf[TS][0] = TS_e[0]
                    self.timeslots_inf[TS][1] = TS_e[1]
                    TS_b[0] = self.timeslots_inf[TS][0]
                    TS_b[1] = self.timeslots_inf[TS][1]
                    
                    duration = self.calc_TS_length(TS)
                    TS_e = self.calculate_time(TS_b, TS_e, duration)
                    self.update_time_inf_ss(TS, TS_b, TS_e)
                    
                    self.timeslots_inf[TS][2] = TS_e[0]
                    self.timeslots_inf[TS][3] = TS_e[1]
                    self.change_timeslot(TS)
                    
                
                if TS == timeslot :
                    TS_e[0] = time.localtime()[3]
                    TS_e[1] = time.localtime()[4]
                    TS_b[0] = self.timeslots_inf[TS][0]
                    TS_b[1] = self.timeslots_inf[TS][1]
                    self.timeslots_inf[TS][2] = TS_e[0]
                    self.timeslots_inf[TS][3] = TS_e[1]
                    self.update_time_inf_ss(TS, TS_b, TS_e)
                    flag_update = True
                    self.change_timeslot(TS)
                    
            flag_update = False                 
            return
        
        def recalculate_user_was_set_first(self, setting_TS):
            TS_b,TS_e,flag_update, TS_end =[None,None],[None,None],False ,[None,None]
            #time.sleep(1)
            for TS in self.all_timeslots :
                if flag_update == True :
                    self.timeslots_inf[TS][0] = TS_e[0]
                    self.timeslots_inf[TS][1] = TS_e[1]
                    TS_b[0] = self.timeslots_inf[TS][0]
                    TS_b[1] = self.timeslots_inf[TS][1]
                    
                    duration = self.calc_TS_length(TS)
                    TS_e = self.calculate_time(TS_b, TS_e, duration)
                    self.update_time_inf_ss(TS, TS_b, TS_e)
                    
                    self.timeslots_inf[TS][2] = TS_e[0]
                    self.timeslots_inf[TS][3] = TS_e[1]
                    self.change_timeslot(TS)
                    #print self.timeslots_inf[TS]
                    
                    
                    
                if setting_TS == TS:
                    TS_b[0] = time.localtime()[3]
                    TS_b[1] = time.localtime()[4]
                    self.timeslots_inf[TS][0] = TS_b[0]
                    self.timeslots_inf[TS][1] = TS_b[1]
                    #qs = node.CreateQueryTransaction(ss_handle)
                    #result2 = qs.rdf_query([((item1[0][2], "length", None), "literal")])
                    duration = self.calc_TS_length(TS)
                    TS_e = self.calculate_time(TS_b, TS_e, duration)
                    self.timeslots_inf[TS][2] = TS_e[0]
                    self.timeslots_inf[TS][3] = TS_e[1]
                    self.update_time_inf_ss(TS, TS_b, TS_e)
                    self.change_timeslot(TS)
                    flag_update = True
                    TS_e[0] = self.timeslots_inf[TS][2]
                    TS_e[1] = self.timeslots_inf[TS][3]
                    #print self.timeslots_inf[TS]
            return
        
        def calc_current_ts_after_stop(self, TS):
            TS_b,TS_e =[None,None],[None,None]
            #===================================================================
            # qs = node.CreateQueryTransaction(ss_handle)
            # result = qs.rdf_query([(("TS", "is", None), "literal")])
            # for item in result:
            #    if (item[0][2] != "over") or (item[0][2] != 'None'):
            #        TS = item[0][2]
            #===================================================================
            #print TS
            TS_b[0] = self.timeslots_inf[TS][0]
            TS_b[1] = self.timeslots_inf[TS][1]
            TS_e[0] = time.localtime()[3]
            TS_e[1] = time.localtime()[4]

            self.timeslots_inf[TS][2] = TS_e[0]
            self.timeslots_inf[TS][3] = TS_e[1]
            self.update_time_inf_ss(TS, TS_b, TS_e)
            self.change_timeslot(TS)
            
        
        def recalculate_user_was_set_first_after_end(self, setting_TS):
            TS_b,TS_e,flag_update, TS_end =[None,None],[None,None],False ,[None,None]
            time.sleep(1)
            for TS in self.all_timeslots :
                if flag_update == True :
                    self.timeslots_inf[TS][0] = TS_e[0]
                    self.timeslots_inf[TS][1] = TS_e[1]
                    TS_b[0] = self.timeslots_inf[TS][0]
                    TS_b[1] = self.timeslots_inf[TS][1]
                    duration = self.calc_TS_length(TS)
                    TS_e = self.calculate_time(TS_b, TS_e, duration)
                    self.update_time_inf_ss(TS, TS_b, TS_e)
                    self.timeslots_inf[TS][2] = TS_e[0]
                    self.timeslots_inf[TS][3] = TS_e[1]
                    self.change_timeslot(TS)
                if setting_TS == TS:
                    TS_b[0] = time.localtime()[3]
                    TS_b[1] = time.localtime()[4]
                    self.timeslots_inf[TS][0] = TS_b[0]
                    self.timeslots_inf[TS][1] = TS_b[1]
                    duration = self.calc_TS_length(TS)
                    TS_e = self.calculate_time(TS_b, TS_e, duration)
                    self.timeslots_inf[TS][2] = TS_e[0]
                    self.timeslots_inf[TS][3] = TS_e[1]
                    self.update_time_inf_ss(TS, TS_b, TS_e)             
                    self.change_timeslot(TS)
                    flag_update = True
                    self.flag_cancelled = True
            flag_update = False
            return
        
        def user_cancelled(self, timeslot):
            TS_b,TS_e,flag_update, TS_end =[None,None],[None,None],False ,[None,None]
            time.sleep(1)
            for TS in self.all_timeslots :
                
                if flag_update == True :
                    
                    self.timeslots_inf[TS][0] = TS_e[0]
                    self.timeslots_inf[TS][1] = TS_e[1]
                    TS_b[0] = self.timeslots_inf[TS][0]
                    TS_b[1] = self.timeslots_inf[TS][1]
                    
                    duration = self.calc_TS_length(TS)
                    TS_e = self.calculate_time(TS_b, TS_e, duration)
                    self.timeslots_inf[TS][2] = TS_e[0]
                    self.timeslots_inf[TS][3] = TS_e[1]
                    
                    self.update_time_inf_ss(TS, TS_b, TS_e)
                    self.change_timeslot(TS)
                
                if TS == timeslot :
                    TS_b[0] = self.timeslots_inf[TS][0]
                    TS_b[1] = self.timeslots_inf[TS][1]
                    self.timeslots_inf[TS][2] = TS_b[0]
                    self.timeslots_inf[TS][3] = TS_b[1]
                    TS_e[0] = self.timeslots_inf[TS][2]
                    TS_e[1] = self.timeslots_inf[TS][3]
                    #print self.timeslots_inf[TS]
                    self.update_time_inf_ss(TS, TS_b, TS_e)
                    flag_update = True
                    self.change_timeslot(TS)
                    
            flag_update = False
            return
        
        def add_zero(self, TS, TS_b, TS_e):
                if (TS_b[1] < 10) and (TS_e[1] >= 10) :
                        TS_Time = [((TS, "is", str(TS_b[0]) + ":" + "0"+str(TS_b[1]) + " - " + str(TS_e[0]) + ":" + str(TS_e[1]) ), "uri", "literal")]
                elif (TS_b[1] >= 10) and (TS_e[1] < 10) :
                        TS_Time = [((TS, "is", str(TS_b[0]) + ":" + str(TS_b[1]) + " - " + str(TS_e[0]) + ":" + "0" + str(TS_e[1]) ), "uri", "literal")]
                elif (TS_b[1] < 10) and (TS_e[1] < 10) :
                        TS_Time = [((TS, "is", str(TS_b[0]) + ":" + "0" + str(TS_b[1]) + " - " + str(TS_e[0]) + ":" + "0" + str(TS_e[1]) ), "uri", "literal")]
                elif (TS_b[1] >= 10) and (TS_e[1] >= 10) :
                        TS_Time = [((TS, "is", str(TS_b[0]) + ":" + str(TS_b[1]) + " - " + str(TS_e[0]) + ":" + str(TS_e[1]) ), "uri", "literal")]
                        
                return TS_Time
        
        def calculate_time(self, TS_b, TS_e, dura=0):
                if int(dura) + int(TS_b[1]) < 60 :
                                TS_e[0] = int(TS_b[0])
                                TS_e[1] = (int(dura) + int(TS_b[1]))
                if (int(dura) + int(TS_b[1])) >= 60 :
                                TS_e[0] = (int(TS_b[0]) + 1)
                                TS_e[1] = (int(dura) + int(TS_b[1]) - 60)
                return TS_e
        
        def update_time_reg(self, current_ts, TS_0, TS_1,increment,TS_Time_old):
                global node, ss_handle
                qs = node.CreateQueryTransaction(ss_handle)
                result = qs.rdf_query([((current_ts, "length", None), "literal")])
                for item in result:
                        duration = int(item[0][2]) + increment
                if increment != 0 :
                        #duration = duration + (int(time.localtime()[3] - int(TS_1[1])) + int (time.localtime()[4])
                        #TS_e = [None,None]
                        #TS_e[0] = time.localtime()[3]
                        #TS_e[1] = time.localtime()[4]
                        #print duration
                        duration = 1 + (int(TS_1[0]) - int(TS_0[0]))*60 + (int(TS_1[1])-int(TS_0[1]))
                        #TS_e 
                        #print duration
                        #TS_1 = TS_e
                        new = [((current_ts, "length", duration ), "uri", "literal")]
                        old = [((current_ts, "length", item[0][2] ), "uri", "literal")]
                        update_inf_SS(new,old)
                TS_1 = self.calculate_time(TS_0, TS_1, duration)
                new = self.add_zero(current_ts, TS_0, TS_1)
                update_inf_SS(new,TS_Time_old)
                # close
                duration = None      
                node.CloseQueryTransaction(qs)
                self.change_timeslot(current_ts)
                return
        
        def calc_time_befor_begin(self):
                Hour = time.localtime()[3]
                Minet = time.localtime()[4]
                Second = time.localtime()[5]
                difference_hour = self.timeslots_inf["TS_1"][0] - Hour
                difference_minet = self.timeslots_inf["TS_1"][1] - Minet
                second_befor_begin = difference_hour*60*60 + difference_minet*60 - Second
                        
                return  second_befor_begin
      
        
        def calc_TS_length(self, TS):
            length = None
            qs = node.CreateQueryTransaction(ss_handle)
            result = qs.rdf_query([((TS, "length", None), "literal")])
            for item in result:
                    length = item[0][2]
            if length != None:
                return length
            # close
            node.CloseQueryTransaction(qs)

        def get_TS_length(self, TS):
            hour = int(self.timeslots_inf[TS][2]) - int(self.timeslots_inf[TS][0])
            min = self.timeslots_inf[TS][3] - self.timeslots_inf[TS][1]
            leng = (hour * 60) + min
            return leng      
                
        def update_time_inf_ss(self, TS, TS_b, TS_e):
            qs = node.CreateQueryTransaction(ss_handle)
            result = qs.rdf_query([((TS, "is", None), "literal")])
            for item in result:
                time_int = item[0][2]
                #TS_Time = [((TS, "is", time_int), "uri", "literal")]
                TS_Time = [((item[0][0], item[0][1], item[0][2]), "uri", "literal")]
                remove_from_SS(TS_Time)
                TS_Time = self.add_zero(TS, TS_b, TS_e)
                insert_in_SS(TS_Time)
            # close
            node.CloseQueryTransaction(qs)
            self.change_timeslot(TS)
            return
        
        def hour_min(self, string):
            el = []
            el.append(int(string[0] + string[1]))
            el.append(int(string[3]+string[4]))
            return el 
        
        def change_timeslot(self, TS):
            global node, ss_handle
            pro = node.CreateInsertTransaction(ss_handle)
            insert = [((TS, "change", "timeslots"), "uri", "literal")]
            pro.send(insert, confirm = True)
            node.CloseInsertTransaction(pro)
            tt = Delete_Change(insert)
            tt.start()

class Delete_Change(threading.Thread):
     def __init__(self, insert):
         self.insert = insert
         threading.Thread.__init__(self)
         self.condition = threading.Condition()
     def run(self):
         time.sleep(1)
         cng = node.CreateRemoveTransaction(ss_handle)
         cng.remove(self.insert, confirm = True)
         node.CloseRemoveTransaction(cng)

class ProgressBar():
    def __init__(self, duration):
        self.pbar = gtk.ProgressBar()
        self.step = 1.0 / (duration/60)
        self.pbar.set_fraction(0.0)

    def increase_pr_bar(self):
        new_val = self.pbar.get_fraction() + self.step
        if new_val > 1.0:
            new_val = 1.0
        self.pbar.set_fraction(new_val)
        self.pbar.show()
    
    def set_text(self, text):
        self.pbar.set_text(text)

    def stop(self):
        self.pbar.hide()
        
    def go(self):
        self.pbar.show()
    
    def get_widget(self):
        return self.pbar         


def insert_in_SS(TS_Time):
    pro = node.CreateInsertTransaction(ss_handle)
    pro.send(TS_Time, confirm = True)
    node.CloseInsertTransaction(pro)


def insert_TS_in_SS(TS):
    pro = node.CreateInsertTransaction(ss_handle)
    insert = [(("TS", "is", TS), "uri", "literal")]
    pro.send(insert, confirm = True)
    node.CloseInsertTransaction(pro)


def remove_from_SS(insert):
    cng = node.CreateRemoveTransaction(ss_handle)
    cng.remove(insert, confirm = True)
    node.CloseRemoveTransaction(cng)


def notify_user(TS):
    TS_over = [((TS, "over", "question"), "uri", "literal")]
    insert_in_SS(TS_over)
    

def update_inf_SS(new, old):
    global node, ss_handle
    upd = node.CreateUpdateTransaction(ss_handle)
    upd.update(new, "RDF-M3", old, "RDF-M3", confirm = True)
    node.CloseUpdateTransaction(upd)


def show_timer_label(counter, pb):
    #global timer_label
    text = ""
    if counter > 300 :
        text =     str(counter/60)+"min"
    if counter < 300 :
        if counter%60 < 10 :
                text =     str(counter/60)+" : "+ "0" + str(counter%60) + "   "
        else :
                text =     str(counter/60)+" : "+  str(counter%60) + "   "
        #text =     str(counter/60)+" : "  + str(counter%60) + "   "
    fontdesc = pango.FontDescription("sance italic 14")
    pb.get_widget().modify_font(fontdesc)
    #timer_label.set_text(text)
    #timer_label.show()
    pb.set_text(text)
    pb.go()
    

#===============================================================================
# def show_statusbar(flag):
# 
#    global status_label
#    if (flag == 0):
#            status_label.set_text(widgets_text_gw[language_gw]['statusbar_1'])
#            fontdesc = pango.FontDescription("sance italic 35")
#            status_label.modify_font(fontdesc)
#            status_label.modify_fg(gtk.STATE_NORMAL, gtk.gdk.color_parse("red"))
#            status_label.show()
#    if (flag == 1):
#            status_label.set_text(widgets_text_gw[language_gw]['statusbar_2'])
#            fontdesc = pango.FontDescription("sance italic 35")
#            status_label.modify_font(fontdesc)
#            status_label.modify_fg(gtk.STATE_NORMAL, gtk.gdk.color_parse("red"))
#            status_label.show()
#    if (flag == 2) :
#        status_label.hide()
#===============================================================================


class Timer(threading.Thread):
     def __init__(self, seconds):
         self.runTime = seconds
         threading.Thread.__init__(self)
         self.condition = threading.Condition()
     def run(self):
        global button, button5, time_oper, agenda_inf, flag_stop, image_button, \
                cur_user#,thread_dev_di timer_label,
        time.sleep(self.runTime)
        all_timeslots = time_oper.all_timeslots
        cuke = ""
        for ts in all_timeslots :
            #print ts
            tm = None
            if flag_stop == True :
                remove = [(("TS", "is", ts), "uri", "literal")]
                remove_from_SS(remove)
                #print "2222"
                break
            #insert_TS_in_SS(ts)     
            qs = node.CreateQueryTransaction(ss_handle)
            result1 = qs.rdf_query([((ts, "is_occupied_by", None), "literal")])
            for item1 in result1 :
                cuke = item1[0][2]
            if cuke != "" :
                #thread_dev_di[ts] = Device_Die()
                insert_TS_in_SS(ts)
                l = time_oper.calc_TS_length(ts)
                k = int(l)*60
                button.set_sensitive(1)
                self.condition.acquire()    
                c = CountDownTimer(k,ts)
                c.start()
                #thread_dev_di[ts].start()
                self.condition.wait()
                self.condition.release()
                #thread_dev_di[ts].end()
                remove = [(("TS", "is", ts), "uri", "literal")]
                remove_from_SS(remove)
                #show_statusbar(2)
                cuke = ""
                c.execute_stop()
                del c
            else:
                if not cur_user:
                    agenda_inf = sort(agenda_inf)
                    agenda_inf[int(ts[3])][4] = temp_folder+'pics/cancelled.jpg'
                    time_oper.user_cancelled(ts)
                    agenda_inf[int(ts[3])][0] = ''
                else :
                    if (time_oper.flag_cancelled == True) and (int(ts[3:]) > int(cur_user)) :
                        agenda_inf = sort(agenda_inf)
                        agenda_inf[int(ts[3])][4] = temp_folder+'pics/cancelled.jpg'
                        time_oper.user_cancelled(ts)
                        agenda_inf[int(ts[3])][0] = ''
                #    time_oper.recalculate_user_was_set_first('TS_'+str(cur_user))
                remove = [(("TS", "is", ts), "uri", "literal")]
                remove_from_SS(remove)
                cuke = ""
            # close
            node.CloseQueryTransaction(qs)
        
        image_button[0].set_from_stock('gtk-media-play',gtk.ICON_SIZE_DIALOG)
        insert_TS_in_SS("None")
        button.set_sensitive(1)
        button5.set_sensitive(1)
        remove = [(("TS", "is", "None"), "uri", "literal")]
        remove_from_SS(remove)
        #timer_label.hide()
        #button.show()
        #image_button = self.widgetsTree.get_widget("image1")
        #image_button[1].set_sensitive(1)
        #tooltips = gtk.tooltips_data_get(widget)[0]
        #tooltips.set_tip(widget, 'Play')
        #time.sleep(1)
        #flag_stop = False
            
     def realese(self):
        self.condition.acquire() # synchronize
        self.condition.notifyAll() # escape processeses
        self.condition.release() # end s.


class CountDownTimer(threading.Thread):
    def __init__(self, seconds, TS):
        self.TS = TS
        self.runTime = seconds
        threading.Thread.__init__(self)
        self.condition = threading.Condition()
        from settings import time_show_statusbar
        self.time_show_statusbar = time_show_statusbar
        self.prog_bar = ProgressBar(seconds)
        align_progress_bar.add(self.prog_bar.get_widget())
        self.ex_stop_flag = False
        
    def __del__(self):
        self.runTime = 1
        #print "del c"
    
    def execute_stop(self):
        self.ex_stop_flag = True
        

    def run(self):
        global flag_end,  t, flag_stop, align_progress_bar #timer_label,
        flag = 0
        counter = self.runTime
        
        self.prog_bar.go()
        
        if (counter%60 == 0) or ((counter < 60) and (counter%10 == 0)) :
                  insert = [(("whiteboard", "timer", counter), "uri", "literal")]
                  insert_in_SS(insert)
                  tt = Delete_Change(insert)
                  tt.start()
        #show_timer_label(counter, self.prog_bar)
        for sec in range(self.runTime):
             if self.ex_stop_flag == True :
                 break
             time.sleep(1.0)
             counter -= 1
             if (flag_end == True) or (flag_stop == True) :
                time_oper.calc_current_ts_after_stop(self.TS)
                #show_statusbar(2)
                
        
                self.prog_bar.stop()
                align_progress_bar.remove(self.prog_bar.get_widget())
                del self.prog_bar
                #timer_label.hide()
                flag_end = False
                t.realese()
                break
             show_timer_label(counter, self.prog_bar)
             if (counter%60 == 0) or ((counter < 60) and (counter%10 == 0)) :
                  insert = [(("whiteboard", "timer", counter), "uri", "literal")]
                  insert_in_SS(insert)
                  tt = Delete_Change(insert)
                  tt.start()
                  #show_timer_label(counter, self.prog_bar)
                  self.prog_bar.increase_pr_bar()
             if (counter <= self.time_show_statusbar) and (flag == 0) : 
                #show_statusbar(0)
                #show_timer_label(counter, self.prog_bar)
                flag = 1
             if counter == 0 :
                #show_statusbar(1)
                self.prog_bar.stop()
                align_progress_bar.remove(self.prog_bar.get_widget())
                del self.prog_bar
                notify_user(self.TS)
                break
                
                

class main_timer(threading.Thread):
    def __init__(self):
        global time_oper
        threading.Thread.__init__(self)
        self.condition = threading.Condition()
        time_oper = timing_opereation()
    def run(self):
        global flag_begin,t,button, TS_0, flag_end, time_oper
        while (flag_begin == False) and (flag_end == False):
            m = time_oper.calc_time_befor_begin()
            time.sleep(1)
            if (m == 1) and (flag_reg == True):
                if button == "" :
                    button.hide()
                flag_begin = True
                t= Timer(1)
                t.start()

            elif (m < 1) and (flag_reg == True):
                if button == "" :
                    button.hide()
                flag_begin = True
                from settings import delay_begin_after_reg
                t= Timer(delay_begin_after_reg)
                t.start()



class RdfMsgHandlerOverTS:
    def handle(self, added, removed):
        global flag_end, time_oper#, Dev_Di
        for item in added :
            insert = [((item[0][0], item[0][1], item[0][2]), "uri", "literal")]
            remove_from_SS(insert)
            flag_end = True
            qs = node.CreateQueryTransaction(ss_handle)
            result = qs.rdf_query([(("TS", "is", None), "literal")])
            for item in result : 
                time_oper.recalculation_time_user_close(item[0][2])
            # close
            node.CloseQueryTransaction(qs)
            scheduling()

            
class RdfMsgHandlerAnswerYes:
    global node, ss_handele, t, time_oper
    def handle(self, added, removed):
        for item in added :
            insert = [((item[0][0], item[0][1], item[0][2]), "uri", "literal")]
            remove_from_SS(insert)
            qs = node.CreateQueryTransaction(ss_handle)
            result = qs.rdf_query([(("TS", "is", None), "literal")])
            for item in result :
                ts_yes = item[0][2]
                #print ts_yes
                if (ts_yes[0] == "T") and (ts_yes[1] == "S"): #and (ts_yes[2] == "_"):
                    time_oper.recalculation_time_user_close(item[0][2])
            #t.realese()

class RdfMsgHandlerAnswerNo:
    global node, ss_handele, c, time_oper
    def handle(self, added, removed):
        for item in added :
            insert = [((item[0][0], item[0][1], item[0][2]), "uri", "literal")]
            remove_from_SS(insert)    
            time_oper.recalculation_time_reg(item[0][0])
            from settings import time_second_question
            c = CountDownTimer(time_second_question,item[0][0])
            c.start()

# Crazy RDF Handlers
#===============================================================================
# class RdfMsgHandler:
#    def handle(self, added, removed):
#            global insert, node, ss_handle,i, time_oper
#            TS_0 = [0,0]
#            if (time_oper.calc_time_befor_begin() < 0 ) :
#                Hour = time.localtime()[3]
#                Minet = time.localtime()[4]
#                for item in added :
#                    if item[0][0] != None :
#                        time_oper.timeslots_inf[item[0][0]][0] = Hour
#                        time_oper.timeslots_inf[item[0][0]][1] = Minet
#                        time_oper.time_slot_reg()
#                        #print "1"
#            #for item in removed :
#                #if item[0][0] == "TS_1" :
#                    #i = 0
#                    #from settings import begin_hour, begin_minet
#                    #TS_0,TS_1,TS_2,TS_3,TS_4 = [begin_hour,begin_minet],[0,0],[0,0],[0,0],[0,0]
#            scheduling()
#===============================================================================
#===============================================================================
# class Device_Die(threading.Thread):
#     def __init__(self):
#         self.time = 20
#         self.flag = False
#         threading.Thread.__init__(self)
#         self.condition = threading.Condition()
#     def run(self):
#         global time_oper
#         #while self.flag != True :#or self.time != 1:
#         while self.flag == False:
#             time.sleep(1)
#             self.time-=1
#             if self.flag == False and self.time < 2 :   
#                     insert = [(("TS", "is", "over"), "uri", "literal")]
#                     insert_in_SS(insert)
#         self.flag = False
#         self.time = 20
#         
#     def incriment_timer(self):
#         self.time = self.time + 10
#     
#     def end(self):
#        self.flag = True
#        self.time = 1
#===============================================================================

#===============================================================================
# class RdfMsgHandlerDeviceALife:
#    def handle(self, added, removed):
#        global timeslot, node, ss_handle, thread_dev_di
#        for item in added:
#            qs = node.CreateQueryTransaction(ss_handle)
#            result = qs.rdf_query([((None, "have", item[0][0]), "literal")])
#            for item1 in result:              
#                try :
#                    thread_dev_di[item1[0][0]].incriment_timer()
#                except :
#                    pass
#            insert = [((item[0][0], item[0][1], item[0][2] ), "uri", "literal")]
#            tt = Delete_Change(insert)
#            tt.start()
#===============================================================================
            
        
class RdfMsgHandlerTS:
    def handle(self, added, removed):
        global timeslot, agenda_inf, node, ss_handle, \
                treeview_lock
        for item in added:
            if item[0][0] == "TS":
                if item[0][1] == "is":
                    timeslot = item[0][2]

        treeview_lock = True
        qs = node.CreateQueryTransaction(ss_handle)
        result = qs.rdf_query([((None, "have", None), "literal")])
        for item in result:
            ts = item[0][0]
            if item[0][0] == timeslot:
                agenda_inf[int(ts[3])][3] = 1
            else:
                agenda_inf[int(ts[3])][3] = 0
        node.CloseQueryTransaction(qs)
        treeview_lock = False
        
#        print 'before scheduling', time.localtime()[5]
#        scheduling()
#        print 'after scheduling', time.localtime()[5]

class RdfMsgHandlerChange:
    def handle(self, added, removed):
        global agenda_inf, spectator_list, node, ss_handle, porn, flag_stop, security_mode
        qs = node.CreateQueryTransaction(ss_handle)
        
        for item in added :
            if item[0][2] == "is_occupied_by" :
                ts = item[0][0]
                agenda_inf = sort(agenda_inf)
                agenda_inf[int(ts[3])][4] = temp_folder+'pics/nospeaker.jpg'
                
                insert = [((item[0][0], item[0][1], item[0][2]), "uri", "literal")]
                tt = Delete_Change(insert)
                tt.start()
                
            if item[0][2] == "stop" :
                flag_stop = True
                #t.realese()
        
        for item in added :
            #TS  = item[0][0]
            #field = item[0][2]
            if item[0][2] == "timeslots" :
                result = qs.rdf_query([((item[0][0], "is", None), "literal")])
                for item in result :
                    result2 = qs.rdf_query([((item[0][0], "is_occupied_by", None), "literal")])
                    for item2 in result2:
                        if item2[0][2] != None :
                            agenda_inf[int(item[0][0][3])][0] = item[0][2]
                        else :
                            agenda_inf[int(item[0][0][3])][0] = ''

        
        for item in added :
            user_id = item[0][0]
            field = item[0][2]
            
            if user_id[0] == 'u':
                if field == "name" :
                    result = qs.rdf_query([((user_id, "is", None), "literal")])
                    for item in result:
                        for item2 in agenda_inf :
                            if agenda_inf[item2][8] == user_id :
                                if security_mode:
                                    agenda_inf[item2][1] = rsa.decrypt(item[0][2])
                                else:
                                    agenda_inf[item2][1] = item[0][2]
                if field == "photoURI" :
                    result = qs.rdf_query([((user_id, "photoURI", None), "literal")])
                    for item in result:
                        for item2 in agenda_inf :
                            if agenda_inf[item2][8] == user_id :
                                if security_mode:
                                    agenda_inf[item2][4] = rsa.decrypt(item[0][2])
                                else:
                                    agenda_inf[item2][4] = item[0][2]
                if field == "title" :
                    result = qs.rdf_query([((user_id, "presents", None), "literal")])
                    for item in result:
                        PresentationID = item[0][2]
                    result1 = qs.rdf_query([((PresentationID, "Title", None), "literal")])
                    for item in result1:
                        for item2 in agenda_inf :
                            if agenda_inf[item2][8] == user_id :
                                if security_mode:
                                    agenda_inf[item2][2] = rsa.decrypt(item[0][2])
                                else:
                                    agenda_inf[item2][2] = item[0][2]
            elif user_id[0] == 's':
                if field == "name" :
                    result = qs.rdf_query([((user_id, "is", None), "literal")])
                    for item in result:
                        for item2 in spectator_list :
                            try:
                                if spectator_list[item2][4] == user_id :
                                    if security_mode:
                                        spectator_list[item2][0] = rsa.decrypt(item[0][2])
                                    else:
                                        spectator_list[item2][0] = item[0][2]
                            except IndexError, err:
                                pass
                if field == "domain_of_interests" :
                    result = qs.rdf_query([((user_id, "interests", None), "literal")])
                    for item in result:
                        for item2 in spectator_list :
                            try:
                                if spectator_list[item2][4] == user_id :
                                    if security_mode:
                                        spectator_list[item2][1] = rsa.decrypt(item[0][2])
                                    else:
                                        spectator_list[item2][1] = item[0][2]
                            except IndexError, err:
                                pass

        result1 = qs.rdf_query([(("rs", "is_occupied_by", None), "literal")])
        node.CloseQueryTransaction(qs)
        t = threading.Timer(3, rm_change, [added, node, ss_handle])
        t.start()

def rm_change(added, node, ss_handle):
    for item in added:
        insert = [((item[0][0], "change", item[0][2] ), "uri", "literal")]
        cng = node.CreateRemoveTransaction(ss_handle)
        cng.remove(insert, confirm = True)
        node.CloseRemoveTransaction(cng)

class MeetingTimeHandler:
    def handle(self, added, removed):
        global node, ss_handle
        for item in added:
            old_mtime = item[0][2]

        now_time = datetime.datetime.now() #+ datetime.timedelta(hours=1)
        now_time = now_time.strftime("%Y-%m-%d %H:%M:%S")

        old = [(("MeetingTime", "isNow", old_mtime), "uri", "literal")]
        new = [(("MeetingTime", "isNow", now_time), "uri", "literal")]        
        upd = node.CreateUpdateTransaction(ss_handle)
        upd.update(new, "RDF-M3", old, "RDF-M3", confirm = True)
        node.CloseUpdateTransaction(upd)
    
class CheckVisitor:
    def handle(self, added, removed):
        global porn, agenda_inf, node, ss_handle, spectator_list, userid
        agenda_inf = sort(agenda_inf)
        for item in added:
            if item[0][2][0] == 'u':
                if security_mode == True:
                    qs = node.CreateQueryTransaction(ss_handle)
                    result = qs.rdf_query([((item[0][2], "is", None), "literal")])
                    for item1 in result:
                        agenda_inf[int(porn[item[0][2]][3])][1] = rsa.decrypt(item1[0][2])
                    result = qs.rdf_query([((item[0][2], "photoURI", None), "literal")])
                    for item1 in result:
                        agenda_inf[int(porn[item[0][2]][3])][4] = rsa.decrypt(item1[0][2])
                    result = qs.rdf_query([((item[0][2], "phone", None), "literal")])
                    for item1 in result:
                        agenda_inf[int(porn[item[0][2]][3])][6] = rsa.decrypt(item1[0][2])
                    result = qs.rdf_query([((item[0][2], "email", None), "literal")])
                    for item1 in result:
                        agenda_inf[int(porn[item[0][2]][3])][7] = rsa.decrypt(item1[0][2])
                    result = qs.rdf_query([((item[0][2], "presents", None), "literal")])
                    for item1 in result:
                        agenda_inf[int(porn[item[0][2]][3])][9] = item1[0][2]
                        result1 = qs.rdf_query([((item1[0][2], "Keywords", None), "literal")])
                        for item2 in result1:
                            agenda_inf[int(porn[item[0][2]][3])][5] = rsa.decrypt(item2[0][2]) 
                        result1 = qs.rdf_query([((item1[0][2], "Title", None), "literal")])
                        for item2 in result1:
                            agenda_inf[int(porn[item[0][2]][3])][2] = rsa.decrypt(item2[0][2])
                    node.CloseQueryTransaction(qs)
                else:
                    qs = node.CreateQueryTransaction(ss_handle)
                    result = qs.rdf_query([((item[0][2], "is", None), "literal")])
                    for item1 in result:
                        agenda_inf[int(porn[item[0][2]][3])][1] = item1[0][2]
                    result = qs.rdf_query([((item[0][2], "photoURI", None), "literal")])
                    for item1 in result:
                        agenda_inf[int(porn[item[0][2]][3])][4] = item1[0][2]
                    result = qs.rdf_query([((item[0][2], "phone", None), "literal")])
                    for item1 in result:
                        agenda_inf[int(porn[item[0][2]][3])][6] = item1[0][2]
                    result = qs.rdf_query([((item[0][2], "email", None), "literal")])
                    for item1 in result:
                        agenda_inf[int(porn[item[0][2]][3])][7] = item1[0][2]
                    result = qs.rdf_query([((item[0][2], "presents", None), "literal")])
                    for item1 in result:
                        agenda_inf[int(porn[item[0][2]][3])][9] = item1[0][2]
                        result1 = qs.rdf_query([((item1[0][2], "Keywords", None), "literal")])
                        for item2 in result1:
                            agenda_inf[int(porn[item[0][2]][3])][5] = item2[0][2] 
                        result1 = qs.rdf_query([((item1[0][2], "Title", None), "literal")])
                        for item2 in result1:
                            agenda_inf[int(porn[item[0][2]][3])][2] = item2[0][2]
                    node.CloseQueryTransaction(qs)
            elif item[0][2][0] == 's':
                if not (item[0][2] in userid):
                    spectator, UserName, interest, phone, email = [],'','','',''
                    qs = node.CreateQueryTransaction(ss_handle)
                    result = qs.rdf_query([((item[0][2], "is", None), "literal")])
                    if security_mode == True:
                        for item1 in result:
                            UserName = rsa.decrypt(item1[0][2])
                        spectator.append(UserName)
                        result = qs.rdf_query([((item[0][2], "interests", None), "literal")])
                        for item1 in result:
                            interest = rsa.decrypt(item1[0][2])
                        spectator.append(interest)
                        result = qs.rdf_query([((item[0][2], "phone", None), "literal")])
                        for item1 in result:
                            phone = rsa.decrypt(item1[0][2])
                        spectator.append(phone)
                    else :
                        for item1 in result:
                            UserName = item1[0][2]
                        spectator.append(UserName)
                        result = qs.rdf_query([((item[0][2], "interests", None), "literal")])
                        for item1 in result:
                            interest = item1[0][2]
                        spectator.append(interest)
                        result = qs.rdf_query([((item[0][2], "phone", None), "literal")])
                        for item1 in result:
                            phone = item1[0][2]
                        spectator.append(phone)
                    result = qs.rdf_query([((item[0][2], "email", None), "literal")])
                    for item1 in result:
                        email = item1[0][2]
                    spectator.append(email)
                    spectator.append(item[0][2])
                    
                    node.CloseQueryTransaction(qs)
                    
                    spl_id = len(spectator_list) + 1
                    spectator_list[spl_id] = spectator
                    userid[item[0][2]] = spl_id
        return

def insert_startinfo_to_SS(node, ss_handle):
    global porn
    import speakers
    #rsa = RSA(1024,4,65537)
    #rsa.load_keys_from_file()
    #try :
    #    rsa.load_keys_from_file()
    #except :
    #    rsa.generate () 
    #    rsa.save_key_pair_into_files()
    #from settings import greeting
    #insert = [(('PresentationURI', 'is', greeting), "uri", "literal")]
    #insert_in_SS(insert)
    i = 0
    sp = speakers.Speakers()
    st, su = [], []
    for item in sp.starting_time:
        st.append(sp.starting_time[item])
    st.sort()
    for item in st:
        for item2 in sp.starting_time:
            if sp.starting_time[item2] == item:
                su.append(item2)
    for item in su:
        i = i + 1
        TS = "TS_"+str(i)#item[1])
        #dsa = "a"*2000
        #dsa = rsa.encrypt(dsa)
        if security_mode == True:
            name = rsa.encrypt(str(sp.name[item]))
            pres = rsa.encrypt(str(sp.presentation_title[item]))
            init_triples = [
                            ((item, 'http://www.w3.org/1999/02/22-rdf-syntax-ns#type',
                              'http://www.smartconference.org/ontologies/smartconference.owl#Speaker'), "uri", "uri"),
                            ((item, "is", name), "uri", "literal"),
                            ((item, "photoURI", rsa.encrypt("None")), "uri", "literal"),
                            ((item, "interests", rsa.encrypt("None")), "uri", "literal"),
                            ((item, "email", rsa.encrypt("None")), "uri", "literal"),
                            ((item, "phone", rsa.encrypt("None")), "uri", "literal"),
                            ((item, "language", "None"), "uri", "literal"),
                            ((item, "presents", sp.presentation_id[item]), "uri", "literal"),
                            ((sp.presentation_id[item], 'http://www.w3.org/1999/02/22-rdf-syntax-ns#type', 
                              'http://www.smartconference.org/ontologies/smartconference.owl#Presentation'), "uri", "uri"),
                            ((sp.presentation_id[item], "Title", pres), "uri", "literal"),
                            ((sp.presentation_id[item], "Keywords", rsa.encrypt("None")), "uri", "literal"),
                            ((sp.presentation_id[item], "duration", time_oper.get_TS_length(TS)), "uri", "literal"),
                            ((sp.presentation_id[item], "url", rsa.encrypt("None")), "uri", "literal")]
        else :
            name = sp.name[item]
            pres = sp.presentation_title[item]
            init_triples = [
                            ((item, 'http://www.w3.org/1999/02/22-rdf-syntax-ns#type',
                              'http://www.smartconference.org/ontologies/smartconference.owl#Speaker'), "uri", "uri"),
                            ((item, "is", name), "uri", "literal"),
                            ((item, "photoURI", "None"), "uri", "literal"),
                            ((item, "interests", "None"), "uri", "literal"),
                            ((item, "email", "None"), "uri", "literal"),
                            ((item, "phone", "None"), "uri", "literal"),
                            ((item, "language", "None"), "uri", "literal"),
                            ((item, "presents", sp.presentation_id[item]), "uri", "literal"),
                            ((sp.presentation_id[item], 'http://www.w3.org/1999/02/22-rdf-syntax-ns#type', 
                              'http://www.smartconference.org/ontologies/smartconference.owl#Presentation'), "uri", "uri"),
                            ((sp.presentation_id[item], "Title", pres), "uri", "literal"),
                            ((sp.presentation_id[item], "Keywords", "None"), "uri", "literal"),
                            ((sp.presentation_id[item], "duration", time_oper.get_TS_length(TS)), "uri", "literal"),
                            ((sp.presentation_id[item], "url", "None"), "uri", "literal")]
        insert = [((TS, "have", item), "uri", "literal"),
                  ((TS, 'http://www.w3.org/1999/02/22-rdf-syntax-ns#type', 
                    'http://www.smartconference.org/ontologies/smartconference.owl#TimeSlot'), "uri", "uri")]
        porn[item] = TS
        pro = node.CreateInsertTransaction(ss_handle)
        pro.send(insert, confirm = True)
        pro.send(init_triples, confirm = True)
        node.CloseInsertTransaction(pro)

if __name__ == "__main__":
    global node, ss_handle, rs1, rs2, rs3, rs4, rs5, rs6, rs7, home
    # get agenda information
    
    from firstboot import NoConnect

    try :
        from smart_m3 import Node
    except :
        NoConnect(1)
        gtk.main()
        sys.exit(1) 
    
    from settings import conn_set
     
    if conn_set == False :
        import firstboot# import SelectConnection
        name,ip,port = firstboot.get_default_connection()
        try :
            node = Node.ParticipantNode("WhiteBoard")
            ss_handle = (str(name), (Node.TCPConnector, (str(ip), int(port))))
            if not node.join(ss_handle):
                sys.exit('Could not join to Smart Space')
        except :
            from firstboot import SelectConnection
            while True :
                try :
                    sc = SelectConnection()
                    gtk.main()
                    name,ip,port = sc.get_connect()
                    
                    node = Node.ParticipantNode("WhiteBoard")
                    ss_handle = (str(name), (Node.TCPConnector, (str(ip), int(port))))
                    if not node.join(ss_handle):
                        sys.exit('Could not join to Smart Space')
                    break
                except :
                    from firstboot import NoConnect
                    try :
                        NoConnect(0,name)
                    except :
                        NoConnect(4)
                        gtk.main()
                        sys.exit(1)
                        break
                    gtk.main()
    else :
        from firstboot import SelectConnection
        while True :
            try :
                sc = SelectConnection()
                gtk.main()
                name,ip,port = sc.get_connect()
                #print name,ip,port
                node = Node.ParticipantNode("WhiteBoard")
                ss_handle = (str(name), (Node.TCPConnector, (str(ip), int(port))))
                if not node.join(ss_handle):
                    sys.exit('Could not join to Smart Space')
                break
            except :
                from firstboot import NoConnect
                NoConnect(0,name)
                gtk.main()
    
    #===========================================================================
    # node = Node.ParticipantNode("Whiteboard")
    # ss_handle = node.discover()
    # print ss_handle
    # if not node.join(ss_handle):
    #    sys.exit('Could not join to Smart Spase')
    # print "--- Member of SS:", node.member_of
    #===========================================================================

    #scheduling()
    try :
        os.system("cp -r ./pics " +temp_folder+ "pics/")
    except :
        print "can`t copy pics"
    timeslot = ""
    timer_begin = main_timer()
    from settings import begin_auto
    
    if begin_auto == True :
        timer_begin.start()
    
    timeslot = ""
    
    insert_startinfo_to_SS(node, ss_handle) # WTF?
    time_oper.time_slot_reg()

    scheduling()
    rs1 = node.CreateSubscribeTransaction(ss_handle)
    result_rdf_TS = rs1.subscribe_rdf([(("TS", "is", None), 'literal')], RdfMsgHandlerTS())
   
    rs2 = node.CreateSubscribeTransaction(ss_handle)
    result_rdf_OverTS = rs2.subscribe_rdf([(("Space", "visited_by", None), 'literal')], CheckVisitor())
    
    rs3 = node.CreateSubscribeTransaction(ss_handle)
    result_rdf_yes = rs3.subscribe_rdf([((None, "over", "yes"), 'literal')], RdfMsgHandlerAnswerYes())

    rs4 = node.CreateSubscribeTransaction(ss_handle)
    result_rdf_no = rs4.subscribe_rdf([((None, "over", "no"), 'literal')], RdfMsgHandlerAnswerNo())

    rs5 = node.CreateSubscribeTransaction(ss_handle)
    result_rdf_UPI = rs5.subscribe_rdf([((None, "change", None), 'literal')], RdfMsgHandlerChange())

    rs6 = node.CreateSubscribeTransaction(ss_handle)
    result_rdf_OverTS = rs6.subscribe_rdf([(("TS", "is", "over"), 'literal')], RdfMsgHandlerOverTS())
    
    #rs7 = node.CreateSubscribeTransaction(ss_handle)
    #result_rdf_OverTS = rs7.subscribe_rdf([((None, "device", "in_network"), 'literal')], RdfMsgHandlerDeviceALife())
    
    now_time = datetime.datetime.now() #+ datetime.timedelta(hours=1)
    now_time = now_time.strftime("%Y-%m-%d %H:%M:%S")
    insert = [(("MeetingTime", "isNow", now_time), "uri", "literal")]
    pro = node.CreateInsertTransaction(ss_handle)
    pro.send(insert, confirm = True)
    node.CloseInsertTransaction(pro)
    
    rs8 = node.CreateSubscribeTransaction(ss_handle)
    result_rdf_OverTS = rs8.subscribe_rdf([(("MeetingTime", "isNow", None), 'literal')], MeetingTimeHandler())
    
    ontotypes = [(('is', 'http://www.w3.org/1999/02/22-rdf-syntax-ns#type',
                  'http://www.smartconference.org/ontologies/smartconference.owl#is'), "uri", "literal"),
                  (('photoURI', 'http://www.w3.org/1999/02/22-rdf-syntax-ns#type',
                  'http://www.smartconference.org/ontologies/smartconference.owl#photoURI'), "uri", "literal"),
                  (('interests', 'http://www.w3.org/1999/02/22-rdf-syntax-ns#type',
                  'http://www.smartconference.org/ontologies/smartconference.owl#interests'), "uri", "literal"),
                  (('email', 'http://www.w3.org/1999/02/22-rdf-syntax-ns#type',
                  'http://www.smartconference.org/ontologies/smartconference.owl#email'), "uri", "literal"),
                  (('phone', 'http://www.w3.org/1999/02/22-rdf-syntax-ns#type',
                  'http://www.smartconference.org/ontologies/smartconference.owl#phone'), "uri", "literal"),
                  (('language', 'http://www.w3.org/1999/02/22-rdf-syntax-ns#type',
                  'http://www.smartconference.org/ontologies/smartconference.owl#language'), "uri", "literal"),
                  (('presents', 'http://www.w3.org/1999/02/22-rdf-syntax-ns#type',
                  'http://www.smartconference.org/ontologies/smartconference.owl#presents'), "uri", "literal"),
                  (('Title', 'http://www.w3.org/1999/02/22-rdf-syntax-ns#type',
                  'http://www.smartconference.org/ontologies/smartconference.owl#Title'), "uri", "literal"),
                  (('Keywords', 'http://www.w3.org/1999/02/22-rdf-syntax-ns#type',
                  'http://www.smartconference.org/ontologies/smartconference.owl#Keywords'), "uri", "literal"),
                  (('duration', 'http://www.w3.org/1999/02/22-rdf-syntax-ns#type',
                  'http://www.smartconference.org/ontologies/smartconference.owl#duration'), "uri", "literal"),
                  (('url', 'http://www.w3.org/1999/02/22-rdf-syntax-ns#type',
                  'http://www.smartconference.org/ontologies/smartconference.owl#url'), "uri", "literal"),
                  ]

    pro = node.CreateInsertTransaction(ss_handle)
    pro.send(ontotypes, confirm = True)
    node.CloseInsertTransaction(pro)
    
    # start GUI
    app = App()
    gtk.main()
