#from smart_m3 import Node
import time
import sys
import math

#node = Node.ParticipantNode("Ontology Merger")
#ss_handle = node.discover()
#print ss_handle

#if not node.join(ss_handle):
#    sys.exit('Could not join to Smart Space')

#print "--- Member of SS:", node.member_of

#from agenda_project import node, ss_handle

def initialisation(onto1, onto2):
	# Array of all subjects and objects of the KP ontology	
	elements_arr1 = []
	# Array of all subjects and objects of the KP ontology	
	elements_arr2 = []
	# Dictionary of all synonyms which set by rules
	synonyms1 = ([])
	synonyms2 = ([])

	# Generate array with all subjects and objects of the KP ontology
	for onto1_item in onto1:
		if elements_arr1.count(onto1_item[0][0]) == 0:
			elements_arr1.append(onto1_item[0][0])
		if elements_arr1.count(onto1_item[0][2]) == 0:
			elements_arr1.append(onto1_item[0][2])
		if onto1_item[0][1] == "synonym":
			key = 0
			i = 0
			for synonym_triple in synonyms1:
				key = 1
				if (synonym_triple.count(onto2_item[0][0]) == 0) and (synonym_triple.count(onto2_item[0][2]) == 0):
					s = []
					s.append(onto2_item[0][0])
					s.append(onto2_item[0][2])
					synonyms1.append(s)
				else:
					if (synonym_triple.count(onto2_item[0][0]) > 0) and (synonym_triple.count(onto2_item[0][2]) == 0):
						synonyms[i].append(onto2_item[0][2])
					if (synonym_triple.count(onto2_item[0][0]) == 0) and (synonym_triple.count(onto2_item[0][2]) > 0):
						synonyms1[i].append(onto2_item[0][0])

				i = i + 1		

			if key == 0:
					s = []
					s.append(onto2_item[0][0])
					s.append(onto2_item[0][2])
					synonyms1.append(s)

	
	# Generate array with all subjects and objects of the SS ontology
	for onto2_item in onto2:
		# Remove unnessesary rules from SS
		s = onto2_item[0][1]
		if s.find("http") == -1:
			if elements_arr2.count(onto2_item[0][0]) == 0:
				elements_arr2.append(onto2_item[0][0])
			if elements_arr2.count(onto2_item[0][2]) == 0:
				elements_arr2.append(onto2_item[0][2])
			if onto2_item[0][1] == "synonym":
				key = 0
				i = 0
				for synonym_triple in synonyms2:
					key = 1
					if (synonym_triple.count(onto2_item[0][0]) == 0) and (synonym_triple.count(onto2_item[0][2]) == 0):
						s = []
						s.append(onto2_item[0][0])
						s.append(onto2_item[0][2])
						synonyms2.append(s)
					else:
						if (synonym_triple.count(onto2_item[0][0]) > 0) and (synonym_triple.count(onto2_item[0][2]) == 0):
							synonyms2[i].append(onto2_item[0][2])
						if (synonym_triple.count(onto2_item[0][0]) == 0) and (synonym_triple.count(onto2_item[0][2]) > 0):
							synonyms2[i].append(onto2_item[0][0])

					i = i + 1		

				if key == 0:
						s = []
						s.append(onto2_item[0][0])
						s.append(onto2_item[0][2])
						synonyms2.append(s)

	return elements_arr1, elements_arr2, synonyms1, synonyms2 

def comparison_synonyms(elements_arr1, elements_arr2, synonyms1, synonyms2):
	synonyms_matched = ([])
	for element1 in elements_arr1:
		for element2 in elements_arr2:
			if element1 == element2:
				# Output all equal elements
				arr = [element1, element2, 1.0]
				synonyms_matched.append(arr)
				#print "Element of the KP ontology: ", element1, " is equal to element: ", element2, " of the SS ontology"
				# And their synonyms
				for synonym_triple in synonyms2:
					if synonym_triple.count(element2) > 0:
						for synonym_element in synonym_triple:
							if synonym_element != element2:
								arr = [element1, synonym_element, 1.0]
								synonyms_matched.append(arr)
								#print "Element of the KP ontology: ", element1, " is equal to element: ", synonym_element, " of the SS ontology"

				for synonym_triple in synonyms1:
					if synonym_triple.count(element1) > 0:
						for synonym_element in synonym_triple:
							if synonym_element != element1:
								arr = [synonym_element, element2, 1.0]
								synonyms_matched.append(arr)
								#print "Element of the KP ontology: ", synonym_element, " is equal to element: ", element2, " of the SS ontology"
	return synonyms_matched

def fsc(element1, element2):
	contained_strings = 0
	all_strings = 0
	i = 0
	while i <= len(element1):
		j = i + 1
		while j <= len(element1):
			#print i, j, element1[i:j], "---", element2
			if element2.find(element1[i:j]) > -1:
				#print element2.find(element1[i:j])
				contained_strings = contained_strings + 1
			all_strings = all_strings + 1
			j = j + 1
		i = i + 1
	return (float(contained_strings) / float(all_strings))

def fsc_manage(elements_arr1, elements_arr2):
	fsc_matched = ([])
	threshold = 0.5
	for element1 in elements_arr1:
		for element2 in elements_arr2:
			if element1 <> element2:
				result1 = fsc(element1, element2)
				result2 = fsc(element2, element1)
				n = 0.5
				result = n * result1 + (1 - n) * result2
				if (result > threshold):
					arr = [element1, element2, result]
					fsc_matched.append(arr)
#					print "+++ ",element1, element2, result1, result2, result
#				else:
#					print element1, element2, result1, result2, result
	return fsc_matched

def wiktionary(elements_arr1, elements_arr2):
	wktionary_matched = ([])

	wiktionary_synonyms = ([["lecture", "presentation"]])

	for element1 in elements_arr1:
		for element2 in elements_arr2:
			if element1 <> element2:
				for syn_triple in wiktionary_synonyms:
					i = 0
					while i < len(syn_triple):
						#print syn_triple, i
						if syn_triple[i] == element1:
							j = i + 1
							while j < len(syn_triple):
								if syn_triple[j] == element2:
									arr = [element1, element2, 0.5]
									wktionary_matched.append(arr)
								j = j + 1
						i = i + 1
			
	return wktionary_matched

def graph_based(user_onto, project_onto, matched_pairs, threshold):
	cont = 1
	while cont == 1:
		maximum = 0
		for item in matched_pairs:
			if item[2] > maximum and item[3] <> 1:
				maximum = item[2]
				element1 = item[0]
				element2 = item[1]
				item[3] = 1
#		print "Maximum: ", maximum
#		print "Element1:", element1
#		print "Element2:", element2

		if maximum > threshold:		
			for item_user in user_onto:
				if item_user[0][2] == element1:
					for item_proj in project_onto:
						if item_proj[0][2] == element2:
							#find similarity for improvement
							for item_m in matched_pairs:
								if item_m[0] == item_user[0][0] and item_m[1] == item_proj[0][0] and item_m[2] < maximum:
									item_m[2] = math.sqrt(float(item_m[2]) * float(maximum))
									item_m[3] = 1
									#print item_m[2]
#									print matched_pairs

	
				if item_user[0][0] == element1:
					for item_proj in project_onto:
						if item_proj[0][0] == element2:
							#find similarity for improvement
							for item_m in matched_pairs:
								if item_m[0] == item_user[0][2] and item_m[1] == item_proj[0][2] and item_m[2] < maximum:
									item_m[2] = math.sqrt(float(item_m[2]) * float(maximum))
									item_m[3] = 1
									#print item_m[2]
#									print matched_pairs
		else:
			cont = 0


#	print matched_pairs	
	return matched_pairs

def user_services(user_onto, matched_pairs):
    descriptions, _return = [], []
    for item in user_onto:
        if "description" in item[0]:
            descriptions.append(item[0])

    for item in descriptions:
        for item1 in matched_pairs:
            if (item[0] in item1) and (not item[2] in _return):
                _return.append(item[2])
    
    return _return


def main(node, ss_handle):
	user_onto = [(("user", "gives", "lecture"), "uri", "literal"),
	            (("lecture", "description", "You can give lecture"), "uri", "literal"),
	            (("current slide", "part of", "lecture"), "uri", "literal"),
	            (("current slide", "is", "number"), "uri", "literal"),
	            (("lecture", "has", "file location"), "uri", "literal"),
	            (("file location", "description", "You can share lecture file"), "uri", "literal"),
	            (("lecture", "is of", "type"), "uri", "literal"),
	
	            (("user", "is_assisted_by", "translator"), "uri", "literal"),
	            (("translator", "description", "Word translation"), "uri", "literal"),
	            (("trnslator", "takes", "string"), "uri", "literal"),
	            (("lecture", "takes", "source language"), "uri", "literal"),
	            (("lecture", "takes", "target language"), "uri", "literal"),
	            (("lecture", "produces", "translated string"), "uri", "literal")]
	
	#projector_onto = [(("projector", "has", "state"), "literal"),
	#        	 (("projector", "show", "presentation"), "literal"),
	#        	 (("slide", "part of", "presentation"), "literal"),
	#        	 (("slide", "is", "number"), "literal"),
	#        	 (("presentation", "has", "URI"), "literal"),
	#        	 (("presentation", "is of", "type"), "literal"),
	#        	 (("URL", "synonym", "URI"), "literal"),
	#		     (("file location", "synonym", "URI"), "literal")]
	
	threshold = 0.75
	
	#pro = node.CreateInsertTransaction(ss_handle)
	#pro.send(projector_onto, confirm = True)
	#node.CloseInsertTransaction(pro)
	print 'merge: main start.. ',time.localtime()[5]
	qs = node.CreateQueryTransaction(ss_handle)
	
	project_onto = qs.rdf_query([((None, None, None), 'literal')])
	
	#print "------------------------------------------------"
	#print "--------------------Input-----------------------"
	#print "------------------------------------------------"
	# Determine lists of ontology elements, and synonyms arrays
	#print "Ontology of the knowledge processor:"
	#print user_onto
	#print
	#print "Ontology of the smart space:"
	#print projector_onto
	#print
	elements_arr1, elements_arr2, synonyms1, synonyms2 = initialisation(user_onto, project_onto)
	#print "Objects and subjects of the knowledge processor ontology: ", elements_arr1
	#print "Objects and subjects of the smart space ontology: ", elements_arr2
	#print "Synonyms of knowledge processor ontology: ", synonyms1
	#print "Synonyms of smart space ontology: ", synonyms2
	#print
	#print "------------------------------------------------"
	#print "-------Matching using rule-based synonyms-------"
	#print "------------------------------------------------"
	# Compare elements using synonyms
	matched_syn = comparison_synonyms(elements_arr1, elements_arr2, synonyms1, synonyms2)
	#print matched_syn
	#print "------------------------------------------------"
	#print "---------Matching using FSC algorithm-----------"
	#print "------------------------------------------------"
	# FSC algorithm
	matched_fsc = fsc_manage(elements_arr1, elements_arr2)
	#print matched_fsc
	#print 
	#print "------------------------------------------------"
	#print "-----Matching using Wiktionary algorithm--------"
	#print "------------------------------------------------"
	# Wiktionary
	matched_wiki = wiktionary(elements_arr1, elements_arr2)
	#print matched_wiki
	
	matched_pairs = ([])
	for item in matched_syn:
		item.append(0)
		matched_pairs.append(item)
	for item in matched_fsc:
		item.append(0)
		matched_pairs.append(item)
	for item in matched_wiki:
		item.append(0)
		matched_pairs.append(item)
	
	#print "------------------------------------------------"
	#print "--------------All matched triples---------------"
	#print "------------------------------------------------"
	#print matched_pairs
	matched_pairs = graph_based(user_onto, project_onto, matched_pairs, threshold)
	
	node.CloseQueryTransaction(qs)
	
	node.leave(ss_handle)
	print 'merge: user_services start.. ',time.localtime()[5]
	return user_services(user_onto, matched_pairs)
	
	#sys.exit()
