#!/usr/bin/env python
# -*- coding: cp1251 -*-

from smart_m3 import Node
import time
import sys
import sys, urllib, urllib2
import simplejson as json
import string, re
import codecs

def translateWords(url, words_list, source_language, target_language):
        """Return a list of translation word of the given "source word".
        """
        api_params = {
                        's': source_language,   # e.g. 'en',
                        't': target_language,   # e.g. 'ru',
                        'w': words_list
                        }
        # make the api call

        url = url + "?" + urllib.urlencode(api_params)

        #print url
        bytes = urllib2.urlopen(url).read()

        try:
                text_res = bytes.decode('utf-8')
        except UnicodeDecodeError:
                text_res = bytes

        trans_words = dict()

        try:    # Your comp doesn't has suitable encoding!?
                response = json.loads(text_res)
                for r in response:
                        trans_words[r['s']] = r['w']

        except UnicodeEncodeError:
                print('e')

        return trans_words


def translate_keywords(keywords, source_lang, target_lang):
  sentence_en = keywords

  tokens = re.split('(\W+)', sentence_en)
  
  words_to_translate = []

  for i in range(0, len(tokens)):
          if (0 == i % 2 and len(tokens[i]) > 0):
                  words_to_translate.append(tokens[i])
  words_comma_list = ",".join(words_to_translate)

  #url = "http://195.201.73.162:8080/gebikisu_gwt/translate_words"
  url = "http://192.168.0.101:8080/gebikisu_gwt/translate_words"
  translations = translateWords(url, words_comma_list, source_lang, target_lang)

  for i in range(0, len(tokens)):
          if (tokens[i] in translations and len(translations[tokens[i]]) > 0):
              tokens[i] = translations[tokens[i]][0]

  return "".join(tokens)

node = Node.ParticipantNode("Translator")
ss_handle = node.discover()
print ss_handle

if not node.join(ss_handle):
    sys.exit('Could not join to Smart Space')

print "--- Member of SS:", node.member_of


# Subscriptions coordination variable
class RdfMsgHandler:
    def handle(self, added, removed):
        for i in added:
            qs = node.CreateQueryTransaction(ss_handle)
            result = qs.rdf_query([(("translatelang", str(i[0][1]), None),"literal")])
            for item in result:

                print "Translation started, request from ", item[0][1], ", lang: ", item[0][2]
                #print str(i[0][2])
                tr_text = translate_keywords(str(i[0][2]), "en", item[0][2])
                translated_text = [(("translatedtext", item[0][1], tr_text), "uri", "literal")]

                print "translation completed"#, tr_text

                pro = node.CreateInsertTransaction(ss_handle)
                pro.send(translated_text, confirm = True)
                node.CloseInsertTransaction(pro)

                remove_text = [(("text2translate", item[0][1], str(i[0][2])), "uri", "literal")]
                remove_lang = [(("translatelang", item[0][1], item[0][2]), "uri", "literal")]
                #print "Remove", remove_text
                #print "Remove", remove_lang
                cng = node.CreateRemoveTransaction(ss_handle)
                cng.remove(remove_text, confirm = True)
                cng.remove(remove_lang, confirm = True)
                node.CloseRemoveTransaction(cng)
            node.CloseQueryTransaction(qs)

translator_onto = [(("translator", "description", "Word translation"), "uri", "literal"),
            (("translator", "takes", "string"), "uri", "literal"),
            (("lecture", "takes", "source language"), "uri", "literal"),
            (("lecture", "takes", "target language"), "uri", "literal"),
            (("lecture", "produces", "translated string"), "uri", "literal")]
pro = node.CreateInsertTransaction(ss_handle)
pro.send(translator_onto, confirm = True)
node.CloseInsertTransaction(pro)
            

rs1 = node.CreateSubscribeTransaction(ss_handle)
result_rdf = rs1.subscribe_rdf([(("text2translate", None, None), 'literal')], RdfMsgHandler())

inp = raw_input("Press any key if you are bored to wait\n")
node.CloseSubscribeTransaction(rs1)
node.leave(ss_handle)
sys.exit()
