#!/usr/bin/env python
# coding: utf-8
import sys
import os
import pygtk
pygtk.require('2.0')
import gtk
import gtk.glade
import threading
import shutil
#from smart_m3 import Node
import _functions
import pango
import Image
from xml.dom.minidom import parse
import xml.sax
from settings_data_handler import Settings_data_handler

home = os.path.expanduser('~')
home = home + "/.sc"
work_directory = os.path.abspath('') + "/"
fontdesc_frame2 = pango.FontDescription("sance bold 14")
fontdesc_label2 = pango.FontDescription("sance 13")
fontdesc_entry2 = pango.FontDescription("sance italic 12")
fontdesc_button2 = pango.FontDescription("sance 16")

flag_update = 0
gl_lang = 'en'
presentation = [(('PresentationURI', 'is', 'None'), "uri", "literal")]
widgets_text = { 'en': {
			'Save': "Save",
			'Cancel': "Cancel",
			'Select': " Refresh ",
			'Name': "Name:",
			'E-mail': "E-mail",
			'Phone': "Phone",
			'Interest': "Interest",
			'Language': "Language",
			'Title': "Title",
			'URL': "URL",
			'Keywords': "Keywords",
			'Personal': "Personal",
			'Presentation': "Presentation",
			'Photo': "Photo",
			'Open': "Open",
			'Close': "Close",
			'Window_title': "Profile",
			'Window_select': "Select",
			'Duration': "Duration",
			'Type': "Type",
			'Video': "Video Url",
			'Photo_url' : "Photo Url",
			'Settings' : "Settings",
			'security_mode' : "Security mode (available after reboot)",
			'auto_connect' : "Autoconnection to sib (available after reboot)",
			'watch_video' : "Play video on device",
			'http_port' : "Http sever port (available after reboot)"
			
			
                        },
                 'ru': {
			'Save': "Сохранить",
			'Cancel': "Отменить",
			'Select': "Обновить",
			'Name': "Имя",
			'E-mail': "Элек.почта",
			'Phone': "Тел.номер",
			'Interest': "Интересы",
			'Language': "Язык",
			'Title': "Название",
			'URL': "Ссылка",
			'Keywords': "Кл.слова",
			'Personal': "Личные",
			'Presentation': "Презентация",
			'Photo': "Фото",
			'Open': "Открыть",
			'Close': "Закрыть",
			'Window_title': "Профиль",
			'Window_select': "Выбрать",
			'Duration': "Время",
			'Type': "Тип",
			'Video': "Видео ссылка",
			'Photo_url' : "Фото ссылка",
			'Settings' : "Настройки",
			'security_mode' : "Режим секртености (доступен после перезагрузки)",
			'auto_connect' : "Автоматическое подключение к sib (доступен после перезагрузки)",
			'watch_video' : "Проигрывать видео на устройстве",
			'http_port' : "Порт http сервера (доступен после перезагрузки)"
                        }
                  }
     
class App:

	def __init__(self, node = None, ss_handle = None, set_tab = 0):
		global widgets_text, presentation, flag_update, gl_lang, fontdesc_entry2,home
		self.user = "u2"#user
		self.presentation_id = "p2"#presentation_id
		self.node = node
		self.ss_handle = ss_handle
		self.settings_value = Settings_data()
		self.gladefile = work_directory +  "Image04.glade"
		self.widgetsTree = gtk.glade.XML(self.gladefile)
		self.set_tab = int(set_tab)
		

		dic = {
				"cancel_clicked_cb"    : self.close_app,
				"review_clicked_cb"    : self.open_review,
				"close_clicked_cb"     : self.on_delete_event,
				"open_clicked_cb"      : self.set_way,
				"save_clicked_cb"      : self.save_inf,
				"ok_clicked_cb"        : self.ok_error,
				"combobox1_changed_cb" : self.get_active_ComBox,
				"combobox2_changed_cb" : self.set_sens_on_entry,
				"checkbutton1_toggled_cb": self.toggled_cb1,
				"checkbutton2_toggled_cb": self.toggled_cb2,
				"checkbutton3_toggled_cb": self.toggled_cb3,
				"button4_clicked_cb" : self.open_review,
               	"button5_clicked_cb" : self.open_review,
				}

		self.widgetsTree.signal_autoconnect(dic)
		self.window = self.widgetsTree.get_widget("dialog1")

		if (self.window):
			self.window.connect("destroy", self.close_app)

		self.window.maximize()
		self.review_dialog = self.widgetsTree.get_widget("dialog_review")        
		self.review_dialog.connect("delete-event", self.on_delete_event)
		self.error_dialog = self.widgetsTree.get_widget("error_dialog")        
		self.error_dialog.connect("delete-event", self.ok_error)
		self.way = None
		self.sp_dic = None
		self.sp_dic = _functions.get_inf(home+'/data.txt')
		self.user = self.sp_dic[9]
		self.presentation_id = self.sp_dic[10]
		self.set_photo(self.sp_dic[0])
		self.speaker = False
        
		if self.sp_dic[12] == "1": self.speaker = True
		notebook1 = self.widgetsTree.get_widget("notebook1")
		notebook1.set_current_page(self.set_tab)
		entry = self.widgetsTree.get_widget("entry_url1")
		entry.modify_font(fontdesc_entry2)
		entry.set_text(self.sp_dic[0])

		entry = self.widgetsTree.get_widget("name")
		entry.modify_font(fontdesc_entry2)
		entry.set_text(self.sp_dic[1])

		entry = self.widgetsTree.get_widget("e-mail")
		entry.modify_font(fontdesc_entry2)
		entry.set_text(self.sp_dic[2])

		entry = self.widgetsTree.get_widget("phone_number")
		entry.modify_font(fontdesc_entry2)
		entry.set_text(self.sp_dic[3])

		entry = self.widgetsTree.get_widget("domain_of_interests")
		entry.modify_font(fontdesc_entry2)
		entry.set_text(self.sp_dic[6])

		if self.speaker:
			dialog_win = self.widgetsTree.get_widget("dialog1")
			#dialog_win.resize(200, 300)
			entry = self.widgetsTree.get_widget("title")
			entry.modify_font(fontdesc_entry2)
			entry.set_text(self.sp_dic[4])
			entry = self.widgetsTree.get_widget("uri")
			entry.modify_font(fontdesc_entry2)
			entry.set_text(self.sp_dic[5])
			entry = self.widgetsTree.get_widget("keywords")
			entry.modify_font(fontdesc_entry2)
			entry.set_text(self.sp_dic[7])
			self.widgetsTree.get_widget("spinbutton1").set_value(int(self.sp_dic[11]))
			
			entry = self.widgetsTree.get_widget("video_url")
			entry.modify_font(fontdesc_entry2)
			entry.set_text(self.sp_dic[13])
		else:
			dialog_win = self.widgetsTree.get_widget("dialog1")
			#dialog_win.resize(200, 270)
			#presentation_frame = self.widgetsTree.get_widget("label5")
			#presentation_frame.hide()

		ComBox = self.widgetsTree.get_widget("combobox1")
		self.model_scrit = gtk.ListStore(str)
		self.model_scrit.append(["English"])
		self.model_scrit.append(["Finnish"])
		self.model_scrit.append(["Russian"])
		ComBox.set_model(self.model_scrit)
		cell = gtk.CellRendererText()
		cell.set_property('font-desc', pango.FontDescription('sance italic 12'))
		ComBox.pack_start(cell)
		ComBox.add_attribute(cell,'text',0)

		if self.sp_dic[8] == "" :
			ComBox.set_active(0)
		elif self.sp_dic[8] == "English":
			ComBox.set_active(0)
			gl_lang = 'en'
		elif self.sp_dic[8] == "Finnish":
			ComBox.set_active(1)
	 		gl_lang = 'en'
		elif self.sp_dic[8] == "Russian":
			ComBox.set_active(2)
			gl_lang = 'ru'
			
		ComBox2 = self.widgetsTree.get_widget("combobox2")
		self.model_scrit = gtk.ListStore(str)
		self.model_scrit.append(["Visitor"])
		self.model_scrit.append(["Speaker"])
		ComBox2.set_model(self.model_scrit)
		cell = gtk.CellRendererText()
		cell.set_property('font-desc', pango.FontDescription('sance italic 12'))
		ComBox2.pack_start(cell)
		ComBox2.add_attribute(cell,'text',0)

		if self.sp_dic[12] == "0" :
			ComBox2.set_active(0)
		elif self.sp_dic[12] == "1":
			ComBox2.set_active(1)
			
		self.set_sens_on_entry(ComBox2)
		#print self.settings_value
		self.checkbutton1 = self.widgetsTree.get_widget("checkbutton1").set_active(self.settings_value.security_mode)
		self.checkbutton2 = self.widgetsTree.get_widget("checkbutton2").set_active(self.settings_value.auto_connect)
		self.checkbutton3 = self.widgetsTree.get_widget("checkbutton3").set_active(self.settings_value.watch_video)
		self.entry_port = self.widgetsTree.get_widget("entry1port")
		self.entry_port.set_text(self.settings_value.http_server_port)
		#=======================================================================
		# if self.settings_value.security_mode == True :
		#	self.checkbutton1 = self.widgetsTree.get_widget("checkbutton1").set_active(1)
		# else :
		#	self.checkbutton1 = self.widgetsTree.get_widget("checkbutton1").set_active(0)
		#	
		# if self.settings_value.auto_connect == True :
		#	self.checkbutton2 = self.widgetsTree.get_widget("checkbutton2").set_active(1)
		# else :
		#	self.checkbutton2 = self.widgetsTree.get_widget("checkbutton2").set_active(0)
		#	
		# if self.settings_value.watch_video == True :
		#	self.checkbutton3 = self.widgetsTree.get_widget("checkbutton3").set_active(1)
		# else :
		#	self.checkbutton3 = self.widgetsTree.get_widget("checkbutton3").set_active(0)
		#=======================================================================
		
		#self.checkbutton3 = self.widgetsTree.get_widget("checkbutton3").set_active(self.settings_value.watch_video)

#		if ComBox2.get_active_text() == "Speaker" :
#			self.widgetsTree.get_widget("title").set_sensitive(True)
#			self.widgetsTree.get_widget("uri").set_sensitive(True)
#			self.widgetsTree.get_widget("keywords").set_sensitive(True)
#			self.widgetsTree.get_widget("video_url").set_sensitive(True)
#		elif ComBox2.get_active_text() == "Visitor" :
#			self.widgetsTree.get_widget("title").set_sensitive(False)
#			self.widgetsTree.get_widget("uri").set_sensitive(False)
#			self.widgetsTree.get_widget("keywords").set_sensitive(False)
#			self.widgetsTree.get_widget("video_url").set_sensitive(False)
			
		dic_it = _functions.get_inf(home+'/data.txt')
		self.init_triples = _functions.set_init_triples(self.user, self.presentation_id, dic_it, self.speaker)
		self.presentation = _functions.set_presentation(dic_it)
		presentation = _functions.set_presentation(dic_it)
		
	def main(self):
		gtk.main()
		
	def toggled_cb1(self, widget):
		self.settings_value.security_mode = widget.get_active()
		#print widget.get_active()
		return
	
	def toggled_cb2(self, widget):
		self.settings_value.auto_connect = widget.get_active()
		#print widget.get_active()
		return
	
	def toggled_cb3(self, widget):
		self.settings_value.watch_video = widget.get_active()
		#print widget.get_active()
		return
	
	def set_sens_on_entry(self,widget):
		ComBox2 = self.widgetsTree.get_widget("combobox2")
		if ComBox2.get_active_text() == "Speaker" :
			self.widgetsTree.get_widget("title").set_sensitive(True)
			self.widgetsTree.get_widget("uri").set_sensitive(True)
			self.widgetsTree.get_widget("keywords").set_sensitive(True)
			self.widgetsTree.get_widget("video_url").set_sensitive(True)
		elif ComBox2.get_active_text() == "Visitor" :
			self.widgetsTree.get_widget("title").set_sensitive(False)
			self.widgetsTree.get_widget("uri").set_sensitive(False)
			self.widgetsTree.get_widget("keywords").set_sensitive(False)
			self.widgetsTree.get_widget("video_url").set_sensitive(False)
		

	def get_active_ComBox(self, widget):
		land = 'ru'
		self.set_lang_int(land)

	def set_lang_int(self, country):
		global widgets_text, fontdesc_frame2, fontdesc_button2, fontdesc_label2

		ComBox = self.widgetsTree.get_widget("combobox1")
		position = ComBox.get_active()
		if position == 0 :
			country = 'en'
		elif position == 1 :
			country = 'en'
		elif position == 1 :
			country = 'ru'
		
		self.window.set_title(widgets_text[country]['Window_title'])
		self.review_dialog.set_title(widgets_text[country]['Window_select'])

		label = self.widgetsTree.get_widget("label1")
		label.modify_font(fontdesc_button2)
		label.set_text(widgets_text[country]['Save'])

		label = self.widgetsTree.get_widget("label2")
		label.modify_font(fontdesc_button2)
		label.set_text(widgets_text[country]['Cancel'])
		label = self.widgetsTree.get_widget("label3")
		label.modify_font(fontdesc_button2)
		label.set_text(widgets_text[country]['Select'])
		
		label = self.widgetsTree.get_widget("label12")
		label.modify_font(fontdesc_label2)
		label.set_text(widgets_text[country]['Name'])
		
		label = self.widgetsTree.get_widget("label13")
		label.modify_font(fontdesc_label2)
		label.set_text(widgets_text[country]['E-mail'])
		
		label = self.widgetsTree.get_widget("label14")
		label.modify_font(fontdesc_label2)
		label.set_text(widgets_text[country]['Phone'])
		
		label = self.widgetsTree.get_widget("label15")
		label.modify_font(fontdesc_label2)
		label.set_text(widgets_text[country]['Interest'])
		
		label = self.widgetsTree.get_widget("label18")
		label.modify_font(fontdesc_label2)
		label.set_text(widgets_text[country]['Language'])
		
		label = self.widgetsTree.get_widget("label16")
		label.modify_font(fontdesc_label2)
		label.set_text(widgets_text[country]['Title'])
		
		label = self.widgetsTree.get_widget("labelu17")
		label.modify_font(fontdesc_label2)
		label.set_text(widgets_text[country]['URL'])
		
		label = self.widgetsTree.get_widget("label20")
		label.modify_font(fontdesc_label2)
		label.set_text(widgets_text[country]['Keywords'])
		
		label = self.widgetsTree.get_widget("label4")
		label.modify_font(fontdesc_frame2)
		label.set_text(widgets_text[country]['Personal'])
		
		label = self.widgetsTree.get_widget("label5")
		label.modify_font(fontdesc_frame2)
		label.set_text(widgets_text[country]['Presentation'])
		
		label = self.widgetsTree.get_widget("label9")
		label.modify_font(fontdesc_frame2)
		label.set_text(widgets_text[country]['Photo'])
		
		label = self.widgetsTree.get_widget("label21")
		label.modify_font(fontdesc_frame2)
		label.set_text(widgets_text[country]['Duration'])
		
		label = self.widgetsTree.get_widget("label4")
		label.modify_font(fontdesc_button2)
		label.set_text(widgets_text[country]['Personal'])
		
		label = self.widgetsTree.get_widget("label5")
		label.modify_font(fontdesc_button2)
		label.set_text(widgets_text[country]['Presentation'])
		
		label = self.widgetsTree.get_widget("labelu16")
		label.modify_font(fontdesc_label2)
		label.set_text(widgets_text[country]['URL'])
		
		label = self.widgetsTree.get_widget("label7")
		label.modify_font(fontdesc_label2)
		label.set_text(widgets_text[country]['Video'])
		
		label = self.widgetsTree.get_widget("label6")
		label.modify_font(fontdesc_label2)
		label.set_text(widgets_text[country]['Type'])
		
		label = self.widgetsTree.get_widget("labelu4")
		label.modify_font(fontdesc_label2)
		label.set_text(widgets_text[country]['Open'])
		
		label = self.widgetsTree.get_widget("labelu5")
		label.modify_font(fontdesc_label2)
		label.set_text(widgets_text[country]['Close'])
		
		label = self.widgetsTree.get_widget("label_url8")
		label.modify_font(fontdesc_label2)
		label.set_text(widgets_text[country]['Photo_url'])
		
		label = self.widgetsTree.get_widget("label8")
		label.modify_font(fontdesc_label2)
		label.set_text(widgets_text[country]['Settings'])
		
		label = self.widgetsTree.get_widget("label10")
		label.modify_font(fontdesc_label2)
		label.set_text(widgets_text[country]['security_mode'])
		
		label = self.widgetsTree.get_widget("label11")
		label.modify_font(fontdesc_label2)
		label.set_text(widgets_text[country]['auto_connect'])
		
		label = self.widgetsTree.get_widget("label17s")
		label.modify_font(fontdesc_label2)
		label.set_text(widgets_text[country]['watch_video'])
		
		label = self.widgetsTree.get_widget("label17port")
		label.modify_font(fontdesc_label2)
		label.set_text(widgets_text[country]['http_port'])
		
		#self.checkbutton1.modify_font(fontdesc_label2)
		#self.checkbutton2.modify_font(fontdesc_label2)
		#self.checkbutton3.modify_font(fontdesc_label2)
		
		
		
		
		


	def SpeackerSpectator(self, widget):
		presentation_frame = self.widgetsTree.get_widget("frame2")
		presentation_frame.hide()

	#Hide error dialog
	def ok_error(self, widget):
		self.error_dialog.hide()

	def set_photo(self, photoURI):
		global photo,home, work_directory
		photo = self.widgetsTree.get_widget("image3")
		photo.set_from_file(work_directory +"pics/default.jpg")
		if _functions.download_file(photoURI, home+"/speakers_photo") == 1:
			photo.set_from_file(work_directory +"pics/default_avatar.jpg")
			t = threading.Timer(3.0, resize_image)
			t.start()
		else:
			photo.set_from_file(work_directory +"pics/default_avatar.jpg")

	def get_photo(self, photoURI):
		os.system(
		"wget -t 10 -o wlog "+photoURI+" -O"+home+"/speakers_photo &")
		if os.access(home+'/speakers_photo', os.F_OK):
			return 1
		else:
			return 0

	#Hide main dialog (profile)               
	def close_app(self, widget):
		if not self.ss_handle:
			gtk.main_quit()
		
		self.window.hide()

	def close_all(self):
		self.window.hide()
		self.error_dialog.hide()
		self.review_dialog.hide()

	#Open review dialog and set way
	def open_review(self, widget):
            global home
            self.review_dialog.set_current_folder(os.path.expanduser('~'))
            
            self.url_entry = self.widgetsTree.get_widget("entry1")
            self.last_widget_name = widget.get_name()
            
            if self.last_widget_name == 'button4' :
            	pass
            elif self.last_widget_name == 'button5' :
            	pass
            elif self.last_widget_name == 'button3' :
            	pass
            self.review_dialog.show()

	#Hide review dialog    
	def on_delete_event(self, widget):                
		self.review_dialog.hide()

    #Set way for foto file
	def set_way(self, widget):
		global work_directory
		add_for_files_url = "http://"+_functions.get_lan_ip()+":"+self.settings_value.http_server_port+"/"
		if self.last_widget_name == 'button4' :
			if self.url_entry.get_text() == "" :
				way = self.review_dialog.get_filename()
				name = os.path.split(way)[1]
				if not os.path.exists(home):
					os.mkdir(home)
					os.mkdir(home+'/www')
				elif not os.path.exists(home+'/www'):
					os.mkdir(home+'/www')
				shutil.copy(way, home+'/www')
				entry = self.widgetsTree.get_widget("uri").set_text(add_for_files_url + name)
			else:
				self.way = self.widgetsTree.get_widget("uri").set_text(self.widgetsTree.get_widget("entry_url1").get_text())
		
		elif self.last_widget_name == 'button5' :
			if self.url_entry.get_text() == "" :
				way = self.review_dialog.get_filename()
				name = os.path.split(way)[1]
				if not os.path.exists(home):
					os.mkdir(home)
					os.mkdir(home+'/www')
				elif not os.path.exists(home+'/www'):
					os.mkdir(home+'/www')
				shutil.copy(way, home+'/www')
				entry = self.widgetsTree.get_widget("video_url").set_text(add_for_files_url + name)
			else :
				entry = self.widgetsTree.get_widget("video_url").set_text(self.widgetsTree.get_widget("entry_url1").get_text())
		
		elif self.last_widget_name == 'button3' :
			if self.url_entry.get_text() == "" :
				way = self.review_dialog.get_filename()
				name = os.path.split(way)[1]
				if not os.path.exists(home):
					os.mkdir(home)
					os.mkdir(home+'/www')
				elif not os.path.exists(home+'/www'):
					os.mkdir(home+'/www')
				shutil.copy(way, home+'/www')
				entry = self.widgetsTree.get_widget("entry_url1").set_text(way)
				self.way = name
			else:
				self.way = self.widgetsTree.get_widget("entry1").get_text()
				entry = self.widgetsTree.get_widget("entry_url1").set_text(self.way)
			
			photo = self.widgetsTree.get_widget("image3")
			photo.set_from_file(work_directory +"pics/default.jpg")
			
			if _functions.download_file(add_for_files_url+os.path.split(self.way)[1], home+"/speakers_photo") == 1:
				#photo.set_from_file("default.jpg")
				t = threading.Timer(1, resize_image)
				t.start()
			else:
				photo.set_from_file(work_directory +"pics/default_avatar.jpg")
				entry_text0 = self.widgetsTree.get_widget("entry_url1").get_text()
				self.way = entry_text0
			
		self.review_dialog.hide()
				
	def save_settings_to_xml(self):
		new_file_name = home + '/user_settings.xml'
		old_file_name = new_file_name + "~"
		self.settings_value.http_server_port = self.entry_port.get_text()
		os.rename(new_file_name, old_file_name)
		doc = parse(old_file_name)
		#print self.settings_value.security_mode
		#print self.settings_value.watch_video
		#print self.settings_value.auto_connect
		elem = doc.getElementsByTagName('security_mode')
		elem[0].firstChild.nodeValue = self.settings_value.security_mode
		elem = doc.getElementsByTagName('watch_video')
		elem[0].firstChild.nodeValue = self.settings_value.watch_video
		elem = doc.getElementsByTagName('auto_connect')
		elem[0].firstChild.nodeValue = self.settings_value.auto_connect
		elem = doc.getElementsByTagName('http_server_port')
		elem[0].firstChild.nodeValue = self.settings_value.http_server_port
		xml_file = open(new_file_name, "w")
		doc.writexml(xml_file, encoding="utf-8")
		xml_file.close()

	#Save or update user information
	def save_inf(self, widget):
		global flag_update, presentation, gl_lang,home
		self.save_settings_to_xml()
		
		entry_text0 = self.widgetsTree.get_widget("entry_url1").get_text()
		entry_text1 = self.widgetsTree.get_widget("name").get_text()
		entry_text2 = self.widgetsTree.get_widget("e-mail").get_text()
		entry_text3 = self.widgetsTree.get_widget("phone_number").get_text()
		entry_text6 = self.widgetsTree.get_widget("domain_of_interests").get_text()
		combo_text = self.widgetsTree.get_widget("combobox1").get_active_text()
		combo_text2 = self.widgetsTree.get_widget("combobox2").get_active_text()
		if combo_text2 == "Speaker" :
			self.speaker = 1
		else :
			self.speaker = 0
			
		if self.speaker:
			entry_text4 = self.widgetsTree.get_widget("title").get_text()
			entry_text5 = self.widgetsTree.get_widget("uri").get_text()
			entry_text7 = self.widgetsTree.get_widget("keywords").get_text()
			entry_text8 = self.widgetsTree.get_widget("video_url").get_text()
			presentation_time = self.widgetsTree.get_widget("spinbutton1").get_value_as_int()	
		else:
			entry_text4, entry_text5, entry_text7, entry_text8, presentation_time = "None", "None","None", "None", 0
		if ((self.speaker) and ((entry_text1 == "") or (entry_text4 == "") or (entry_text7 == "")  or (entry_text5 == ""))) or ((not self.speaker) and (entry_text1 == "")):
			self.error_dialog.show()
			return
		else:
			myfile = open(home+'/data.txt', "w")
			myfile.write(entry_text0+";")
			if combo_text2 == "Speaker" :
					self.sp_dic[12] = "1"
			elif combo_text2 == "Visitor":
					self.sp_dic[12] = "0"
			myfile.write(entry_text1+";")
			myfile.write(entry_text2+";")
			myfile.write(entry_text3+";")
			myfile.write(entry_text4+";")
			myfile.write(entry_text5+";")
			myfile.write(entry_text6+";")
			myfile.write(entry_text7+";")
			myfile.write(combo_text+";")
			myfile.write(self.sp_dic[9]+";")
			myfile.write(self.sp_dic[10]+";")
			myfile.write(str(presentation_time)+";")
			myfile.write(self.sp_dic[12]+";")
			if entry_text8 == "" :
				myfile.write("None")
			else:
			 	myfile.write(entry_text8)
			myfile.write(";")
			myfile.close()
			old_init_triples = self.init_triples
			dic_it = _functions.get_inf(home+'/data.txt')
			self.init_triples = _functions.set_init_triples(self.user,self.presentation_id,dic_it, self.speaker)
			self.presentation = _functions.set_presentation(dic_it)
			presentation = self.presentation
                
			if self.ss_handle:
				old_init_triples = _functions.get_init_triples_from_ss(self.sp_dic[9],self.node, self.ss_handle)
				#upd = self.node.CreateUpdateTransaction(self.ss_handle)
				#upd.update(self.init_triples, "RDF-M3", old_init_triples, "RDF-M3", confirm = True)
				#self.node.CloseUpdateTransaction(upd)
				cng = self.node.CreateRemoveTransaction(self.ss_handle)
				cng.remove(old_init_triples, confirm = True)
				self.node.CloseRemoveTransaction(cng)
				pro = self.node.CreateInsertTransaction(self.ss_handle)
				pro.send(self.init_triples, confirm = True)
				self.node.CloseInsertTransaction(pro)
				
				flag_update = flag_update + 1
				if combo_text == "English" :
					gl_lang = 'en'
				elif combo_text == "Russian" :
					gl_lang = 'ru'
				elif combo_text == "Finnish":
					gl_lang = 'fi'
				
				if entry_text0 != self.sp_dic[0]:
					pro = self.node.CreateInsertTransaction(self.ss_handle)
					insert = [((self.sp_dic[9], "change", "photoURI"), "uri", "literal")]
					pro.send(insert, confirm = True)
					self.node.CloseInsertTransaction(pro) 
				if entry_text1 != self.sp_dic[1]:
					pro = self.node.CreateInsertTransaction(self.ss_handle)
					insert = [((self.sp_dic[9], "change", "name"), "uri", "literal")]
					pro.send(insert, confirm = True)
					self.node.CloseInsertTransaction(pro) 
				if entry_text2 != self.sp_dic[2]:
					pro = self.node.CreateInsertTransaction(self.ss_handle)
					insert = [((self.sp_dic[9], "change", "e-mail"), "uri", "literal")]
					pro.send(insert, confirm = True)
					self.node.CloseInsertTransaction(pro)
				if entry_text3 != self.sp_dic[3]:
					pro = self.node.CreateInsertTransaction(self.ss_handle)
					insert = [((self.sp_dic[9], "change", "phone_number"), "uri", "literal")]
					pro.send(insert, confirm = True)
					self.node.CloseInsertTransaction(pro)
				if entry_text6 != self.sp_dic[6]:
					pro = self.node.CreateInsertTransaction(self.ss_handle)
					insert = [((self.sp_dic[9], "change", "domain_of_interests"), "uri", "literal")]
					pro.send(insert, confirm = True)
					self.node.CloseInsertTransaction(pro)
				if combo_text != self.sp_dic[8]:
					pro = self.node.CreateInsertTransaction(self.ss_handle)
					insert = [((self.sp_dic[9], "change", "language"), "uri", "literal")]
					pro.send(insert, confirm = True)
					self.node.CloseInsertTransaction(pro)
				if self.speaker:
					if entry_text4 != self.sp_dic[4]:
						pro = self.node.CreateInsertTransaction(self.ss_handle)
						insert = [((self.sp_dic[9], "change", "title"), "uri", "literal")]
						pro.send(insert, confirm = True)
						self.node.CloseInsertTransaction(pro)
					if entry_text5 != self.sp_dic[5]:
						pro = self.node.CreateInsertTransaction(self.ss_handle)
						insert = [((self.sp_dic[9], "change", "uri"), "uri", "literal")]
						pro.send(insert, confirm = True)
						self.node.CloseInsertTransaction(pro)
					if entry_text7 != self.sp_dic[7]:
						pro = self.node.CreateInsertTransaction(self.ss_handle)
						insert = [((self.sp_dic[9], "change", "keywords"), "uri", "literal")]
						pro.send(insert, confirm = True)
						self.node.CloseInsertTransaction(pro)
				self.window.hide()
			else:
				self.window.destroy()



class Settings_data:
    security_mode = False
    watch_video = False
    auto_connect = False
    http_server_port = None
    def __init__(self):
    	parser = xml.sax.make_parser()
    	handler = Settings_data_handler()
        parser.setContentHandler(handler)
        try :
        	parser.parse(home+"/user_settings.xml")
        except :
        	if not os.path.exists(home):
        		os.mkdir(home)
        	myfile = open(home+"/user_settings.xml", "w+")
        	myfile.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>")
        	myfile.write("<settings_speakers>")
        	myfile.write("<user id=\"user\">")
        	myfile.write("<security_mode>False</security_mode>")
        	myfile.write("<watch_video>False</watch_video>")
        	myfile.write("<auto_connect>False</auto_connect>")
        	myfile.write("<http_server_port>8888</http_server_port>")
        	myfile.write("</user>")
        	myfile.write("</settings_speakers>")
        	myfile.close()
        	parser.parse(home+"/user_settings.xml")
        	
        for item in handler.mapping:
        	#print handler.mapping
        	self.security_mode = handler.mapping[item][0]
        	self.watch_video = handler.mapping[item][1]
        	self.auto_connect = handler.mapping[item][2]
        	self.http_server_port = handler.mapping[item][3]
        	
        if self.security_mode == "True" :
        	self.security_mode = True
        else :
        	self.security_mode = False
        	
        if self.watch_video == "True" :
        	self.watch_video = True
        else :
        	self.watch_video = False
        
        if self.auto_connect == "True" :
        	self.auto_connect = True
        else :
        	self.auto_connect = False
        

#Loadin foto for profile
def loading_profile_photo():
	global photo,home
	photo.set_from_file(home+"/speakers_photo.jpg")
	photo.show()
	
def resize_image(url = home+"/speakers_photo"):
        from settings import presenter_photo_size
        try:
            im1 = Image.open(url)
            im2 = im1.resize((presenter_photo_size, presenter_photo_size), Image.NEAREST)
            im2.save(url+".jpg")
            loading_profile_photo()
        except IOError, err:
            return 0
        return 1

if __name__ == "__main__":
	app = App()
	gtk.main()
