/*
 * src/Game/Sledder.cpp
 *
 * Copyright (C) 2009 Wilson Tang.
 *
 * This file is part of Slysics and is free software, distributed,
 * and licensed under the GNU General Public License, version 3.
 *
 * You should have received a copy of the GNU General Public License.
 * If not, see <http://www.gnu.org/licenses/gpl-3.0.html>.
*/

#include "Sledder.h"

Sledder::Sledder()
{
	visible = true;
	created = false;
	spawnX = -0.3f;
	spawnY = -0.6f;

	sledderBodyBody = NULL;
	sledderBodyBodyDef.position.Set( spawnX, spawnY );
	/*sledderBodyShapeDef.vertexCount = 4;
	sledderBodyShapeDef.vertices[0].Set( -0.55f, -0.75f );
	sledderBodyShapeDef.vertices[1].Set(  0.55f, -0.75f );
	sledderBodyShapeDef.vertices[2].Set(  0.55f, 0.75f );
	sledderBodyShapeDef.vertices[3].Set( -0.55f, 0.75f );*/
	sledderBodyShapeDef.SetAsBox( 0.55f, 0.75f );
	sledderBodyShapeDef.density = 1.0f;
	sledderBodyShapeDef.friction = 0.5f;
	sledderBodyShapeDef.filter.groupIndex = -1;
	type = 5;
	sledderBodyShapeDef.userData = (void*)type;


	sledderHeadBody = NULL;
	sledderHeadBodyDef.position.Set( spawnX, spawnY - 1.1f );
	/*sledderHeadShapeDef.vertexCount = 4;
	sledderHeadShapeDef.vertices[0].Set( -0.55f, -1.1f );
	sledderHeadShapeDef.vertices[1].Set(  0.55f, -1.1f );
	sledderHeadShapeDef.vertices[2].Set(  0.55f,  0.0f );
	sledderHeadShapeDef.vertices[3].Set( -0.55f,  0.0f );*/
	sledderHeadShapeDef.SetAsBox( 0.4f, 0.4f );
	sledderHeadShapeDef.density = 1.0f;
	sledderHeadShapeDef.friction = 0.5f;
	sledderHeadShapeDef.filter.groupIndex = -1;
	type = 5;
	sledderHeadShapeDef.userData = (void*)type;

	sledderHatBody = NULL;
	sledderHatBodyDef.position.Set( spawnX, spawnY - 1.6f );
	sledderHatShapeDef.vertexCount = 3;
	sledderHatShapeDef.vertices[0].Set(  0.0f, -0.3f );
	sledderHatShapeDef.vertices[1].Set(  0.45f, 0.3f );
	sledderHatShapeDef.vertices[2].Set( -0.45f, 0.3f );
	sledderHatShapeDef.density = 1.0f;
	sledderHatShapeDef.friction = 0.8f;
	type = 5;
	sledderHatShapeDef.userData = (void*)type;

	sledderLegBody = NULL;
	sledderLegBodyDef.position.Set( spawnX + 0.15f, spawnY + 1.15f );
	/*sledderLegShapeDef.vertexCount = 4;
	sledderLegShapeDef.vertices[0].Set( -0.4f, -0.15f );
	sledderLegShapeDef.vertices[1].Set(  0.1f, -0.15f );
	sledderLegShapeDef.vertices[2].Set(  0.1f,  1.35f );
	sledderLegShapeDef.vertices[3].Set( -0.4f,  1.35f );*/
	sledderLegShapeDef.SetAsBox( 0.3f, 0.75f );
	sledderLegShapeDef.density = 1.0f;
	sledderLegShapeDef.friction = 0.5f;
	sledderLegShapeDef.filter.groupIndex = -1;
	type = 5;
	sledderLegShapeDef.userData = (void*)type;

	sledderArmBody = NULL;
	sledderArmBodyDef.position.Set( spawnX + 0.05f, spawnY + 0.3 );
	/*sledderArmShapeDef.vertexCount = 4;
	sledderArmShapeDef.vertices[0].Set( -0.25f, -0.15f );
	sledderArmShapeDef.vertices[1].Set(  0.25f, -0.15f );
	sledderArmShapeDef.vertices[2].Set(  0.25f, 1.25f );
	sledderArmShapeDef.vertices[3].Set( -0.25f, 1.25f );*/
	sledderArmShapeDef.SetAsBox( 0.15f, 0.65f );
	sledderArmShapeDef.density = 1.0f;
	sledderArmShapeDef.friction = 0.5f;
	sledderArmShapeDef.filter.groupIndex = -1;
	type = 5;
	sledderArmShapeDef.userData = (void*)type;

	hatToHeadJoint = NULL;
	headToBodyJoint = NULL;
	armToBodyJoint = NULL;
	legToBodyJoint = NULL;
	armToSledJoint = NULL;
	legToSledJoint = NULL;
}

void Sledder::SetPositions( float x, float y, float angle )
{
	//spawnX = x - 0.3f;
	//spawnY = y - 0.6f;

	spawnX = ( ( -0.3f * cos( angle ) ) - ( -0.6f * sin( angle ) ) ) + x;
	spawnY = ( ( -0.3f * sin( angle ) ) + ( -0.6f * cos( angle ) ) ) + y;

	sledderBodyBodyDef.position.Set( spawnX, spawnY );
	sledderBodyBodyDef.angle = angle;

	headOffsetX = ( ( -0.3f * cos( angle ) ) - ( ( -0.6f - 1.1f ) * sin( angle ) ) ) + x;
	headOffsetY = ( ( -0.3f * sin( angle ) ) + ( ( -0.6f - 1.1f ) * cos( angle ) ) ) + y;

	headJointOffsetX = ( ( -0.3f * cos( angle ) ) - ( ( -0.6f - 0.55f ) * sin( angle ) ) ) + x;
	headJointOffsetY = ( ( -0.3f * sin( angle ) ) + ( ( -0.6f - 0.55f ) * cos( angle ) ) ) + y;

	sledderHeadBodyDef.position.Set( headOffsetX, headOffsetY );
	sledderHeadBodyDef.angle = angle;


	hatOffsetX = ( ( -0.3f * cos( angle ) ) - ( ( -0.6f - 1.6f ) * sin( angle ) ) ) + x;
	hatOffsetY = ( ( -0.3f * sin( angle ) ) + ( ( -0.6f - 1.6f ) * cos( angle ) ) ) + y;

	hatJointOffsetX = ( ( -0.3f * cos( angle ) ) - ( ( -0.6f - 1.5f ) * sin( angle ) ) ) + x;
	hatJointOffsetY = ( ( -0.3f * sin( angle ) ) + ( ( -0.6f - 1.5f ) * cos( angle ) ) ) + y;

	sledderHatBodyDef.position.Set( hatOffsetX, hatOffsetY );
	sledderHatBodyDef.angle = angle;

	float armX = ( ( ( -0.3f + 0.2f ) * cos( angle ) ) - ( ( -0.6f - 0.2f ) * sin( angle ) ) ) + x;
	float armY = ( ( ( -0.3f + 0.2f ) * sin( angle ) ) + ( ( -0.6f - 0.2f ) * cos( angle ) ) ) + y;

	armOffsetX = ( ( ( 0.0f ) * cos( angle - b2_pi / 3.0f ) ) ) - ( ( 0.5f ) * sin( angle - b2_pi / 3.0f ) ) + armX;
	armOffsetY = ( ( ( 0.0f ) * sin( angle - b2_pi / 3.0f ) ) ) + ( ( 0.5f ) * cos( angle - b2_pi / 3.0f ) ) + armY;

	armJointOffsetX = ( ( ( -0.3f ) * cos( angle ) ) - ( ( -0.6f - 0.25f ) * sin( angle ) ) ) + x;
	armJointOffsetY = ( ( ( -0.3f ) * sin( angle ) ) + ( ( -0.6f - 0.25f ) * cos( angle ) ) ) + y;

	sledderArmBodyDef.position.Set( armOffsetX, armOffsetY );
	sledderArmBodyDef.angle = angle - b2_pi / 3.0f;


	float legX = ( ( ( -0.3f + 0.3f ) * cos( angle ) ) - ( ( -0.6f + 0.4f ) * sin( angle ) ) ) + x;
	float legY = ( ( ( -0.3f + 0.3f ) * sin( angle ) ) + ( ( -0.6f + 0.4f ) * cos( angle ) ) ) + y;

	legOffsetX = ( ( ( 0.0f ) * cos( angle - b2_pi / 2.5f ) ) ) - ( ( 0.5f ) * sin( angle - b2_pi / 2.5f ) ) + legX;
	legOffsetY = ( ( ( 0.0f ) * sin( angle - b2_pi / 2.5f ) ) ) + ( ( 0.5f ) * cos( angle - b2_pi / 2.5f ) ) + legY;

	legJointOffsetX = ( ( ( -0.3f ) * cos( angle ) ) - ( ( -0.6f + 0.5f ) * sin( angle ) ) ) + x;
	legJointOffsetY = ( ( ( -0.3f ) * sin( angle ) ) + ( ( -0.6f + 0.5f ) * cos( angle ) ) ) + y;

	sledderLegBodyDef.position.Set( legOffsetX, legOffsetY );
	sledderLegBodyDef.angle = angle - b2_pi / 2.5f;


	armToSledJointOffsetX = ( ( ( -0.3f + 0.7f ) * cos( angle ) ) - ( ( -0.6f + 0.9f ) * sin( angle ) ) ) + x;
	armToSledJointOffsetY = ( ( ( -0.3f + 0.7f ) * sin( angle ) ) + ( ( -0.6f + 0.9f ) * cos( angle ) ) ) + y;

	legToSledJointOffsetX = ( ( ( -0.3f + 0.9f ) * cos( angle ) ) - ( ( -0.6f + 0.9f ) * sin( angle ) ) ) + x;
	legToSledJointOffsetY = ( ( ( -0.3f + 0.9f ) * sin( angle ) ) + ( ( -0.6f + 0.9f ) * cos( angle ) ) ) + y;


}

Sledder::~Sledder()
{
	sledderBodyBody = NULL;
	sledderHeadBody = NULL;
	sledderHatBody = NULL;
	sledderLegBody = NULL;
	sledderArmBody = NULL;
	headToBodyJoint = NULL;
	hatToHeadJoint = NULL;
	armToBodyJoint = NULL;
	legToBodyJoint = NULL;
	armToSledJoint = NULL;
	legToSledJoint = NULL;
}

void Sledder::InitializeSledder()
{
	bodyImage.LoadImage( "data/body.png" );
	headImage.LoadImage( "data/head.png" );
	legImage.LoadImage( "data/leg.png" );
	armImage.LoadImage( "data/arm.png" );
	hatImage.LoadImage( "data/hat.png" );
}

void Sledder::SetVelocity(b2Vec2 vel, float angVel )
{
	sledderBodyBody->SetLinearVelocity( vel );
	sledderHeadBody->SetLinearVelocity( vel );
	sledderArmBody->SetLinearVelocity( vel );
	sledderLegBody->SetLinearVelocity( vel );
	sledderHatBody->SetLinearVelocity( vel );

	sledderBodyBody->SetAngularVelocity( angVel );
	sledderHatBody->SetAngularVelocity( angVel );
	sledderHeadBody->SetAngularVelocity( angVel );
	sledderArmBody->SetAngularVelocity( angVel );
	sledderLegBody->SetAngularVelocity( angVel );
}

void Sledder::SetVisibility( bool co )
{
	visible = co;
}
