/*
 * src/Game/Sled.cpp
 *
 * Copyright (C) 2009 Wilson Tang.
 *
 * This file is part of Slysics and is free software, distributed,
 * and licensed under the GNU General Public License, version 3.
 *
 * You should have received a copy of the GNU General Public License.
 * If not, see <http://www.gnu.org/licenses/gpl-3.0.html>.
*/

#include "Sled.h"

Sled::Sled()
{
	created = false;
	spawnX = 0.0f;
	spawnY = 0.0f;
	sledBody = NULL;
	sledBodyDef.position.Set( spawnX, spawnY );


	sledShapeDef.vertexCount = 4;
	sledShapeDef.vertices[0].Set( -1.6f,  0.2f );
	sledShapeDef.vertices[1].Set(  1.25f, 0.2f );
	sledShapeDef.vertices[2].Set(  1.25f, 0.6f );
	sledShapeDef.vertices[3].Set( -2.0f,  0.6f );
	sledShapeDef.density = 1.0f;
	sledShapeDef.friction = 0.0f;
	sledShapeDef.filter.groupIndex = -1;
	type = 6;
	sledShapeDef.userData = (void*)type;

	sledFrontShape.radius = 0.6f;
	sledFrontShape.density = 1.0f;
	sledFrontShape.friction = 0.0f;
	sledFrontShape.localPosition.Set(1.25f, 0.0f);
	sledFrontShape.filter.groupIndex = -1;
	type = 6;
	sledFrontShape.userData = (void*)type;

	crumpled = false;

}

Sled::~Sled()
{
	sledBody = NULL;
}

void Sled::SetPositions(float x, float y, float angle)
{
	spawnX = x;
	spawnY = y;
	sledBodyDef.position.Set( spawnX, spawnY );
	sledBodyDef.angle = angle;
}

void Sled::InitializeSled()
{
	sledImage.LoadImage("data/sled.png");
	sledCrumpledImage.LoadImage("data/sledCrumpled.png");
}

void Sled::SetVelocity( b2Vec2 vel, float angVel )
{
	sledBody->SetLinearVelocity( vel );
	sledBody->SetAngularVelocity( angVel );
}

void Sled::SetCrumpled( bool co )
{
	crumpled = co;
	sledImage.SetVisible(false);
	sledCrumpledImage.SetVisible( true );
}

void Sled::ApplyImpulse( b2Vec2 impulse )
{
	sledBody->ApplyImpulse( impulse, sledBody->GetPosition() );
}
