#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QKeyEvent>
#include <QDesktopWidget>
#include <QDBusInterface>
#include <QDebug>
#include <QDBusConnection>
#include <QTimer>

#include "ui_mainwindow.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

private:
    Ui::MainWindow *ui;
    void closeEvent(QCloseEvent *);
    void reject();
    void connectSignals();
    void setIcons();

private slots:
    void orientationChanged();
    void setAtom();
    void onCallReceived(const QDBusMessage &);
    void acceptCall();
    void rejectCall();
    void onAnswerSliderChanged(int);
    void onRejectSliderChanged(int);
    void onAnswerSliderReleased();
    void onRejectSliderReleased();
};

#endif // MAINWINDOW_H
