#include "mainwindow.h"

#ifdef Q_WS_MAEMO_5
#include <QtGui/QX11Info>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <libintl.h>
#endif

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    setWindowFlags(Qt::WindowStaysOnTopHint | Qt::Dialog);
    setAttribute(Qt::WA_Maemo5AutoOrientation);
    setAttribute(Qt::WA_OpaquePaintEvent);
    this->setIcons();
    this->setWindowTitle(" ");
    this->connectSignals();
    this->setAtom();
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::setIcons()
{
    ui->avatarLabel->setPixmap(QPixmap("/usr/share/icons/hicolor/96x96/hildon/general_default_avatar.png"));
    ui->silentButton->setIcon(QIcon::fromTheme("call_speaker_muted"));
    ui->smsButton->setIcon(QIcon::fromTheme("general_sms"));
}

void MainWindow::connectSignals()
{
    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));
    connect(ui->answerSlider, SIGNAL(sliderMoved(int)), this, SLOT(onAnswerSliderChanged(int)));
    connect(ui->rejectSlider, SIGNAL(sliderMoved(int)), this, SLOT(onRejectSliderChanged(int)));
    connect(ui->answerSlider, SIGNAL(sliderReleased()), this, SLOT(onAnswerSliderReleased()));
    connect(ui->rejectSlider, SIGNAL(sliderReleased()), this, SLOT(onRejectSliderReleased()));

    QDBusConnection::systemBus().connect("com.nokia.csd.Call",
                                         "/com/nokia/csd/call",
                                         "com.nokia.csd.Call",
                                         "Coming", this, SLOT(onCallReceived(const QDBusMessage &)));
    QDBusConnection::systemBus().connect("com.nokia.csd.Call",
                                         "/com/nokia/csd/call/1",
                                         "com.nokia.csd.Call.Instance",
                                         "Terminated", this, SLOT(hide()));
}

void MainWindow::onAnswerSliderReleased()
{
    if(ui->answerSlider->value() != ui->answerSlider->maximum())
        ui->answerSlider->setValue(ui->answerSlider->minimum());
}

void MainWindow::onRejectSliderReleased()
{
    if(ui->rejectSlider->value() != ui->rejectSlider->maximum())
        ui->rejectSlider->setValue(ui->rejectSlider->minimum());
}

void MainWindow::closeEvent(QCloseEvent *event)
{
    event->ignore();
    this->activateWindow();
}

void MainWindow::orientationChanged()
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
    if (screenGeometry.width() > screenGeometry.height()) {
        ui->horizontalLayout_4->setDirection(QBoxLayout::LeftToRight);
        ui->spacer->show();
        this->setWindowState(Qt::WindowMaximized);
        this->activateWindow();
    } else {
        ui->spacer->hide();
        ui->numberLabel->setAlignment(Qt::AlignCenter);
        ui->horizontalLayout_4->setDirection(QBoxLayout::TopToBottom);
        this->setWindowState(Qt::WindowFullScreen);
    }
}

void MainWindow::setAtom()
{
    quint32 enable = {9};
    Atom winStackingAtom = XInternAtom(QX11Info::display(), "_HILDON_STACKING_LAYER", false);
    XChangeProperty(QX11Info::display(), winId(), winStackingAtom, XA_CARDINAL, 32, PropModeReplace, (uchar*) &enable, 1);
}

void MainWindow::onCallReceived(const QDBusMessage &message)
{
    QString number;
    number = message.arguments()[1].toString();
    if (number.isEmpty())
#ifdef Q_WS_MAEMO_5
        number.append(dgettext("rtcom-call-ui", "voip_fi_caller_information_unknown_caller"));
#else
        number.append(tr("Unknown number"));
#endif
    ui->numberLabel->setText(number);
    this->show();
}

void MainWindow::acceptCall()
{
    QDBusInterface accept("com.nokia.csd.Call",
                          "/com/nokia/csd/call/1",
                          "com.nokia.csd.Call.Instance",
                          QDBusConnection::systemBus(), this);
    accept.call("Answer");
    this->hide();
}

void MainWindow::rejectCall()
{
    QDBusInterface reject("com.nokia.csd.Call",
                          "/com/nokia/csd/call",
                          "com.nokia.csd.Call",
                          QDBusConnection::systemBus(), this);
    reject.call("Release");
    this->hide();
}

void MainWindow::onAnswerSliderChanged(int value)
{
    if (value == ui->answerSlider->maximum())
        this->acceptCall();
}

void MainWindow::onRejectSliderChanged(int value)
{
    if (value == ui->rejectSlider->maximum())
        this->rejectCall();
}
