/*
 *  slide2answer channel handler
 *  Copyright (C) 2011 Nicolai Hess
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <glib.h>
#include <string.h>
#include "slide2answer_channel_handler.h"

#include <telepathy-glib/interfaces.h>
#include <telepathy-glib/gtypes.h>
#include <telepathy-glib/channel-dispatch-operation.h>
#include <telepathy-glib/svc-generic.h>
#include <telepathy-glib/svc-client.h>
#include <telepathy-glib/dbus.h>
#include <telepathy-glib/defs.h>
#include <telepathy-glib/handle.h>
#include <telepathy-glib/connection.h>
#include <telepathy-glib/channel.h>



static void handler_iface_init(gpointer, gpointer);

#define SLIDE2ANSWER_CHANNEL_HANDLER_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE((obj), TYPE_SLIDE2ANSWER_CHANNEL_HANDLER, Slide2AnswerChannelHandlerPrivate))

struct _Slide2AnswerChannelHandlerPrivate
{
  GPtrArray* filter;
};

G_DEFINE_TYPE_WITH_CODE (Slide2AnswerChannelHandler, slide2answer_channel_handler, G_TYPE_OBJECT,
			G_IMPLEMENT_INTERFACE(TP_TYPE_SVC_DBUS_PROPERTIES,
					      tp_dbus_properties_mixin_iface_init);
			G_IMPLEMENT_INTERFACE(TP_TYPE_SVC_CLIENT, NULL);
			G_IMPLEMENT_INTERFACE(TP_TYPE_SVC_CLIENT_HANDLER, handler_iface_init);
			);

static const char* client_interfaces[] = 
  {
    TP_IFACE_CLIENT_HANDLER, 
    NULL
  };

enum
{
  PROP_0,
  PROP_INTERFACES,
  PROP_CHANNEL_FILTER,
  PROP_BYPASS_APPROVAL,
  PROP_HANDLED_CHANNELS,
  PROP_HANDLE_CHANNELS_CB
};

static void
slide2answer_channel_handler_get_property(GObject* self,
				      guint property_id,
				      GValue* value,
				      GParamSpec* pspec)
{
  switch (property_id)
    {
    case PROP_INTERFACES:
      g_value_set_boxed (value, client_interfaces);
      break;

    case PROP_CHANNEL_FILTER:
      g_value_set_boxed (value, SLIDE2ANSWER_CHANNEL_HANDLER(self)->priv->filter);

      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (self, property_id, pspec);
      break;
    }
}

static void
slide2answer_channel_handler_finalize(GObject* object)
{
  Slide2AnswerChannelHandler* self = SLIDE2ANSWER_CHANNEL_HANDLER(object);
  g_boxed_free(TP_ARRAY_TYPE_CHANNEL_CLASS_LIST, self->priv->filter);
  G_OBJECT_CLASS(slide2answer_channel_handler_parent_class)->finalize(object);
}

static void
slide2answer_channel_handler_class_init(Slide2AnswerChannelHandlerClass* klass)
{
  GObjectClass* object_class = G_OBJECT_CLASS(klass);
  object_class->get_property = slide2answer_channel_handler_get_property;
  object_class->finalize = slide2answer_channel_handler_finalize;
  g_type_class_add_private(klass, sizeof(Slide2AnswerChannelHandlerPrivate));
  
  static TpDBusPropertiesMixinPropImpl client_props[] = {
    {"Interfaces", "interfaces", NULL},
    {NULL}
  };
  
  static TpDBusPropertiesMixinPropImpl client_handler_props[] = {
        { "HandlerChannelFilter", "channel-filter", NULL },
        { "BypassApproval", "bypass-approval", NULL },
        { "HandledChannels", "handled-channels", NULL },
        { NULL }
  };

  static TpDBusPropertiesMixinIfaceImpl prop_interfaces[] = {
    {TP_IFACE_CLIENT,
     tp_dbus_properties_mixin_getter_gobject_properties,
     NULL,
     client_props
    },
    {TP_IFACE_CLIENT_HANDLER,
     tp_dbus_properties_mixin_getter_gobject_properties,
     NULL,
     client_handler_props
    },
    {NULL}
  };
  
  g_object_class_install_property(object_class, PROP_INTERFACES,
				  g_param_spec_boxed("interfaces",
						     "Interfaces",
						     "Available D-Bus Interfaces",
						     G_TYPE_STRV,
						     G_PARAM_READABLE | G_PARAM_STATIC_STRINGS));
  
  g_object_class_install_property(object_class, PROP_CHANNEL_FILTER,
				  g_param_spec_boxed("channel-filter",
						     "Channel Filter",
						     "Filter for channels we want to handle",
						     TP_ARRAY_TYPE_CHANNEL_CLASS_LIST,
						     G_PARAM_READABLE | G_PARAM_STATIC_STRINGS));
  
  g_object_class_install_property(object_class, PROP_BYPASS_APPROVAL,
				  g_param_spec_boxed("bypass-approval",
						     "Bypass Approval",
						     "Whether we should bypass the approver",
						     FALSE,
						     G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
  
  g_object_class_install_property (object_class, PROP_HANDLED_CHANNELS,
				   g_param_spec_boxed ("handled-channels",
						       "Handled Channels",
						       "List of channels we're handling",
						       TP_ARRAY_TYPE_OBJECT_PATH_LIST,
						       G_PARAM_READABLE));
  
  g_object_class_install_property (object_class, PROP_HANDLE_CHANNELS_CB,
				   g_param_spec_pointer ("handle-channels-cb",
							 "Handle Channels Callback",
							 "Callback to pass HandleChannels to",
							 G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
  
  klass->dbus_props_class.interfaces = prop_interfaces;
  tp_dbus_properties_mixin_class_init(object_class,
				      G_STRUCT_OFFSET(Slide2AnswerChannelHandlerClass, dbus_props_class));

}

static void
slide2answer_channel_handler_handle_channels (TpSvcClientHandler   *self,
					      const char            *account_path,
					      const char            *connection_path,
					      const GPtrArray       *channels,
					      const GPtrArray       *requests_satisfied,
					      guint64                user_action_time,
					      GHashTable            *handler_info,
					      DBusGMethodInvocation *context)
{
  g_warning("account %s\n", account_path);
  g_warning("connection path %s\n", connection_path);
}

static void
slide2answer_channel_handler_init(Slide2AnswerChannelHandler* self)
{
  self->priv = SLIDE2ANSWER_CHANNEL_HANDLER_GET_PRIVATE(self);
  self->priv->filter = g_ptr_array_new();
  GHashTable* asv = tp_asv_new(TP_IFACE_CHANNEL ".ChannelType",
			       G_TYPE_STRING, "org.freedesktop.Telepathy.Channel.Type.StreamedMedia",
			       NULL);
  g_ptr_array_add(self->priv->filter, asv);
}


static void
handler_iface_init(gpointer g_iface, gpointer iface_data)
{
  TpSvcClientHandlerClass* klass = (TpSvcClientHandlerClass*)g_iface;
#define IMPLEMENT(x) tp_svc_client_handler_implement_##x (klass, \
    slide2answer_channel_handler_##x)
  IMPLEMENT (handle_channels);
#undef IMPLEMENT
}

Slide2AnswerChannelHandler*
slide2answer_channel_handler_new(void)
{
  return g_object_new(TYPE_SLIDE2ANSWER_CHANNEL_HANDLER, NULL);
}
