/*
 *  slide2answer channel handler
 *  Copyright (C) 2011 Nicolai Hess
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef _SLIDE2ANSWER_CHANNEL_HANDLER_H_
#define _SLIDE2ANSWER_CHANNEL_HANDLER_H_
#include <glib-object.h>
#include <glib.h>
#include <telepathy-glib/interfaces.h>
#include <telepathy-glib/gtypes.h>
#include <telepathy-glib/channel-dispatch-operation.h>
#include <telepathy-glib/svc-generic.h>
#include <telepathy-glib/svc-client.h>
#include <telepathy-glib/dbus.h>
#include <telepathy-glib/defs.h>
#include <telepathy-glib/handle.h>
#include <telepathy-glib/connection.h>
#include <telepathy-glib/channel.h>



G_BEGIN_DECLS

#define TYPE_SLIDE2ANSWER_CHANNEL_HANDLER (slide2answer_channel_handler_get_type())
#define SLIDE2ANSWER_CHANNEL_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_SLIDE2ANSWER_CHANNEL_HANDLER, Slide2AnswerChannelHandler))
#define SLIDE2ANSWER_CHANNEL_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_SLIDE2ANSWER_CHANNEL_HANDLER, Slide2AnswerChannelHandlerClass))
#define IS_SLIDE2ANSWER_CHANNEL_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_SLIDE2ANSWER_CHANNEL_HANDLER))
#define IS_SLIDE2ANSWER_CHANNEL_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_SLIDE2ANSWER_CHANNEL_HANDLER))
#define SLIDE2ANSWER_CHANNEL_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_SLIDE2ANSWER_CHANNEL_HANDLER, Slide2AnswerChannelHandlerClass))

#define SLIDE2ANSWER_CHANNEL_HANDLER_NAME "Slide2AnswerChannelHandler"
typedef struct _Slide2AnswerChannelHandler Slide2AnswerChannelHandler;
typedef struct _Slide2AnswerChannelHandlerClass Slide2AnswerChannelHandlerClass;
typedef struct _Slide2AnswerChannelHandlerPrivate Slide2AnswerChannelHandlerPrivate;

struct _Slide2AnswerChannelHandler
{
  GObject parent;
  Slide2AnswerChannelHandlerPrivate* priv;
};

struct _Slide2AnswerChannelHandlerClass
{
  GObjectClass parent_class;
  TpDBusPropertiesMixinClass dbus_props_class;
};

GType slide2answer_channel_handler_get_type(void);

Slide2AnswerChannelHandler* slide2answer_channel_handler_new(void);

void slide2answer_channel_handler_set_block_list(Slide2AnswerChannelHandler* self, const gchar* account_name, GSList* block_list);
void slide2answer_channel_handler_set_active(Slide2AnswerChannelHandler* self, gboolean active);

G_END_DECLS

#endif
