#!/usr/bin/env python2.5
# -*- coding: utf-8 -*-
#
# 
# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#
# ============================================================================
# Name        : sleeppy.py
# Author      : Vadim Karpusenko < vadikus gmail com >
# Version     : 0.1
# Description : Python Hildon SleepPy Patterns
# ============================================================================
#
# ToDo:
# - show current statustics, plot, etc.
# - time interval sec, min...
# - Options change.
# - reverse linear threshold at the alarm window
# - start counting duration only after deep phase sleep (optional)
# - bugfix: gst custom mp3 alarm play
# - make smart snooze
#
# ToDo 15 apr:
# - Translate in the propper way, use Russian as default 
# - Statistics window:
#   - plot
#   - deep phase sleep analysis
#   - how long was felling asleep
#   - total time
# - main window
#   - time intervals before start
#   - current statistics while running
#   - plotting accelerometr
# - options window
#
# - combine video presentation
# - Write about SleepPy on habrahabr.ru
# - wtite on fruict.ru
# - register program on garage
# - register in contest
# - send email with links

from __future__ import with_statement
import gtk 
import hildon
import ConfigParser
import os, os.path
import datetime
import time
#import pygst
#import gst
import alarm
import gobject
import gettext
import locale
import math


APP_NAME = "SleepPy"
gettext.install(APP_NAME)

# TODO: migrate to gettext
#local_path = os.path.realpath(os.path.dirname(sys.argv[0]))
## Init the list of languages to support
#langs = []
##Check the default locale
#lc, encoding = locale.getdefaultlocale()
#if (lc):
#    #If we have a default, it's the first in the list
#    langs = [lc]
## Now lets get all of the supported languages on the system
#language = os.environ.get('LANGUAGE', None)
#if (language):
#    """langage comes back something like en_CA:en_US:en_GB:en
#    on linuxy systems, on Win32 it's nothing, so we need to
#    split it up into a list"""
#    langs += language.split(":")
#"""Now add on to the back of the list the translations that we
#know that we have, our defaults"""
#langs += ["ru_RU", "en_US"]
#
#"""Now langs is a list of all of the languages that we are going
#to try to use.  First we check the default, then what the system
#told us, and finally the 'known' list"""
#
#gettext.bindtextdomain(APP_NAME, self.local_path)
#gettext.textdomain(APP_NAME)
## Get the language to use
#self.lang = gettext.translation(APP_NAME, self.local_path
#    , languages=langs, fallback = True)
#"""Install the language, map _() (which we marked our
#strings to translate with) to self.lang.gettext() which will
#translate them."""
#_ = self.lang.gettext


defdir = '/home/user/MyDocs/sleeppy'
config = ConfigParser.SafeConfigParser()
if os.path.exists(defdir):
    if os.path.exists(defdir+'/sleeppy.cfg'):
        config.read(defdir+'/sleeppy.cfg')
else:
    config.add_section('user')
    #config.set('user', 'mp3', '/home/user/MyDocs/al.mp3')
    config.set('user', 'fileformat', defdir+'/sleeppy-$04d.log')
    config.set('user', 'index', '2')
    config.set('user', 'alarm', '8:00')
    config.set('user', 'window', '15')
    config.set('user', 'duration',  '7.5')
    config.set('user', 'used_durations',  '7.5 7.0')
    config.set('user', 'duration_or_alarm', 'duration')
    config.set('user', 'language', 'eng')
    config.set('user', 'alarm_threshold', '100')
    config.set('user', 'alarm_play_time_sec', '60')
    #config.set('user', 'snooze_time_min', '10')
    config.set('user', 'accelerometr_threshold', '100')
    config.set('user', 'deep_sleep', '10.0')
    
    config.add_section('tech')
    config.set('tech', 'average', '100')
    config.set('tech', 'accelerometr', "/sys/class/i2c-adapter/i2c-3/3-001d/coord")
    config.set('tech', 'pause', '0.01')
    
    config.add_section('rus')
    config.add_section('eng')
    config.set('rus', 'name', u'Мониторинг Сна')
    config.set('eng', 'name', 'SleepPy Patterns')
    config.set('rus', 'button_alarm', u"""Нажмите для начала записи статистики.""")
    config.set('eng', 'button_alarm', """Click here to start gethering statistics""")
    config.set('rus', 'button_alarm_stop', u'Нажмите опять для остановки сбора статистики\nЗапись идёт в файл:\n')
    config.set('eng', 'button_alarm_stop', 'Press to stop statistics gethering\nLoggin to the file:\n') 
    config.set('rus', 'alarm_title', u'Будильник для лучшего просыпания')
    config.set('eng', 'alarm_title', 'Alarm for easier wake up')
    config.set('rus', 'hours', u" часов")
    config.set('eng', 'hours', ' hours')
    config.set('rus', 'button_duration', u"Задать длительность сна")
    config.set('eng', 'button_duration', 'Set sleep duration')
    config.set('rus', 'button_time', u"Задать время подъёма")
    config.set('eng', 'button_time', 'Set alarm time')
    config.set('rus', 'statistics', u"Статистика")
    config.set('eng', 'statistics', 'Statistics')
    config.set('rus', 'button_statistics', u"Данные о качестве сна")
    config.set('eng', 'button_statistics', 'Sleep quality data')
    config.set('rus', 'wake_up', u'Просыпайся! Покажи миру на что ты способен!')
    config.set('eng', 'wake_up', 'Wake Up! Go, get them, Tiger!')
    config.set('rus', 'stop', u'Отключить')
    config.set('eng', 'stop', 'Stop')
    config.set('rus', 'snooze', u'Подремать')
    config.set('eng', 'snooze', 'Snooze')
    config.set('rus', 'minutes', u'мин.')
    config.set('eng', 'minutes', 'min')
    config.set('rus', 'time_button', u'Время обязательного подъёма')
    config.set('eng', 'time_button', 'Required wake up time')
    config.set('rus', 'interval_lable', u'Временной интервал пробуждения (в минутах)')
    config.set('eng', 'interval_lable', 'Wake up time interval (minutes)')
    config.set('rus', 'duration', u'Необходимая длительность сна (в часах)')
    config.set('eng', 'duration', 'Required sleep duration (hours)')        

    os.mkdir(defdir)
    with open(defdir+'/sleeppy-0001.log', 'w') as f:
        f.write("""# 2010-04-14 23:04:36
  0.0036 477.000
  0.0044 437.454
  0.0047 145.115
  0.0050 191.915
  0.0053 126.466
  0.0056 468.179
  0.0058 144.553
  0.0064 398.064
  0.0072 381.072
  0.0072 227.703
  0.0075 389.077
  0.0078 319.221
  0.0081 816.285
  0.0097 619.848
  0.0117 266.352
  0.0119 702.015
  0.0122 263.296
  0.0125 122.756
  0.1103 110.604
  0.1108 485.935
  0.1111 189.630
  0.1114 327.724
  0.1117 190.806
  0.1119 136.293
  0.1122 222.404
  0.1125 395.129
  0.1142 117.478
  0.1142 113.357
  0.1150 100.339
  0.1153 180.934
  0.1228 245.912
  0.1233 226.968
  0.1481 139.675
  0.1539 202.119
  0.1544 105.050
  0.1553 179.047
  0.1561 319.761
  0.1561 146.166
  0.1567 109.979
  0.1567 104.180
  0.1569 125.877
  0.1572 258.478
  0.1578 135.685
  0.1578 126.383
  0.1581 409.679
  0.1617 151.794
  0.1617 122.863
  0.1622 128.936
  0.1644 113.949
  0.1681 208.148
  0.1681 133.204
  0.2139 101.445
  0.2142 206.882
  0.2147 109.847
  0.2147 363.736
  0.2150 168.608
  0.2153 118.567
  0.2350 239.624
  0.2353 111.103
  0.2356 154.303
  0.2358 118.504
  0.2361 403.868
  0.2364 554.143
  0.2367 264.115
  0.2378 108.070
  0.2492 252.132
  0.2494 123.821
  0.2808 153.079
  0.2822 204.350
  0.2833 190.846
  0.2994 238.063
  0.2994 304.000
  0.2997 216.643
  0.3547 257.165
  0.3553 131.229
  0.3556 524.882
  0.3558 189.801
  0.3561 617.686
  0.3564 499.531
  0.3567 195.625
  0.3572 220.668
  0.3572 141.055
  0.3575 153.888
  0.3578 187.096
  0.3581 103.926
  0.3586 422.564
  0.3586 176.073
  1.3975 141.297
  1.3983 105.663
  1.3997 101.582
  1.4000 184.671
  1.4003 265.141
  1.4014 164.196
  1.6897 162.004
  2.2986 109.606
  2.7250 207.490
  2.7253 108.910
  2.7269 105.284
  2.7275 112.255
  2.7275 111.028
  2.7278 222.023
  2.7289 167.154
  2.7289 273.436
  2.7297 197.673
  2.7317 115.853
  2.7317 161.100
  2.7319 408.176
  3.3139 264.244
  3.4225 143.187
  3.4231 140.608
  3.4233 378.161
  3.4236 270.024
  3.4239 432.009
  3.4242 414.052
  3.4244 576.612
  3.4247 372.385
  3.4250 402.070
  3.4253 207.429
  3.4256 539.099
  3.4769 147.149
  3.5094 447.788
  3.5225 199.098
  3.6678 234.009
  3.6681 516.545
  3.7981 119.863
  3.7983 124.073
  3.7986 102.917
  4.3708 227.677
  4.3708 161.026
  4.3711 581.570
  4.3714 472.430
  4.6567 267.436
  4.6569 158.687
  4.6581 358.597
  4.9317 187.530
  4.9319 144.798
  4.9911 119.660
  4.9914 138.610
  4.9919 129.333
  5.0878 130.495
  5.0881 115.482
  5.0883 399.418
  5.0886 150.488
  5.4989 179.209
  5.4994 439.709
  5.4997 365.170
  5.8442 332.959
  6.2231 443.551
  6.2497 380.463
  6.2683 156.777
  6.3931 175.355
  6.3939 105.529
  6.3942 101.131
  6.3944 101.707
  6.3947 106.582
  6.3950 397.914
  6.3953 1302.469
  6.3956 1067.468
  7.1125 118.404
  7.4864 295.324
  7.4978 102.650
  7.4986 107.179
  7.4986 155.057
  7.4989 370.962
  7.7369 284.962
  7.7369 249.755
  7.7375 132.127
  7.8172 153.477
  7.9356 121.858
  7.9369 146.673
  7.9372 827.187
  7.9375 315.333
  7.9378 263.045
  7.9381 623.806
  7.9383 364.351
  7.9386 208.922
  7.9389 1172.658
  7.9392 409.733
  7.9394 561.339
  7.9397 395.542
  7.9986 112.599
  8.1503 123.452
  8.1511 173.403
  8.1514 431.316
  8.1517 237.259
  8.2122 170.749
  8.2128 328.002
  8.2128 132.886
  8.2133 193.815
  8.2136 456.281
  8.2139 399.140
  8.2939 167.370
  8.2942 109.546
  8.2944 141.935
  8.2950 109.126
  8.2950 789.141
  8.3844 530.187
  8.3847 294.117
  8.3850 134.648
  8.3853 144.186
  8.3856 458.676
  8.5161 364.420
  8.5164 152.787
  8.5178 200.644
  8.5181 455.643
  8.5183 346.956
  9.0228 158.601
  9.0231 405.579
  9.1561 136.069
  9.2781 517.708
  9.2783 152.842
  9.2794 121.035
  9.2803 102.471
  9.2806 183.141
  9.2808 195.533
  9.3631 104.296
  9.3639 190.749
  9.3642 129.331
  9.4869 107.945
  9.4875 226.479
  9.4875 132.147
  9.4878 845.868
  9.4881 668.945
  9.4883 176.560
  9.4886 187.322
  9.5761 216.211
  9.5764 174.786
  9.5767 117.623
  9.7289 106.999
  9.7292 134.097
  9.7306 101.598
  9.7311 127.112
  9.7317 283.058
  9.7319 170.815
  9.7322 182.226
  9.7325 483.905
  9.7328 250.508
  9.7331 167.153
  9.7333 423.180
  9.7336 416.933
  9.7339 934.469
  9.7344 444.880
  9.9247 134.694
  9.9261 117.198
  9.9264 584.951
 10.5989 237.638 """)

border = 2
    
class SleepPyPatterns(hildon.Program):
    def __init__(self):
        hildon.Program.__init__(self)

        self.window = hildon.StackableWindow()
        self.window.connect("delete_event", self.quit)  
        self.add_window(self.window)
        
        self.lang = config.get('user', 'language')
        gtk.set_application_name(config.get(self.lang, 'name'))
        
        vbox = gtk.VBox(False, border)
        vbox.set_border_width(border)
        self.window.add(vbox)
        vbox.show()
        
        box1 = gtk.HBox(True, border)
        box1.set_border_width(border)
        vbox.pack_start(box1, True, False, border)
        box1.show()
        
        separator = gtk.HSeparator()
        vbox.pack_start(separator, False, False, border)
        separator.show()
        
        box2 = gtk.HBox(True, border)
        box2.set_border_width(border)
        vbox.pack_start(box2, True, False, border)
        box2.show()
        
        self.button_alarm = hildon.Button(gtk.HILDON_SIZE_AUTO, 
                               hildon.BUTTON_ARRANGEMENT_VERTICAL, 
                               config.get(self.lang, 'alarm_title'),
                               config.get(self.lang, 'button_alarm') 
                               )
        #button_alarm.set_style(hildon.BUTTON_STYLE_PICKER)
        self.button_alarm.connect('pressed', self.main)
        
        box1.pack_start(self.button_alarm, False, False, 0)
        self.button_alarm.show()

        self.button_duration = hildon.Button(gtk.HILDON_SIZE_THUMB_HEIGHT, 
                               hildon.BUTTON_ARRANGEMENT_VERTICAL, 
                               config.get('user', 'duration')+' '+config.get(self.lang, 'hours'), 
                               config.get(self.lang, 'button_duration'))
        self.button_duration.connect('clicked', self.duration_dialog)
        
        self.button_time = hildon.Button(gtk.HILDON_SIZE_THUMB_HEIGHT, 
                               hildon.BUTTON_ARRANGEMENT_VERTICAL, 
                               config.get('user', 'alarm'), 
                               config.get(self.lang, 'button_time'))
        self.button_time.connect('clicked', self.time_dialog)

        self.button_statistics = hildon.Button(gtk.HILDON_SIZE_THUMB_HEIGHT, 
                               hildon.BUTTON_ARRANGEMENT_VERTICAL, 
                               config.get(self.lang, 'statistics'),
                               config.get(self.lang, 'button_statistics'))
        self.button_statistics.connect("clicked", self.test_win)#self.show_stat_window)
        
        image_statistics = gtk.image_new_from_stock(gtk.STOCK_EXECUTE, gtk.ICON_SIZE_BUTTON)
        self.button_statistics.set_image(image_statistics)
        self.button_statistics.set_image_position(gtk.POS_RIGHT)
    
        
        box2.pack_start(self.button_duration, False, True, 0)
        box2.pack_start(self.button_time, False, True, 0)
        box2.pack_start(self.button_statistics, False, True, 0)
        self.button_duration.show()
        self.button_time.show()
        self.button_statistics.show()
        
        self.alarm_running = False
    
    def test_win(self, wiget):
        # Create a new backing pixmap of the appropriate size
        def configure_event(widget, event):
            global pixmap

            gc = widget.window.new_gc()
            gc.set_rgb_fg_color(gtk.gdk.color_parse("#222222"))
            x, y, width, height = widget.get_allocation()
            pixmap = gtk.gdk.Pixmap(widget.window, width, height)
            pixmap.draw_rectangle(gc, #widget.get_style().white_gc,
                                  True, 0, 0, width, height)
        
            return True
        
        # Redraw the screen from the backing pixmap
        def expose_event(widget, event):
            x , y, width, height = event.area
            widget.window.draw_drawable(widget.get_style().fg_gc[gtk.STATE_NORMAL],
                                        pixmap, x, y, x, y, width, height)
            return False
        
        # Draw a rectangle on the screen
        def draw_brush(widget, x, y):
            
            gc = widget.window.new_gc()
            gc.set_rgb_fg_color(gtk.gdk.color_parse("#AAAAAA"))

            rect = (int(x-5), int(y-5), 10, 10)
            pixmap.draw_rectangle(gc, #widget.get_style().bg_gc, 
                                  True,
                                  rect[0], rect[1], rect[2], rect[3])
            widget.queue_draw_area(rect[0], rect[1], rect[2], rect[3])

        def draw_stripe(widget, width, x, y):
            
            gc = widget.window.new_gc()
            gc.set_rgb_fg_color(gtk.gdk.Color(y, y, y, 0))

            rect = (int(x-width), 0, int(width)+1, 500)
            pixmap.draw_rectangle(gc, #widget.get_style().bg_gc, 
                                  True,
                                  rect[0], rect[1], rect[2], rect[3])
            widget.queue_draw_area(rect[0], rect[1], rect[2], rect[3])

        def draw_line(widget, x, y):
            
            gc = widget.window.new_gc()
            gc.set_rgb_fg_color(gtk.gdk.color_parse("#555555"))

            rect = (int(x-1), int(y), 3, 500)
            pixmap.draw_rectangle(gc, #widget.get_style().bg_gc, 
                                  True,
                                  rect[0], rect[1], rect[2], rect[3])
            widget.queue_draw_area(rect[0], rect[1], rect[2], rect[3])

#            gc = widget.window.new_gc()
#            gc.set_rgb_fg_color(gtk.gdk.color_parse("#AAAAAA"))
#
#            rect = (int(x-5), int(y-5), 10, 10)
#            pixmap.draw_rectangle(gc, #widget.get_style().bg_gc, 
#                                  True,
#                                  rect[0], rect[1], rect[2], rect[3])
#            widget.queue_draw_area(rect[0], rect[1], rect[2], rect[3])
        
#        def button_press_event(widget, event):
#            if event.button == 1 and pixmap != None:
#                draw_brush(widget, event.x, event.y)
#            return True
#        
#        def motion_notify_event(widget, event):
#            if event.is_hint:
#                x, y, state = event.window.get_pointer()
#            else:
#                x = event.x
#                y = event.y
#                state = event.state
#        
#            if state & gtk.gdk.BUTTON1_MASK and pixmap != None:
#                draw_brush(widget, x, y)
#        
#            return True            

        window = hildon.StackableWindow()
        window.set_title(config.get(self.lang, 'statistics'))
        hildon.hildon_gtk_window_set_progress_indicator(window, 1)
        label = gtk.Label(config.get(self.lang, 'button_statistics'))
        vbox = gtk.VBox(True, 0)
        vbox.pack_start(label, True, True, 0)
        vbox.pack_start(gtk.HSeparator(), False, False, border)
        window.add(vbox)
        vbox.show()
        plots, labels, data, times = [], [], [], []
        plot_max = 0
        filename = config.get('user', 'fileformat').replace('$', '%')
        for i in range(config.getint('user', 'index')):
            if os.path.exists(filename%i):
                plot_max += 1
        plot_max = min(4, plot_max)
        for i in range(plot_max):
            data.append([])
            times.append([])
            
            label = gtk.Label()
            label.set_alignment(0, 0)
            vbox.pack_start(label, False, False, 0)
            labels.append(label)
            
            drawing_area = gtk.DrawingArea()
            drawing_area.set_size_request(800, 200)
            vbox.pack_start(drawing_area, False, True, 0)
            plots.append(drawing_area)
        
            drawing_area.show()

            # Signals used to handle backing pixmap
            drawing_area.connect("expose_event", expose_event)
            drawing_area.connect("configure_event", configure_event)
        
            # Event signals
#            drawing_area.connect("motion_notify_event", motion_notify_event)
#            drawing_area.connect("button_press_event", button_press_event)
        
            drawing_area.set_events(gtk.gdk.EXPOSURE_MASK
                                    | gtk.gdk.LEAVE_NOTIFY_MASK
                                    | gtk.gdk.BUTTON_PRESS_MASK
                                    | gtk.gdk.POINTER_MOTION_MASK
                                    | gtk.gdk.POINTER_MOTION_HINT_MASK)
    
            vbox.pack_start(gtk.HSeparator(), False, False, border)        
        window.show_all()

        num = config.getint('user', 'index')
        for i in range(plot_max):
            while gtk.events_pending():
                gtk.main_iteration(False)
            while not os.path.exists(filename%num):
                num -= 1
            x, y, width, height = plots[i].get_allocation()
            with open(filename%num, 'r') as file:
                for line in file:
                    if line[0] == '#':
                        labels[i].set_text(labels[i].get_text()+' '+line[1:].strip())
                    else:
                        try:
                            t, shake = [float(x) for x in line.split()]
                        except:
                            pass
                        data[i].append(shake)
                        times[i].append(t)
                        
            deep_sleep_time = 0.0
            fell_asleep = 0.0
            ds = config.getfloat('user', 'deep_sleep')/60.0
            if len(times[i]) >2:
                for j in range(len(times[i])-1):
                    dt = times[i][j+1]-times[i][j]                
                    if dt>ds:
                        deep_sleep_time += dt - ds
                        if not fell_asleep:
                            fell_asleep = times[i][j]
            
                scalet, scaled = [], []
                for t in times[i]:
                    scalet.append(t/max(times[i])*(width-1))
                for dat in data[i]:
                    #scaled.append((1-dat/max(data[i]))*height)
                    scaled.append(int(dat/max(data[i])*65535*3/4 + 65535/4))
                    
                #for td in zip(scalet, scaled):
                #    draw_line(plots[i], *td)
                for td in zip(scalet, scaled):
                    draw_stripe(plots[i], width/max(times[i])/3600+1, *td)
                
    
                labels[i].set_text(labels[i].get_text()+
                                   _(u" Сон: ")+timed(max(times[i]))+
                                   _(u" Глубокий: ")+timed(deep_sleep_time)+
                                   _(u" Засыпали: ")+timed(fell_asleep)
                                   )            
            num -= 1
            
        
        
        hildon.hildon_gtk_window_set_progress_indicator(window, 0)

    def on_history_append(self, toolbar, user_data):
        # Get last added index
        index = toolbar.get_last_index()
        # Get the inner list
        list = toolbar.get("list")    
        # Get the item
        iter = list.get_iter_from_string("%d" % index)    
        item, = list.get(iter, 0)
        return item

    def duration_dialog(self, widget):
        dialog = hildon.PickerDialog(self.window)
        dialog.set_transient_for(self.window)

        dialog.set_title(config.get(self.lang, 'duration'))
        selector = hildon.TouchSelectorEntry(text=True)
        for val in config.get('user', 'used_durations').split():
            selector.append_text(str(val))
        dialog.set_selector(selector)
        selector.set_name(config.get('user', 'duration'))
        
        dialog.show_all()
        response = dialog.run()
        if response == gtk.RESPONSE_OK:
            try:
                duration = float(selector.get_current_text().strip())
                config.set('user', 'duration', selector.get_current_text().strip())
                if selector.get_current_text().strip() not in config.get('user', 'used_durations').split():
                    config.set('user', 'used_durations', selector.get_current_text().strip() +' '+
                                                config.get('user', 'used_durations').strip())
                widget.set_title(config.get('user', 'duration')+' '+config.get(self.lang, 'hours'))
                config.set('user', 'duration_or_alarm', 'duration')
                duration = float(selector.get_current_text().strip())
                nownum = time2num(str(datetime.datetime.now())[11:16])
                self.button_time.set_title(timed((nownum + duration)%24))
            except:
                banner = hildon.hildon_banner_show_information(widget, gtk.STOCK_CLOSE, _(u"Введите число, пожалуйста"))
                banner.set_timeout(9000)

    #            image_statistics = gtk.image_new_from_stock(gtk.STOCK_CLOSE, gtk.ICON_SIZE_BUTTON)
    #            self.button_duration.set_image(image_statistics)
    #            #self.button_time.set_image(None)
    #            self.button_duration.set_image_position(gtk.POS_LEFT)
            dialog.hide()
        
    def time_dialog(self, widget):
        dialog = hildon.Dialog()
        dialog.set_title(config.get(self.lang, 'button_time'))
        dialog.set_transient_for(self.window)
        time_button = hildon.TimeButton(gtk.HILDON_SIZE_THUMB_HEIGHT, hildon.BUTTON_ARRANGEMENT_HORIZONTAL)
        h, m = [int(x) for x in config.get('user', 'alarm').split(':')]
        time_button.set_time(h, m)
        dialog.vbox.pack_start(time_button, True, True, border)
        dialog.vbox.pack_start(gtk.HSeparator(), False, False, border)
        dialog.vbox.pack_start(gtk.Label(config.get(self.lang, 'interval_lable')), False, False, border)
        bar = hildon.Seekbar()
        bar.set_total_time(60)
        bar.set_position(config.getint('user', 'window'))
        dialog.vbox.pack_start(bar, True, True, border)
        interval = gtk.Label()
        self.control_changed(bar, interval)
        dialog.vbox.pack_start(interval, False, False, border)
        bar.connect('value-changed', self.control_changed, interval)        
        dialog.add_buttons("Done", gtk.RESPONSE_OK)
        dialog.show_all()
        response = dialog.run()
        if response == gtk.RESPONSE_OK:
            h, m = time_button.get_time()
            str_alarm = '%d:%02d'%(h,m)
            config.set('user', 'alarm', str_alarm)
            config.set('user', 'window', str(bar.get_position()))
            widget.set_title(str_alarm)
            config.set('user', 'duration_or_alarm', 'alarm')
            alarmnum = h+m/60.0
            nownum = time2num(str(datetime.datetime.now())[11:16])
            if nownum>alarmnum:
                alarm_time = 24.0 - nownum + alarmnum
            else:
                alarm_time = alarmnum - nownum
            self.button_duration.set_title('%.2f '%alarm_time+config.get(self.lang, 'hours'))
            dialog.hide()

    def control_changed(self, widget, label): 
        label.set_text(" %d %s" % (int(widget.get_value()), config.get(self.lang, 'minutes')))

    def quit(self, *args):
        self.alarm_running = False
        with open(defdir+'/sleeppy.cfg', 'wb') as configfile:
            config.write(configfile)
        gtk.main_quit()
        
    def run(self):     
        self.window.show_all()
        gtk.main() 

#    def alarm_play(self, widget=None):
#        player = gst.element_factory_make("playbin2", "player")
#        fakesink = gst.element_factory_make("fakesink", "fakesink")
#        player.set_property("video-sink", fakesink)
#        bus = player.get_bus()
#        bus.add_signal_watch()
#        #bus.connect("message", self.on_message)
#        player.set_property("uri", 'file://'+config.get('user', 'mp3'))
#        player.set_state(gst.STATE_PLAYING)

    def add_two_button_alarm(self, widget=None):
        event = alarm.Event()
        event.appid = 'SleepPy'
        event.message = config.get(self.lang, 'wake_up')
        event.alarm_time = time.time()
        action_stop, action_snooze = event.add_actions(2)
        action_stop.label = config.get(self.lang, 'stop')
        action_stop.flags |= alarm.ACTION_WHEN_RESPONDED | alarm.ACTION_TYPE_NOP
        action_snooze.label = config.get(self.lang, 'snooze')
        action_snooze.flags |= alarm.ACTION_WHEN_RESPONDED | alarm.ACTION_TYPE_SNOOZE
        cookie = alarm.add_event(event)
        return cookie
    
    def get_rotation(self):
        file = open(config.get('tech', 'accelerometr'), 'r' )
        coords = [int(w) for w in file.readline().split()]
        file.close()
        return coords
    
    def main(self, wiget):
        if not self.alarm_running:
            self.alarm_running = True
            average = [0.0, 0.0, 0.0]
            dif = [0.0, 0.0, 0.0]
            begining_time = datetime.datetime.now()
            t_old = begining_time
            filename = config.get('user', 'fileformat').replace('$', 
                                    '%')%config.getint('user', 'index')
            self.button_alarm.set_value(config.get(self.lang, 'button_alarm_stop')+filename)
            config.set('user', 'index', str(config.getint('user', 'index')+1))
            alarm = -config.getfloat('user', 'alarm_play_time_sec')
            diff_old = 0.0
            const_average = config.getfloat('tech', 'average')
            
            alarmnum = time2num(config.get('user', 'alarm'))
            windownum = config.getfloat('user', 'window')/60.0
            nownum = time2num(str(datetime.datetime.now())[11:16])
            
            pause = config.getfloat('tech', 'pause')
            threshold = config.getint('user', 'accelerometr_threshold')
            
            if nownum>alarmnum:
                alarm_time = 24.0 - nownum + alarmnum
            else:
                alarm_time = alarmnum - nownum 
            
            with open(filename, 'w') as file:
                file.write('# '+ str(begining_time)[:19])
                while self.alarm_running:
                    
                    value = self.get_rotation()
                    
                    while gtk.events_pending():
                        gtk.main_iteration(False)
                        
                    time.sleep(pause)
                    t = datetime.datetime.now()
                    dt = (t - begining_time).seconds
                    dth = dt/3600.0
                    
                    # required alarm
                    if dth > alarm_time: 
                        if config.get('user', 'duration_or_alarm') == 'alarm':
                            self.set_alarm_up()
                            # TODO use: alarm.delete_event(num)
                            break
                    
                    for i in range(3):
                        average[i] = (value[i] + (const_average-1)*average[i])/const_average
                        dif[i] = abs(value[i] - average[i])
                    if max(dif) > threshold:
                        if t.second == t_old.second:
                            diff_old = max(diff_old, max(dif))
                        else:
                            file.write('\n%8.4f %7.3f'%(dth, diff_old))
                            t_old = t
                            diff_old = max(dif)
                        if config.get('user', 'duration_or_alarm') == 'duration':
                            if dth > config.getfloat('user', 'duration') and max(dif
                                ) > config.getint('user', 'alarm_threshold'):
                                #button_alarm.set_title(str((dt-alarm, config.getint('user', 'alarm_play_time_sec'))))
                                if dt-alarm > config.getfloat('user', 'alarm_play_time_sec'):
                                    self.set_alarm_up()
                        else:
                            if dth > alarm_time-windownum and max(dif
                                ) > config.getint('user', 'alarm_threshold'):
                                if dt-alarm > config.getfloat('user', 'alarm_play_time_sec'):
                                    self.set_alarm_up()
                                    
        else:
            self.alarm_running = False
            self.button_alarm.set_value(config.get(self.lang, 'button_alarm'))

    def set_alarm_up(self):
        self.add_two_button_alarm()
        self.alarm_running = False
        self.button_alarm.set_value(config.get(self.lang, 'button_alarm'))    

            
def timed(t):
        min = (t - math.floor(t))*60
        return '%d:%02d'%(math.floor(t), min)

def time2num(t):
        h, m = [int(x) for x in t.split(':')]
        return h+m/60.0

if __name__ == "__main__":
    app = SleepPyPatterns() 
    app.run()         
