# -*- coding: utf-8 -*-

from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4 import QtCore, QtGui

import sys
import os
#import random
import time
from time import strftime
#import math
#import array
import string

import ConfigParser
import os, os.path

import dbus
from dbus.mainloop.qt import DBusQtMainLoop

import data
import filter_data #filter
import records #record data


#load language file
import i18n
#_ = i18n.language.gettext
_ = i18n.language.ugettext

###########################################################################
## Load the configuration from the config file
###########################################################################
def LoadConfig():
    #get configuration
    global config
    if(data.debug==True): print "Configuration file:",  data.configFolder+data.ConfigFile
    config = ConfigParser.SafeConfigParser()
    try:
        config.read(data.configFolder+data.ConfigFile)
    except: #use default config
        print "Configuration file "+data.configFolder+data.ConfigFile + " not existing or not compatible"

    try:
        config.add_section('main')
    except:
        pass


    try:
        data.Sampling_interval = config.getint('main', 'sampling')
    except:
        config.set('main', 'sampling', str(data.Sampling_interval))

    try:
        data.Sample_smoothing = config.getint('main', 'sample_smoothing')
    except:
        config.set('main', 'sample_smoothing', str(data.Sample_smoothing))

    try:
        data.Value_smoothing = config.getint('main', 'value_smoothing')
    except:
        config.set('main', 'value_smoothing', str(data.Value_smoothing))

    try:
        data.Trigger = config.getint('main', 'Trigger')
    except:
        config.set('main', 'Trigger', str(data.Trigger))

    try:
        data.Derivation = config.getint('main', 'Derivation')
    except:
        config.set('main', 'Derivation', str(data.Derivation))

    try:
        data.Ysize = config.getint('main', 'Ysize')
    except:
        config.set('main', 'Ysize', str(data.Ysize))

    try:
        data.Xscale = config.getint('main', 'Xscale')
    except:
        config.set('main', 'Xscale', str(data.Xscale))

    try:
        data.Yscale_Movement = config.getint('main', 'Yscale_Movement')
    except:
        config.set('main', 'Yscale_Movement', str(data.Yscale_Movement_default))

    try:
        data.derivation_offset = config.getint('main', 'derivation_offset')
    except:
        config.set('main', 'derivation_offset', str(data.derivation_offset))

    try:
        data.Yscale_Sleep_Pattern = config.getint('main', 'Yscale_Sleep_Pattern')
    except:
        config.set('main', 'Yscale_Sleep_Pattern', str(data.Yscale_Sleep_Pattern_default))

    try:
        data.Yoffset_Sleep_Pattern = config.getint('main', 'Yoffset_Sleep_Pattern')
    except:
        config.set('main', 'Yoffset_Sleep_Pattern', str(data.Yoffset_Sleep_Pattern_default))

    try:
        data.limitMovement = config.getint('main', 'limitMovement')
    except:
        config.set('main', 'limitMovement', str(data.limitMovement))

    try:
        tmp=config.get('main', 'user')
        data.user = tmp.decode("utf-8")
    except:
        config.set('main', 'user', str(data.user.encode( "utf-8" )))

    try:
        data.LastRecord = config.get('main', 'LastRecord')
    except:
        config.set('main', 'LastRecord', str(data.LastRecord))

    try:
        tmp = config.get('main', 'OfflineMode')
        if(tmp=="True"): data.OfflineMode=True
        else: data.OfflineMode=False
    except:
        config.set('main', 'OfflineMode', str(data.OfflineMode))

    try:
        tmp = config.get('main', 'SilentProfile')
        if(tmp=="True"): data.SilentProfile=True
        else: data.SilentProfile=False
    except:
        config.set('main', 'SilentProfile', str(data.SilentProfile))

    try:
        data.DelayStartTime = config.getint('main', 'DelayStartTime')
    except:
        config.set('main', 'DelayStartTime', str(data.DelayStartTime))

    try:
        tmp = config.get('main', 'UseAlarm')
        if(tmp=="True"): data.UseAlarm=True
        else: data.UseAlarm=False
    except:
        config.set('main', 'UseAlarm', str(data.UseAlarm))

    try:
        data.AlarmHour = config.getint('main', 'AlarmHour')
    except:
        config.set('main', 'AlarmHour', str(data.AlarmHour))

    try:
        data.AlarmMinute = config.getint('main', 'AlarmMinute')
    except:
        config.set('main', 'AlarmMinute', str(data.AlarmMinute))

    try:
        data.AlarmTimeWindow = config.getint('main', 'AlarmTimeWindow')
    except:
        config.set('main', 'AlarmTimeWindow', str(data.AlarmTimeWindow))

    try:
        tmp = config.get('main', 'StopAfterAlarm')
        if(tmp=="True"): data.StopAfterAlarm=True
        else: data.StopAfterAlarm=False
    except:
        config.set('main', 'StopAfterAlarm', str(data.StopAfterAlarm))



    try:
        tmp = config.get('main', 'Use_Lucid_Dream_Song')
        if(tmp=="True"): data.Use_Lucid_Dream_Song=True
        else: data.Use_Lucid_Dream_Song=False
    except:
        config.set('main', 'Use_WakeUp_Song', str(data.Use_WakeUp_Song))

    try:
        data.Lucid_Dream_Song = config.get('main', 'Lucid_Dream_Song')
    except:
        config.set('main', 'Lucid_Dream_Song', str(data.Lucid_Dream_Song))

    try:
        data.Lucid_Dream_Song_Volume = config.getint('main', 'Lucid_Dream_Song_Volume')
    except:
        config.set('main', 'Lucid_Dream_Song_Volume', str(data.Lucid_Dream_Song_Volume))

    try:
        data.Lucid_Dream_Song_Delay = config.getint('main', 'Lucid_Dream_Song_Delay')
    except:
        config.set('main', 'Lucid_Dream_Song_Delay', str(data.Lucid_Dream_Song_Delay))

    try:
        data.Lucid_Dream_Song_Duration = config.getint('main', 'Lucid_Dream_Song_Duration')
    except:
        config.set('main', 'Lucid_Dream_Song_Duration', str(data.Lucid_Dream_Song_Duration))



    try:
        tmp = config.get('main', 'Use_WakeUp_Song')
        if(tmp=="True"): data.Use_WakeUp_Song=True
        else: data.Use_WakeUp_Song=False
    except:
        config.set('main', 'Use_WakeUp_Song', str(data.Use_WakeUp_Song))

    try:
        data.WakeUp_Song = config.get('main', 'WakeUp_Song')
    except:
        config.set('main', 'WakeUp_Song', str(data.WakeUp_Song))

    try:
        data.WakeUp_Song_Volume = config.getint('main', 'WakeUp_Song_Volume')
    except:
        config.set('main', 'WakeUp_Song_Volume', str(data.WakeUp_Song_Volume))

    try:
        data.WakeUp_Song_Duration = config.getint('main', 'WakeUp_Song_Duration')
    except:
        config.set('main', 'WakeUp_Song_Duration', str(data.WakeUp_Song_Duration))


    try:
        data.AlternativeAlarm = config.get('main', 'AlternativeAlarm')
    except:
        config.set('main', 'AlternativeAlarm', str(data.AlternativeAlarm))

    try:
        tmp = config.get('main', 'UseAlternativeAlarm')
        if(tmp=="True"): data.UseAlternativeAlarm=True
        else: data.UseAlternativeAlarm=False
    except:
        config.set('main', 'UseAlternativeAlarm', str(data.UseAlternativeAlarm))



## Add forced configuration changes here
    try:
        configFileVersion = config.getint('main', 'configFileVersion')
    except:
        configFileVersion=0
    if(configFileVersion<data.configFileVersion): #config file is old, update some parameters...
        if(data.configFileVersion<=3):
            data.Yscale_Movement=data.Yscale_Movement_default
            config.set('main', 'Yscale_Movement', str(data.Yscale_Movement_default))

            QMessageBox.critical(None, "Changes in SleepAnalyser",
            "There are new functions and changes in SleepAnalyser. Please have a look in the help menu to see what has changed. " + \
            "Because of the changes some parameters might need adjustment, expecially the trigger level. " + \
            "You can change them in the configuration dialog.")

    else: #config file up to date
        pass

    print "Configuration successful loaded from "+data.ConfigFile
    return config









###########################################################################
## Write the configuration into the config file
###########################################################################
def WriteConfig():
    global config
    config.set('main', 'Trigger', str(data.Trigger))
    config.set('main', 'ConfigFileVersion', str(data.configFileVersion))

    f=data.configFolder+data.ConfigFile
    if(data.debug==True): print "Save configuration ("+f+")"
    if (not os.path.exists(data.configFolder)):
        print "Create configuration folder: ",  data.configFolder
        os.mkdir(data.configFolder)
    try:
        data.configfile = open(f, 'w')
        config.write(data.configfile)
        data.configfile.close()
        print "Configuration saved"
    except:
        print "Failed to write configuration file!"




def PrintConfig():
    print "###################### CONFIG DATA #######################"
    a=config.items("main")
    for i in range(0, len(a)): #print data
        print a[i]
    print "##########################################################"


###########################################################################
##
###########################################################################
def Seconds2Tuple(secs):
    tuple=time.localtime(secs)
    return tuple



###########################################################################
##
###########################################################################
def Tuple2Seconds(Tuple):
    secs=int(time.mktime(Tuple))
    return secs



###########################################################################
##
###########################################################################
def Tuple2Index(Tuple):
    t0=records.StartTime_seconds
    t1=Tuple2Seconds(Tuple)
    tdiff=t1-t0
#    print records.StartTime_tuple,  Tuple
#    print "Tuple2Index:",  t0,  t1,  tdiff,  float(1000)/(records.Sampling_interval*records.Value_smoothing)
#    return Seconds2Index(tdiff)
    return int((tdiff-10)*1000/(records.Sampling_interval*records.Value_smoothing))+3



###########################################################################
##
###########################################################################
def Index2Tuple(Index):
    tdiff=int(Index*records.Sampling_interval*records.Value_smoothing/1000-3)+10
#    tdiff=Index2Seconds(Index)
    t=records.StartTime_seconds+tdiff
    return Seconds2Tuple(t)








def SwitchModes(start):
    if(data.DeviceIsN900==True): #We are on a N900
        if(data.QuickMode==False):  #only do in normal recording mode
            if(start==True): #start of recording
                if(data.SwitchedModes==False): #protection so it only gets switched once
                    data.SwitchedModes=True
                    if(data.OfflineMode==True): #change to offline mode
                        set_profile(False)
                    if(data.SilentProfile==True): #change to silent profile
                        set_silent(True)
                    data.PreviousVolume=GetVolume()

            else: #end of recording
                if(data.SwitchedModes==True): #protection so it only gets switched once
                    data.SwitchedModes=False
                    if(data.OfflineMode==True and data.demo!=1): #change to online mode
                       set_profile(True)
                    if(data.SilentProfile==True and data.demo!=1): #change to general profile
                        set_silent(False)
                    SetVolume(data.PreviousVolume)





def set_profile(online):
    if(online==True):
        try:
            if(data.PreviousMode=="normal"): #was online mode (before start measurement), so restore
                print "Change to online mode"
                cmd="dbus-send --system --dest=com.nokia.mce --type=method_call /com/nokia/mce/request com.nokia.mce.request.req_device_mode_change string:\"normal\""
                os.popen(cmd)
        except:
            pass
    else: #offline
        try:
            cmd="dbus-send --system --dest=com.nokia.mce --print-reply --type=method_call /com/nokia/mce/request com.nokia.mce.request.get_device_mode"
            ret=os.popen2(cmd) #get current mode
            p=ret[1].readline() #not used
            p=ret[1].readline()
            tmp=string.split(p,  "\"")
            data.PreviousMode=tmp[1]
            if(data.PreviousMode=="normal"): #was normal, change to offline
                print "Change to offline mode"
                cmd="dbus-send --system --dest=com.nokia.mce --type=method_call /com/nokia/mce/request com.nokia.mce.request.req_device_mode_change string:\"offline\""
                os.popen(cmd)
        except:
            pass






def set_silent(silent):
    if(silent==True):
        try:
            cmd="dbus-send --type=method_call --print-reply --dest=com.nokia.profiled /com/nokia/profiled com.nokia.profiled.get_profile"
            ret=os.popen2(cmd) #get current profile
            p=ret[1].readline() #not used
            p=ret[1].readline()
            tmp=string.split(p,  "\"")
            data.PreviousProfile=tmp[1]
            if(data.PreviousProfile=="general"): #was general profile, change to silent profile
                cmd="dbus-send --type=method_call --dest=com.nokia.profiled /com/nokia/profiled com.nokia.profiled.set_profile string:\"silent\" | echo \"\""
                os.popen(cmd)
                print "Silent Profile activated"
                Notify(_("Silent Profile activated"))
        except:
            pass
    else: #normal
        try:
            if(data.PreviousProfile=="general"): #was general (before start measurement), so restore to general
                cmd="dbus-send --type=method_call --dest=com.nokia.profiled /com/nokia/profiled com.nokia.profiled.set_profile string:\"general\" | echo \"\""
                os.popen(cmd)  #set profile
                print "General Profile activated"
                Notify(_("General Profile activated"))
                os.popen(cmd)  #notification
        except:
            pass







def SetVolume(percent):
    cmd="dbus-send --type=method_call --dest=com.nokia.mafw.renderer.Mafw-Gst-Renderer-Plugin.gstrenderer /com/nokia/mafw/renderer/gstrenderer com.nokia.mafw.extension.set_extension_property string:volume variant:uint32:"+str(percent)
    os.popen(cmd)
    data.CurrentVolume=percent



def GetVolume():
    if(data.DeviceIsN900==True): #we are on a N900
        bus = dbus.SessionBus()
        obj = bus.get_object("com.nokia.mafw.renderer.Mafw-Gst-Renderer-Plugin.gstrenderer",
            "/com/nokia/mafw/renderer/gstrenderer")
        mafw = dbus.Interface(obj, "com.nokia.mafw.extension")
        volume = int(mafw.get_extension_property("volume")[1])
    #    print "volume,", volume
        return volume



def Notify(notify_txt):
    notify_cmd="dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\""+notify_txt+"\""
    os.popen(notify_cmd.encode( "utf-8" ))



def PlaySong(volume, filename):
    print strftime("%x %X"), "Play", filename, "with volume", volume
    cmd="dbus-send --print-reply --dest=com.nokia.mediaplayer /com/nokia/mediaplayer com.nokia.mediaplayer.mime_open string:\"file:///"+str(filename)+"\""
    SetVolume(volume)
    b = os.popen(cmd)
    b.close()




def PauseSong():
    print strftime("%x %X"), "Pause song (if active)"
    cmd="dbus-send --dest=com.nokia.mafw.renderer.Mafw-Gst-Renderer-Plugin.gstrenderer /com/nokia/mafw/renderer/gstrenderer com.nokia.mafw.renderer.pause"
    b = os.popen(cmd)
    b.close()



def GetSongLength(filename):
    print "get song length for file:", filename
    output = os.popen("ffmpeg -i \""+str(filename)+"\" 2>&1 | grep Duration").read() # run ffmpeg and make the output look like a file I can read
    arr=output.split(".")
    arr=arr[0].split(":")
    duration=int(int(arr[1])*3600+int(arr[2])*60+int(arr[3]))
    return duration



def CloseMediaPlayer():
    print strftime("%x %X"), "killall mediaplayer"
    cmd="killall mediaplayer"
    b = os.popen(cmd)
    b.close()





############################################################################
## Function to measure used time in a function
############################################################################
#def Show_passed_time(text="",  reset=0):
#    if(data.debug==False): return
#    now=time.time()
#    if(reset==1): data.passed_time=now
#
#    t=1000*(now-data.passed_time)
#    t2=1000*(now-data.passed_time2)
#    print "### ",  str(int(t)), "ms, (",  str(int(t2)), "ms delta): ", text
#
#    data.passed_time2 = time.time()