# -*- coding: utf-8 -*-

import sys
import os
import random
import time
from time import strftime
import math
import array
import string

import ConfigParser
import os, os.path

import data
import filter_data #filter
import records #record data

#own functions
from functions_general import *

#own c cfunctions (for speed improvements)
try:
    from lib import mylib
except:
    pass #already handled in main.py


###########################################################################
## Read the sensor data x times and smoothen it
###########################################################################
def ReadAccSensor():
    coords=[0, 0, 0]
    if(data.demo==False):
        for i in range(data.Sample_smoothing):
            f = open("/sys/class/i2c-adapter/i2c-3/3-001d/coord", 'r' )
            coords_tmp = [int(w) for w in f.readline().split()]
            f.close()
            coords[0]=coords[0] + coords_tmp[0] #X
            coords[1]=coords[1] + coords_tmp[1] #Y
            coords[2]=coords[2] + coords_tmp[2] #Z
        coords[0]=coords[0] / data.Sample_smoothing
        coords[1]=coords[1] / data.Sample_smoothing
        coords[2]=coords[2] / data.Sample_smoothing
    else: #dmo mode, use randomizer
        coords[0]=int(random.uniform(-20,20))
        coords[1]=int(random.uniform(-20,20))
        coords[2]=int(random.uniform(-20,20))
    return coords



###########################################################################
## Get the smoothened sensor data, smoothen it again and fill the data into the main data array
###########################################################################
def GetSensorData():
    d=ReadAccSensor()
    data.arrDataTemp[0]=data.arrDataTemp[0]+d[0]
    data.arrDataTemp[1]=data.arrDataTemp[1]+d[1]
    data.arrDataTemp[2]=data.arrDataTemp[2]+d[2]

    data.sample_index=data.sample_index+1

    if(data.sample_index==data.Value_smoothing): #if is 10 runs over
        data.sample_index=0
        data.Values_total=data.Values_total+1

        if(records.Index==records.MaxArrayDataLen-1): return 0 #Array full

        records.arrData[0][records.Index]=strftime("%H:%M:%S", time.localtime())
        records.arrData[1][records.Index]=data.arrDataTemp[0]/data.Value_smoothing #note: indices are shifted in arrData!
        records.arrData[2][records.Index]=data.arrDataTemp[1]/data.Value_smoothing
        records.arrData[3][records.Index]=data.arrDataTemp[2]/data.Value_smoothing

        records.Index=records.Index+1
        records.LastIndex=max(records.Index,  records.LastIndex)

        records.EndTime_seconds=Tuple2Seconds(records.StartTime_tuple)+records.Index*records.Sampling_interval*records.Value_smoothing/1000
        records.EndTime_tuple=Seconds2Tuple(records.EndTime_seconds)

        data.arrDataTemp[0]=0
        data.arrDataTemp[1]=0
        data.arrDataTemp[2]=0

        return 1 #added new values to arrData
    else: return 0 #no new data added




###########################################################################
##
###########################################################################
def GetFirstEntry():
    records.arrData[0][0]=strftime("%H:%M:%S", time.localtime())
    records.arrData[1][0]=0 #X
    records.arrData[2][0]=0 #Y
    records.arrData[3][0]=0 #Z

    records.Index=1
    records.LastIndex=max(records.Index,  records.LastIndex)




###########################################################################
##  Process the data, generate movement indication
###########################################################################
def ProcessData(ProcessAll=False, ShowFiltered=False):  #DERIVATION (ABLEITUNG)
    if(data.debug==True): print "Process Data (Process whole array:", ProcessAll,  ")"
    data.Progress="Process data..."
    lastmovebeforegraph=0
    if(ProcessAll==True): start=0 #process whole array
    else: start=records.Index-data.Derivation-1 #process only last (changed) records
    if(data.debug==True): print "Process entry", start+data.Derivation, "to", records.Index



    for i in range(start, records.Index-data.Derivation):
        t=i*(records.Sampling_interval*records.Value_smoothing)/1000
        if(data.QuickMode==True or t>data.DelayStartTime):
            Xder=records.arrData[1][i+data.Derivation] - records.arrData[1][i] #X  in 50 sec - X now
            Yder=records.arrData[2][i+data.Derivation] - records.arrData[2][i]  #Y  in 50 sec - Y now
            Zder=records.arrData[3][i+data.Derivation] - records.arrData[3][i]  #Z  in 50 sec - Z now
            XYZderivation=abs(Xder)+abs(Yder)+abs(Zder) #sum of all 3 absolute Derivations
        else: #During delayed phase, do not use data
            Xder=0
            Yder=0
            Zder=0
            XYZderivation=0
#        records.arrData[4][i]=min(XYZderivation*data.Yscale,  data.Ysize-17) #cut off if higher than graph border
        records.arrData[4][i]=abs(XYZderivation-data.derivation_offset)

#    for i in range(0, min(records.Index-data.Derivation, 200)): records.arrData[4][i]=20 #debug

    #noise reduction of derivation
    for i in range(data.noiseReduction,  records.Index-data.Derivation):
#        val=0
#        for j in range(0, data.noiseReduction):
#            val+=records.arrData[4][i-j]
#        records.arrData[5][i]  = val/data.noiseReduction
        records.arrData[5][i]  = records.arrData[4][i]







def Generate_Sleep_Pattern():
    #NOTE:
    #records.arrData has strings and integers mixed. This is ok in python, but does not work in C.
    #So we have to export the data and import it again afterwarts:
    arrSend=[0]*(records.Index+len(filter_data.arrFilter))
    for i in range(0,  records.Index-data.Derivation): #copy array
        arrSend[i]=records.arrData[4][i]

    #Exported function:
#    arrRet=mylib.sleep_filter(arfunctions_record.pyrSend, records.Index-data.Derivation, filter_data.arrFilter, filter_data.FilterShift, (61-data.FilterScale)*100, data.Ysize-7, 13, data.limitMovement)
#sleep_filter(ar, len, filter,  shift, Yscale, Yoffset, Ymax, Ymin, limitMovement)
    arrRet=mylib.sleep_filter(arrSend, records.Index-data.Derivation, filter_data.arrFilter, filter_data.FilterShift, data.FilterScale, data.Sleep_Pattern_Yoffset, data.Ysize-7, 13, data.limitMovement)

    for i in range(0,  records.Index-data.Derivation): #copy array and scale
        records.arrData[6][i]  = arrRet[i]
#        print i,  records.arrData[6][i]






###########################################################################
## Show (refreshs) the graph.
## the first parameter indcates on which window it will be drawn
###########################################################################
def DrawGraph(self,  QtGui, ShowFiltered=False):
    try:
        if(data.debug==True): print "Draw Graph into bitmap"

        Xscale=data.arrXscale[data.Xscale]
        decade=360/Xscale

        paint = QtGui.QPainter()
        paint.begin(self)

        paint.setFont(QtGui.QFont('Decorative', 12))

        #clear whole pitmap (remove old data)
        paint.setPen(QtGui.QColor(data.GraphBackground))
        paint.setBrush(QtGui.QColor(data.GraphBackground))
        paint.drawRect(0,0,records.MaxArrayDataLen+10,data.GraphBitMapHeight)



#        if(data.run==False):  #only draw background for sleep levels when recording is finished
        paint.setPen(QtGui.QColor(data.GraphBackground2))
        paint.setBrush(QtGui.QColor(data.GraphBackground2))
        h1=(data.Ysize-(data.Deep_Sleep_Level*data.Yscale/2))
        h2=(data.Ysize-(data.Light_Sleep_Level*data.Yscale/2))
        paint.drawRect(1, h1-6, records.MaxArrayDataLen-2, h2-h1+2)






        #Stop if data is not ok
        if(records.statusID!="OK"):#Show useful infos
            paint.setFont(QtGui.QFont('Decorative', 20))
            paint.setPen(QtGui.QColor("White"))
            paint.drawText(100, data.Ysize/2+5, records.status) #show status information
            return


        GraphStart_tuple=Index2Tuple(0) #time of first record entry
    #    if(data.debug==True): print "data.GraphStart",  data.GraphStart,  GraphStart_tuple
        h=int(strftime("%H", GraphStart_tuple))
        m=int(strftime("%M", GraphStart_tuple))
        s=int(strftime("%S", GraphStart_tuple))
    #    print h,  m,  s

        secondsincefullhour=m*60+s
        GraphStart_seconds=Tuple2Seconds(GraphStart_tuple)
        LastFullHour_sec=GraphStart_seconds-secondsincefullhour
        LastFullHour_tuple=Seconds2Tuple(LastFullHour_sec)

        h0=int(strftime("%H", LastFullHour_tuple))
        m0=0 #int(strftime("%M", LastFullHour_tuple))
        s0=0# int(strftime("%S", LastFullHour_tuple))


        LastFullHour_index=Tuple2Index(LastFullHour_tuple)

        GraphStart_index=Tuple2Index(GraphStart_tuple)
    #    print "Indexes:",  GraphStart_index,  "(",  data.GraphStart, ")",  LastFullHour_index

        OffsetToLastFullHour=-1*(GraphStart_index - LastFullHour_index)/Xscale
        OffsetToLastFullHour=OffsetToLastFullHour- data.Derivation/Xscale  #Derivation takes 5 indices, so visualisation is delayed!







        #DRAW main scaling lines + text
        paint.setPen(QtGui.QColor("white"))
        h=h0-2
        if(data.QuickMode==False): #normal mode
    #        print "OffsetToLastFullHour:",  OffsetToLastFullHour
            if(data.Xscale==0): #max zoom
    #            for i in range(OffsetToLastFullHour-decade, 781+decade,  decade): #full hours
    #            for i in range(0, data.GraphBitMapLen,  decade): #full hours
                for i in range(OffsetToLastFullHour-decade, max(data.GraphBitMapLen, records.Index)+decade,  decade): #full hours
#                    h=(h0+int(i/decade)+1) % 24
                    h=(h+1) % 24
    #                print i
                    paint.drawLine(i, data.Ysize, i, data.Ysize+10)
                    paint.setFont(QtGui.QFont('Decorative', 18))
                    paint.drawText(i-25, data.Ysize+32, str(h)+":00")
    #                #show dashed line
    #                paint.drawLine(i, 0, i, data.Ysize)

                    paint.setFont(QtGui.QFont('Decorative', 12))
                    for k in range(1, 6): #hour + k * 10 minutes
                        x=i+k*decade/6
    #                    print " ", x,  str(h)+":"+str(10*k)
                        paint.drawLine(x, data.Ysize, x, data.Ysize+10)
                        paint.drawText(x-20, data.Ysize+26, str(h)+":"+str(10*k))
                    for m in range(1, 30): #hour + m * 2 minutes
                        x2=i+m*decade/30
    #                    print "  ",  x2
                        paint.drawLine(x2, data.Ysize, x2, data.Ysize+4)

            elif(data.Xscale==1 or data.Xscale==2): #mid + min zoom
    #            for i in range(OffsetToLastFullHour-decade, 781+decade,  decade): #full hours
                for i in range(OffsetToLastFullHour-decade, max(data.GraphBitMapLen, records.Index)+decade,  decade): #full hours
#                    h=(h0+int(i/decade)+1) % 24
                    h=(h+1) % 24
    #                print i
                    paint.drawLine(i, data.Ysize, i, data.Ysize+10)
                    paint.drawText(i-15, data.Ysize+30, str(h)+":00")

    #                #show dashed line
    #                paint.setPen(QtGui.QColor("grey"))
    #                paint.drawLine(i, 0, i, data.Ysize)

                    for k in range(1, 6): #hour + k * 10 minutes
                        x=i+k*decade/6
    #                    print " ", x,  str(h)+":"+str(10*k)
                        paint.drawLine(x, data.Ysize, x, data.Ysize+4)

        else: #quick mode, do not show X scale as it is not calibrated
    #        paint.drawText(200, data.Ysize+20, "Test Mode, no time scale available")
    #        paint.drawText((max(data.GraphBitMapLen, records.Index)-500)/Xscale, data.Ysize+20, "Test Mode, no time scale available")
            pass



        #DRAW time bars
        gradient = QtGui.QLinearGradient(0, data.Ysize-11, 0, data.Ysize-1)
        p=0
        p0=0
        while(p<records.Index-data.Derivation):
            if(records.arrData[6][p]>data.Light_Sleep_Level): #awake
                p0=p
                while(records.arrData[6][p]>data.Light_Sleep_Level and p<records.Index-data.Derivation): p=p+1*Xscale
#                print p0,"-", p, records.arrData[0][p0], "-", records.arrData[0][p], "Awake"
                gradient.setColorAt(0, QtGui.QColor(data.Awake_Color))
                gradient.setColorAt(0.5, QtGui.QColor(data.Awake_ColorDark))
                gradient.setColorAt(1, QtGui.QColor(data.Awake_Color))
                paint.setPen(QtGui.QColor(data.Awake_Color))

            elif(records.arrData[6][p]>data.Deep_Sleep_Level): #light sleep
                p0=p
                while(records.arrData[6][p]>data.Deep_Sleep_Level and records.arrData[6][p]<=data.Light_Sleep_Level and p<records.Index-data.Derivation): p=p+1*Xscale
#                print p0,"-", p, records.arrData[0][p0], "-", records.arrData[0][p], "Light Sleep ==="
                gradient.setColorAt(0, QtGui.QColor(data.Light_Sleep_Color))
                gradient.setColorAt(0.5, QtGui.QColor(data.Light_Sleep_ColorDark))
                gradient.setColorAt(1, QtGui.QColor(data.Light_Sleep_Color))
                paint.setPen(QtGui.QColor(data.Light_Sleep_Color))
#
            else:
                p0=p
                while(records.arrData[6][p]<=data.Deep_Sleep_Level and p<records.Index-data.Derivation): p=p+1*Xscale
#                print p0,"-", p, records.arrData[0][p0], "-", records.arrData[0][p], "Deep Sleep ============"
                gradient.setColorAt(0, QtGui.QColor(data.Deep_Sleep_Color))
                gradient.setColorAt(0.5, QtGui.QColor(data.Deep_Sleep_ColorDark))
                gradient.setColorAt(1, QtGui.QColor(data.Deep_Sleep_Color))
                paint.setPen(QtGui.QColor(data.Deep_Sleep_Color))
#
            x0=p0/Xscale
            x1=p/Xscale
            paint.setBrush(QtGui.QBrush(gradient))
            paint.drawRect(x0+1-2, data.Ysize-11, x1-x0-1, 9)






        #DRAW movement bars (yellow)
        paint.setPen(QtGui.QColor(data.MovementBarColor))
        peak=0
    #    for p in range(GraphStart_index,  records.Index-data.Derivation,  Xscale):
        for p in range(0,  records.Index-data.Derivation,  Xscale):
            i=p-GraphStart_index
    #        if(i>779*Xscale): break
            #when Xscale is small, we have to merge several records into 1 pixel.
            #Too not miss any movement, we use the biggest movement of the merged records:
            peak=0
            for j in range(0, Xscale):
#                if(records.arrData[4][p+j]>peak): peak=records.arrData[4][p+j]
                if(records.arrData[5][p+j]>peak): peak=records.arrData[5][p+j]
            x=i/Xscale
    #        x=i/Xscale+1
    #        paint.drawLine(x, data.Ysize-peak-1-15, x, data.Ysize-1-15)  #draw yellow movement bar
            h=min(peak*data.Yscale/2,  data.Ysize-17) #cut off if higher than graph border
            paint.drawLine(x, data.Ysize-h-1-15, x, data.Ysize-1-15)  #draw yellow movement bar




        #DRAW sleep graph (blue)
        if(ShowFiltered==True):
            pen=QtGui.QPen()

#            records.arrData[6][records.Index-data.Derivation-Xscale]=records.arrData[6][records.Index-data.Derivation-Xscale-1] #fix for last entry

            #filling
            pen.setColor(QtGui.QColor(19, 54, 255, 150))
            pen.setWidth(1)
            paint.setPen(pen)
            for p in range(0,  records.Index-data.Derivation-Xscale,  Xscale):
                i=p-GraphStart_index
                x=i/Xscale+1
                y=data.Ysize-records.arrData[6][p+Xscale]-5
                paint.drawLine(x, data.Ysize-16,       x, y)
#                print p, records.arrData[0][p+Xscale], records.arrData[6][p+Xscale]

            #outline
            pen.setColor(QtGui.QColor(19, 54, 255))
            pen.setWidth(3) #3
            paint.setPen(pen)
            for p in range(0,  records.Index-data.Derivation-Xscale,  Xscale):
                i=p-GraphStart_index
                x=i/Xscale+1
                y0=data.Ysize-records.arrData[6][p]-5
                y1=data.Ysize-records.arrData[6][p+Xscale]-5
                paint.drawLine(x, y0,       x+1, y1)
#                paint.drawLine(x, data.Ysize-records.arrData[6][p],       x+1, data.Ysize-records.arrData[6][p+Xscale])
#                print records.arrData[6][p+Xscale], data.Ysize-records.arrData[6][p+Xscale]-5











       #ALARM VISUALISATION
        if(records.AlarmIsSet==True): #alarm time window is set, show it
            paint.setBrush(QtGui.QColor(255, 128, 0, 200))
            paint.setPen(QtGui.QColor(255, 128, 0, 200))
            x0=Tuple2Index(records.AlarmTimeWindowStart_tuple)-data.Derivation*Xscale
            x1=Tuple2Index(records.AlarmTimeWindowEnd_tuple)-data.Derivation*Xscale
    #        x0=Tuple2Index(records.AlarmTimeWindowStart_tuple)-data.Derivation
    #        x1=Tuple2Index(records.AlarmTimeWindowEnd_tuple)-data.Derivation
            x00=(x0-GraphStart_index)/Xscale
            x10=(x1-GraphStart_index)/Xscale
    #        if(x00>0 or x10<780): #visible in screen
    #            x00=max(x00,  1) #limit drawn line to border
    #            x10=min(x10,  780) #limit drawn line to border
    #            if(x00<x10):
    #        print  x1,   x10
    #        print Tuple2Index((2010, 8, 15, 20, 0, 0, 6, 227, 0)),  (Tuple2Index((2010, 8, 15, 20, 0, 0, 6, 227, 0)) -GraphStart_index)/Xscale
    #        print ""
            paint.drawRect(x00,  8,  x10-x00,  2) #Time Window
    #            x11=(x1+3-GraphStart_index)/Xscale
    #            if(x11>1 and x11<779):
            paint.drawRect(x10,  4,  1,  10)  #Last Alarm opportunity



            if(data.AlarmIsActive==True or data.run==False): #only show alarm if alarm occured or in view mode
    #            if(records.Index>=Tuple2Index(records.AlarmTimeWindowEnd_tuple)): #only show alarm dot when alarm really came
                if(records.AlarmTime_seconds!=-1):
#                    print "AlarmTimeWindowEnd:",  records.AlarmTimeWindowEnd_seconds,  "AlarmTime:",  records.AlarmTime_seconds,  "records.EndTime_seconds:",records.EndTime_seconds
    #                EndTime_seconds=Tuple2Seconds(records.StartTime_tuple)+records.Index*records.Sampling_interval*records.Value_smoothing/1000
                    if(records.EndTime_seconds>=records.AlarmTime_seconds-60): #alarm got set off during recording (-60 is workaround)
#                        paint.setBrush(QtGui.QColor(data.AlarmColor))
                        paint.setPen(QtGui.QColor(178, 0, 0))
                        if(records.AlarmTimeWindowEnd_seconds<=records.AlarmTime_seconds):
#                            print "Alarm due end of alarm time window"
                            a0=Tuple2Index(records.AlarmTime_tuple)-data.Derivation*Xscale
                        else:
#                            print "alarm due movement"
                            a0=Tuple2Index(records.AlarmTime_tuple)-data.Derivation
                        a00=(a0-GraphStart_index)/Xscale




#                        gradient = QtGui.QRadialGradient(200,  100,  5)
                        gradient = QtGui.QRadialGradient(a00,  20,  3)
                        gradient.setColorAt(0, QtGui.QColor(255, 152, 152))
                        gradient.setColorAt(1, QtGui.QColor(255, 0, 0))
                        paint.setBrush(QtGui.QBrush(gradient))





#                        paint.drawEllipse(100, 0, 200, 200)
                        paint.drawEllipse(a00-5, 15, 10, 10)

            #            print "AlarmTimeWindow:",  x1,  x10,  "Alarm:",  a0,  a00
#                    else:
#                        print "Alarm set, but never occured"




        #DRAW Trigger line
        if(records.statusID=="OK"):
            if(data.run==False):  #only show trigger level stored in record when recording is finished
                t=records.Trigger
            else:
                t=data.Trigger
#            offset=15 #visual correction to mach blue graph
#            print t
#            y=(data.Ysize-(t*data.Yscale/2))+offset
#            print y
#            y=(data.Ysize-(t/(61-data.FilterScale)))+offset
            y=(data.Ysize-(t*data.FilterScale*3/40))+10

#            print "--------------"
#            print t,  t*data.FilterScale*3/40,  y
            paint.setPen(QtGui.QColor(255,  255,  255, 200))
            paint.drawLine(1, y-17, data.GraphBitMapLen, y-17)  #Trigger line
            paint.drawText(data.GraphBitMapLen-31, y-19, str(t)) #Trigger level




        #Draw border around graph
        paint.setPen(QtGui.QColor("white"))
        paint.drawLine(0, 0, 0, data.Ysize)  #left side
        paint.drawLine(data.GraphBitMapLen-1, 0, data.GraphBitMapLen-1, data.Ysize)  #right side
        paint.drawLine(0, 0, data.GraphBitMapLen-1, 0)  #top
        paint.drawLine(0, data.Ysize, data.GraphBitMapLen-1, data.Ysize)  #bottom

    #    #show Graph border with gradient background
#        paint.setPen(QtGui.QColor("white"))
#        paint.setBrush(QtGui.QColor(10, 10, 10, 200))
#        gradient = QtGui.QLinearGradient(0, 0, 0, data.Ysize)
#        gradient.setColorAt(0, QtGui.QColor(255, 255, 255, 50)) #top
#        gradient.setColorAt(0.5, QtGui.QColor(255, 255, 255, 0)) #bottom
#        paint.setBrush(QtGui.QBrush(gradient))
#        paint.drawRect(0,0,data.GraphBitMapLen-1,data.Ysize)






        #When in test mode, make noise if last moveent is over trigger level
        if(data.QuickMode==True): MakeNoise_if_over_trigger(records.arrData[6][records.Index-data.Derivation-1])

    except:
        print "Error while drawing the graph"
        print sys.exc_info()

    paint.end()














#TODO: improve function!!!!
def MakeNoise_if_over_trigger(peak):
    #beep in test mode
    if(peak>data.Trigger): #if last value is over peak
#        if(data.QuickMode==True and (records.Index-data.Derivation)>data.last_beep): #quick mode for testing but only once per move
        if((records.Index-data.Derivation)>data.last_beep): #quick mode for testing but only once per move
            if(data.debug==True): print "Beep"
            data.last_beep=records.Index
            if(data.demo==False): #make beep for testing movement
                b = os.popen("pacat --channels=2 /usr/share/sounds/ui-default_beep.wav")
                b.close()
            print "Beep"





###########################################################################
##
###########################################################################
def DrawStatistic(self,  QtGui, QtCore):
#    try:
#        if(daDta.debug==1): print "Draw Graph into bitmap"

    paint = QtGui.QPainter()
    paint.begin(self)

    #clear whole pitmap (remove old data)
    paint.setPen(QtGui.QColor(data.GraphBackground))
#    paint.setBrush(QtGui.QColor("red"))
#    paint.drawRect(0, 0, data.StatisticsBitMapLen/2,  data.StatisticsBitMapHeight/2)

    paint.setBrush(QtGui.QColor(data.GraphBackground))
#    paint.setBrush(QtGui.QColor(255, 255, 255, 50))
#    paint.setBrush(QtCore.Qt.NoBrush)
    paint.drawRect(0, 0, data.StatisticsBitMapLen,  data.StatisticsBitMapHeight)

#    paint.

#    linearGrad = QtGui.QLinearGradient(10, 10, 20, 20)
#    linearGrad.setColorAt(0, QtGui.QColor("red"))
#    linearGrad.setColorAt(1, QtGui.QColor("green"))



#    paint.setBrush(QtGui.QGradient())

    paint.setPen(QtGui.QColor(data.GraphBackground))



    if(records.arrStatData[0][3]>0): #Awake
        gradient = QtGui.QLinearGradient(0, 20, 0, 30)
        gradient.setColorAt(0, QtGui.QColor(data.Awake_Color))
        gradient.setColorAt(0.5, QtGui.QColor(data.Awake_ColorDark))
        gradient.setColorAt(1, QtGui.QColor(data.Awake_Color))
        paint.setBrush(QtGui.QBrush(gradient))
        paint.setPen(QtGui.QColor(data.Awake_Color))
        paint.drawRect(0, 20, records.arrStatData[0][3], 10)

    if(records.arrStatData[1][3]>0): #Light Sleep
        gradient = QtGui.QLinearGradient(0, 35, 0, 45)
        gradient.setColorAt(0, QtGui.QColor(data.Light_Sleep_Color))
        gradient.setColorAt(0.5, QtGui.QColor(data.Light_Sleep_ColorDark))
        gradient.setColorAt(1, QtGui.QColor(data.Light_Sleep_Color))
        paint.setBrush(QtGui.QBrush(gradient))
        paint.setPen(QtGui.QColor(data.Light_Sleep_Color))
        paint.drawRect(0, 35, records.arrStatData[1][3], 10)

    if(records.arrStatData[2][3]>0): #deep sleep
        gradient = QtGui.QLinearGradient(0, 50, 0, 60)
        gradient.setColorAt(0, QtGui.QColor(data.Deep_Sleep_Color))
        gradient.setColorAt(0.5, QtGui.QColor(data.Deep_Sleep_ColorDark))
        gradient.setColorAt(1, QtGui.QColor(data.Deep_Sleep_Color))
        paint.setBrush(QtGui.QBrush(gradient))
        paint.setPen(QtGui.QColor(data.Deep_Sleep_Color))
        paint.drawRect(0, 50, records.arrStatData[2][3], 10)

    paint.end()


###########################################################################
##
###########################################################################
def GenerateStatisticData():
    for i in range(0, 4): #clear array
        for j in range(0,  3): records.arrStatData[j][i]=0




    p=0
    p0=0
    while(p<records.Index-data.Derivation):
        if(records.arrData[6][p]>data.Light_Sleep_Level): #awake
            p0=p
            while(records.arrData[6][p]>data.Light_Sleep_Level and p<records.Index-data.Derivation): p=p+1
            records.arrStatData[0][0]=records.arrStatData[0][0]+p-p0 #Accumulated time for Awake
            records.arrStatData[0][1]=records.arrStatData[0][1]+1 #Amount of times in Awake
            if(records.arrStatData[0][2]<p-p0): records.arrStatData[0][2]=p-p0 #Max time in Awake

        elif(records.arrData[6][p]>data.Deep_Sleep_Level): #light sleep
            p0=p
            while(records.arrData[6][p]>data.Deep_Sleep_Level and records.arrData[6][p]<=data.Light_Sleep_Level and p<records.Index-data.Derivation): p=p+1
            records.arrStatData[1][0]=records.arrStatData[1][0]+p-p0 #Accumulated time for Light sleep
            records.arrStatData[1][1]=records.arrStatData[1][1]+1#Amount of times in Light sleep
            if(records.arrStatData[1][2]<p-p0): records.arrStatData[1][2]=p-p0 #Max time in Light sleep

        else:
            p0=p
            while(records.arrData[6][p]<=data.Deep_Sleep_Level and p<records.Index-data.Derivation): p=p+1
            records.arrStatData[2][0]=records.arrStatData[2][0]+p-p0 #Accumulated time for Deep sleep
            records.arrStatData[2][1]=records.arrStatData[2][1]+1#Amount of times in Deep sleep
            if(records.arrStatData[2][2]<p-p0): records.arrStatData[2][2]=p-p0 #Max time in Deep sleep


#    print "Statistic data:",  records.arrStatData

    #Accumulated time/phase
    records.arrStatData[0][0]=records.arrStatData[0][0]*records.Sampling_interval*records.Value_smoothing/1000
    records.arrStatData[1][0]=records.arrStatData[1][0]*records.Sampling_interval*records.Value_smoothing/1000
    records.arrStatData[2][0]=records.arrStatData[2][0]*records.Sampling_interval*records.Value_smoothing/1000


    #Max time/phase
    records.arrStatData[0][2]=records.arrStatData[0][2]*records.Sampling_interval*records.Value_smoothing/1000
    records.arrStatData[1][2]=records.arrStatData[1][2]*records.Sampling_interval*records.Value_smoothing/1000
    records.arrStatData[2][2]=records.arrStatData[2][2]*records.Sampling_interval*records.Value_smoothing/1000


    #time percent
    t_total=(records.EndTime_seconds-records.StartTime_seconds)
    if(t_total==0):  t_total=1 #division by zerro prevention
    records.arrStatData[0][3]=records.arrStatData[0][0]*100/t_total
    records.arrStatData[1][3]=records.arrStatData[1][0]*100/t_total
    records.arrStatData[2][3]=records.arrStatData[2][0]*100/t_total

    if(data.debug==True): print "Statistic data:",  records.arrStatData



###########################################################################
##
###########################################################################
def InitRecord():
    records.Index=0
    records.LastIndex=0
    records.StartTime_tuple=time.localtime()
    records.StartTime_seconds=Tuple2Seconds(records.StartTime_tuple)
    records.EndTime_tuple=records.StartTime_tuple
    records.EndTime_seconds=records.StartTime_seconds
    records.AlarmTime_tuple=-1
    records.AlarmTime_seconds=-1
    records.AlarmTimeWindowStart_tuple=-1
    records.AlarmTimeWindowStart_seconds=-1
    records.AlarmTimeWindowEnd_tuple=-1
    records.AlarmTimeWindowEnd_seconds=-1
    records.AlarmTimeWindow_minutes=-1
    records.AlarmIsSet=False
    records.Note=""
    records.Sampling_interval=-1
    records.Sample_smoothing=-1
    records.Value_smoothing=-1
    records.Trigger=-1
    records.status=""
    records.statusID=""

    for i in range(0, records.MaxArrayDataLen-1): #clear data of old records
        for j in range(0,  6):
            records.arrData[j][i]=0
#        records.arrData[6][i]=0
#        records.arrData[5][i]=""

    print "Reset/cleared all record data"











###########################################################################
##
## Only used for debugging
###########################################################################
def PrintRecordData(ShowArray=True):
    print "###################### RECORD DATA #######################"
    print "Index:",  records.Index
    print "LastIndex:",  records.LastIndex
    print "StartTime_tuple:",  records.StartTime_tuple
    print "StartTime_seconds:",  records.StartTime_seconds
    print "EndTime_tuple:",  records.EndTime_tuple
    print "EndTime_seconds:",  records.EndTime_seconds
    print "AlarmTime_tuple:",  records.AlarmTime_tuple
    print "AlarmTime_seconds:",  records.AlarmTime_seconds
    print "AlarmTimeWindowStart_tuple:",  records.AlarmTimeWindowStart_tuple
    print "AlarmTimeWindowStart_seconds:",  records.AlarmTimeWindowStart_seconds
    print "AlarmTimeWindowEnd_tuple:",  records.AlarmTimeWindowEnd_tuple
    print "AlarmTimeWindowEnd_seconds",  records.AlarmTimeWindowEnd_seconds
    print "AlarmTimeWindow_minutes:",  records.AlarmTimeWindow_minutes
    print "AlarmIsSet:",  records.AlarmIsSet
    print "Note:",  records.Note
    print "Sampling_interval:",  records.Sampling_interval
    print "Sample_smoothing:",  records.Sample_smoothing
    print "Value_smoothing:",  records.Value_smoothing
    print "Trigger:",  records.Trigger
    print "Status:",  records.statusID,  records.status

    if(ShowArray==True):
        for i in range(0, records.Index): #print data of  records
            print records.arrData[0][i],  records.arrData[1][i],  records.arrData[2][i],  records.arrData[3][i],  records.arrData[4][i],  records.arrData[5][i],  records.arrData[6][i]

    print "##########################################################"
