#include <Python.h>

/* Plain C functions */

/*  c_squaring_func

    Input: An integer.
    Output: An integer.

    Function: Squares the input and returns it.
*/
PyObject *c_squaring_func(PyObject *self, PyObject *args)
{
    PyObject *raw_input, *raw_output;
    long input, output;
    PyObject *zero;

    /* Parse input */
    zero = Py_BuildValue("i", 0);
    raw_input = PyObject_GetItem(args, zero);   
    input = PyInt_AsLong(raw_input);	/* Careful: no error checking */

    /* Do computations */
    output = input*input;

    /* Format and return output */
    raw_output = Py_BuildValue("i", output);
    return raw_output;
}







/*  c_string_concat

    Input: A string.
    Output: A string.

    Function: Concatenates a string with itself and returns
    the concatenated string.
*/
PyObject *c_string_concat(PyObject *self, PyObject *args)
{
    PyObject *raw_input, *raw_output;
    char *input, *output;
    int input_len;
    PyObject *zero;	    

    /* Parse input */
    zero = Py_BuildValue("i", 0);
    raw_input = PyObject_GetItem(args, zero);   
    input = PyString_AsString(raw_input); /* Careful: no error checking */
    /* Do computations */
    input_len = strlen(input);
    output = PyMem_Malloc(sizeof(char)*(input_len*2));	/* Don't use malloc, use PyMem_Malloc */
    strcpy(output, input);	/* Copy over first copy */
    strcat(output, input);  	/* Concat second copy */

    raw_output = Py_BuildValue("s", output);
    PyMem_Del(output);	/* Free memory allocated via Python */
    return raw_output;
}










/* Python/C required items */

PyMethodDef methods[] = 
{
    {"squared", (PyCFunction) c_squaring_func, METH_VARARGS, "Squares a number"},
    {"repeat", (PyCFunction) c_string_concat, METH_VARARGS, "Concats a string with itself"},
    {NULL, NULL, 0, NULL}
};

PyMODINIT_FUNC initA_Module(void)
{
    (void) Py_InitModule("A_Module", methods);
}	
	
