import sys
import os
import random
import time
from time import strftime
import math
import array
import string

import ConfigParser
import os, os.path

import data
import records #record data

#own functions
from functions_general import *


###########################################################################
## Read the sensor data x times and smoothen it
###########################################################################
def ReadAccSensor():    
    coords=[0, 0]    
    if(data.demo==False):        
        for i in range(data.Sample_smoothing):
            f = open("/sys/class/i2c-adapter/i2c-3/3-001d/coord", 'r' )
            coords_tmp = [int(w) for w in f.readline().split()]
            f.close()
            coords[0]=coords[0] + coords_tmp[0] #X
            coords[1]=coords[1] + coords_tmp[1] #Y
        coords[0]=coords[0] / data.Sample_smoothing
        coords[1]=coords[1] / data.Sample_smoothing
    else:
        coords[0]=int(random.uniform(-50,50))
        coords[1]=int(random.uniform(-50,50))
    return coords



###########################################################################
## Get the smoothened sensor data, smoothen it again and fill the data into the main data array
###########################################################################
def GetSensorData():    
    d=ReadAccSensor()
    data.arrDataTemp[0]=data.arrDataTemp[0]+d[0]
    data.arrDataTemp[1]=data.arrDataTemp[1]+d[1]

    data.sample_index=data.sample_index+1
    
    if(data.sample_index==data.Value_smoothing): #if is 10 runs over        
        data.sample_index=0
        data.Values_total=data.Values_total+1
        
        if(records.Index==records.MaxArrayDataLen-1): return 0 #Array full
        
        records.arrData[0][records.Index]=strftime("%H:%M:%S", time.localtime())
        records.arrData[1][records.Index]=data.arrDataTemp[0]/data.Value_smoothing
        records.arrData[2][records.Index]=data.arrDataTemp[1]/data.Value_smoothing
        
        records.Index=records.Index+1
        records.LastIndex=max(records.Index,  records.LastIndex)

        data.arrDataTemp[0]=0
        data.arrDataTemp[1]=0

        return 1 #added new values to arrData        
    else: return 0 #no new data added




###########################################################################
## 
###########################################################################
def GetFirstEntry():
    records.arrData[0][0]=strftime("%H:%M:%S", time.localtime())
    records.arrData[1][0]=0
    records.arrData[2][0]=0
    
    records.Index=1
    records.LastIndex=max(records.Index,  records.LastIndex)
        
        


###########################################################################
##  Process the data, generate movement indication
###########################################################################
def ProcessData(ProcessAll=False):  #DERIVATION (ABLEITUNG)
    lastmovebeforegraph=0 
    if(ProcessAll==True): start=0 #process whole array
    else: start=records.Index-data.Derivation-1 #process only last (changed) records
    
    lastindexovertrigger=records.arrData[4][start]
    for i in range(start, records.Index-data.Derivation):     
        t=i*(records.Sampling_interval*records.Value_smoothing)/1000
        if(data.QuickMode==True or t>data.DelayStartTime):
            Xder=records.arrData[1][i+data.Derivation] - records.arrData[1][i] #X  in 50 sec - X now
            Yder=records.arrData[2][i+data.Derivation] - records.arrData[2][i]  #Y  in 50 sec - Y now
            XYder=abs(Xder)+abs(Yder) #summ of both absolute Derivations
        else: #During delayed phase, do not use data
            Xder=0
            Yder=0
            XYder=0
#        records.arrData[3][i]=min(XYder*data.Yscale,  data.Ysize-17) #cut off if higher than graph border
        records.arrData[3][i]=XYder
        records.arrData[4][i]=lastindexovertrigger
#        if(records.arrData[3][i]>data.Trigger): #over trigger
#            lastindexovertrigger=i
        
            

#    for i in range(max(start,  5), records.Index-data.Derivation):     
#        t=i*(records.Sampling_interval*records.Value_smoothing)/1000
#        if(data.QuickMode==True or t>data.DelayStartTime):
#            Xder=records.arrData[1][i] - records.arrData[1][i-data.Derivation] #X  Now - 50 sec ago
#            Yder=records.arrData[2][i] - records.arrData[2][i-data.Derivation]  #Y  Now - 50 sec ago
#            XYder=abs(Xder)+abs(Yder) #summ of both absolute Derivations
#        else: #During delayed phase, do not use data
#            Xder=0
#            Yder=0
#            XYder=0
#        records.arrData[3][i]=min(XYder*data.Yscale,  data.Ysize-17) #cut off if higher than graph border







###########################################################################
## Show (refreshs) the graph.
## the first parameter indcates on which window it will be drawn
###########################################################################
def GenerateGraph(self,  QtGui):

    Xscale=data.arrXscale[data.Xscale]
    decade=360/Xscale
    
#    data.GraphStart=0
    
#    GraphSize=max(data.GraphBitMapLen+2, 785)

#        print "-----------------------------------"
#        print "Xscale:",  Xscale
#        print "Current index:",  records.Index
#        print "LastIndex:",  records.LastIndex
#        print "data.GraphBitMapLen (WindowSize):",  data.data.GraphBitMapLen
#        print "GraphStart:",  data.GraphStart
#        print "GraphEnd:",  data.GraphEnd
#        print "The area between index",data.GraphStart , "and",data.GraphEnd , "will be shown"
#        print "Scrollbar:",  ScrollbarStartPercent, "...", ScrollbarEndPercent, "%"
    
#        print "Shown graph is from index",  data.GraphStart,  "to",  data.GraphStart+data.GraphBitMapLen
        
#    PrintRecordData()

#    print "data.QuickMode:",  data.QuickMode
        
#    data.ChangesInGraph=False
    paint = QtGui.QPainter()
    paint.begin(self)

    paint.setFont(QtGui.QFont('Decorative', 12))
    
    #clear whole pitmap (remove old data)
    paint.setPen(QtGui.QColor("#101010"))
    paint.setBrush(QtGui.QColor("#101010"))    
    paint.drawRect(0,0,data.GraphBitMapLen,data.GraphBitMapHeight)   
    
    
#    #show Graph border 
##    paint.setPen(QtGui.QColor("white"))
##    paint.setBrush(QtGui.QColor("#101010"))    
###    paint.drawRect(0,0,781,data.Ysize)    
##    paint.drawRect(0,0,data.GraphBitMapLen,data.Ysize)   

    #Stop if data is not ok
    if(records.statusID!="OK"):#Show useful infos                 
        paint.setFont(QtGui.QFont('Decorative', 20))
        paint.setPen(QtGui.QColor("White"))  
        paint.drawText(100, data.Ysize/2+5, records.status) #show status information
        return
    
    
#    GraphStart_tuple=Index2Tuple(data.GraphStart)
    GraphStart_tuple=Index2Tuple(0) #time of first record entry
#    if(data.debug==1): print "data.GraphStart",  data.GraphStart,  GraphStart_tuple
    h=int(strftime("%H", GraphStart_tuple))
    m=int(strftime("%M", GraphStart_tuple))
    s=int(strftime("%S", GraphStart_tuple))
#    print h,  m,  s
    
    secondsincefullhour=m*60+s
    GraphStart_seconds=Tuple2Seconds(GraphStart_tuple)
    LastFullHour_sec=GraphStart_seconds-secondsincefullhour
    LastFullHour_tuple=Seconds2Tuple(LastFullHour_sec)
    
    h0=int(strftime("%H", LastFullHour_tuple))
    m0=0 #int(strftime("%M", LastFullHour_tuple))
    s0=0# int(strftime("%S", LastFullHour_tuple))
#    print h0,  m0,  s0
    
    
#    print GraphStart_seconds,  LastFullHour_sec,  secondsincefullhour
#    print GraphStart_tuple,  LastFullHour_tuple
    
    LastFullHour_index=Tuple2Index(LastFullHour_tuple)

    GraphStart_index=Tuple2Index(GraphStart_tuple) 
#    print "Indexes:",  GraphStart_index,  "(",  data.GraphStart, ")",  LastFullHour_index

    OffsetToLastFullHour=-1*(GraphStart_index - LastFullHour_index)/Xscale 
    OffsetToLastFullHour=OffsetToLastFullHour- data.Derivation/Xscale  #Derivation takes 5 indices, so visualisation is delayed!
    
#    print "OffsetToLastFullHour:",  OffsetToLastFullHour,  "GraphStart_index:",  GraphStart_index,  "LastFullHour_index:",  LastFullHour_index
    
#    print "Last data is on:",  Index2Tuple(records.Index)
    
    
    
    
    
    
    
    #DRAW main scaling lines + text        
    paint.setPen(QtGui.QColor("white"))
    if(data.QuickMode==False): #normal mode
#        print "OffsetToLastFullHour:",  OffsetToLastFullHour
        if(data.Xscale==0): #max zoom
#            for i in range(OffsetToLastFullHour-decade, 781+decade,  decade): #full hours
#            for i in range(0, data.GraphBitMapLen,  decade): #full hours
            for i in range(OffsetToLastFullHour-decade, max(data.GraphBitMapLen, records.Index)+decade,  decade): #full hours
                h=(h0+int(i/decade)+1) % 24
#                print i
                paint.drawLine(i, data.Ysize, i, data.Ysize+10) 
                paint.setFont(QtGui.QFont('Decorative', 18))
                paint.drawText(i-25, data.Ysize+32, str(h)+":00")
#                #show dashed line
#                paint.drawLine(i, 0, i, data.Ysize) 
                
                paint.setFont(QtGui.QFont('Decorative', 12))
                for k in range(1, 6): #hour + k * 10 minutes
                    x=i+k*decade/6
#                    print " ", x,  str(h)+":"+str(10*k)
                    paint.drawLine(x, data.Ysize, x, data.Ysize+10)  
                    paint.drawText(x-20, data.Ysize+26, str(h)+":"+str(10*k))
                for m in range(1, 30): #hour + m * 2 minutes
                    x2=i+m*decade/30
#                    print "  ",  x2
                    paint.drawLine(x2, data.Ysize, x2, data.Ysize+4) 

        elif(data.Xscale==1 or data.Xscale==2): #mid + min zoom
#            for i in range(OffsetToLastFullHour-decade, 781+decade,  decade): #full hours
            for i in range(OffsetToLastFullHour-decade, max(data.GraphBitMapLen, records.Index)+decade,  decade): #full hours
                h=(h0+int(i/decade)+1) % 24
#                print i
                paint.drawLine(i, data.Ysize, i, data.Ysize+10) 
                paint.drawText(i-15, data.Ysize+30, str(h)+":00")
                
#                #show dashed line
#                paint.setPen(QtGui.QColor("grey"))
#                paint.drawLine(i, 0, i, data.Ysize) 
                
                for k in range(1, 6): #hour + k * 10 minutes
                    x=i+k*decade/6
#                    print " ", x,  str(h)+":"+str(10*k)
                    paint.drawLine(x, data.Ysize, x, data.Ysize+4)  

    else: #quick mode, do not show X scale as it is not calibrated
#        paint.drawText(200, data.Ysize+20, "Test Mode, no time scale available")
#        paint.drawText((max(data.GraphBitMapLen, records.Index)-500)/Xscale, data.Ysize+20, "Test Mode, no time scale available")
        pass



    #DRAW time bars
    start=GraphStart_index % 6
    lastmoveovertrigger=start
#    for p in range(start,  records.Index-data.Derivation):
    for p in range(0,  records.Index-data.Derivation):
        if(records.arrData[3][p]>data.Trigger or p>records.Index-data.Derivation-2):
            x0=(lastmoveovertrigger-GraphStart_index)/Xscale
            x1=(p-GraphStart_index)/Xscale
#            print lastmoveovertrigger,  p,  "(", x0,  x1 , ")"
#            if(x1-Xscale<=x0):
#                print "-"
#                continue
            lastmoveovertrigger=p

            if(x0<x1): 
                t=(x1-x0)*Xscale/6        
#                print x0,  x1
                if(t>30): color="#009100" #green
                elif(t>15): color="#005000" #dark green
                elif(t>7): color="#97320e" #orange
                else: color="#6D0000" #dark red                   
                paint.setBrush(QtGui.QColor(color))
                paint.setPen(QtGui.QColor(color))
                paint.drawRect(x0+1, data.Ysize-11, x1-x0-1, 10)                     
                paint.setPen(QtGui.QColor("yellow"))




    #DRAW graph
    paint.setPen(QtGui.QColor("yellow"))           
    peak=0
#    for p in range(GraphStart_index,  records.Index-data.Derivation,  Xscale):
    for p in range(0,  records.Index-data.Derivation,  Xscale):
        i=p-GraphStart_index
#        if(i>779*Xscale): break
        #when Xscale is small, we have to merge several records into 1 pixel.
        #Too not miss any movement, we use the biggest movement of the merged records:
        peak=0            
        for j in range(0, Xscale): 
            if(records.arrData[3][p+j]>peak): peak=records.arrData[3][p+j]
        x=i/Xscale
#        x=i/Xscale+1
#        paint.drawLine(x, data.Ysize-peak-1-15, x, data.Ysize-1-15)  #draw yellow movement bar
        h=min(peak*data.Yscale/2,  data.Ysize-17) #cut off if higher than graph border
        paint.drawLine(x, data.Ysize-h-1-15, x, data.Ysize-1-15)  #draw yellow movement bar
        
        if(peak>data.Trigger):
            paint.setPen(QtGui.QColor("#101010"))
            paint.drawLine(x, data.Ysize-11, x, data.Ysize-1)  #draw yellow movement bar
            paint.setPen(QtGui.QColor("yellow"))
#            print "Peak:", i,  x





        
    
   #ALARM VISUALISATION
    if(records.AlarmIsSet==True): #alarm time window is set, show it            
        paint.setBrush(QtGui.QColor("Orange"))
        paint.setPen(QtGui.QColor("Orange"))  
        x0=Tuple2Index(records.AlarmTimeWindowStart_tuple)-data.Derivation*Xscale
        x1=Tuple2Index(records.AlarmTimeWindowEnd_tuple)-data.Derivation*Xscale
#        x0=Tuple2Index(records.AlarmTimeWindowStart_tuple)-data.Derivation
#        x1=Tuple2Index(records.AlarmTimeWindowEnd_tuple)-data.Derivation
        x00=(x0-GraphStart_index)/Xscale
        x10=(x1-GraphStart_index)/Xscale
#        if(x00>0 or x10<780): #visible in screen
#            x00=max(x00,  1) #limit drawn line to border
#            x10=min(x10,  780) #limit drawn line to border
#            if(x00<x10): 
#        print  x1,   x10
#        print Tuple2Index((2010, 8, 15, 20, 0, 0, 6, 227, 0)),  (Tuple2Index((2010, 8, 15, 20, 0, 0, 6, 227, 0)) -GraphStart_index)/Xscale
#        print ""
        paint.drawRect(x00,  8,  x10-x00,  2) #Time Window 
#            x11=(x1+3-GraphStart_index)/Xscale
#            if(x11>1 and x11<779):        
        paint.drawRect(x10,  4,  1,  10)  #Last Alarm opportunity
                
        if(data.AlarmIsActive==True or data.run==False): #only show alarm if alarm occured or in record
#            if(records.Index>=Tuple2Index(records.AlarmTimeWindowEnd_tuple)): #only show alarm dot when alarm really came
            if(records.AlarmTime_seconds!=-1):
                paint.setBrush(QtGui.QColor("Red"))
                paint.setPen(QtGui.QColor("Red"))  
#                print "AlarmTimeWindowEnd:",  records.AlarmTimeWindowEnd_seconds,  "AlarmTime:",  records.AlarmTime_seconds
                if(records.AlarmTimeWindowEnd_seconds<=records.AlarmTime_seconds):
#                    print "Alarm due end of alarm time window"
                    a0=Tuple2Index(records.AlarmTime_tuple)-data.Derivation*Xscale
                else:
#                    print "alarm due movement"
                    a0=Tuple2Index(records.AlarmTime_tuple)-data.Derivation
                a00=(a0-GraphStart_index)/Xscale
                paint.drawEllipse(a00-5, 15, 10, 10)     
    #            print "AlarmTimeWindow:",  x1,  x10,  "Alarm:",  a0,  a00
#            else:
#                print "Alarm set, but never occured"




    #DRAW Trigger line
    if(records.statusID=="OK"):       
        if(data.run==False):  #show trigger level stored in record
            paint.setPen(QtGui.QColor("gray"))
            y=(data.Ysize-(records.Trigger*data.Yscale/2))-2
            paint.drawLine(1, y-15, data.GraphBitMapLen-2, y-15)  #Trigger line
            paint.drawText(data.GraphBitMapLen-25, y-17, str(records.Trigger)) #Trigger level
#            paint.drawText(5, 15, str(data.Yscale)) #Y scale
        paint.setPen(QtGui.QColor("white"))
        y=(data.Ysize-(data.Trigger*data.Yscale/2))-2
        paint.drawLine(1, y-15, data.GraphBitMapLen-2, y-15)  #Trigger line
        paint.drawText(data.GraphBitMapLen-25, y-17, str(data.Trigger)) #Trigger level
#        paint.drawText(5, 15, str(data.Yscale)) #Y scale
       
       
       
    #Draw border around it
    paint.setPen(QtGui.QColor("white"))
    paint.drawLine(0, 0, 0, data.Ysize)  #left side    
    paint.drawLine(data.GraphBitMapLen-1, 0, data.GraphBitMapLen-1, data.Ysize)  #right side
    paint.drawLine(0, 0, data.GraphBitMapLen-1, 0)  #top
    paint.drawLine(0, data.Ysize, data.GraphBitMapLen-1, data.Ysize)  #bottom


       
    #beep in test mode
    if(peak>data.Trigger): #if last value is over peak
        if(data.QuickMode==True and (records.Index-data.Derivation)>data.last_beep): #quick mode for testing but only once per move
            if(data.debug==1): print "Beep"
            data.last_beep=records.Index
            if(data.demo==False): #make beep for testing movement                    
                b = os.popen("pacat --channels=2 /usr/share/sounds/ui-default_beep.wav")
                b.close()


    paint.end()







############################################################################
### 
############################################################################  
#def ScrollbarData():        
#    Xscale=data.arrXscale[data.Xscale]
#    data.data.GraphBitMapLen=(records.LastIndex+5)/Xscale
#    if(data.data.GraphBitMapLen==0): data.data.GraphBitMapLen=1 #prevent divisions by zero
#    data.GraphEnd=min(records.LastIndex+5,  data.GraphStart+779*Xscale-data.Derivation)
#    
#    if(data.GraphEnd<=data.Derivation): return [0,  100]
#    
#    p0=float(data.GraphStart)*100/data.data.GraphBitMapLen/Xscale
#    p1=float(data.GraphEnd)*100/data.data.GraphBitMapLen/Xscale
#    p1=min(100,  p1)
##    print "--------------------"
##    print "Scroll bar is on %:", p0, "...", p1 
##    print "records.LastIndex:",  records.LastIndex
##    print "data.data.GraphBitMapLen:",  data.data.GraphBitMapLen
##    print "data.GraphEnd:",  data.GraphEnd
#    return [p0,  p1]






###########################################################################
## 
###########################################################################
def InitRecord():
    records.Index=0    
    records.LastIndex=0
    records.StartTime_tuple=time.localtime()
    records.StartTime_seconds=Tuple2Seconds(records.StartTime_tuple)
    records.AlarmTime_tuple=-1
    records.AlarmTime_seconds=-1
    records.AlarmTimeWindowStart_tuple=-1
    records.AlarmTimeWindowStart_seconds=-1
    records.AlarmTimeWindowEnd_tuple=-1
    records.AlarmTimeWindowEnd_seconds=-1
    records.AlarmTimeWindow_minutes=-1
    records.AlarmIsSet=False
    records.Note=""
    records.Sampling_interval=-1
    records.Sample_smoothing=-1
    records.Value_smoothing=-1
    records.Trigger=-1
    records.status=""
    records.statusID=""
    
    for i in range(0, records.MaxArrayDataLen-1): #clear data of old records
        for j in range(0,  4): 
            records.arrData[j][i]=0
        records.arrData[5][i]=""
    
    print "Reset/cleared all record data"
    
    
    
    
    



###########################################################################
## 
## Only used for debugging
###########################################################################
def PrintRecordData(ShowArray=True):
    print "###################### RECORD DATA #######################"
    print "Index:",  records.Index    
    print "LastIndex:",  records.LastIndex
    print "StartTime_tuple:",  records.StartTime_tuple
    print "StartTime_seconds:",  records.StartTime_seconds
    print "AlarmTime_tuple:",  records.AlarmTime_tuple
    print "AlarmTime_seconds:",  records.AlarmTime_seconds
    print "AlarmTimeWindowStart_tuple:",  records.AlarmTimeWindowStart_tuple
    print "AlarmTimeWindowStart_seconds:",  records.AlarmTimeWindowStart_seconds
    print "AlarmTimeWindowEnd_tuple:",  records.AlarmTimeWindowEnd_tuple
    print "AlarmTimeWindowEnd_seconds",  records.AlarmTimeWindowEnd_seconds
    print "AlarmTimeWindow_minutes:",  records.AlarmTimeWindow_minutes
    print "AlarmIsSet:",  records.AlarmIsSet
    print "Note:",  records.Note
    print "Sampling_interval:",  records.Sampling_interval
    print "Sample_smoothing:",  records.Sample_smoothing
    print "Value_smoothing:",  records.Value_smoothing
    print "Trigger:",  records.Trigger
    print "Status:",  records.statusID,  records.status
    
    if(ShowArray==True):
        for i in range(0, records.Index): #print data of  records
            print records.arrData[0][i],  records.arrData[1][i],  records.arrData[2][i],  records.arrData[3][i],  records.arrData[4][i],  records.arrData[5][i]

    print "##########################################################"
    


    
