import sys
import os
import random
import time
from time import strftime
import math
import array
import string

import ConfigParser
import os, os.path

import data
import records #record data

#own functions
from functions_general import *
from functions_record import *



###########################################################################
# Function to open or close the log file
###########################################################################
def CreateRecordFile(interval):       
    #if not on the N900, use another place for the log file 
    if(data.demo==True): data.logfolder=data.devlogfolder #folder on devel PC
    else: data.logfolder=data.defaultlogfolder
    
    print "Logfolder:",  data.logfolder
    if(not os.path.exists(data.logfolder)): #create log folder
        try:
            os.mkdir(data.logfolder)
        except:
            print "Failed to create logfolder!"
            
    PrintRecordData()
        
    
    #create file, write header
    d=strftime("%Y-%m-%d_%H-%M-%S", records.StartTime_tuple)
    data.logfilename="SleepAnalyser_"+d+".csv"
    data.logfile = open(data.logfolder+data.logfilename, 'w')
    print "Created logfile "+data.logfilename
    
    h=CreateHeader()
    data.logfile.write(h)
    
    








def CreateHeader():
    h=" , , , User: " + str(records.User)+ \
        ", SW version: " + str(records.SWversion)+ \
        ", Sampling interval: " + str(records.Sampling_interval)+ \
        ", Sample smoothing: " + str(records.Sample_smoothing)+ \
        ", Value smoothing: " + str(records.Value_smoothing) + \
        ", Trigger level: " + str(records.Trigger) 
        
    h=h+"\n"+"Start time: "+strftime(data.dateformat,  records.StartTime_tuple)
            
    if(records.AlarmIsSet==True):
        h=h+"\n"+"Alarm: "+strftime(data.dateformat,records.AlarmTime_tuple)
        h=h+"\n"+"Alarm Time Window Start: "+strftime(data.dateformat,records.AlarmTimeWindowStart_tuple)
        h=h+"\n"+"Alarm Time Window End: "+strftime(data.dateformat,records.AlarmTimeWindowEnd_tuple)
    else:
        h=h+"\n"+"No alarm set"
        h=h+"\n"+"Alarm Time Window Start: Not set"
        h=h+"\n"+"Alarm Time Window End: Not set"
    
    h=h+"\n"+"Note: "+str(records.Note)
    
    h=h+"\n"+"Time, AccX, AccY, Event:\n"
    
#    print "Record header:\n"+h+"\n"
    print "##############################\nHeader:\n"+h+"\n##############################"
    return h




###########################################################################
#  Write data into file, so it can be used in other tools
###########################################################################
def WriteIntoRecordFile():
    d=str(records.arrData[0][records.Index]) + ", " +  \
        str(records.arrData[1][records.Index]) + ", " +  \
        str(records.arrData[2][records.Index]) + ", " +  \
        str(records.arrData[5][records.Index])

    data.logfile.write(d+"\n")
    if(data.debug==1): print d





###########################################################################
#  Close log file
###########################################################################
def StopLogfile():    
    if(records.AlarmIsSet==True): 
        records.LastIndex=max(records.Index,  Tuple2Index(records.AlarmTimeWindowEnd_tuple)+5) #the very last index to be shown (incl. AlarmTimeWindowEnd
    else: records.LastIndex=records.Index
    data.logfile.close()
    



###########################################################################
#  Load list of log files into array
###########################################################################
def LoadFileList():
    print "Load list of all csv files in folder:",  data.logfolder
    output = os.popen("cd "+str(data.logfolder)+"; ls -C1 *.csv").read() # run ls and make the output look like a file I can read
    data.arrLogFiles=output.split("\n")
    data.arrLogFiles.pop()
    if(data.debug==1): print data.arrLogFiles
    if(data.logfilename>""):
        if(data.debug==1): print data.logfilename
        data.arrLogFileIndex=0
        for i in range(len(data.arrLogFiles)):
            if(data.logfilename==data.arrLogFiles[i]): data.arrLogFileIndex=i
            





###########################################################################
#  Load log file  to read and visualise it
###########################################################################
def LoadRecord():    
    InitRecord() #clear all old data
        
    data.logfolder=string.replace(data.logfolder, "~",  data.homedir) #workaround
    print "Open Log file:",  data.logfolder+data.logfilename,  "to load data..."    
    if(not os.path.exists(data.logfolder)): #create log folder (dirty workaround for if folder is not existing
        os.mkdir(data.logfolder)
        data.lastlogfile=""
    f=data.logfolder+data.logfilename
    if(not os.path.exists(f) or data.logfilename==""): return 2 #selected file or folder does not exist 
    
    file = open(f, 'r')    
    
    try: #read header data
       #process header line 1
        tmp=file.readline()
#        print tmp
        header=string.split(tmp, ", ")
        records.SWversion=float(string.replace(header[4], "SW version:",  ""))
        if(records.SWversion<1.6):
            print "Sorry, records older than SW version 1.6 are not compatible."
            records.status="File version not compatible"
            records.statusID="VERSION_INCOMPATIBLE"
            file.close()
            return 9    
        records.User=header[3]
        records.Sampling_interval=int(string.replace(header[5], "Sampling interval:",  ""))
        records.Sample_smoothing=int(string.replace(header[6], "Sample smoothing:",  ""))
        records.Value_smoothing=int(string.replace(header[7], "Value smoothing:",  ""))
        records.Trigger=int(string.replace(header[8], "Trigger level:",  ""))
        
       #process header line 2
        tmp=file.readline()
#        print tmp
        tmp=string.replace(tmp[:-1], "Start time: ",  "")
        records.StartTime_tuple=time.strptime(tmp,  data.dateformat)
        records.StartTime_seconds=Tuple2Seconds( records.StartTime_tuple)
            
       #process header line 3
        tmp=file.readline()
#        print tmp
        if(tmp!="No alarm set\n"):
            print "An alarm is set"
            records.AlarmIsSet=True
            tmp=string.replace(tmp[:-1], "Alarm: ",  "")
            records.AlarmTime_tuple=time.strptime(tmp,  data.dateformat)
            records.AlarmTime_seconds=Tuple2Seconds( records.AlarmTime_tuple)
        else:
            print "No alarm is set"
        
       #process header line 4
        tmp=file.readline()
#        print tmp
        if(records.AlarmIsSet==True): 
            tmp=string.replace(tmp[:-1], "Alarm Time Window Start: ",  "")
            records.AlarmTimeWindowStart_tuple=time.strptime(tmp,  data.dateformat)
            records.AlarmTimeWindowStart_seconds=Tuple2Seconds(records.AlarmTimeWindowStart_tuple)
        
       #process header line 5
        tmp=file.readline()
#        print tmp
        if(records.AlarmIsSet==True): 
            tmp=string.replace(tmp[:-1], "Alarm Time Window End: ",  "")
            records.AlarmTimeWindowEnd_tuple=time.strptime(tmp,  data.dateformat)
            records.AlarmTimeWindowEnd_seconds=Tuple2Seconds( records.AlarmTimeWindowEnd_tuple)
            records.AlarmTimeWindow_minutes=int((records.AlarmTimeWindowEnd_seconds-records.AlarmTimeWindowStart_seconds)/60)
        
       #process header line 6
        tmp=file.readline()
        records.Note=string.replace(tmp[:-1], "Note: ",  "")
        
      #process header line 7
        tmp=file.readline()  #not used, column header
        
        print "Record header successful read"
    except:
        print "Record header data corrupt"
        records.status="File header corrupted"
        records.statusID="HEADER_CORRUPTED"
#        print sys.exc_info() 
        file.close()
        return 8
    
    

    records.Index=0
    try: #get data
        for line in file:
#            print line
            d=string.split(line[:-1],  ", ")
#                print len(d)
            records.arrData[0][records.Index]=d[0] #time
            records.arrData[1][records.Index]=int(d[1]) #X
            records.arrData[2][records.Index]=int(d[2]) #Y
            records.arrData[5][records.Index]=d[3] #Event
#           
            records.Index=records.Index+1            
            if(records.Index==records.MaxArrayDataLen-1): 
                print "Stopped, array is full, file is to big. Loaded ",  records.Index,  "lines"                
                records.status="Array full"
                records.statusID="ARRAY_FULL"
#                file.close()
#                return 7 #File to long
                break
    except:
        print "File is corrupted"
        records.status="File is corrupted"
        records.statusID="FILE_CORRUPTED"
        file.close()
        return 3 #corrupted file
    finally:
        file.close()
        
    if(records.Index==0):
        print "No movement data in record"
        records.status="No data in file"
        records.statusID="NO_DATA"
        return 4

    print "Loaded successful",  records.Index, "lines"
    if(records.AlarmIsSet==True): 
        records.LastIndex=max(records.Index,  Tuple2Index(records.AlarmTimeWindowEnd_tuple)+5) #the very last index to be shown (incl. AlarmTimeWindowEnd
        print "But will show up to index",  records.LastIndex,  "as the AlarmTimeWindow ends there"
    else: records.LastIndex=records.Index
        
    PrintRecordData(False)
    records.status="Data successful loaded"
    records.statusID="OK"
    return 0 #all ok
    
    
    
    
    
    
    
###########################################################################
#  Load log file  to change Note (on line 2)
###########################################################################
def UpdateFileHeader():    
    print "Reopen log file and update note:",  records.Note
    file = open(data.logfolder+data.logfilename, 'w')
    print "Update header in logfile",  data.logfilename

    h=CreateHeader()
    file.write(h)
    i=0
    for i in range(0,  records.Index):
        d=str(records.arrData[0][i]) + ", " + str(records.arrData[1][i]) + ", " +  str(records.arrData[2][i]) + ", " +  str(records.arrData[5][i])
        file.write(d+"\n")
    file.close()
    print "Wrote",  i +1,  "records into file"
    
    
