import sys
import os
import random
import time
from time import strftime
import math
import array
import string

import ConfigParser
import os, os.path

import data
from myFunctions2 import * #Own functions


###########################################################################
# Function to open or close the log file
###########################################################################
def StartLogfile(interval):       
    #if not on the N900, use another place for the log file 
    if(data.demo==1): data.logfolder=data.devlogfolder #folder on devel PC
    else: data.logfolder=data.defaultlogfolder
    
    print "Logfolder:",  data.logfolder
    if(not os.path.exists(data.logfolder)): #create log folder
        try:
            os.mkdir(data.logfolder)
        except:
            print "Failed to create logfolder!"
        
    
    #open file, write header
    data.StartTime=time.localtime()
    data.StartTimeSec=time.mktime(data.StartTime)
    t=strftime("%Y-%m-%d_%H-%M-%S", data.StartTime)
    data.logfilename="SleepAnalyser_"+t+".csv"
    data.logfile = open(data.logfolder+data.logfilename, 'w')
    print "Created logfile "+data.logfilename
    t="Time, AccX, AccY, "
    d=strftime("%d-%m-%Y", data.StartTime)
    data.Header=t+"User: "+data.user+", SW version: "+data.version+", Date: " + d + \
            ", Sampling interval: " + str(interval)+" ms, sampling smoothing: " +str(data.sample_smoothing)+ \
            ", value_smoothing: " + str(data.sample_smoothing )+"\n"
    data.logfile.write(data.Header)
    data.logfile.write("Note: \n")
#    data.Note=""








###########################################################################
#  Write data into file, so it can be used in other tools
###########################################################################
def WriteIntoLogFile():
    d=str(data.arrData[0][data.arrDataIndex]) + ", " +  \
        str(data.arrData[1][data.arrDataIndex]) + ", " +  \
        str(data.arrData[2][data.arrDataIndex])

    data.logfile.write(d+"\n")
    if(data.debug==1): print d



###########################################################################
#  Close log file
###########################################################################
def StopLogfile():
    data.logfile.close()



###########################################################################
#  Load list of log files into array
###########################################################################
def LoadFileList():
    Show_passed_time("LoadFileList Start")
    print "Load list of all csv files in folder:",  data.logfolder
    output = os.popen("cd "+str(data.logfolder)+"; ls -C1 *.csv").read() # run ls and make the output look like a file I can read
    data.arrLogFiles=output.split("\n")
    data.arrLogFiles.pop()
    if(data.debug==1): print data.arrLogFiles
    if(data.logfilename>""):
        if(data.debug==1): print data.logfilename
        data.arrLogFileIndex=0
        for i in range(len(data.arrLogFiles)):
            if(data.logfilename==data.arrLogFiles[i]): data.arrLogFileIndex=i
            
    Show_passed_time("LoadFileList End")






###########################################################################
#  Load log file  to read and visualise it
###########################################################################
def OpenLogFile():    
#    Show_passed_time("OpenLogFile Start")
    data.logfolder=string.replace(data.logfolder, "~",  data.homedir) #workaround
    print "Open Log file:",  data.logfolder+data.logfilename
    
    if(not os.path.exists(data.logfolder)): #create log folder (dirty workaround for if folder is not existing
        os.mkdir(data.logfolder)
        data.lastlogfile=""

    f=data.logfolder+data.logfilename
    if(not os.path.exists(f) or data.logfilename==""): return 2 #selected file or folder does not exist 
    file = open(f, 'r')
    data.arrDataIndex=0
    ret=0
    try:
        data.Header=file.readline()
        if(data.debug==1): print "Header:",  data.Header
        h=string.split(data.Header, ", ")
        x=h[4] #SW version
        SWversion=string.replace(x, "SW version:",  "")
        try:
            fl=float(SWversion)
        except:
            print "SW Version format not valid:",  SWversion
            fl=0.0
#        print x,  fl,  data.version
        if(fl>1.1 and fl!=213.1321): #log files newer than SW version 1.1. and not Demo version have a new line with notes
#            print "SW version > 1.1, contains Note"
            data.Note=file.readline()
            data.Note=string.replace(data.Note, "Note: ",  "")
            data.Note=string.replace(data.Note, "\n",  "")
        else:
            data.Note=""
            data.Header=string.replace(data.Header,  x,  "SW version: "+str(data.version))
#            print "New header:",  data.Header
        if(data.debug==1): print "Note:",  data.Note
            
            
        x=h[5] #Date
        data.StartDate=string.replace(x, "Date: ",  "")
            
        data.MidnightTransitions=0
        for line in file:
#            print line
            d=string.split(line,  ", ")
            data.arrData[0][data.arrDataIndex]=d[0] #time
            data.arrData[1][data.arrDataIndex]=int(d[1]) #X
            data.arrData[2][data.arrDataIndex]=int(d[2]) #Y
            
            #check for transitions beond midnight:
            if(data.arrDataIndex>0): 
#                print data.arrDataIndex, data.arrData[0][data.arrDataIndex],  data.arrData[0][data.arrDataIndex-1]
                if(data.arrData[0][data.arrDataIndex][:2]=="00" and  data.arrData[0][data.arrDataIndex-1][:2]=="23"):
                    data.MidnightTransitions=data.MidnightTransitions+1
#                    print data.arrDataIndex, "Midnight transition:",  data.MidnightTransitions
            
            data.arrDataIndex=data.arrDataIndex+1            
            if(data.arrDataIndex==data.arrDataLen): 
                print "Stopped, array is full, file is to big"
                ret=1
                break
    finally:
        file.close()
    
    print "Loaded",  str(data.arrDataIndex),  "lines"
#    Show_passed_time("OpenLogFile End")
    return ret
    
    
    
    
###########################################################################
#  Load log file  to change Note (on line 2)
###########################################################################
def ChangeNoteInFile():    
    print "Reopen log file and add note:",  data.Note
    file = open(data.logfolder+data.logfilename, 'w')
    print "Open logfile",  data.logfilename,  ", change Note to\"",  data.Note,  "\" in file",  data.logfilename

    file.write(data.Header)
    file.write("Note: "+data.Note+"\n")
    i=0
    for i in range(0,  data.arrDataIndex):
        d=str(data.arrData[0][i]) + ", " + str(data.arrData[1][i]) + ", " +  str(data.arrData[2][i])
        file.write(d+"\n")
    file.close()
    print "Wrote",  i +1,  "lines into file"
    
    
    
    
###########################################################################
# Load the configuration from the config file
###########################################################################
def LoadConfig():    
    #get configuration
    print "Configuration file:",  data.configfolder+data.ConfigFile
    config = ConfigParser.SafeConfigParser()
#    if os.path.exists(data.configfolder+data.ConfigFile):
    try:
        config.read(data.configfolder+data.ConfigFile)
        
        data.sampling = config.getint('main', 'sampling')
        data.sample_smoothing = config.getint('main', 'sample_smoothing')
        data.value_smoothing = config.getint('main', 'value_smoothing')
        data.trigger = config.getint('main', 'trigger')
        data.derivation = config.getint('main', 'derivation')
        data.Ysize = config.getint('main', 'Ysize')
        data.Xscale = config.getint('main', 'Xscale')
        data.Yscale = config.getint('main', 'Yscale')
        data.user = config.get('main', 'user')
        data.lastlogfile = config.get('main', 'lastlogfile')
        data.OfflineMode = config.get('main', 'OfflineMode')
        data.DelayStartTime = config.getint('main', 'DelayStartTime')
        print "Configuration loaded ("+data.ConfigFile+")"
#    else:
    except: #use default config
        print data.configfolder+data.ConfigFile + " not existing or not read properly, using default parameters..."
        try:
            config.add_section('main')
        except:
            pass
        config.set('main', 'sampling', str(data.sampling))
        config.set('main', 'sample_smoothing', str(data.sample_smoothing))      
        config.set('main', 'value_smoothing', str(data.value_smoothing))      
        config.set('main', 'trigger', str(data.trigger))      
        config.set('main', 'derivation', str(data.derivation))      
        config.set('main', 'Ysize', str(data.Ysize))      
        config.set('main', 'Xscale', str(data.Xscale))     
        config.set('main', 'Yscale', str(data.Yscale))      
        config.set('main', 'user', str(data.user))      
        config.set('main', 'lastlogfile', str(data.lastlogfile))    
        config.set('main', 'OfflineMode', str(data.OfflineMode))      
        config.set('main', 'DelayStartTime', str(data.DelayStartTime))    

    
    #print usefull data
#    print "SW version:", data.version
#    print "Sampling interval:", data.sampling, "ms"
#    print "sample_smoothing:", data.sample_smoothing, "x"
#    print "value_smoothing:", data.value_smoothing, "x"
#    print "=> log interval:", data.sampling*data.value_smoothing/1000, "s"
#    print "Derivation:", data.derivation, "(substracts value", data.derivation, "- value 0)"  
#    print "Trigger level:", data.trigger
#    print "Yscale (for graph only):",  data.Yscale

    return config



###########################################################################
# Write the configuration into the config file
###########################################################################
def WriteConfig(config):    
        config.set('main', 'trigger', str(data.trigger))  
        
        f=data.configfolder+data.ConfigFile
        print "Save configuration ("+f+")"
        if (not os.path.exists(data.configfolder)):
            print "Create configuration folder: ",  data.configfolder
            os.mkdir(data.configfolder)
        try:
            data.configfile = open(f, 'w')
            config.write(data.configfile)
            print "Configuration saved"
        except:
            print "Failed to write configuration file!"
    
    
    
    
    
    

