#include <QtGui>
#include "maekerstartview.h"
#include "menuscene.h"
#include "gamescene.h"
#include "aboutscene.h"

MaekerStartView::MaekerStartView(QGraphicsScene *scene)
    : QGraphicsView(scene) //, m_scene(scene)
{
    // Ui
    m_menuScene = static_cast <menuScene *> (scene);
    connect(this,SIGNAL(checkMenuState()),m_menuScene,SLOT(checkState()));
    this->setWindowTitle(QT_TRANSLATE_NOOP(QGraphicsView, "Skid Stone"));
    this->setViewportUpdateMode(QGraphicsView::BoundingRectViewportUpdate);
//    QPixmap bgPix(":/img/main_back.png");
//    this->setBackgroundBrush(bgPix);
    this->setCacheMode(QGraphicsView::CacheBackground);
    this->setRenderHints(QPainter::Antialiasing | QPainter::SmoothPixmapTransform);
    QIcon icon(":/img/box4.png");
    this->setWindowIcon(icon);
    connect(m_menuScene, SIGNAL(newGameClicked()),this,SLOT(newGame()));
    connect(m_menuScene, SIGNAL(loadGameClicked()),this,SLOT(loadGame()));
    connect(m_menuScene, SIGNAL(hideApp()),this,SLOT(hide()));
    connect(m_menuScene, SIGNAL(aboutPopup()),this,SLOT(showAbout()));
    m_gameStarted = false;

    m_aboutScene = new AboutScene();
    connect(m_aboutScene, SIGNAL(okAbouClicked()),this,SLOT(closeAbout()));
}

void MaekerStartView::showAbout()
{
    this->setScene(m_aboutScene);
}

void MaekerStartView::closeAbout()
{
    this->setScene(m_menuScene);
}

void MaekerStartView::showMenu()
{
    this->setScene(m_menuScene);
    emit checkMenuState();
}

void MaekerStartView::newGame()
{
    if (m_gameStarted)
    {
        int sc = m_gameScene->score();
        int tsc = m_gameScene->topScore();
        if (sc > tsc)
            m_gameScene->setTopScore(sc);
        delete m_gameScene;
    }
    m_gameScene = new gameScene(true);
    connect(m_gameScene,SIGNAL(backButtonClicked()),this,SLOT(showMenu()));
    connect(m_gameScene,SIGNAL(gameOver()),this,SLOT(gameOver()));
    this->setScene(m_gameScene);
    m_gameStarted = true;
}

void MaekerStartView::loadGame()
{
    if (!m_gameStarted)   // create game scene and load last state
    {
        m_gameScene = new gameScene(false);
        connect(m_gameScene,SIGNAL(backButtonClicked()),this,SLOT(showMenu()));
    }
    this->setScene(m_gameScene);
    m_gameStarted = true;
}

void MaekerStartView::resizeEvent(QResizeEvent *event)
{
    QGraphicsView::resizeEvent(event);
    fitInView(sceneRect(), Qt::KeepAspectRatio);
}

void MaekerStartView::gameOver()
{
    m_gameStarted = false;
    showMenu();
}
