#ifndef GAMESCENE_H
#define GAMESCENE_H

#include <QGraphicsScene>
#include <QStateMachine>
#include <QTimer>
#include <QBitArray>
#include <QLabel>
//#include "boxwidget.h"

//forward declaration
class DigitWidget;
class BoxWidget;

class gameScene : public QGraphicsScene
{
    Q_OBJECT

public:
    gameScene(bool newGame, QObject *parent = 0);
    int score();
    int topScore();
    void setTopScore(int);

signals:
    void moveTile();
    void tile2box();
    void tile2way();
    void box2tile();
    void cleantile();
    void backButtonClicked();
    void gameOver();

private:
    void sceneInit();
    void disableMove();
//    bool checkBuddy(int aPos, QColor aColor);
    bool checkBuddy(int aPos, int aColor);
    void renewField();
    void readLevel();
    void tile2boxAssign(BoxWidget *aTile);
    void saveState();
    void gnerateField();
    void loadField();
    void loadScores();
    void saveScores();

public slots:
    void a1Updated();
//    void boxFired(QPointF aPos, QPointF aPoint, QColor aColor);
    void boxFired(QPointF aPos, QPointF aPoint, int aColor);
    void tileTransform();
    void checkColor();
    void checkField();
    void cleanField();
    void setFieldBoxes2();
    void checkBuddyColors();
    void gotoDektop();

private slots:
//    void statesInitialized();
    void setFieldBoxes();
    void backCommand();
    void startGameOver();
    void signalGameOver();

private:
    QStateMachine m_states;
    int m_xBox;
    QList<BoxWidget *> m_items;
//    QColor m_xColor;
    int m_xColor;
    bool m_initState;
    BoxWidget *m_movingBox;
    QState *m_mb1;
    QState *m_mb2;
    QState *m_mb3;
    QTimer m_timer;
    QTimer m_timerColor;
//    QTimer m_timerFirst;
    QTimer m_timerField;
    QTimer m_timerFieldCheck;
    QTimer m_timerOver;
    QBitArray m_levelDat;
    int currentLevel;
    int m_colorNumber;
//    QGraphicsProxyWidget *m_proxy;
//    QLabel *m_levelLabel;
//    QLabel *m_scoreLabel;
//    QLabel *m_topScoreLabel;
    int m_score;
    int m_prevDel;
    int m_topScore;
    QString m_datFileName;
    DigitWidget * _wScore;
    DigitWidget * _wLevel;
    DigitWidget * _wTScore;
};


#endif // GAMESCENE_H
